/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import loci.formats.gui.AWTImageTools;

public class SignedColorModel
extends ColorModel {
    private int pixelBits;
    private int nChannels;
    private ComponentColorModel helper;
    private int max;

    public SignedColorModel(int pixelBits, int dataType, int nChannels) throws IOException {
        super(pixelBits, SignedColorModel.makeBitArray(nChannels, pixelBits), AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, dataType);
        int type = dataType;
        if (type == 2) {
            type = 1;
        }
        this.helper = new ComponentColorModel(AWTImageTools.makeColorSpace(nChannels), nChannels == 4, false, 3, type);
        this.pixelBits = pixelBits;
        this.nChannels = nChannels;
        this.max = (int)Math.pow(2.0, pixelBits) - 1;
    }

    @Override
    public synchronized Object getDataElements(int rgb, Object pixel) {
        return this.helper.getDataElements(rgb, pixel);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        if (this.pixelBits == 16) {
            return raster.getTransferType() == 2;
        }
        return this.helper.isCompatibleRaster(raster);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h2) {
        if (this.pixelBits == 16) {
            int[] bandOffsets = new int[this.nChannels];
            for (int i = 0; i < this.nChannels; ++i) {
                bandOffsets[i] = i;
            }
            ComponentSampleModel m3 = new ComponentSampleModel(2, w, h2, this.nChannels, w * this.nChannels, bandOffsets);
            DataBufferShort db = new DataBufferShort(w * h2, this.nChannels);
            return Raster.createWritableRaster(m3, db, null);
        }
        return this.helper.createCompatibleWritableRaster(w, h2);
    }

    @Override
    public int getAlpha(int pixel) {
        if (this.nChannels < 4) {
            return 255;
        }
        return this.rescale(pixel, this.max);
    }

    @Override
    public int getBlue(int pixel) {
        if (this.nChannels == 1) {
            return this.getRed(pixel);
        }
        return this.rescale(pixel, this.max);
    }

    @Override
    public int getGreen(int pixel) {
        if (this.nChannels == 1) {
            return this.getRed(pixel);
        }
        return this.rescale(pixel, this.max);
    }

    @Override
    public int getRed(int pixel) {
        return this.rescale(pixel, this.max);
    }

    @Override
    public int getAlpha(Object data) {
        if (data instanceof byte[]) {
            byte[] b = (byte[])data;
            if (b.length == 1) {
                return this.getAlpha(b[0]);
            }
            return this.rescale(b.length == 4 ? b[0] : this.max, this.max);
        }
        if (data instanceof short[]) {
            short[] s2 = (short[])data;
            if (s2.length == 1) {
                return this.getAlpha(s2[0]);
            }
            return this.rescale(s2.length == 4 ? s2[0] : this.max, this.max);
        }
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getAlpha(i[0]);
            }
            return this.rescale(i.length == 4 ? i[0] : this.max, this.max);
        }
        return 0;
    }

    @Override
    public int getRed(Object data) {
        if (data instanceof byte[]) {
            byte[] b = (byte[])data;
            if (b.length == 1) {
                return this.getRed(b[0]);
            }
            return this.rescale(b.length != 4 ? b[0] : b[1]);
        }
        if (data instanceof short[]) {
            short[] s2 = (short[])data;
            if (s2.length == 1) {
                return this.getRed(s2[0]);
            }
            return this.rescale(s2.length != 4 ? s2[0] : s2[1], this.max);
        }
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getRed(i[0]);
            }
            return this.rescale(i.length != 4 ? i[0] : i[1], this.max);
        }
        return 0;
    }

    @Override
    public int getGreen(Object data) {
        if (data instanceof byte[]) {
            byte[] b = (byte[])data;
            if (b.length == 1) {
                return this.getGreen(b[0]);
            }
            return this.rescale(b.length != 4 ? b[1] : b[2]);
        }
        if (data instanceof short[]) {
            short[] s2 = (short[])data;
            if (s2.length == 1) {
                return this.getGreen(s2[0]);
            }
            return this.rescale(s2.length != 4 ? s2[1] : s2[2], this.max);
        }
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getGreen(i[0]);
            }
            return this.rescale(i.length != 4 ? i[1] : i[2], this.max);
        }
        return 0;
    }

    @Override
    public int getBlue(Object data) {
        if (data instanceof byte[]) {
            byte[] b = (byte[])data;
            if (b.length == 1) {
                return this.getBlue(b[0]);
            }
            return this.rescale(b.length > 2 ? b[b.length - 1] : 0);
        }
        if (data instanceof short[]) {
            short[] s2 = (short[])data;
            if (s2.length == 1) {
                return this.getBlue(s2[0]);
            }
            return this.rescale(s2.length > 2 ? s2[s2.length - 1] : 0, this.max);
        }
        if (data instanceof int[]) {
            int[] i = (int[])data;
            if (i.length == 1) {
                return this.getBlue(i[0]);
            }
            return this.rescale(i.length > 2 ? i[i.length - 1] : 0, this.max);
        }
        return 0;
    }

    private int rescale(int value, int max) {
        float v = (float)value / (float)max;
        return this.rescale((int)(v *= 255.0f));
    }

    private int rescale(int value) {
        value = value < 128 ? (value += 128) : (value -= 128);
        return value;
    }

    private static int[] makeBitArray(int nChannels, int nBits) {
        int[] bits = new int[nChannels];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = nBits;
        }
        return bits;
    }
}

