/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.completion;

import icy.util.ClassUtil;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import plugins.tprovoost.scripteditor.completion.IcyAutoCompletion;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.NewInstanceCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;

public class JSAutoCompletion
extends IcyAutoCompletion {
    public JSAutoCompletion(CompletionProvider provider) {
        super(provider);
    }

    protected void insertCompletion(Completion c, boolean typedParamListStartChar) {
        if (!(c instanceof ScriptFunctionCompletion)) {
            if (c instanceof BasicJavaClassCompletion) {
                JTextComponent tc = this.getTextComponent();
                int caretPos = tc.getCaretPosition();
                Class<?> clazz = ((BasicJavaClassCompletion)c).getJavaClass();
                String neededClass = clazz.getName();
                if (clazz.isMemberClass()) {
                    neededClass = ClassUtil.getBaseClassName((String)neededClass);
                }
                if (!this.classAlreadyImported(neededClass)) {
                    tc.getCaret().setDot(caretPos += this.addImport(tc, neededClass, true).length());
                }
            } else if (c instanceof NewInstanceCompletion) {
                JTextComponent tc = this.getTextComponent();
                int caretPos = tc.getCaretPosition();
                Class<?> clazz = ((NewInstanceCompletion)c).getConstructor().getDeclaringClass();
                String neededClass = clazz.getName();
                if (!this.classAlreadyImported(neededClass)) {
                    tc.getCaret().setDot(caretPos += this.addImport(tc, neededClass, true).length());
                }
            }
        }
        super.insertCompletion(c, typedParamListStartChar);
    }

    protected String getReplacementText(Completion c, Document doc, int start, int len) {
        String toReturn = super.getReplacementText(c, doc, start, len);
        if (c instanceof ScriptFunctionCompletion) {
            ScriptFunctionCompletion fc = (ScriptFunctionCompletion)c;
            String textBefore = "";
            if (!fc.isStatic()) {
                CompletionProvider provider = this.getCompletionProvider();
                if (provider instanceof IcyCompletionProvider) {
                    textBefore = provider.getAlreadyEnteredText(this.getTextComponent());
                    int lastIdx = textBefore.lastIndexOf(46);
                    textBefore = lastIdx != -1 ? textBefore.substring(0, lastIdx + 1) : "";
                }
                toReturn = String.valueOf(textBefore) + fc.getMethod().getName();
            }
        } else if (c instanceof BasicJavaClassCompletion) {
            Class<?> clazz = ((BasicJavaClassCompletion)c).getJavaClass();
            String textBefore = "";
            CompletionProvider provider = this.getCompletionProvider();
            if (provider instanceof IcyCompletionProvider) {
                textBefore = ((IcyCompletionProvider)provider).getAlreadyEnteredTextWithFunc(this.getTextComponent());
                int lastIdx = textBefore.lastIndexOf(46);
                textBefore = lastIdx != -1 ? textBefore.substring(0, lastIdx) : "";
            }
            if (textBefore == "") {
                toReturn = clazz.getName();
                toReturn = ClassUtil.getSimpleClassName((String)toReturn).replace('$', '.');
            } else {
                toReturn = clazz.getSimpleName();
            }
        }
        return toReturn;
    }

    @Override
    public String addImport(JTextComponent tc, String neededClass, boolean isClass) {
        String resultingImport = isClass ? "importClass(Packages." + neededClass + ")\n" : "importPackage(Packages." + ClassUtil.getPackageName((String)neededClass) + ")\n";
        if (!tc.getText().contains(resultingImport)) {
            tc.setText(String.valueOf(resultingImport) + tc.getText());
        }
        return resultingImport;
    }

    public String addBaseClass(JTextComponent tc, String neededBaseClass) {
        return neededBaseClass;
    }

    @Override
    public boolean classAlreadyImported(String neededClass) {
        String text = this.getTextComponent().getText();
        if (neededClass.startsWith("java.") || neededClass.startsWith("javax.")) {
            return text.contains("importClass(" + neededClass + ")") || text.contains("importPackage(" + ClassUtil.getPackageName((String)neededClass) + ")");
        }
        return text.contains("importClass(Packages." + neededClass + ")") || text.contains("importPackage(Packages." + ClassUtil.getPackageName((String)neededClass) + ")");
    }
}

