/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.util.EventUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class ConsoleOutput
extends JPanel {
    protected boolean scrollLocked;
    final JTextPane textPane;
    private JScrollPane scrollpane;

    ConsoleOutput() {
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setBorder(BorderFactory.createBevelBorder(1));
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EventUtil.isRightMouseButton((MouseEvent)e)) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem itemCopy = new JMenuItem("Copy");
                    itemCopy.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            (this).ConsoleOutput.this.textPane.copy();
                        }
                    });
                    popup.add(itemCopy);
                    popup.show(ConsoleOutput.this.textPane, e.getX(), e.getY());
                    e.consume();
                }
            }
        });
        class NonSrollingCaret
        extends DefaultCaret {
            NonSrollingCaret() {
            }

            @Override
            public void adjustVisibility(Rectangle rec) {
            }
        }
        this.textPane.setCaret(new NonSrollingCaret());
        this.scrollpane = new JScrollPane(this.textPane);
        this.scrollpane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.scrollpane.setAutoscrolls(true);
        this.scrollpane.setPreferredSize(new Dimension(400, 200));
        this.add(this.scrollpane);
        final JScrollBar scrollbar = this.scrollpane.getVerticalScrollBar();
        scrollbar.addAdjustmentListener(new AdjustmentListener(){
            final BoundedRangeModel brm;
            {
                this.brm = jScrollBar.getModel();
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (scrollbar.getValueIsAdjusting()) {
                    boolean atBottom;
                    boolean bl = atBottom = scrollbar.getValue() + scrollbar.getVisibleAmount() == scrollbar.getMaximum();
                    if (atBottom) {
                        ConsoleOutput.this.setScrollLocked(false);
                    } else {
                        ConsoleOutput.this.setScrollLocked(true);
                    }
                }
                if (!ConsoleOutput.this.isScrollLocked() && !ConsoleOutput.this.textPane.getText().isEmpty()) {
                    this.brm.setValue(this.brm.getMaximum());
                }
            }
        });
        this.scrollpane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                boolean atBottom;
                boolean bl = atBottom = scrollbar.getValue() + scrollbar.getVisibleAmount() == scrollbar.getMaximum();
                if (atBottom && e.getWheelRotation() >= 0) {
                    ConsoleOutput.this.setScrollLocked(false);
                } else {
                    ConsoleOutput.this.setScrollLocked(true);
                }
            }
        });
    }

    private synchronized boolean isScrollLocked() {
        return this.scrollLocked;
    }

    private synchronized void setScrollLocked(boolean scrollLocked) {
        this.scrollLocked = scrollLocked;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void append(String s) {
        Document doc = this.textPane.getDocument();
        try {
            Style style = this.textPane.getStyle("normal");
            if (style == null) {
                style = this.textPane.addStyle("normal", null);
            }
            doc.insertString(doc.getLength(), s, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clear() {
        this.textPane.setText("");
    }

    public void appendError(String s) {
        Document doc = this.textPane.getDocument();
        try {
            Style style = this.textPane.getStyle("error");
            if (style == null) {
                style = this.textPane.addStyle("error", null);
                StyleConstants.setForeground(style, Color.red);
            }
            doc.insertString(doc.getLength(), s, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

