/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.gui;

import icy.util.EventUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import plugins.tprovoost.scripteditor.gui.ScriptingEditor;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;

public class TabComponentButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ScriptingPanel panel;
    private final ScriptingEditor editor;
    private final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (EventUtil.isMiddleMouseButton((MouseEvent)e)) {
                TabComponentButton.this.deletePane();
                e.consume();
            } else {
                super.mouseClicked(e);
            }
        }
    };

    public TabComponentButton(ScriptingEditor scriptingEditor, ScriptingPanel panelCreated) {
        super(new FlowLayout(0, 0, 0));
        if (panelCreated == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.panel = panelCreated;
        this.editor = scriptingEditor;
        this.setOpaque(false);
        JLabel label = new JLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getText() {
                JTabbedPane pane = TabComponentButton.this.editor.getTabbedPane();
                int i = pane.indexOfTabComponent(TabComponentButton.this);
                if (i != -1) {
                    return pane.getTitleAt(i);
                }
                return "";
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public boolean deletePane() {
        return this.editor.closeTab(this);
    }

    public ScriptingPanel getPanel() {
        return this.panel;
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(TabComponentButton.this.buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabComponentButton.this.deletePane();
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                g2.setColor(Color.MAGENTA);
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

