/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptblock.editor;

import icy.gui.component.button.IcyButton;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.tprovoost.scripteditor.gui.ScriptingPanel;
import plugins.tprovoost.scripteditor.scriptblock.script.Script;
import plugins.tprovoost.scripteditor.scriptblock.var.VarScript;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public abstract class VarScriptEditor
extends SwingVarEditor<Script> {
    private ScriptingPanel panelIn;
    private ScriptingPanel panelOut;
    private IcyFrame frame;
    private IcyFrameListener frameListener;

    public VarScriptEditor(VarScript variable) {
        super((Var)variable);
    }

    public VarScript getVariable() {
        return (VarScript)super.getVariable();
    }

    protected JComponent createEditorComponent() {
        this.setNameVisible(false);
        this.setComponentResizeable(true);
        JPanel component = this.buildComponentPanel();
        final Set<VarMutable> inputVariables = this.getVariable().getInputVariables();
        final Set<VarMutable> outputVariables = this.getVariable().getOutputVariables();
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VarScriptEditor.this.setupVariables(inputVariables, outputVariables);
                VarScriptEditor.this.panelIn.getScriptHandler().interpret(false);
                VarScriptEditor.this.panelOut.getScriptHandler().interpret(false);
            }
        });
        return component;
    }

    private JPanel buildComponentPanel() {
        JPanel componentPanel = new JPanel(new BorderLayout());
        componentPanel.setOpaque(false);
        componentPanel.add((Component)this.buildInternalEditorPanel(), "Center");
        componentPanel.add((Component)this.buildInternalEastPanel(), "East");
        return componentPanel;
    }

    private JPanel buildInternalEditorPanel() {
        this.panelIn = new ScriptingPanel("Internal Editor", this.getEditorScriptType());
        this.panelIn.setText(this.getVariable().getCode());
        this.panelIn.getTextArea().setCaretPosition(0);
        this.panelIn.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ((Script)VarScriptEditor.this.getVariable().getValue()).updateCode(VarScriptEditor.this.panelIn.getTextArea().getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ((Script)VarScriptEditor.this.getVariable().getValue()).updateCode(VarScriptEditor.this.panelIn.getTextArea().getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        return this.panelIn;
    }

    private String getEditorScriptType() {
        switch (((Script)this.getVariable().getValue()).getScriptType()) {
            case JAVASCRIPT: {
                return "JavaScript";
            }
            case PYTHON: {
                return "Python";
            }
        }
        throw new RuntimeException("Unsupported script type: " + (Object)((Object)((Script)this.getVariable().getValue()).getScriptType()));
    }

    private JPanel buildInternalEastPanel() {
        JPanel eastPanel = new JPanel();
        eastPanel.setOpaque(false);
        eastPanel.setLayout(new BoxLayout(eastPanel, 1));
        eastPanel.add(Box.createVerticalGlue());
        IcyButton editButton = new IcyButton(new IcyIcon("redo.png", 12));
        eastPanel.add((Component)editButton);
        eastPanel.add(Box.createVerticalGlue());
        this.buildExternalEditorFrame();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarScriptEditor.this.getVariable().updateCode(VarScriptEditor.this.panelIn.getTextArea().getText());
                VarScriptEditor.this.panelOut.getTextArea().setText(VarScriptEditor.this.getVariable().getCode());
                VarScriptEditor.this.panelOut.getTextArea().setCaretPosition(VarScriptEditor.this.panelIn.getTextArea().getCaretPosition());
                VarScriptEditor.this.panelIn.getTextArea().setEnabled(false);
                VarScriptEditor.this.frame.setVisible(true);
                VarScriptEditor.this.frame.requestFocus();
            }
        });
        return eastPanel;
    }

    private void buildExternalEditorFrame() {
        this.frame = new IcyFrame("External Editor", true, true, true, true);
        this.frame.setSize(500, 500);
        this.buildExternalPanel();
        this.frame.setContentPane((Container)this.panelOut);
        this.frame.addToDesktopPane();
        this.frame.setDefaultCloseOperation(1);
        this.frame.center();
        this.frameListener = new IcyFrameAdapter(){

            public void icyFrameClosing(IcyFrameEvent e) {
                VarScriptEditor.this.panelIn.getTextArea().setText(VarScriptEditor.this.panelOut.getTextArea().getText());
                VarScriptEditor.this.panelIn.getTextArea().setCaretPosition(VarScriptEditor.this.panelOut.getTextArea().getCaretPosition());
                VarScriptEditor.this.panelIn.getTextArea().setEnabled(true);
                VarScriptEditor.this.panelIn.getTextArea().repaint();
            }
        };
    }

    private void buildExternalPanel() {
        this.panelOut = new ScriptingPanel("External Editor", this.getEditorScriptType());
        this.panelOut.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.panelOut.getTextArea().setCaretPosition(0);
        this.panelOut.getTextArea().setText(this.panelIn.getTextArea().getText());
    }

    public double getComponentVerticalResizeFactor() {
        return 1.0;
    }

    protected void activateListeners() {
        this.frame.addFrameListener(this.frameListener);
    }

    protected void deactivateListeners() {
        this.frame.removeFrameListener(this.frameListener);
        this.frame.close();
    }

    protected void updateInterfaceValue() {
        this.panelIn.getTextArea().setText(((Script)this.getVariable().getValue()).getCode());
        this.panelOut.getTextArea().setText(((Script)this.getVariable().getValue()).getCode());
        this.setupVariables(this.getVariable().getInputVariables(), this.getVariable().getOutputVariables());
    }

    public void setupVariables(Set<VarMutable> inputVariables, Set<VarMutable> outputVariables) {
        ScriptingHandler inHandler = this.panelIn.getScriptHandler();
        ScriptingHandler outHandler = this.panelOut.getScriptHandler();
        this.setupVariables(inputVariables, outputVariables, inHandler);
        this.setupVariables(inputVariables, outputVariables, outHandler);
    }

    private void setupVariables(Set<VarMutable> inputVariables, Set<VarMutable> outputVariables, final ScriptingHandler handler) {
        HashMap<String, ScriptVariable> handlerVariables = handler.getExternalVariables();
        handlerVariables.clear();
        for (Var var : inputVariables) {
            handlerVariables.put(var.getName(), new ScriptVariable(new VariableType(var.getType())));
        }
        for (Var var : outputVariables) {
            handlerVariables.put(var.getName(), new ScriptVariable(new VariableType(var.getType())));
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                handler.interpret(false);
            }
        });
    }
}

