/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers;

import java.util.ArrayList;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public class ScriptVariable {
    private ArrayList<ScriptVariableScope> variableScopes = new ArrayList();

    public ScriptVariable() {
    }

    public ScriptVariable(VariableType returnType) {
        this.addType(0, returnType);
    }

    public void addType(int offsetBegin, VariableType returnType) {
        this.addType(offsetBegin, -1, returnType);
    }

    public void addType(int offsetBegin, int offsetEnd, VariableType returnType) {
        ScriptVariableScope lastScope;
        if (!this.variableScopes.isEmpty() && (lastScope = this.variableScopes.get(this.variableScopes.size() - 1)).endScopeOffset == -1) {
            lastScope.endScopeOffset = offsetBegin - 1;
        }
        this.variableScopes.add(new ScriptVariableScope(offsetBegin, offsetEnd, returnType));
    }

    public VariableType getVariableClassType(int offset) {
        for (ScriptVariableScope svc : this.variableScopes) {
            VariableType type = svc.getType(offset);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public VariableType getVariableLastClassType() {
        if (!this.variableScopes.isEmpty()) {
            return this.variableScopes.get(this.variableScopes.size() - 1).type;
        }
        return null;
    }

    public ArrayList<ScriptVariableScope> getVariableScopes() {
        return this.variableScopes;
    }

    public boolean isInScope(int offset) {
        for (ScriptVariableScope svc : this.variableScopes) {
            boolean inScope;
            boolean bl = inScope = offset >= svc.declarationOffset && (svc.endScopeOffset == -1 || offset < svc.endScopeOffset);
            if (!inScope) continue;
            return true;
        }
        return false;
    }

    public class ScriptVariableScope {
        private int declarationOffset;
        private int endScopeOffset;
        private VariableType type;

        public ScriptVariableScope(int declarationOffset, int endScopeOffset, Class<?> type) {
            this(declarationOffset, endScopeOffset, new VariableType(type));
        }

        public ScriptVariableScope(int declarationOffset, int endScopeOffset, VariableType type) {
            this.declarationOffset = declarationOffset;
            this.endScopeOffset = endScopeOffset;
            this.type = type;
            ScriptVariable.this.variableScopes.add(this);
        }

        public VariableType getType(int offset) {
            if (offset >= this.declarationOffset && (this.endScopeOffset == -1 || offset < this.endScopeOffset)) {
                return this.type;
            }
            return null;
        }

        public int getDeclarationOffset() {
            return this.declarationOffset;
        }

        public int getEndScopeOffset() {
            return this.endScopeOffset;
        }

        public void setDeclarationOffset(int declarationOffset) {
            this.declarationOffset = declarationOffset;
        }

        public void setEndScopeOffset(int endScopeOffset) {
            this.endScopeOffset = endScopeOffset;
        }
    }
}

