/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.search;

import icy.common.listener.ProgressListener;
import icy.gui.frame.progress.DownloadFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.tprovoost.scripteditor.main.ScriptEditorPlugin;
import plugins.tprovoost.scripteditor.search.ScriptDescriptor;
import plugins.tprovoost.scripteditor.search.ScriptRichToolTip;

public class ScriptProvider
extends SearchResultProducer {
    private static final String SEARCH_URL = "http://icy.bioimageanalysis.org/search/search.php?search=";
    private static final String ID_SEARCH_RESULT = "searchresult";
    private static final String ID_SCRIPT = "script";
    private static final String ID_TEXT = "string";
    private final long REQUEST_INTERVAL = 400L;

    public String getName() {
        return "Scripts";
    }

    public String getTooltipText() {
        return "Result(s) from online scripts";
    }

    public void doSearch(String[] words, SearchResultConsumer consumer) {
        String request = SEARCH_URL;
        if (words.length > 0) {
            request = String.valueOf(request) + words[0].replace("+", "%2B").replace("&", "%26").replace("@", "%40").replace("<", "%3C").replace(">", "%3E");
        }
        if (words.length > 1) {
            int i = 1;
            while (i < words.length) {
                request = String.valueOf(request) + "%20" + words[i].replace("+", "%2B").replace("&", "%26").replace("@", "%40").replace("<", "%3C").replace(">", "%3E");
                ++i;
            }
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 400L) {
            ThreadUtil.sleep((int)10);
            if (!this.hasWaitingSearch()) continue;
            return;
        }
        Document doc = null;
        int retry = 0;
        while (doc == null && retry < 10) {
            doc = XMLUtil.loadDocument((URL)URLUtil.getURL((String)request), (boolean)false);
            if (this.hasWaitingSearch()) {
                return;
            }
            if (doc == null) {
                ThreadUtil.sleep((int)100);
            }
            ++retry;
        }
        if (doc == null) {
            return;
        }
        if (this.hasWaitingSearch()) {
            return;
        }
        Element resultElement = XMLUtil.getElement((Node)doc.getDocumentElement(), (String)ID_SEARCH_RESULT);
        if (resultElement == null) {
            return;
        }
        ArrayList<OnlineScriptResult> tmpResults = new ArrayList<OnlineScriptResult>();
        for (Element script : XMLUtil.getElements((Node)resultElement, (String)ID_SCRIPT)) {
            if (((Object)((Object)this)).getClass().getClassLoader() != SystemUtil.getSystemClassLoader() && this.hasWaitingSearch()) {
                return;
            }
            OnlineScriptResult result = this.getResult(script, words);
            if (result == null) continue;
            tmpResults.add(result);
        }
        this.results = tmpResults;
        consumer.resultsChanged((SearchResultProducer)this);
    }

    private OnlineScriptResult getResult(Element scriptNode, String[] words) {
        String text = XMLUtil.getElementValue((Node)scriptNode, (String)ID_TEXT, (String)"");
        ScriptDescriptor script = new ScriptDescriptor(scriptNode);
        return new OnlineScriptResult(this, script, text, words);
    }

    private class OnlineScriptResult
    extends SearchResult {
        private ScriptDescriptor script;
        private String description;

        public OnlineScriptResult(ScriptProvider scriptProvider2, ScriptDescriptor script, String text, String[] searchWords) {
            super((SearchResultProducer)scriptProvider2);
            this.script = script;
            int wi = 0;
            this.description = "";
            while (StringUtil.isEmpty((String)this.description) && wi < searchWords.length) {
                this.description = StringUtil.trunc((String)text, (String)searchWords[wi], (int)80);
                ++wi;
            }
            if (!StringUtil.isEmpty((String)this.description)) {
                this.description = this.description.replace("\n", "");
                if (searchWords.length > 1 || searchWords[0].length() > 2) {
                    String[] stringArray = searchWords;
                    int n = searchWords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String word = stringArray[n2];
                        this.description = StringUtil.htmlBoldSubstring((String)this.description, (String)word, (boolean)true);
                        ++n2;
                    }
                }
            }
        }

        public String getTitle() {
            return this.script.getName();
        }

        public Image getImage() {
            ImageIcon icon = this.script.getIcon();
            if (icon != null) {
                return icon.getImage();
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTooltip() {
            return "Left click: Open   -   Right click: Online documentation";
        }

        public void execute() {
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    final String name = String.valueOf(OnlineScriptResult.this.script.getName()) + " v" + OnlineScriptResult.this.script.getVersion() + "." + OnlineScriptResult.this.script.getExtension();
                    try (DownloadFrame frameDownload = new DownloadFrame(name);){
                        try {
                            byte[] data = NetworkUtil.download((URL)new URL(OnlineScriptResult.this.script.getFileUrl()), (ProgressListener)frameDownload, (boolean)true);
                            if (data != null) {
                                final String s = new String(data);
                                ThreadUtil.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ScriptEditorPlugin.openInScriptEditor(s, name);
                                    }
                                });
                            }
                        }
                        catch (MalformedURLException e1) {
                            new FailedAnnounceFrame("Could not load the script :" + e1.getMessage());
                            frameDownload.close();
                        }
                    }
                }
            });
        }

        public void executeAlternate() {
            NetworkUtil.openBrowser((String)this.script.getUrl());
        }

        public RichTooltip getRichToolTip() {
            return new ScriptRichToolTip(this.script);
        }
    }
}

