package plugins.tprovoost.painting.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;

import plugins.tprovoost.painting.PaintingTools;

public abstract class PaintingShape
{
    protected Stroke stroke;
    protected Shape shape;
    protected Color shapeColor;
    protected int thickness;
    protected boolean fill;
    protected boolean isEditable;

    public abstract void update(Point p);

    public PaintingShape(PaintingTools tools)
    {
        shapeColor = tools.getForegroundColor();
        thickness = tools.getThickness();
        stroke = new BasicStroke(thickness);
        fill = false;
        isEditable = true;
    }

    public void drawShape(Graphics2D g)
    {
        final Graphics2D g2 = (Graphics2D) g.create();

        g2.setColor(shapeColor);
        if (fill)
            g2.fill(shape);
        else
            g2.draw(shape);

        g2.dispose();
    }

    public boolean isFill()
    {
        return fill;
    }

    public void setFill(boolean fill)
    {
        this.fill = fill;
    }

    public boolean isEditable()
    {
        return isEditable;
    }

    public void setEditable(boolean isEditable)
    {
        this.isEditable = isEditable;
    }

    public Color getShapeColor()
    {
        return shapeColor;
    }

    public void setShapeColor(Color shapeColor)
    {
        this.shapeColor = shapeColor;
    }

    public int getThickness()
    {
        return thickness;
    }

    // public void setThickness(int thickness)
    // {
    // this.thickness = thickness;
    // }

    public void setStroke(Stroke stroke)
    {
        this.stroke = stroke;
    }

    public Stroke getStroke()
    {
        return stroke;
    }
}
