package plugins.ylemontag.sequencecomparator.gui;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

import plugins.ylemontag.sequencecomparator.GlobalComparisonPool;
import plugins.ylemontag.sequencecomparator.LocalComparisonPool;

public class MainPanel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	private ReferenceSequenceComponent _refComponent;
	private SampleSequenceComponent _sampleComponent;
	private GlobalComparatorComponent _globalComparatorComponent;
	private LocalComparatorComponent _localComparatorComponent;
	private JButton _refreshLUTButton;
	private JSplitPane _splitPane;
	private ErrorMeasureComponent _errorMeasureComponent;
	private JButton _enableSelectionButton;
	private JButton _disableSelectionButton;
	private OptionButton _optionButton;
	private ErrorMapChooserComponent _errorMapLUTButton;
	private JCheckBox _extendTComponent;
	private JCheckBox _extendZComponent;
	
	public ReferenceSequenceComponent getRefComponent() {
		return _refComponent;
	}
	
	public JCheckBox getExtendZComponent() {
		return _extendZComponent;
	}
	
	public JCheckBox getExtendTComponent() {
		return _extendTComponent;
	}
	
	public SampleSequenceComponent getSampleComponent() {
		return _sampleComponent;
	}
	
	public GlobalComparatorComponent getGlobalComparatorComponent() {
		return _globalComparatorComponent;
	}
	
	public LocalComparatorComponent getLocalComparatorComponent() {
		return _localComparatorComponent;
	}
	
	public JButton getRefreshLUTButton() {
		return _refreshLUTButton;
	}
	
	public ErrorMapChooserComponent getErrorMapLUTButton() {
		return _errorMapLUTButton;
	}
	
	public JButton getEnableSelectionButton() {
		return _enableSelectionButton;
	}
	
	public JButton getDisableSelectionButton() {
		return _disableSelectionButton;
	}
	
	public OptionButton getOptionButton() {
		return _optionButton;
	}
	
	public JSplitPane getSplitPane() {
		return _splitPane;
	}
	
	public ErrorMeasureComponent getErrorMeasureComponent() {
		return _errorMeasureComponent;
	}
	
	private String getSampleComponentTooltip() {
		return "List of all sequences that can be compared (i.e. that have the same size) to the reference sequence. The error maps are hidden.";
	}

	public MainPanel(GlobalComparisonPool globalComparisonPool, LocalComparisonPool localComparisonPool)
	{
		setBorder(new EmptyBorder(5, 5, 5, 5));
		setLayout(new BorderLayout(5, 5));
		
		_splitPane = new JSplitPane();
		add(_splitPane, BorderLayout.CENTER);
		_splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
		
		_errorMeasureComponent = new ErrorMeasureComponent();
		_splitPane.setRightComponent(_errorMeasureComponent);
		
		_sampleComponent = new SampleSequenceComponent(globalComparisonPool, localComparisonPool);
		_sampleComponent.setToolTipText(getSampleComponentTooltip());
		
		JScrollPane scrollPane = new JScrollPane(_sampleComponent);
		scrollPane.setToolTipText(getSampleComponentTooltip());
		_splitPane.setLeftComponent(scrollPane);
		
		JPanel panel_11 = new JPanel();
		add(panel_11, BorderLayout.NORTH);
		panel_11.setLayout(new BorderLayout(5, 5));
		
		JPanel panel_12 = new JPanel();
		panel_12.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_11.add(panel_12, BorderLayout.CENTER);
		panel_12.setLayout(new BorderLayout(0, 0));
		
		Component verticalStrut_9 = Box.createVerticalStrut(5);
		panel_12.add(verticalStrut_9, BorderLayout.NORTH);
		
		Component verticalStrut_10 = Box.createVerticalStrut(5);
		panel_12.add(verticalStrut_10, BorderLayout.SOUTH);
		
		Component horizontalStrut_9 = Box.createHorizontalStrut(5);
		panel_12.add(horizontalStrut_9, BorderLayout.EAST);
		
		Component horizontalStrut_10 = Box.createHorizontalStrut(5);
		panel_12.add(horizontalStrut_10, BorderLayout.WEST);
		
		JPanel panel_13 = new JPanel();
		panel_12.add(panel_13, BorderLayout.CENTER);
		panel_13.setLayout(new BoxLayout(panel_13, BoxLayout.Y_AXIS));
		
		JPanel panel_14 = new JPanel();
		panel_13.add(panel_14);
		panel_14.setLayout(new BoxLayout(panel_14, BoxLayout.X_AXIS));
		
		JLabel lblNewLabel_3 = new JLabel("Reference sequence");
		panel_14.add(lblNewLabel_3);
		
		Component horizontalGlue_2 = Box.createHorizontalGlue();
		panel_14.add(horizontalGlue_2);
		
		Component verticalStrut_11 = Box.createVerticalStrut(5);
		panel_13.add(verticalStrut_11);
		
		_refComponent = new ReferenceSequenceComponent();
		_refComponent.setToolTipText("The reference sequence can be understood as a ground truth. The plugin will compute and display the error between the reference sequence and a list of result sequences.");
		panel_13.add(_refComponent);
		
		Component verticalStrut_3 = Box.createVerticalStrut(5);
		panel_13.add(verticalStrut_3);
		
		JPanel panel_5 = new JPanel();
		panel_13.add(panel_5);
		panel_5.setLayout(new BoxLayout(panel_5, BoxLayout.X_AXIS));
		
		_extendZComponent = new JCheckBox("Extend Z");
		_extendZComponent.setToolTipText("Allow reference sequences with a single Z slice to be matched with multi-Z sequences");
		panel_5.add(_extendZComponent);
		
		Component horizontalStrut_6 = Box.createHorizontalStrut(20);
		panel_5.add(horizontalStrut_6);
		
		_extendTComponent = new JCheckBox("Extend T");
		_extendTComponent.setToolTipText("Allow reference sequences with a single T frame to be matched with multi-T sequences");
		panel_5.add(_extendTComponent);
		
		Component horizontalGlue = Box.createHorizontalGlue();
		panel_5.add(horizontalGlue);
		
		JPanel panel = new JPanel();
		panel.setBorder(new EtchedBorder(EtchedBorder.LOWERED, null, null));
		panel_11.add(panel, BorderLayout.EAST);
		panel.setLayout(new BorderLayout(0, 0));
		
		Component verticalStrut = Box.createVerticalStrut(5);
		panel.add(verticalStrut, BorderLayout.NORTH);
		
		Component verticalStrut_1 = Box.createVerticalStrut(5);
		panel.add(verticalStrut_1, BorderLayout.SOUTH);
		
		Component horizontalStrut = Box.createHorizontalStrut(5);
		panel.add(horizontalStrut, BorderLayout.WEST);
		
		Component horizontalStrut_1 = Box.createHorizontalStrut(5);
		panel.add(horizontalStrut_1, BorderLayout.EAST);
		
		JPanel panel_1 = new JPanel();
		panel.add(panel_1);
		panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
		
		JPanel panel_2 = new JPanel();
		panel_1.add(panel_2);
		panel_2.setLayout(new BorderLayout(5, 0));
		
		_globalComparatorComponent = new GlobalComparatorComponent();
		panel_2.add(_globalComparatorComponent, BorderLayout.CENTER);
		
		JLabel lblNewLabel = new JLabel("Error measure");
		panel_2.add(lblNewLabel, BorderLayout.WEST);
		
		Component verticalStrut_2 = Box.createVerticalStrut(5);
		panel_1.add(verticalStrut_2);
		
		JPanel panel_3 = new JPanel();
		panel_1.add(panel_3);
		panel_3.setLayout(new BorderLayout(5, 0));
		
		_localComparatorComponent = new LocalComparatorComponent();
		panel_3.add(_localComparatorComponent, BorderLayout.CENTER);
		
		JLabel lblNewLabel_1 = new JLabel("Error maps");
		panel_3.add(lblNewLabel_1, BorderLayout.WEST);
		
		Component verticalGlue = Box.createVerticalGlue();
		panel_1.add(verticalGlue);
		
		JPanel panel_4 = new JPanel();
		panel_11.add(panel_4, BorderLayout.SOUTH);
		panel_4.setLayout(new BoxLayout(panel_4, BoxLayout.X_AXIS));
		
		_refreshLUTButton = new JButton("Refresh LUTs");
		_refreshLUTButton.setToolTipText("Apply the reference's LUT to all compared sequences (this is done by default when an error measure or an error map is activated)");
		panel_4.add(_refreshLUTButton);
		
		Component horizontalStrut_2 = Box.createHorizontalStrut(5);
		panel_4.add(horizontalStrut_2);
		
		_errorMapLUTButton = new ErrorMapChooserComponent(localComparisonPool);
		_errorMapLUTButton.setToolTipText("Apply the LUT of a given error map to all other error maps");
		panel_4.add(_errorMapLUTButton);
		
		Component horizontalStrut_4 = Box.createHorizontalStrut(5);
		panel_4.add(horizontalStrut_4);
		
		_enableSelectionButton = new JButton("Enable error measure");
		_enableSelectionButton.setToolTipText("Enable error measure for all the selected sequences");
		panel_4.add(_enableSelectionButton);
		
		Component horizontalStrut_3 = Box.createHorizontalStrut(5);
		panel_4.add(horizontalStrut_3);
		
		_disableSelectionButton = new JButton("Disable error measure");
		_disableSelectionButton.setToolTipText("Disable error measure for all the selected sequences");
		panel_4.add(_disableSelectionButton);
		
		Component horizontalStrut_5 = Box.createHorizontalStrut(5);
		panel_4.add(horizontalStrut_5);
		
		_optionButton = new OptionButton();
		panel_4.add(_optionButton);
		
		//Component horizontalStrut_4 = Box.createHorizontalStrut(5);
		//panel_4.add(horizontalStrut_4);
		
		//JButton btnNewButton_2 = new JButton("SSIM options");
		//panel_4.add(btnNewButton_2);
	}
}
