/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.icy.gui.pair;

import plugins.adufour.ezplug.EzVar;
import plugins.adufour.vars.gui.model.VarEditorModel;

/**
 * EzVar for a Pair object.
 * 
 * @version May 3, 2014
 * 
 * @author Julien Jacquemot
 */
public class EzVarPair extends EzVar<Pair> {

	protected EzVarPair(VarPair variable, VarEditorModel<Pair> constraint) {
		super(variable, constraint);
	}

	protected EzVarPair(VarPair variable, Pair[] defaultValues,
			int defaultValueIndex, boolean allowUserInput) {
		super(variable, defaultValues, defaultValueIndex, allowUserInput);
	}

	/** Set the minimum for the first value of the pair. */
	public void setFirstMinimum(double min) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setFirstMinimum(min);
	}

	/** Returns the minimum for the first value of the pair. */
	public double getFirstMinimum() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getFirstMinimum();
	}

	/** Set the maximum for the first value of the pair. */
	public void setFirstMaximum(double max) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setFirstMaximum(max);
	}

	/** Returns the maximum for the first value of the pair. */
	public double getFirstMaximum() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getFirstMaximum();
	}

	/** Set the bounds for the first value of the pair. */
	public void setFirstBounds(double min, double max) {
		setFirstMinimum(min);
		setFirstMaximum(max);
	}

	/** Set the minimum for the second value of the pair. */
	public void setSecondMinimum(double min) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setSecondMinimum(min);
	}

	/** Returns the minimum for the second value of the pair. */
	public double getSecondMinimum() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getSecondMinimum();
	}

	/** Set the maximum for the second value of the pair. */
	public void setSecondMaximum(double max) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setSecondMaximum(max);
	}

	/** Returns the maximum for the second value of the pair. */
	public double getSecondMaximum() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getSecondMaximum();
	}

	/** Set the bounds for the second value of the pair. */
	public void setSecondBounds(double min, double max) {
		setSecondMinimum(min);
		setSecondMaximum(max);
	}

	/** Set the minimum for both values of the pair. */
	public void setMinimum(double min) {
		setFirstMinimum(min);
		setSecondMinimum(min);
	}

	/** Set the maximum for both values of the pair. */
	public void setMaximum(double max) {
		setFirstMaximum(max);
		setSecondMaximum(max);
	}

	/** Set the bounds for both values of the pair. */
	public void setBounds(double min, double max) {
		setFirstBounds(min, max);
		setSecondBounds(min, max);
	}

	/** Set the step size for the first value of the pair. */
	public void setFirstStepSize(double step) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setStepSize(step);
	}

	/** Returns the step size for the first value of the pair. */
	public double getFirstStepSize() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getFirstStepSize();
	}

	/** Set the step size for the second value of the pair. */
	public void setSecondStepSize(double step) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setStepSize(step);
	}

	/** Returns the step size for the second value of the pair. */
	public double getSecondStepSize() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getSecondStepSize();
	}

	/** Set the step size for both values of the pair. */
	public void setStepSize(double step) {
		setFirstStepSize(step);
		setSecondStepSize(step);
	}

	/**
	 * Set the linking word displayed between the first and the second value of
	 * the pair.
	 */
	public void setLinkingWord(final String word) {
		PairEditor editor = (PairEditor) getVarEditor();
		editor.setLinkingWord(word);
	}

	/**
	 * Returns the linking word displayed between the first and the second value
	 * of the pair.
	 */
	public String getLinkingWord() {
		PairEditor editor = (PairEditor) getVarEditor();
		return editor.getLinkingWord();
	}

	/**
	 * EzVarPair for a integer values (convenient class)
	 * 
	 * @version October 17, 2013
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Integer extends EzVarPair {
		public Integer(String varName) {
			this(varName, new Pair.Integer(0, 0), 0, (int) 10E6, 1);
		}

		public Integer(String varName, int min, int max, int step) {
			this(varName, new Pair.Integer(min, min), min, max, step);
		}

		public Integer(String varName, Pair.Integer value, int min, int max,
				int step) {
			this(varName, new PairRangeModel(value, min, max, new Pair.Integer(
					step, step)));
		}

		public Integer(String varName, VarEditorModel<Pair> constraint) {
			super(new VarPair(varName, constraint.getDefaultValue()),
					constraint);
		}

		public Integer(String varName, Pair.Integer[] defaultValues,
				boolean allowUserInput) throws NullPointerException {
			this(varName, defaultValues, 0, allowUserInput);
		}

		public Integer(String varName, Pair.Integer[] defaultValues,
				int defaultValueIndex, boolean allowUserInput)
				throws NullPointerException {
			super(new VarPair(varName, new Pair.Integer(0, 0)), defaultValues,
					defaultValueIndex, allowUserInput);
		}
	}

	/**
	 * EzVarPair for a double values (convenient class)
	 * 
	 * @version October 17, 2013
	 * @author Julien Jacquemot
	 * 
	 */
	public static class Double extends EzVarPair {
		public Double(String varName) {
			this(varName, new Pair.Double(0.0, 0.0), 0.0, 10E6, 1);
		}

		public Double(String varName, double min, double max, double step) {
			this(varName, new Pair.Double(min, min), min, max, step);
		}

		public Double(String varName, Pair.Double value, double min,
				double max, double step) {
			this(varName, new PairRangeModel(value, min, max, new Pair.Double(
					step, step)));
		}

		public Double(String varName, VarEditorModel<Pair> constraint) {
			super(new VarPair(varName, constraint.getDefaultValue()),
					constraint);
		}

		public Double(String varName, Pair.Double[] defaultValues,
				boolean allowUserInput) throws NullPointerException {
			this(varName, defaultValues, 0, allowUserInput);
		}

		public Double(String varName, Pair.Double[] defaultValues,
				int defaultValueIndex, boolean allowUserInput)
				throws NullPointerException {
			super(new VarPair(varName, new Pair.Double(0.0, 0.0)),
					defaultValues, defaultValueIndex, allowUserInput);
		}
	}
}
