/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.shape.priorshapes.shapes;

import plugins.big.bigsnakeutils.icy.snake2D.Snake2DNode;

/**
 * Shape prior with taking the shape of an electric guitar.
 * 
 * @version November 13, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class ElectricGuitar extends PriorShape {

	public ElectricGuitar() {
		name_ = new String("Electric guitar");
		minNumberNodes_ = 18;
		coef_ = new Snake2DNode[minNumberNodes_];
		coef_[0] = new Snake2DNode(252.99, 393.89412409921886);
		coef_[1] = new Snake2DNode(363.58073072960593, 358.5029645666088);
		coef_[2] = new Snake2DNode(273.6660229811351, 305.4013975838948);
		coef_[3] = new Snake2DNode(350.2524001690953, 231.9189995134855);
		coef_[4] = new Snake2DNode(289.3130498437619, 232.71522531288838);
		coef_[5] = new Snake2DNode(262.7785717528942, 243.44364781218206);
		coef_[6] = new Snake2DNode(260.9139965300148, 118.86694417181513);
		coef_[7] = new Snake2DNode(294.95792269120426, 78.2576861819989);
		coef_[8] = new Snake2DNode(260.07312367862386, 93.95238934295816);
		coef_[9] = new Snake2DNode(252.99, 67.10431510786776);
		coef_[10] = new Snake2DNode(245.90851943321692, 93.95282278854046);
		coef_[11] = new Snake2DNode(211.02275995087248, 78.26025464948907);
		coef_[12] = new Snake2DNode(245.06917141513625, 118.8674290322507);
		coef_[13] = new Snake2DNode(243.2122204102894, 243.4442465547047);
		coef_[14] = new Snake2DNode(216.67708579564336, 232.7174480136687);
		coef_[15] = new Snake2DNode(155.73768685453445, 231.92495177158142);
		coef_[16] = new Snake2DNode(232.32856109380396, 305.40266253594314);
		coef_[17] = new Snake2DNode(142.4171033956866, 358.50973231118286);
	}
}
