/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.system.thread.ThreadUtil;
import java.util.LinkedList;
import plugins.ylemontag.mathoperations.Controller;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.DimensionScalar;

public class Functor {
    private int _inputArguments;
    private String _describePattern;
    private FunPtr _functionPointer;

    public static Functor rawParse(String expr, String[] variables) {
        return Expression.parse(expr).getFunctor(variables);
    }

    public static Functor rawParse(String expr) {
        return Expression.parse(expr).getFunctor();
    }

    public static boolean isConsistentInputTypes(Variant.Type[] inputTypes) {
        try {
            Functor.computeOutputType(inputTypes);
            return true;
        }
        catch (InconsistentArguments err) {
            return false;
        }
    }

    public static Variant.DimensionType computeOutputType(Variant.Type[] inputTypes) {
        Variant.DimensionType retVal = Variant.DimensionType.SCALAR;
        block5: for (Variant.Type t : inputTypes) {
            if (t == null) continue;
            switch (t.getDimensionType()) {
                case SCALAR: {
                    continue block5;
                }
                case ARRAY: {
                    if (retVal == Variant.DimensionType.SCALAR || retVal == Variant.DimensionType.ARRAY) {
                        retVal = Variant.DimensionType.ARRAY;
                        continue block5;
                    }
                    throw new InconsistentArguments("Cannot operate on a array and on a " + retVal.toString().toLowerCase() + " at the same time.");
                }
                case SEQUENCE: {
                    if (retVal == Variant.DimensionType.SCALAR || retVal == Variant.DimensionType.SEQUENCE) {
                        retVal = Variant.DimensionType.SEQUENCE;
                        continue block5;
                    }
                    throw new InconsistentArguments("Cannot operate on a sequence and on a " + retVal.toString().toLowerCase() + " at the same time.");
                }
                default: {
                    throw new RuntimeException("Unreachable code point");
                }
            }
        }
        return retVal;
    }

    public Functor(int inputArguments, String describePattern, FunPtr functionPointer) {
        this._inputArguments = inputArguments;
        this._describePattern = describePattern;
        this._functionPointer = functionPointer;
    }

    public int getInputArgumentCount() {
        return this._inputArguments;
    }

    public String getFormatPattern() {
        return this._describePattern;
    }

    public FunPtr getFunctionPointer() {
        return this._functionPointer;
    }

    public String describeOperation(String[] inputs) {
        this.ensureValidNumberOfArguments(inputs.length);
        return String.format(this._describePattern, inputs);
    }

    public Variant apply(Variant[] inputs) {
        try {
            return this.apply(inputs, null);
        }
        catch (Controller.CanceledByUser err) {
            throw new RuntimeException("Unreachable code point");
        }
    }

    public void apply(Variant output, Variant[] inputs) {
        try {
            this.apply(output, inputs, null);
        }
        catch (Controller.CanceledByUser err) {
            throw new RuntimeException("Unreachable code point");
        }
    }

    public Variant apply(Variant[] inputs, Controller controller) throws Controller.CanceledByUser {
        Variant retVal = this.allocateOutput(inputs);
        this.apply(retVal, inputs, controller);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Variant output, Variant[] inputs, Controller controller) throws Controller.CanceledByUser {
        long currentNumberOfBlocks;
        Variant.Dimension thOutputDim;
        this.ensureValidNumberOfArguments(inputs.length);
        if (!output.isWritable()) {
            throw new InconsistentArguments("The allocated output object is not writable.");
        }
        for (Variant in : inputs) {
            if (in.isReadable()) continue;
            throw new InconsistentArguments("One of the input arguments is not readable.");
        }
        Variant.Dimension outputDim = output.getDimension();
        if (!outputDim.equals(thOutputDim = Functor.computeOutputDimension(inputs))) {
            throw new InconsistentArguments("The output does not have the right dimensions (expected: " + thOutputDim + "; current: " + outputDim + ").");
        }
        long sampleCount = outputDim.getFlatSize();
        int granularity = outputDim.getGranularity();
        if (granularity == 0 || sampleCount % (long)granularity != 0L) {
            throw new IllegalStateException("The granularity must be a divisor of the flat size.");
        }
        LinkedList<Job> jobs = new LinkedList<Job>();
        int maximumNumberOfJobs = SystemUtil.getAvailableProcessors();
        int minimumSamplesPerJob = 0x100000;
        int minimumBlocksPerJob = minimumSamplesPerJob / granularity;
        long startAt = 0L;
        for (long remainingBlocks = sampleCount / (long)granularity; remainingBlocks > 0L; remainingBlocks -= currentNumberOfBlocks) {
            int remainingJobs = maximumNumberOfJobs - jobs.size();
            if (remainingJobs <= 0) {
                throw new RuntimeException("Unreachable code point");
            }
            currentNumberOfBlocks = (remainingBlocks + (long)remainingJobs - 1L) / (long)remainingJobs;
            currentNumberOfBlocks = Math.max(currentNumberOfBlocks, (long)minimumBlocksPerJob);
            currentNumberOfBlocks = Math.min(currentNumberOfBlocks, remainingBlocks);
            long length = currentNumberOfBlocks * (long)granularity;
            jobs.addLast(new Job(output, inputs, controller, startAt, length));
            startAt += length;
        }
        try {
            if (controller != null) {
                controller.clearProbes();
                for (Job job : jobs) {
                    controller.pushProbe(job.getProbe());
                }
            }
            output.beginUpdate();
            try {
                if (jobs.size() == 0) {
                } else if (jobs.size() == 1) {
                    ((Job)jobs.getFirst()).doTheJob();
                } else {
                    Processor processor = new Processor(jobs.size(), SystemUtil.getAvailableProcessors());
                    for (Job job : jobs) {
                        processor.addTask((Runnable)job);
                    }
                    ThreadUtil.sleep((int)50);
                    processor.waitAll();
                    if (controller != null) {
                        controller.checkPoint();
                    }
                }
            }
            finally {
                output.endUpdate();
            }
        }
        finally {
            if (controller != null) {
                controller.clearProbes();
            }
        }
    }

    private void ensureValidNumberOfArguments(int inputLength) {
        if (inputLength != this._inputArguments) {
            throw new WrongArgumentNumber("Wrong number of input arguments (expected: " + this._inputArguments + "; current: " + inputLength + ").");
        }
    }

    private Variant allocateOutput(Variant[] inputs) {
        Variant retVal = Functor.computeOutputDimension(inputs).allocateNewVariant();
        if (retVal.getType() == Variant.Type.SEQUENCE) {
            String[] names = new String[inputs.length];
            for (int k = 0; k < inputs.length; ++k) {
                names[k] = inputs[k].getRepresentation(true);
            }
            retVal.getAsSequence().setName(this.describeOperation(names));
        }
        return retVal;
    }

    private static Variant.Dimension computeOutputDimension(Variant[] inputs) {
        Variant.Dimension retVal = new DimensionScalar();
        block5: for (Variant in : inputs) {
            switch (in.getType().getDimensionType()) {
                case SCALAR: {
                    continue block5;
                }
                case ARRAY: {
                    if (retVal.getType() == Variant.DimensionType.SCALAR) {
                        retVal = in.getDimension();
                        continue block5;
                    }
                    if (((Variant.Dimension)retVal).equals(in.getDimension())) continue block5;
                    throw new InconsistentArguments("Wrong combination of inputs: " + retVal + " together with " + in + ".");
                }
                case SEQUENCE: {
                    if (retVal.getType() == Variant.DimensionType.SCALAR) {
                        retVal = in.getDimension();
                        continue block5;
                    }
                    if (((Variant.Dimension)retVal).equals(in.getDimension())) continue block5;
                    throw new InconsistentArguments("Wrong combination of inputs: " + retVal + " together with " + in + ".");
                }
                default: {
                    throw new RuntimeException("Unreachable code point");
                }
            }
        }
        return retVal;
    }

    private class Job
    implements Runnable {
        private Variant _out;
        private Variant[] _in;
        private final Controller _controller;
        long _startAt;
        long _length;
        int _counter;

        public Job(Variant out, Variant[] in, Controller controller, long startAt, long length) {
            this._out = out;
            this._in = in;
            this._controller = controller;
            this._startAt = startAt;
            this._length = length;
            this._counter = 0;
        }

        public Controller.JobProbe getProbe() {
            return new Controller.JobProbe(){

                @Override
                public long getMaxStep() {
                    return Job.this._length;
                }

                @Override
                public long getCurrentStep() {
                    return Job.this._counter;
                }
            };
        }

        public void doTheJob() throws Controller.CanceledByUser {
            int k;
            if (this._controller != null) {
                this._controller.checkPoint();
            }
            double[] buffer = new double[this._in.length];
            Variant.ReadIterator[] itIn = new Variant.ReadIterator[this._in.length];
            Variant.WriteIterator itOut = this._out.getWriteIterator();
            itOut.startAt(this._startAt);
            for (k = 0; k < this._in.length; ++k) {
                itIn[k] = this._in[k].getReadIterator();
                itIn[k].startAt(this._startAt);
            }
            this._counter = 0;
            while ((long)this._counter < this._length) {
                if (this._controller != null) {
                    this._controller.checkPoint();
                }
                for (k = 0; k < this._in.length; ++k) {
                    buffer[k] = itIn[k].get();
                    itIn[k].next();
                }
                itOut.set(Functor.this._functionPointer.apply(buffer));
                itOut.next();
                ++this._counter;
            }
        }

        @Override
        public void run() {
            try {
                this.doTheJob();
            }
            catch (Controller.CanceledByUser canceledByUser) {
                // empty catch block
            }
        }
    }

    public static interface FunPtr {
        public double apply(double[] var1);
    }

    public static class WrongArgumentNumber
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public WrongArgumentNumber() {
        }

        public WrongArgumentNumber(String message) {
            super(message);
        }
    }

    public static class InconsistentArguments
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public InconsistentArguments() {
        }

        public InconsistentArguments(String message) {
            super(message);
        }
    }

    public static class UnsupportedArguments
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public UnsupportedArguments() {
        }

        public UnsupportedArguments(String message) {
            super(message);
        }
    }
}

