/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.BlockInfo;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.Variant;

public abstract class MathOperationAbstractBlock
extends Plugin
implements Block,
BlockInfo,
PluginBundled {
    private VarMutable _out;
    private Variant.DimensionType _outType;
    private Set<String> _staticVars;
    private Map<String, VarVariant> _inputs;

    protected MathOperationAbstractBlock(String outLabel) {
        this._out = new VarMutable(outLabel, null);
        this._outType = null;
        this._staticVars = new HashSet<String>();
        this._inputs = new HashMap<String, VarVariant>();
    }

    protected void addInputVariant(VarList inputMap, String name, String uid) {
        this._staticVars.add(name);
        inputMap.add(uid, (Var)new VarVariant(name));
    }

    protected void defineRuntimeInputVariants(VarList inputMap, String[] names) {
        if (names != null) {
            for (String name : names) {
                if (this._inputs.get(name) != null) continue;
                VarVariant v = new VarVariant(name);
                inputMap.addRuntimeVariable("dyn-" + name, (VarMutable)v);
            }
        }
        Set<String> toBeRemoved = this.getOutdatedVariables(names);
        for (String name : toBeRemoved) {
            VarVariant v = this._inputs.get(name);
            inputMap.remove((Var)v);
            this._inputs.remove(name);
        }
        this.refreshOutputType();
    }

    private Set<String> getOutdatedVariables(String[] runtimeVariables) {
        HashSet<String> retVal = new HashSet<String>();
        for (String name : this._inputs.keySet()) {
            if (this._staticVars.contains(name)) continue;
            if (runtimeVariables != null) {
                boolean inRuntimeVariables = false;
                for (String s : runtimeVariables) {
                    if (!name.equals(s)) continue;
                    inRuntimeVariables = true;
                    break;
                }
                if (inRuntimeVariables) continue;
            }
            retVal.add(name);
        }
        return retVal;
    }

    protected Variant retrieveInputValue(String name) {
        VarVariant v = this._inputs.get(name);
        if (v == null) {
            throw new IllegalArgumentException("Undeclared variable name: " + name + ".");
        }
        return v.getVariant();
    }

    protected void defineOutputValue(Variant value) {
        switch (value.getType()) {
            case SCALAR: {
                this._out.setValue((Object)value.getAsScalar());
                break;
            }
            case ARRAY: {
                this._out.setValue((Object)value.getAsArray());
                break;
            }
            case SEQUENCE: {
                this._out.setValue((Object)value.getAsSequence());
                break;
            }
            default: {
                throw new RuntimeException("Unreachable code point");
            }
        }
    }

    protected static void reportError(Functor.InconsistentArguments err, String description) {
        throw new VarException("Error while executing the operation " + description + ": " + err.getMessage());
    }

    private Variant.DimensionType computeOutputType() {
        for (VarVariant v : this._inputs.values()) {
            if (v.getVariantType() != null) continue;
            return null;
        }
        Variant.Type[] inputTypes = new Variant.Type[this._inputs.size()];
        int k = 0;
        for (VarVariant v : this._inputs.values()) {
            inputTypes[k] = v.getVariantType();
            ++k;
        }
        return Functor.computeOutputType(inputTypes);
    }

    private void refreshOutputType() {
        Variant.DimensionType newType = this.computeOutputType();
        if (this._outType == newType) {
            return;
        }
        if (this._out.isReferenced()) {
            Iterator outReferrersIt = this._out.getReferrers();
            ArrayList<Var> outReferrers = new ArrayList<Var>();
            while (outReferrersIt.hasNext()) {
                outReferrers.add((Var)outReferrersIt.next());
            }
            for (Var varCasted : outReferrers) {
                System.out.println("Remove ref on " + varCasted.getName());
                varCasted.setReference(null);
            }
        }
        this._outType = newType;
        if (this._outType == null) {
            this._out.setType(null);
        } else {
            switch (this._outType) {
                case SCALAR: {
                    this._out.setType(Double.class);
                    this._out.setValue((Object)0.0);
                    break;
                }
                case ARRAY: {
                    this._out.setType(double[].class);
                    this._out.setValue((Object)new double[0]);
                    break;
                }
                case SEQUENCE: {
                    this._out.setType(Sequence.class);
                    this._out.setValue(null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable code point");
                }
            }
        }
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Out", (Var)this._out);
    }

    public String getDescription() {
        return null;
    }

    private class VarVariant
    extends VarMutable {
        private Variant.Type _variantType;

        public VarVariant(String name) {
            super(name, null);
            this.addTypeChangeListener(new TypeChangeListener(){

                public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
                    VarVariant.this.updateVariantType(newType);
                    MathOperationAbstractBlock.this.refreshOutputType();
                }
            });
            MathOperationAbstractBlock.this._inputs.put(name, this);
        }

        public Variant.Type getVariantType() {
            return this._variantType;
        }

        public Variant getVariant() {
            if (this._variantType == null) {
                throw new VarException("No variable linked to the input '" + this.getName() + "'");
            }
            switch (this._variantType) {
                case SCALAR: {
                    return Variant.wrap(this.getScalar());
                }
                case ARRAY: {
                    return Variant.wrap(this.getArray());
                }
                case SEQUENCE: {
                    return Variant.wrap(this.getSequence());
                }
            }
            throw new RuntimeException("Unreachable code point");
        }

        public boolean isAssignableFrom(Var source) {
            Class sourceType = source.getType();
            if (this._variantType == null) {
                if (this.isScalarType(sourceType)) {
                    return this.willVariantTypeBeConsistent(Variant.Type.SCALAR);
                }
                if (this.isArrayType(sourceType)) {
                    return this.willVariantTypeBeConsistent(Variant.Type.ARRAY);
                }
                if (this.isSequenceType(sourceType)) {
                    return this.willVariantTypeBeConsistent(Variant.Type.SEQUENCE);
                }
                return false;
            }
            switch (this._variantType) {
                case SCALAR: {
                    return this.isScalarType(sourceType);
                }
                case ARRAY: {
                    return this.isArrayType(sourceType);
                }
                case SEQUENCE: {
                    return this.isSequenceType(sourceType);
                }
            }
            throw new RuntimeException("Unreachable code point");
        }

        private boolean willVariantTypeBeConsistent(Variant.Type futureType) {
            Variant.Type[] inputTypes = new Variant.Type[MathOperationAbstractBlock.this._inputs.size()];
            int k = 0;
            for (VarVariant v : MathOperationAbstractBlock.this._inputs.values()) {
                inputTypes[k] = v == this ? futureType : v.getVariantType();
                ++k;
            }
            return Functor.isConsistentInputTypes(inputTypes);
        }

        private void updateVariantType(Class<?> type) {
            if (type == null) {
                this._variantType = null;
            } else if (this.isScalarType(type)) {
                this._variantType = Variant.Type.SCALAR;
            } else if (this.isArrayType(type)) {
                this._variantType = Variant.Type.ARRAY;
            } else if (this.isSequenceType(type)) {
                this._variantType = Variant.Type.SEQUENCE;
            } else {
                throw new IllegalStateException("Illegal affectation: trying to link '" + this.getName() + "' to a variable with type " + type.getName());
            }
        }

        private boolean isScalarType(Class<?> type) {
            return type == Double.class || type == Float.class || type == Integer.class || type == Double.TYPE || type == Float.TYPE || type == Integer.TYPE;
        }

        private boolean isArrayType(Class<?> type) {
            return type == double[].class || type == float[].class || type == int[].class;
        }

        private boolean isSequenceType(Class<?> type) {
            return type == Sequence.class;
        }

        private double getScalar() {
            Class type = this.getType();
            if (type == Double.class || type == Double.TYPE) {
                return (Double)this.getValue(true);
            }
            if (type == Float.class || type == Float.TYPE) {
                return ((Float)this.getValue(true)).floatValue();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return ((Integer)this.getValue(true)).intValue();
            }
            throw new IllegalArgumentException("Cannot interpret '" + this.getName() + "' as a scalar value as it has type " + type.getName());
        }

        private double[] getArray() {
            Class type = this.getType();
            if (type == double[].class) {
                return (double[])this.getValue(true);
            }
            if (type == float[].class) {
                return Array1DUtil.floatArrayToDoubleArray((float[])((float[])this.getValue(true)));
            }
            if (type == int[].class) {
                return Array1DUtil.intArrayToDoubleArray((int[])((int[])this.getValue(true)), (boolean)true);
            }
            throw new IllegalArgumentException("Cannot interpret '" + this.getName() + "' as an array as it has type " + type.getName());
        }

        private Sequence getSequence() {
            Class type = this.getType();
            if (type == Sequence.class) {
                return (Sequence)this.getValue(true);
            }
            throw new IllegalArgumentException("Cannot interpret '" + this.getName() + "' as a sequence as it has type " + type.getName());
        }
    }
}

