/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonStripUI;

public class BasicCommandButtonStripUI
extends CommandButtonStripUI {
    protected JCommandButtonStrip buttonStrip;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandButtonStripUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonStrip = (JCommandButtonStrip)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.buttonStrip = null;
    }

    protected void installListeners() {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() == 1) {
                    BasicCommandButtonStripUI.this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.ONLY);
                } else {
                    BasicCommandButtonStripUI.this.buttonStrip.getButton(0).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.FIRST);
                    int i = 1;
                    while (i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() - 1) {
                        BasicCommandButtonStripUI.this.buttonStrip.getButton(i).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE);
                        ++i;
                    }
                    BasicCommandButtonStripUI.this.buttonStrip.getButton(BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() - 1).setLocationOrderKind(AbstractCommandButton.CommandButtonLocationOrderKind.LAST);
                }
            }
        };
        this.buttonStrip.addChangeListener(this.changeListener);
    }

    protected void uninstallListeners() {
        this.buttonStrip.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    protected void installDefaults() {
        this.buttonStrip.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.buttonStrip.setLayout(this.createLayoutManager());
    }

    protected void uninstallComponents() {
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonStripLayout();
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private ButtonStripLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int i;
            int width = 0;
            int height = 0;
            if (BasicCommandButtonStripUI.this.buttonStrip.getOrientation() == JCommandButtonStrip.StripOrientation.HORIZONTAL) {
                i = 0;
                while (i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                    width += BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width;
                    height = Math.max(height, BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height);
                    ++i;
                }
            } else {
                i = 0;
                while (i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                    height += BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().height;
                    width = Math.max(width, BasicCommandButtonStripUI.this.buttonStrip.getButton((int)i).getPreferredSize().width);
                    ++i;
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            if (BasicCommandButtonStripUI.this.buttonStrip.getButtonCount() == 0) {
                return;
            }
            Insets ins = c.getInsets();
            int height = c.getHeight() - ins.top - ins.bottom;
            int width = c.getWidth() - ins.left - ins.right;
            if (BasicCommandButtonStripUI.this.buttonStrip.getOrientation() == JCommandButtonStrip.StripOrientation.HORIZONTAL) {
                int totalPreferredWidth = 0;
                int i = 0;
                while (i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredWidth += currButton.getPreferredSize().width;
                    ++i;
                }
                int deltaX = (width - totalPreferredWidth) / BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                if (BasicCommandButtonStripUI.this.buttonStrip.getComponentOrientation().isLeftToRight()) {
                    int x = ins.left;
                    int i2 = 0;
                    while (i2 < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i2);
                        currButton.setBounds(x, ins.top, currButton.getPreferredSize().width + deltaX, height);
                        x += currButton.getPreferredSize().width + deltaX;
                        ++i2;
                    }
                } else {
                    int x = c.getWidth() - ins.right;
                    int i3 = 0;
                    while (i3 < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                        AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i3);
                        int buttonWidth = currButton.getPreferredSize().width + deltaX;
                        currButton.setBounds(x - buttonWidth, ins.top, buttonWidth, height);
                        x -= buttonWidth;
                        ++i3;
                    }
                }
            } else {
                int totalPreferredHeight = 0;
                int i = 0;
                while (i < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i);
                    totalPreferredHeight += currButton.getPreferredSize().height;
                    ++i;
                }
                float deltaY = (float)(height - totalPreferredHeight) / (float)BasicCommandButtonStripUI.this.buttonStrip.getButtonCount();
                float y = ins.top;
                int i4 = 0;
                while (i4 < BasicCommandButtonStripUI.this.buttonStrip.getButtonCount()) {
                    AbstractCommandButton currButton = BasicCommandButtonStripUI.this.buttonStrip.getButton(i4);
                    float buttonHeight = (float)currButton.getPreferredSize().height + deltaY;
                    currButton.setBounds(ins.left, (int)y, width, (int)Math.ceil(buttonHeight));
                    y += buttonHeight;
                    ++i4;
                }
            }
        }
    }
}

