/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.flamingo.common.TransitionAwareResizableIcon;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonBandBorder;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceRibbonBandUI
extends BasicRibbonBandUI {
    protected Set lafWidgets;

    @Override
    protected void installComponents() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installListeners() {
        super.installListeners();
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceRibbonBandUI();
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installDefaults() {
        super.installDefaults();
        SubstanceLookAndFeel.setDecorationType(this.ribbonBand, DecorationAreaType.GENERAL);
        Color backgr = this.ribbonBand.getBackground();
        if (backgr == null || backgr instanceof UIResource) {
            Color toSet = SubstanceColorSchemeUtilities.getColorScheme(this.ribbonBand, ComponentState.ENABLED).getBackgroundFillColor();
            this.ribbonBand.setBackground(new ColorUIResource(toSet));
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType(this.ribbonBand);
        super.uninstallDefaults();
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonBandUI__installComponents() {
        super.installComponents();
        SubstanceLookAndFeel.setDecorationType(this.ribbonBand, DecorationAreaType.GENERAL);
        if (this.expandButton != null) {
            this.expandButton.putClientProperty("substancelaf.useThemedDefaultIcons", Boolean.FALSE);
            this.expandButton.setFocusable(false);
        }
    }

    @Override
    protected void paintBandTitle(Graphics graphics, Rectangle titleRectangle, String title) {
        if (titleRectangle.width <= 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setFont(UIManager.getFont("Ribbon.font"));
        FontMetrics fm = graphics.getFontMetrics();
        int currLength = (int)fm.getStringBounds(title, g2d).getWidth();
        String titleToPaint = title;
        while (currLength > titleRectangle.width) {
            title = title.substring(0, title.length() - 1);
            titleToPaint = title + "...";
            currLength = (int)fm.getStringBounds(titleToPaint, g2d).getWidth();
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(this.ribbonBand);
        SubstanceColorScheme bgColorScheme = skin.getBackgroundColorScheme(DecorationAreaType.HEADER);
        Color bgFillColor = bgColorScheme.getBackgroundFillColor();
        Color fgColor = bgColorScheme.getForegroundColor();
        fgColor = SubstanceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, 0.8f);
        g2d.setColor(fgColor);
        int deltaX = (titleRectangle.width - currLength) / 2;
        int deltaY = (titleRectangle.height - fm.getAscent() - fm.getDescent()) / 2;
        Rectangle smallTitleRectangle = new Rectangle(titleRectangle.x + deltaX, titleRectangle.y + deltaY, titleRectangle.width - 2 * deltaX, titleRectangle.height - 2 * deltaY);
        SubstanceTextUtilities.paintText(g2d, this.ribbonBand, smallTitleRectangle, titleToPaint, -1, g2d.getFont(), g2d.getColor(), g2d.getClipBounds());
        g2d.dispose();
    }

    @Override
    protected void paintBandTitleBackground(Graphics g, Rectangle titleRectangle, String title) {
        MatteFillPainter gradientPainter = new MatteFillPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(this.ribbonBand);
        SubstanceColorScheme colorScheme = skin.getBackgroundColorScheme(DecorationAreaType.HEADER);
        boolean isDark = colorScheme.isDark();
        float alpha = 0.85f - (isDark ? 0.15f : 0.35f) * this.rolloverAmount;
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite(this.ribbonBand, alpha, g));
        SubstanceRibbonBandBorder border = (SubstanceRibbonBandBorder)this.ribbonBand.getBorder();
        float cornerRadius = border.getCornerRadius(this.ribbonBand);
        GeneralPath outline = new GeneralPath();
        outline.moveTo(0.0f, 0.0f);
        outline.lineTo(titleRectangle.width, 0.0f);
        outline.lineTo(titleRectangle.width, (float)titleRectangle.height - cornerRadius - 1.0f);
        outline.append(new Arc2D.Double((float)titleRectangle.width - 2.0f * cornerRadius - 1.0f, (float)(titleRectangle.height - 1) - 2.0f * cornerRadius, 2.0f * cornerRadius, 2.0f * cornerRadius, 0.0, -90.0, 0), true);
        outline.lineTo(cornerRadius, titleRectangle.height - 1);
        outline.append(new Arc2D.Double(0.0, (float)titleRectangle.height - 2.0f * cornerRadius - 1.0f, 2.0f * cornerRadius, 2.0f * cornerRadius, 270.0, -90.0, 0), true);
        outline.lineTo(0.0f, 0.0f);
        g2d.translate(titleRectangle.x, titleRectangle.y);
        gradientPainter.paintContourBackground(g2d, this.ribbonBand, titleRectangle.width, titleRectangle.height, outline, false, colorScheme, false);
        g2d.setColor(colorScheme.getMidColor());
        g2d.setStroke(new BasicStroke(1.2f));
        g2d.draw(outline);
        SubstanceColorScheme separatorScheme = SubstanceLookAndFeel.getCurrentSkin(this.ribbonBand).getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        g2d.setComposite(LafWidgetUtilities.getAlphaComposite(this.ribbonBand, alpha * 0.7f, g));
        SeparatorPainterUtils.paintSeparator(this.ribbonBand, g2d, separatorScheme, titleRectangle.width, 1, 0, false, 0, 0, true);
        g2d.dispose();
    }

    @Override
    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        SubstanceRibbonBandUI.paintRibbonBandBackground(graphics, this.ribbonBand, this.rolloverAmount, 0);
    }

    public static void paintRibbonBandBackground(Graphics graphics, Component comp, float rolloverAmount, int dy) {
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(comp);
        SubstanceColorScheme bgScheme = skin.getBackgroundColorScheme(SubstanceLookAndFeel.getDecorationType(comp));
        int offset = 20 - dy;
        float bp = (float)offset / (float)comp.getHeight();
        Color c1 = bgScheme.getUltraLightColor();
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(bgScheme.getUltraLightColor(), bgScheme.getExtraLightColor(), rolloverAmount);
        Color c3 = SubstanceColorUtilities.getInterpolatedColor(bgScheme.getExtraLightColor(), bgScheme.getLightColor(), rolloverAmount);
        Color c4 = SubstanceColorUtilities.getInterpolatedColor(bgScheme.getUltraLightColor(), bgScheme.getExtraLightColor(), rolloverAmount);
        LinearGradientPaint fillPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, comp.getHeight(), new float[]{0.0f, bp - 1.0E-5f, bp, 1.0f}, new Color[]{c1, c2, c3, c4});
        Graphics2D g2d = (Graphics2D)graphics.create();
        g2d.setPaint(fillPaint);
        g2d.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        SubstanceWatermark watermark = skin.getWatermark();
        if (watermark != null && SubstanceCoreUtilities.toDrawWatermark(comp)) {
            watermark.drawWatermarkImage(g2d, comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.dispose();
    }

    @Override
    public int getBandTitleHeight() {
        return 1 + SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.ribbonBand), 17, 1, 1, false);
    }

    @Override
    protected JCommandButton createExpandButton() {
        RibbonBandExpandButton result = new RibbonBandExpandButton();
        SubstanceLookAndFeel.setDecorationType(result, DecorationAreaType.HEADER);
        result.setIcon(SubstanceRibbonBandUI.getExpandButtonIcon(result));
        return result;
    }

    private static ResizableIcon getExpandButtonIcon(final AbstractCommandButton button) {
        final int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
        int arrowIconHeight = (int)SubstanceSizeUtils.getSmallArrowIconHeight(fontSize) + 2;
        int arrowIconWidth = (int)SubstanceSizeUtils.getSmallArrowIconWidth(fontSize);
        TransitionAwareResizableIcon arrowIcon = new TransitionAwareResizableIcon(button, new TransitionAwareResizableIcon.StateTransitionTrackerDelegate(){

            @Override
            public StateTransitionTracker getStateTransitionTracker() {
                return ((ActionPopupTransitionAwareUI)((Object)button.getUI())).getActionTransitionTracker();
            }
        }, new TransitionAwareResizableIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme, int width, int height) {
                return SubstanceImageCreator.getDoubleArrowIcon(SubstanceSizeUtils.getComponentFontSize(button), width, height, SubstanceSizeUtils.getDoubleArrowStrokeWidth(fontSize), button.getComponentOrientation().isLeftToRight() ? 3 : 7, scheme);
            }
        }, new Dimension(arrowIconWidth, arrowIconHeight));
        return arrowIcon;
    }

    @Override
    protected void syncExpandButtonIcon() {
        ResizableIcon icon = SubstanceRibbonBandUI.getExpandButtonIcon(this.expandButton);
        this.expandButton.setIcon(icon);
    }

    private class RibbonBandExpandButton
    extends JCommandButton
    implements SubstanceInternalButton {
        public RibbonBandExpandButton() {
            super(null, null);
            this.setFocusable(false);
            this.setBorder(new EmptyBorder(3, 2, 3, 2));
            this.setActionKeyTip(SubstanceRibbonBandUI.this.ribbonBand.getExpandButtonKeyTip());
            this.setActionRichTooltip(SubstanceRibbonBandUI.this.ribbonBand.getExpandButtonRichTooltip());
        }
    }
}

