/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackPainterChangeEvent;
import plugins.fab.trackmanager.TrackPainterListener;
import plugins.fab.trackmanager.TrackPool;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackManagerPainter
extends Overlay {
    private TrackPool trackPool = null;
    private List<TrackPainterListener> trackPainterListener = new ArrayList<TrackPainterListener>();
    private boolean drawTracksOnSequence = true;
    private boolean subPixelicDisplay = true;

    public TrackManagerPainter(TrackPool trackPool) {
        super("Track painter");
        this.trackPool = trackPool;
    }

    public boolean isSubPixelicDisplay() {
        return this.subPixelicDisplay;
    }

    public void setSubPixelicDisplay(boolean subPixelicDisplay) {
        this.subPixelicDisplay = subPixelicDisplay;
    }

    public void mouseClick(MouseEvent e, Point2D p, IcyCanvas icyCanvas) {
        if (e.isConsumed()) {
            return;
        }
        float distanceThresholdSqr = (float)icyCanvas.canvasToImageDeltaX(3);
        distanceThresholdSqr *= distanceThresholdSqr;
        for (TrackGroup tg : this.trackPool.getTrackGroupList()) {
            block1: for (TrackSegment ts : tg.getTrackSegmentList()) {
                for (Detection d : ts.getDetectionList()) {
                    double dist;
                    if (!d.isEnabled() || !((dist = new Point2D.Double(p.getX(), p.getY()).distanceSq(new Point2D.Double(d.getX(), d.getY()))) < (double)distanceThresholdSqr)) continue;
                    TrackSegment ts1 = this.trackPool.getTrackSegmentWithDetection(d);
                    if (ts1 == null) continue block1;
                    ts1.setAllDetectionSelected(!ts1.isAllDetectionSelected());
                    this.trackPool.getDisplaySequence().overlayChanged((Overlay)this);
                    this.fireTrackPainterEvent();
                    e.consume();
                    continue block1;
                }
            }
        }
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (this.trackPool != null && this.trackPool.getTrackManager() != null && canvas != null && this.trackPool.getTrackManager().currentT != canvas.getPositionT()) {
            this.trackPool.getTrackManager().currentT = canvas.getPositionT();
            this.trackPool.getTrackManager().trackPanel.recomputeProcessors();
        }
        if (!this.isDrawTracksOnSequence()) {
            return;
        }
        if (canvas instanceof Canvas2D) {
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            Line2D.Double line = new Line2D.Double();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.RED);
            g2.translate(0.5, 0.5);
            float trackWidth = (float)canvas.canvasToImageLogDeltaX(2);
            g2.setStroke(new BasicStroke(trackWidth));
            ArrayList<Detection> allDetections = new ArrayList<Detection>();
            ArrayList<TrackLineSection> lineSections = new ArrayList<TrackLineSection>();
            ArrayList<TrackLineSection> connectorSections = new ArrayList<TrackLineSection>();
            for (SwimmingObject result : this.trackPool.resultList) {
                TrackGroup tg = (TrackGroup)result.getObject();
                for (TrackSegment ts : tg.getTrackSegmentList()) {
                    Detection endDetection;
                    ArrayList<Detection> detectionList = ts.getDetectionList();
                    allDetections.addAll(detectionList);
                    if (detectionList.size() > 1) {
                        Detection startDetection = (Detection)detectionList.get(0);
                        for (int i = 1; i < ts.getDetectionList().size(); ++i) {
                            endDetection = (Detection)detectionList.get(i);
                            lineSections.add(new TrackLineSection(startDetection, endDetection));
                            startDetection = endDetection;
                        }
                    }
                    if (!ts.getLastDetection().isEnabled()) continue;
                    for (TrackSegment tsNext : ts.nextList) {
                        endDetection = tsNext.getFirstDetection();
                        if (!endDetection.isEnabled()) continue;
                        connectorSections.add(new TrackLineSection(ts.getLastDetection(), endDetection));
                    }
                }
            }
            g2.setStroke(new BasicStroke(trackWidth * 3.0f));
            g2.setColor(Color.white);
            for (TrackLineSection lineSection : lineSections) {
                if (!lineSection.isEnabled() || !lineSection.isSelected() || !GraphicsUtil.isVisible((Graphics)g2, (Rectangle2D)lineSection.getBounds(bounds, trackWidth * 2.0f))) continue;
                g2.draw(lineSection.getLine2D(line));
            }
            g2.setStroke(new BasicStroke(trackWidth));
            for (TrackLineSection lineSection : lineSections) {
                if (!lineSection.isEnabled() || !GraphicsUtil.isVisible((Graphics)g2, (Rectangle2D)lineSection.getBounds(bounds, trackWidth))) continue;
                g2.setColor(lineSection.getColor());
                g2.draw(lineSection.getLine2D(line));
            }
            g2.setColor(Color.green);
            for (TrackLineSection lineSection : connectorSections) {
                if (!GraphicsUtil.isVisible((Graphics)g2, (Rectangle2D)lineSection.getBounds(bounds, trackWidth))) continue;
                g2.draw(lineSection.getLine2D(line));
            }
            for (Detection detection : allDetections) {
                if (!detection.isEnabled() || detection.getT() != canvas.getPositionT()) continue;
                double x = detection.getX();
                double y = detection.getY();
                bounds.setFrame(x - (double)trackWidth * 1.5, y - (double)trackWidth * 1.5, trackWidth * 3.0f, trackWidth * 3.0f);
                if (!GraphicsUtil.isVisible((Graphics)g2, (Rectangle2D)bounds)) continue;
                ellipse.setFrame(bounds);
                g2.setColor(detection.getColor());
                g2.draw(ellipse);
            }
            g2.dispose();
        }
    }

    public void addTrackPainterListener(TrackPainterListener trackPainterListener) {
        this.trackPainterListener.add(trackPainterListener);
    }

    public void removeTrackPainterListener(TrackPainterListener trackPainterListener) {
        this.trackPainterListener.remove(trackPainterListener);
    }

    private void fireTrackPainterEvent() {
        for (TrackPainterListener tpl : this.trackPainterListener) {
            tpl.trackPainterChanged(new TrackPainterChangeEvent((Object)this));
        }
    }

    public boolean isDrawTracksOnSequence() {
        return this.drawTracksOnSequence;
    }

    public void setDrawTracksOnSequence(boolean drawTracksOnSequence) {
        this.drawTracksOnSequence = drawTracksOnSequence;
    }

    private class TrackLineSection {
        final Detection start;
        final Detection end;

        public TrackLineSection(Detection start, Detection end) {
            this.start = start;
            this.end = end;
        }

        public Line2D getLine2D(Line2D line) {
            line.setLine(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY());
            return line;
        }

        public Color getColor() {
            return this.start.getColor();
        }

        public Rectangle2D getBounds(Rectangle2D bounds, float stroke) {
            bounds.setFrameFromDiagonal(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY());
            ShapeUtil.enlarge((RectangularShape)bounds, (double)stroke, (double)stroke, (boolean)true);
            return bounds;
        }

        public boolean isSelected() {
            return this.start.isSelected() && this.end.isSelected();
        }

        public boolean isEnabled() {
            return this.start.isEnabled() && this.end.isEnabled();
        }
    }
}

