/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.ShortArray;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ShortGenerator;

public class ShortScalar
extends Scalar
implements ShortArray {
    final short[] data;
    final int offset;
    final boolean flat;

    public ShortScalar() {
        this.data = new short[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public ShortScalar create() {
        return new ShortScalar();
    }

    public ShortScalar(short[] arr, int idx) {
        this.data = arr;
        this.offset = idx;
        this.flat = idx == 0 && arr.length == 1;
        this.checkSanity();
    }

    public static ShortScalar wrap(short[] arr, int idx) {
        return new ShortScalar(arr, idx);
    }

    public ShortScalar(short value) {
        this.data = new short[]{value};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final short get() {
        return this.data[this.offset];
    }

    public final void set(short value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(short value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(ShortGenerator generator) {
        this.data[this.offset] = generator.nextShort();
    }

    @Override
    public final void increment(short value) {
        int n = this.offset;
        this.data[n] = (short)(this.data[n] + value);
    }

    @Override
    public final void decrement(short value) {
        int n = this.offset;
        this.data[n] = (short)(this.data[n] - value);
    }

    @Override
    public final void scale(short value) {
        int n = this.offset;
        this.data[n] = (short)(this.data[n] * value);
    }

    @Override
    public final void map(ShortFunction function) {
        this.data[this.offset] = function.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(ShortScanner scanner) {
        scanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final short[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final short[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        return new short[]{this.data[this.offset]};
    }

    @Override
    public final short[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public short min() {
        return this.data[this.offset];
    }

    @Override
    public short max() {
        return this.data[this.offset];
    }

    @Override
    public short[] getMinAndMax() {
        short[] result = new short[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(short[] mm) {
        short value;
        mm[0] = value = this.data[this.offset];
        mm[1] = value;
    }

    @Override
    public int sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return this;
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar(this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar(this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar(this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Short1D as1D() {
        if (this.offset == 0) {
            return new FlatShort1D(this.data, 1);
        }
        return new StriddenShort1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (src.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)src).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)src).get();
                break;
            }
            case 2: {
                this.data[this.offset] = (short)((IntScalar)src).get();
                break;
            }
            case 3: {
                this.data[this.offset] = (short)((LongScalar)src).get();
                break;
            }
            case 4: {
                this.data[this.offset] = (short)((FloatScalar)src).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (short)((DoubleScalar)src).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (short)src.get(0);
    }

    @Override
    public final ShortScalar copy() {
        return new ShortScalar(this.data[this.offset]);
    }
}

