/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.intensityprofile;

import icy.file.FileUtil;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.ActiveViewerListener;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.image.IcyBufferedImage;
import icy.image.IntensityInfo;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.thread.ThreadUtil;
import icy.type.collection.array.Array1DUtil;
import icy.util.XLSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class IntensityProfile
extends PluginActionable
implements ActionListener,
ROIListener {
    IcyFrame mainFrame = new IcyFrame("Intensity profile", true);
    JButton associateROIButton = new JButton("Associate selected ROI");
    JButton exportToExcelButton = new JButton("Export to excel");
    JButton exportToConsoleButton = new JButton("Export to console");
    JCheckBox graphOverZ = new JCheckBox("Graph Z");
    ChartPanel chartPanel;
    JFreeChart chart;
    XYSeriesCollection xyDataset = new XYSeriesCollection();
    JCheckBox OPTION_meanAlongZ = new JCheckBox("Mean along current Z");
    JCheckBox OPTION_meanAlongT = new JCheckBox("Mean along current T");
    ArrayList<Marker> markerDomainList = new ArrayList();
    ArrayList<Marker> markerRangeList = new ArrayList();
    ROI associatedROI = null;
    Runnable updateRunnable;

    public void run() {
        this.mainFrame.getContentPane().setLayout(new BoxLayout(this.mainFrame.getContentPane(), 3));
        this.mainFrame.getContentPane().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.associateROIButton, this.exportToConsoleButton, this.exportToExcelButton}));
        this.mainFrame.getContentPane().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.OPTION_meanAlongZ, this.OPTION_meanAlongT}));
        this.exportToExcelButton.addActionListener(this);
        this.OPTION_meanAlongZ.addActionListener(this);
        this.OPTION_meanAlongT.addActionListener(this);
        this.exportToConsoleButton.addActionListener(this);
        this.chart = ChartFactory.createXYLineChart((String)"Intensity profile", (String)"", (String)"intensity", (XYDataset)this.xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.chartPanel = new ChartPanel(this.chart, 500, 200, 500, 200, 500, 500, false, false, true, true, true, true);
        this.mainFrame.getContentPane().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.chartPanel}));
        Sequence activeSequence = this.getActiveSequence();
        if (activeSequence != null && activeSequence.getROIs().size() > 0) {
            this.associatedROI = (ROI)activeSequence.getROIs().get(0);
        }
        if (this.associatedROI != null) {
            this.associatedROI.addListener((ROIListener)this);
        }
        this.updateChart();
        this.associateROIButton.addActionListener(this);
        this.mainFrame.setVisible(true);
        this.mainFrame.addToDesktopPane();
        this.mainFrame.pack();
        this.mainFrame.center();
        this.mainFrame.toFront();
        Icy.getMainInterface().addActiveSequenceListener(new ActiveSequenceListener(){

            public void sequenceDeactivated(Sequence sequence) {
            }

            public void sequenceActivated(Sequence sequence) {
            }

            public void activeSequenceChanged(SequenceEvent event) {
                if (event.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
                    IntensityProfile.this.updateChart();
                }
            }
        });
        Icy.getMainInterface().addActiveViewerListener(new ActiveViewerListener(){

            public void viewerDeactivated(Viewer viewer) {
                IntensityProfile.this.updateChart();
            }

            public void viewerActivated(Viewer viewer) {
                IntensityProfile.this.updateChart();
            }

            public void activeViewerChanged(ViewerEvent event) {
                if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED) {
                    IntensityProfile.this.updateChart();
                }
            }
        });
    }

    private void updateChart() {
        this.chart.setAntiAlias(true);
        this.chart.setTextAntiAlias(true);
        if (this.updateRunnable == null) {
            this.updateRunnable = new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.updateChartThreaded();
                }
            };
        }
        ThreadUtil.bgRunSingle((Runnable)this.updateRunnable);
    }

    private void updateChartThreaded() {
        this.removeAllHorizontalRangeMarker();
        if (this.associatedROI != null && this.associatedROI.getSequences().size() == 0) {
            this.associatedROI = null;
        }
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                IntensityProfile.this.xyDataset.removeAllSeries();
            }
        });
        int currentZ = 0;
        int currentT = 0;
        Viewer v = Icy.getMainInterface().getFirstViewerContaining(this.associatedROI);
        if (v != null) {
            currentZ = v.getPositionZ();
            currentT = v.getPositionT();
        }
        if (currentZ < 0) {
            currentZ = 0;
        }
        if (currentT < 0) {
            currentT = 0;
        }
        if (this.associatedROI != null) {
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.chart.setTitle("Intensity profile of ROI " + IntensityProfile.this.associatedROI.getName());
                }
            });
            Sequence sequence = (Sequence)this.associatedROI.getSequences().get(0);
            if (this.associatedROI instanceof ROI2DLine || this.associatedROI instanceof ROI2DPolyLine) {
                ROI2DShape roiShape = (ROI2DShape)this.associatedROI;
                ArrayList pointList = roiShape.getPoints();
                this.computeLineProfile(pointList, currentT, currentZ, sequence);
                if (this.OPTION_meanAlongZ.isSelected()) {
                    this.computeZMeanLineProfile(pointList, currentT, sequence);
                }
                if (this.OPTION_meanAlongT.isSelected()) {
                    this.computeTMeanLineProfile(pointList, currentZ, sequence);
                }
            } else if (this.associatedROI instanceof ROI2DRectangle || this.associatedROI instanceof ROI2DEllipse || this.associatedROI instanceof ROI2DPolygon || this.associatedROI instanceof ROI2DArea) {
                List<Object> pointList;
                boolean isRectOrPoly;
                ROI2D roi = (ROI2D)this.associatedROI;
                boolean bl = isRectOrPoly = roi instanceof ROI2DRectangle || roi instanceof ROI2DPolygon;
                if (isRectOrPoly) {
                    pointList = ((ROI2DShape)roi).getPoints();
                    if (!this.isCCW((List<Point2D>)pointList)) {
                        Collections.reverse(pointList);
                    }
                    this.shiftToMinYMinXPoint((List<Point2D>)pointList);
                    if (pointList != null && !pointList.isEmpty()) {
                        pointList.add(pointList.get(0));
                    }
                } else {
                    pointList = roi.getBooleanMask2D(-1, currentT, -1, true).getConnectedContourPoints().stream().map(p -> new Point2D.Double(p.x, p.y)).collect(Collectors.toList());
                }
                this.computeLineProfile(pointList, currentT, currentZ, sequence, isRectOrPoly);
                if (this.OPTION_meanAlongZ.isSelected()) {
                    this.computeZMeanLineProfile(pointList, currentT, sequence);
                }
                if (this.OPTION_meanAlongT.isSelected()) {
                    this.computeTMeanLineProfile(pointList, currentZ, sequence);
                }
            } else {
                ROI roi = this.associatedROI;
                this.getValueForSurfaceAllComponent(roi, sequence, currentT, currentZ);
                if (this.OPTION_meanAlongZ.isSelected()) {
                    this.computeSurfaceProfileAlongZ(roi, sequence, currentT);
                }
                if (this.OPTION_meanAlongT.isSelected()) {
                    this.computeSurfaceProfileAlongT(roi, sequence, currentZ);
                }
            }
        }
        this.chart.fireChartChanged();
    }

    private boolean isCCW(List<Point2D> pointList) {
        double area = 0.0;
        Iterator<Point2D> it = pointList.iterator();
        Point2D prev = null;
        if (it.hasNext()) {
            prev = pointList.get(pointList.size() - 1);
        }
        while (it.hasNext()) {
            Point2D curr = it.next();
            area += (curr.getX() - prev.getX()) * (curr.getY() + prev.getY());
            prev = curr;
        }
        return area <= 0.0;
    }

    private void shiftToMinYMinXPoint(List<Point2D> pointList) {
        int i;
        ArrayList<Point2D> tempList = new ArrayList<Point2D>(pointList);
        int shiftNumber = 0;
        Point2D minPt = tempList.isEmpty() ? null : (Point2D)tempList.get(0);
        ListIterator it = tempList.listIterator();
        int size = tempList.size();
        for (i = 0; i < size; ++i) {
            Point2D currPt = (Point2D)it.next();
            if (!(currPt.getY() < minPt.getY()) && (currPt.getY() != minPt.getY() || !(currPt.getX() < minPt.getX()))) continue;
            shiftNumber = i;
            minPt = currPt;
        }
        pointList.clear();
        i = 0;
        int pos = shiftNumber;
        while (i < size) {
            pointList.add((Point2D)tempList.get(pos % size));
            ++i;
            ++pos;
        }
    }

    private void getValueForSurfaceAllComponent(ROI roi, Sequence sequence, final int currentT, final int currentZ) {
        int c = 0;
        while (c < sequence.getSizeC()) {
            final XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean of surface channel #" + c + " t:" + currentT + " z:" + currentZ)));
            IntensityInfo intensityInfo = ROIUtil.getIntensityInfo((Sequence)sequence, (ROI)roi, (int)currentZ, (int)currentT, (int)c);
            final double value = intensityInfo.meanIntensity;
            final int channel = c++;
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.drawHorizontalSurfaceValue(value, channel, currentT, currentZ);
                    seriesXY.add(0.0, value);
                    IntensityProfile.this.xyDataset.addSeries(seriesXY);
                }
            });
        }
    }

    private void computeSurfaceProfileAlongZ(ROI roi, Sequence sequence, int currentT) {
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            final XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along Z channel #" + c + " t:" + currentT)));
            for (int z = 0; z < sequence.getSizeZ(); ++z) {
                IntensityInfo intensityInfo = ROIUtil.getIntensityInfo((Sequence)sequence, (ROI)roi, (int)z, (int)currentT, (int)c);
                double value = intensityInfo.meanIntensity;
                seriesXY.add((double)z, value);
            }
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.xyDataset.addSeries(seriesXY);
                }
            });
        }
    }

    private void computeSurfaceProfileAlongT(ROI roi, Sequence sequence, int currentZ) {
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            final XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along T channel #" + c + " z:" + currentZ)));
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                IntensityInfo intensityInfo = ROIUtil.getIntensityInfo((Sequence)sequence, (ROI)roi, (int)currentZ, (int)t, (int)c);
                double value = intensityInfo.meanIntensity;
                seriesXY.add((double)t, value);
            }
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.xyDataset.addSeries(seriesXY);
                }
            });
        }
    }

    private void computeZMeanLineProfile(List<Point2D> pointList, final int currentT, final Sequence sequence) {
        if (sequence.getSizeZ() > 1) {
            double[][] result = null;
            for (int z = 0; z < sequence.getSizeZ(); ++z) {
                IcyBufferedImage image = sequence.getImage(currentT, z);
                Profile profile = this.getValueForPointList(pointList, image);
                if (result == null) {
                    result = new double[profile.values.length][profile.values[0].length];
                }
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    for (int i = 0; i < profile.values[c].length; ++i) {
                        double[] dArray = result[c];
                        int n = i;
                        dArray[n] = dArray[n] + profile.values[c][i];
                    }
                }
            }
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                int i = 0;
                while (i < result[c].length) {
                    double[] dArray = result[c];
                    int n = i++;
                    dArray[n] = dArray[n] / (double)sequence.getSizeZ();
                }
            }
            final double[][] resultCopy = result;
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int c = 0; c < sequence.getSizeC(); ++c) {
                        XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along Z channel #" + c + " t:" + currentT)));
                        for (int i = 0; i < resultCopy[c].length; ++i) {
                            seriesXY.add((double)i, resultCopy[c][i]);
                        }
                        IntensityProfile.this.xyDataset.addSeries(seriesXY);
                    }
                }
            });
        }
    }

    private void computeTMeanLineProfile(List<Point2D> pointList, final int currentZ, final Sequence sequence) {
        if (sequence.getSizeT() > 1) {
            double[][] result = null;
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                IcyBufferedImage image = sequence.getImage(t, currentZ);
                Profile profile = this.getValueForPointList(pointList, image);
                if (result == null) {
                    result = new double[profile.values.length][profile.values[0].length];
                }
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    for (int i = 0; i < profile.values[c].length; ++i) {
                        double[] dArray = result[c];
                        int n = i;
                        dArray[n] = dArray[n] + profile.values[c][i];
                    }
                }
            }
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                int i = 0;
                while (i < result[c].length) {
                    double[] dArray = result[c];
                    int n = i++;
                    dArray[n] = dArray[n] / (double)sequence.getSizeT();
                }
            }
            final double[][] resultCopy = result;
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (int c = 0; c < sequence.getSizeC(); ++c) {
                        XYSeries seriesXY = new XYSeries((Comparable)((Object)("Mean along T channel #" + c + " z:" + currentZ)));
                        for (int i = 0; i < resultCopy[c].length; ++i) {
                            seriesXY.add((double)i, resultCopy[c][i]);
                        }
                        IntensityProfile.this.xyDataset.addSeries(seriesXY);
                    }
                }
            });
        }
    }

    private void computeLineProfile(List<Point2D> pointList, int currentT, int currentZ, Sequence sequence) {
        this.computeLineProfile(pointList, currentT, currentZ, sequence, true);
    }

    private void computeLineProfile(List<Point2D> pointList, int currentT, int currentZ, Sequence sequence, boolean showControlPoints) {
        Profile profile = this.getValueForPointList(pointList, sequence.getImage(currentT, currentZ));
        if (showControlPoints) {
            SwingUtilities.invokeLater(() -> this.drawVerticalROIBreakBar(profile));
        } else {
            SwingUtilities.invokeLater(() -> this.chart.getXYPlot().clearDomainMarkers());
        }
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            final XYSeries seriesXY = new XYSeries((Comparable)((Object)("Intensity c" + c + " t" + currentT + " z" + currentZ)));
            for (int i = 0; i < profile.values[c].length; ++i) {
                seriesXY.add((double)i, profile.values[c][i]);
            }
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntensityProfile.this.xyDataset.addSeries(seriesXY);
                }
            });
        }
    }

    private void drawVerticalROIBreakBar(Profile profile) {
        XYPlot plot = this.chart.getXYPlot();
        for (Marker marker : this.markerDomainList) {
            plot.removeDomainMarker(marker);
        }
        if (profile.roiLineBreaks.size() <= 1) {
            return;
        }
        int nb = 1;
        for (Integer i : profile.roiLineBreaks) {
            ValueMarker start = new ValueMarker((double)i.intValue());
            this.markerDomainList.add((Marker)start);
            start.setPaint((Paint)Color.black);
            start.setLabel("" + nb);
            start.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            start.setLabelTextAnchor(TextAnchor.TOP_LEFT);
            plot.addDomainMarker((Marker)start);
            ++nb;
        }
    }

    void removeAllHorizontalRangeMarker() {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                XYPlot plot = IntensityProfile.this.chart.getXYPlot();
                for (Marker marker : IntensityProfile.this.markerRangeList) {
                    plot.removeRangeMarker(marker);
                }
            }
        });
    }

    private void drawHorizontalSurfaceValue(final double value, final int c, final int currentT, final int currentZ) {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                XYPlot plot = IntensityProfile.this.chart.getXYPlot();
                ValueMarker start = new ValueMarker(value);
                IntensityProfile.this.markerRangeList.add((Marker)start);
                start.setLabel("channel #" + c + " t: " + currentT + " z:" + currentZ + " mean value: " + value);
                start.setPaint((Paint)Color.black);
                switch (c) {
                    case 0: {
                        start.setPaint((Paint)Color.red);
                        start.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                        start.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                        break;
                    }
                    case 1: {
                        start.setPaint((Paint)Color.green.darker());
                        start.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                        start.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                        break;
                    }
                    case 2: {
                        start.setPaint((Paint)Color.blue);
                        start.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                        start.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                    }
                }
                start.setLabelPaint(start.getPaint());
                plot.addRangeMarker((Marker)start);
            }
        });
    }

    private Profile getValueForPointList(List<Point2D> pointList, IcyBufferedImage image) {
        ArrayList<double[][]> dataList = new ArrayList<double[][]>();
        ArrayList<Integer> roiLineBreaks = new ArrayList<Integer>();
        int indexSize = 0;
        for (int i = 0; i < pointList.size() - 1; ++i) {
            double[][] dataTmp = this.getValueFor1DSegment(pointList.get(i), pointList.get(i + 1), image);
            dataList.add(dataTmp);
            roiLineBreaks.add(indexSize += dataTmp[0].length);
        }
        double[][] data = new double[image.getSizeC()][indexSize];
        int index = 0;
        for (double[][] dataToAdd : dataList) {
            for (int c = 0; c < image.getSizeC(); ++c) {
                for (int i = 0; i < dataToAdd[0].length; ++i) {
                    data[c][index + i] = dataToAdd[c][i];
                }
            }
            index += dataToAdd[0].length;
        }
        Profile profile = new Profile();
        profile.values = data;
        profile.roiLineBreaks = roiLineBreaks;
        return profile;
    }

    private double[][] getValueFor1DSegment(Point2D p1, Point2D p2, IcyBufferedImage image) {
        if (image == null) {
            return null;
        }
        int distance = (int)p1.distance(p2);
        double vx = (p2.getX() - p1.getX()) / (double)distance;
        double vy = (p2.getY() - p1.getY()) / (double)distance;
        int nbComponent = image.getSizeC();
        double[][] data = new double[nbComponent][distance];
        double x = p1.getX();
        double y = p1.getY();
        for (int i = 0; i < distance; ++i) {
            int component;
            if (image.isInside((int)x, (int)y)) {
                for (component = 0; component < nbComponent; ++component) {
                    data[component][i] = Array1DUtil.getValue((Object)image.getDataXY(component), (int)image.getOffset((int)x, (int)y), (boolean)image.isSignedDataType());
                }
            } else {
                for (component = 0; component < nbComponent; ++component) {
                    data[component][i] = 0.0;
                }
            }
            x += vx;
            y += vy;
        }
        return data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.OPTION_meanAlongT || e.getSource() == this.OPTION_meanAlongZ) {
            this.updateChart();
        }
        if (e.getSource() == this.exportToExcelButton) {
            this.exportToExcel();
        }
        if (e.getSource() == this.exportToConsoleButton) {
            this.exportToConsole();
        }
        if (e.getSource() == this.associateROIButton) {
            Sequence activeSequence;
            if (this.associatedROI != null) {
                this.associatedROI.removeListener((ROIListener)this);
            }
            if ((activeSequence = Icy.getMainInterface().getActiveSequence()) != null) {
                this.associatedROI = activeSequence.getSelectedROI();
            }
            if (this.associatedROI != null) {
                this.associatedROI.addListener((ROIListener)this);
            }
            this.updateChart();
        }
    }

    private void exportToConsole() {
        List xyDataSetList = this.xyDataset.getSeries();
        if (this.associatedROI != null) {
            System.out.println("------ Intensity Profile console output");
            System.out.println("ROI name: " + this.associatedROI.getName());
        }
        for (int i = 0; i < xyDataSetList.size(); ++i) {
            XYSeries series = (XYSeries)xyDataSetList.get(i);
            System.out.println("--- Graph output");
            System.out.println("Description: " + series.getKey().toString());
            System.out.println("nb items: " + series.getItemCount());
            List itemList = series.getItems();
            for (int j = 0; j < itemList.size(); ++j) {
                XYDataItem item = (XYDataItem)itemList.get(j);
                System.out.println("x : " + item.getXValue() + " y : " + item.getYValue());
            }
        }
    }

    private void exportToExcel() {
        WritableWorkbook workBook;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select xls file.");
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        file = new File(FileUtil.setExtension((String)file.getAbsolutePath(), (String)".xls"));
        try {
            workBook = XLSUtil.createWorkbook((File)file);
        }
        catch (IOException e) {
            new AnnounceFrame("Can't create the excel output. (file already opened ?)");
            return;
        }
        WritableSheet writableSheet = workBook.createSheet("Intensity profile", 0);
        List xyDataSetList = this.xyDataset.getSeries();
        XLSUtil.setCellString((WritableSheet)writableSheet, (int)0, (int)0, (String)"ROI name:");
        String roiName = "no roi associated";
        if (this.associatedROI != null) {
            roiName = this.associatedROI.getName();
        }
        XLSUtil.setCellString((WritableSheet)writableSheet, (int)1, (int)0, (String)roiName);
        XLSUtil.setCellString((WritableSheet)writableSheet, (int)0, (int)1, (String)"Sequence:");
        XLSUtil.setCellString((WritableSheet)writableSheet, (int)1, (int)1, (String)this.getActiveSequence().getName());
        for (int i = 0; i < xyDataSetList.size(); ++i) {
            XYSeries series = (XYSeries)xyDataSetList.get(i);
            WritableSheet w = workBook.createSheet(series.getKey().toString(), 0);
            XLSUtil.setCellString((WritableSheet)w, (int)0, (int)0, (String)"x");
            XLSUtil.setCellString((WritableSheet)w, (int)1, (int)0, (String)"i");
            XLSUtil.setCellString((WritableSheet)w, (int)3, (int)0, (String)"Serie:");
            XLSUtil.setCellString((WritableSheet)w, (int)4, (int)0, (String)series.getKey().toString());
            XLSUtil.setCellString((WritableSheet)w, (int)3, (int)1, (String)"ROI:");
            XLSUtil.setCellString((WritableSheet)w, (int)4, (int)1, (String)roiName);
            int yOffset = 1;
            List itemList = series.getItems();
            for (int j = 0; j < itemList.size(); ++j) {
                XYDataItem item = (XYDataItem)itemList.get(j);
                XLSUtil.setCellNumber((WritableSheet)w, (int)0, (int)yOffset, (double)item.getXValue());
                XLSUtil.setCellNumber((WritableSheet)w, (int)1, (int)yOffset, (double)item.getYValue());
                ++yOffset;
            }
        }
        try {
            XLSUtil.saveAndClose((WritableWorkbook)workBook);
        }
        catch (WriteException e) {
            new AnnounceFrame("Can't create the excel output. (file already opened ?)");
            return;
        }
        catch (IOException e) {
            new AnnounceFrame("Can't create the excel output. (file already opened ?)");
            return;
        }
        new AnnounceFrame("Excel export finished: " + file.getAbsolutePath());
    }

    public void roiChanged(ROIEvent event) {
        boolean update = false;
        if (event.getType() == ROIEvent.ROIEventType.PROPERTY_CHANGED && event.getPropertyName().equals("name")) {
            update = true;
        }
        if (event.getType() == ROIEvent.ROIEventType.ROI_CHANGED) {
            update = true;
        }
        if (update) {
            this.updateChart();
        }
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)IntensityProfile.class.getName()));
    }

    class Profile {
        double[][] values;
        ArrayList<Integer> roiLineBreaks = new ArrayList();

        Profile() {
        }
    }
}

