/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class IOUtils {
    private static final String FF = "%.4f";

    private IOUtils() {
    }

    public static double computeRMSE(float f, float f2) {
        double d = f - f2;
        double d2 = d * d;
        return Math.sqrt(d2);
    }

    public static double computeRMSE(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            double d2 = fArray[i] - fArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)fArray.length);
    }

    public static double computeRMSE(FloatLargeArray floatLargeArray, FloatLargeArray floatLargeArray2) {
        if (floatLargeArray.length() != floatLargeArray2.length()) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (long i = 0L; i < floatLargeArray.length(); ++i) {
            double d2 = floatLargeArray.getFloat(i) - floatLargeArray2.getFloat(i);
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)floatLargeArray.length());
    }

    public static double computeRMSE(float[][] fArray, float[][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                double d2 = fArray[i][j] - fArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length));
    }

    public static double computeRMSE(float[][][] fArray, float[][][] fArray2) {
        if (fArray.length != fArray2.length || fArray[0].length != fArray2[0].length || fArray[0][0].length != fArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                for (int k = 0; k < fArray[0][0].length; ++k) {
                    double d2 = fArray[i][j][k] - fArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(fArray.length * fArray[0].length * fArray[0][0].length));
    }

    public static double computeRMSE(double d, double d2) {
        double d3 = d - d2;
        double d4 = d3 * d3;
        return Math.sqrt(d4);
    }

    public static double computeRMSE(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    public static double computeRMSE(DoubleLargeArray doubleLargeArray, DoubleLargeArray doubleLargeArray2) {
        if (doubleLargeArray.length() != doubleLargeArray2.length()) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (long i = 0L; i < doubleLargeArray.length(); ++i) {
            double d2 = doubleLargeArray.getDouble(i) - doubleLargeArray2.getDouble(i);
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)doubleLargeArray.length());
    }

    public static double computeRMSE(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                double d2 = dArray[i][j] - dArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length));
    }

    public static double computeRMSE(double[][][] dArray, double[][][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length || dArray[0][0].length != dArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray[0][0].length; ++k) {
                    double d2 = dArray[i][j][k] - dArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length * dArray[0][0].length));
    }

    public static void fillMatrix_1D(long l, double[] dArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            dArray[n] = random.nextDouble();
            ++n;
        }
    }

    public static void fillMatrix_1D(long l, DoubleLargeArray doubleLargeArray) {
        Random random = new Random(2L);
        for (long i = 0L; i < l; ++i) {
            doubleLargeArray.setDouble(i, random.nextDouble());
        }
    }

    public static void fillMatrix_1D(long l, FloatLargeArray floatLargeArray) {
        Random random = new Random(2L);
        for (long i = 0L; i < l; ++i) {
            floatLargeArray.setDouble(i, random.nextFloat());
        }
    }

    public static void fillMatrix_1D(long l, float[] fArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            fArray[n] = random.nextFloat();
            ++n;
        }
    }

    public static void fillMatrix_2D(long l, long l2, double[] dArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                dArray[(int)((long)n * l2 + (long)n2)] = random.nextDouble();
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_2D(long l, long l2, FloatLargeArray floatLargeArray) {
        Random random = new Random(2L);
        for (long i = 0L; i < l; ++i) {
            for (long j = 0L; j < l2; ++j) {
                floatLargeArray.setFloat(i * l2 + j, random.nextFloat());
            }
        }
    }

    public static void fillMatrix_2D(long l, long l2, DoubleLargeArray doubleLargeArray) {
        Random random = new Random(2L);
        for (long i = 0L; i < l; ++i) {
            for (long j = 0L; j < l2; ++j) {
                doubleLargeArray.setDouble(i * l2 + j, random.nextDouble());
            }
        }
    }

    public static void fillMatrix_2D(long l, long l2, float[] fArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                fArray[(int)((long)n * l2 + (long)n2)] = random.nextFloat();
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_2D(long l, long l2, double[][] dArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                dArray[n][n2] = random.nextDouble();
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_2D(long l, long l2, float[][] fArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                fArray[n][n2] = random.nextFloat();
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, double[] dArray) {
        Random random = new Random(2L);
        long l4 = l2 * l3;
        long l5 = l3;
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = 0;
                while ((long)n3 < l3) {
                    dArray[(int)((long)n * l4 + (long)n2 * l5 + (long)n3)] = random.nextDouble();
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, DoubleLargeArray doubleLargeArray) {
        Random random = new Random(2L);
        long l4 = l2 * l3;
        long l5 = l3;
        for (long i = 0L; i < l; ++i) {
            for (long j = 0L; j < l2; ++j) {
                for (long k = 0L; k < l3; ++k) {
                    doubleLargeArray.setDouble(i * l4 + j * l5 + k, random.nextDouble());
                }
            }
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, FloatLargeArray floatLargeArray) {
        Random random = new Random(2L);
        long l4 = l2 * l3;
        long l5 = l3;
        for (long i = 0L; i < l; ++i) {
            for (long j = 0L; j < l2; ++j) {
                for (long k = 0L; k < l3; ++k) {
                    floatLargeArray.setDouble(i * l4 + j * l5 + k, random.nextFloat());
                }
            }
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, float[] fArray) {
        Random random = new Random(2L);
        long l4 = l2 * l3;
        long l5 = l3;
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = 0;
                while ((long)n3 < l3) {
                    fArray[(int)((long)n * l4 + (long)n2 * l5 + (long)n3)] = random.nextFloat();
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, double[][][] dArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = 0;
                while ((long)n3 < l3) {
                    dArray[n][n2][n3] = random.nextDouble();
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void fillMatrix_3D(long l, long l2, long l3, float[][][] fArray) {
        Random random = new Random(2L);
        int n = 0;
        while ((long)n < l) {
            int n2 = 0;
            while ((long)n2 < l2) {
                int n3 = 0;
                while ((long)n3 < l3) {
                    fArray[n][n2][n3] = random.nextFloat();
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public static void showComplex_1D(double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < dArray.length; i += 2) {
            if (dArray[i + 1] == 0.0) {
                System.out.println(String.format(FF, dArray[i]));
                continue;
            }
            if (dArray[i] == 0.0) {
                System.out.println(String.format(FF, dArray[i + 1]) + "i");
                continue;
            }
            if (dArray[i + 1] < 0.0) {
                System.out.println(String.format(FF, dArray[i]) + " - " + String.format(FF, -dArray[i + 1]) + "i");
                continue;
            }
            System.out.println(String.format(FF, dArray[i]) + " + " + String.format(FF, dArray[i + 1]) + "i");
        }
        System.out.println();
    }

    public static void showComplex_2D(int n, int n2, double[] dArray, String string) {
        StringBuilder stringBuilder = new StringBuilder(String.format(string + ": complex array 2D: %d rows, %d columns\n\n", n, n2));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 2 * n2; j += 2) {
                if (dArray[i * 2 * n2 + j + 1] == 0.0) {
                    stringBuilder.append(String.format("%.4f\t", dArray[i * 2 * n2 + j]));
                    continue;
                }
                if (dArray[i * 2 * n2 + j] == 0.0) {
                    stringBuilder.append(String.format("%.4fi\t", dArray[i * 2 * n2 + j + 1]));
                    continue;
                }
                if (dArray[i * 2 * n2 + j + 1] < 0.0) {
                    stringBuilder.append(String.format("%.4f - %.4fi\t", dArray[i * 2 * n2 + j], -dArray[i * 2 * n2 + j + 1]));
                    continue;
                }
                stringBuilder.append(String.format("%.4f + %.4fi\t", dArray[i * 2 * n2 + j], dArray[i * 2 * n2 + j + 1]));
            }
            stringBuilder.append("\n");
        }
        System.out.println(stringBuilder.toString());
    }

    public static void showComplex_2D(double[][] dArray, String string) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        StringBuilder stringBuilder = new StringBuilder(String.format(string + ": complex array 2D: %d rows, %d columns\n\n", n, n2));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; j += 2) {
                if (dArray[i][j + 1] == 0.0) {
                    stringBuilder.append(String.format("%.4f\t", dArray[i][j]));
                    continue;
                }
                if (dArray[i][j] == 0.0) {
                    stringBuilder.append(String.format("%.4fi\t", dArray[i][j + 1]));
                    continue;
                }
                if (dArray[i][j + 1] < 0.0) {
                    stringBuilder.append(String.format("%.4f - %.4fi\t", dArray[i][j], -dArray[i][j + 1]));
                    continue;
                }
                stringBuilder.append(String.format("%.4f + %.4fi\t", dArray[i][j], dArray[i][j + 1]));
            }
            stringBuilder.append("\n");
        }
        System.out.println(stringBuilder.toString());
    }

    public static void showComplex_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * 2 * n3;
        int n5 = 2 * n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < 2 * n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (dArray[j * n4 + k * n5 + i + 1] == 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                        continue;
                    }
                    if (dArray[j * n4 + k * n5 + i] == 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[j * n4 + k * n5 + i + 1] < 0.0) {
                        System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + " - " + String.format(FF, -dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + " + " + String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(double[][][] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        for (int i = 0; i < n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (dArray[j][k][i + 1] == 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i]) + "\t");
                        continue;
                    }
                    if (dArray[j][k][i] == 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[j][k][i + 1] < 0.0) {
                        System.out.print(String.format(FF, dArray[j][k][i]) + " - " + String.format(FF, -dArray[j][k][i + 1]) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j][k][i]) + " + " + String.format(FF, dArray[j][k][i + 1]) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showComplex_3D(int n, int n2, int n3, float[] fArray, String string) {
        int n4 = n2 * 2 * n3;
        int n5 = 2 * n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < 2 * n3; i += 2) {
            System.out.println("(:,:," + i / 2 + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (fArray[j * n4 + k * n5 + i + 1] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + "\t");
                        continue;
                    }
                    if (fArray[j * n4 + k * n5 + i] == 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                        continue;
                    }
                    if (fArray[j * n4 + k * n5 + i + 1] < 0.0f) {
                        System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + " - " + String.format(FF, Float.valueOf(-fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                        continue;
                    }
                    System.out.print(String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i])) + " + " + String.format(FF, Float.valueOf(fArray[j * n4 + k * n5 + i + 1])) + "i\t");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    public static void showReal_1D(double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.println(String.format(FF, dArray[i]));
        }
        System.out.println();
    }

    public static void showReal_2D(int n, int n2, double[] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (Math.abs(dArray[i * n2 + j]) < 5.0E-5) {
                    System.out.print("0\t");
                    continue;
                }
                System.out.print(String.format(FF, dArray[i * n2 + j]) + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void showReal_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3;
        int n5 = n3;
        System.out.println(string);
        System.out.println("-------------------");
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println("(:,:," + i + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (Math.abs(dArray[j * n4 + k * n5 + i]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void showReal_3D(double[][][] dArray, String string) {
        System.out.println(string);
        System.out.println("-------------------");
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println("(:,:," + i + ")=\n");
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (Math.abs(dArray[j][k][i]) <= 5.0E-5) {
                        System.out.print("0\t");
                        continue;
                    }
                    System.out.print(String.format(FF, dArray[j][k][i]) + "\t");
                }
                System.out.println();
            }
        }
        System.out.println();
    }

    public static void writeToFileComplex_1D(double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < dArray.length; i += 2) {
                if (dArray[i + 1] == 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i]));
                    bufferedWriter.newLine();
                    continue;
                }
                if (dArray[i] == 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i + 1]) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                if (dArray[i + 1] < 0.0) {
                    bufferedWriter.write(String.format(FF, dArray[i]) + " - " + String.format(FF, -dArray[i + 1]) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(String.format(FF, dArray[i]) + " + " + String.format(FF, dArray[i + 1]) + "i");
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_1D(float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < fArray.length; i += 2) {
                if (fArray[i + 1] == 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])));
                    bufferedWriter.newLine();
                    continue;
                }
                if (fArray[i] == 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i + 1])) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                if (fArray[i + 1] < 0.0f) {
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])) + " - " + String.format(FF, Float.valueOf(-fArray[i + 1])) + "i");
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])) + " + " + String.format(FF, Float.valueOf(fArray[i + 1])) + "i");
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n, int n2, double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(dArray[i * 2 * n2 + j]) < 5.0E-5 && Math.abs(dArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i * 2 * n2 + j]) < 5.0E-5) {
                        if (dArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, dArray[i * 2 * n2 + j + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, -dArray[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[i * 2 * n2 + j + 1] < 0.0) {
                        bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " - " + String.format(FF, -dArray[i * 2 * n2 + j + 1]) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i * 2 * n2 + j]) + " + " + String.format(FF, dArray[i * 2 * n2 + j + 1]) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(int n, int n2, float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if ((double)Math.abs(fArray[i * 2 * n2 + j]) < 5.0E-5 && (double)Math.abs(fArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if ((double)Math.abs(fArray[i * 2 * n2 + j + 1]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " - 0i\t");
                        continue;
                    }
                    if ((double)Math.abs(fArray[i * 2 * n2 + j]) < 5.0E-5) {
                        if ((double)fArray[i * 2 * n2 + j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j + 1])) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, Float.valueOf(-fArray[i * 2 * n2 + j + 1])) + "i\t");
                        continue;
                    }
                    if (fArray[i * 2 * n2 + j + 1] < 0.0f) {
                        bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " - " + String.format(FF, Float.valueOf(-fArray[i * 2 * n2 + j + 1])) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j])) + " + " + String.format(FF, Float.valueOf(fArray[i * 2 * n2 + j + 1])) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_2D(double[][] dArray, String string) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 2 * n2; j += 2) {
                    if (Math.abs(dArray[i][j]) < 5.0E-5 && Math.abs(dArray[i][j + 1]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write("0 + 0i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i][j + 1]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[i][j]) + " + 0i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[i][j]) + " - 0i\t");
                        continue;
                    }
                    if (Math.abs(dArray[i][j]) < 5.0E-5) {
                        if (dArray[i][j + 1] >= 0.0) {
                            bufferedWriter.write("0 + " + String.format(FF, dArray[i][j + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write("0 - " + String.format(FF, -dArray[i][j + 1]) + "i\t");
                        continue;
                    }
                    if (dArray[i][j + 1] < 0.0) {
                        bufferedWriter.write(String.format(FF, dArray[i][j]) + " - " + String.format(FF, -dArray[i][j + 1]) + "i\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i][j]) + " + " + String.format(FF, dArray[i][j + 1]) + "i\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3 * 2;
        int n5 = n3 * 2;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < 2 * n3; i += 2) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i / 2 + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        if (dArray[j * n4 + k * n5 + i + 1] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                            continue;
                        }
                        if (dArray[j * n4 + k * n5 + i] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                            continue;
                        }
                        if (dArray[j * n4 + k * n5 + i + 1] < 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + " - " + String.format(FF, -dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + " + " + String.format(FF, dArray[j * n4 + k * n5 + i + 1]) + "i\t");
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileComplex_3D(double[][][] dArray, String string) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < 2 * n3; i += 2) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i / 2 + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        if (dArray[j][k][i + 1] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i]) + "\t");
                            continue;
                        }
                        if (dArray[j][k][i] == 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i + 1]) + "i\t");
                            continue;
                        }
                        if (dArray[j][k][i + 1] < 0.0) {
                            bufferedWriter.write(String.format(FF, dArray[j][k][i]) + " - " + String.format(FF, -dArray[j][k][i + 1]) + "i\t");
                            continue;
                        }
                        bufferedWriter.write(String.format(FF, dArray[j][k][i]) + " + " + String.format(FF, dArray[j][k][i + 1]) + "i\t");
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < dArray.length; ++i) {
                bufferedWriter.write(String.format(FF, dArray[i]));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_1D(float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < fArray.length; ++i) {
                bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i])));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n, int n2, double[] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (Math.abs(dArray[i * n2 + j]) < 5.0E-5) {
                        bufferedWriter.write("0\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, dArray[i * n2 + j]) + "\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_2D(int n, int n2, float[] fArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if ((double)Math.abs(fArray[i * n2 + j]) < 5.0E-5) {
                        bufferedWriter.write("0\t");
                        continue;
                    }
                    bufferedWriter.write(String.format(FF, Float.valueOf(fArray[i * n2 + j])) + "\t");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeToFileReal_3D(int n, int n2, int n3, double[] dArray, String string) {
        int n4 = n2 * n3;
        int n5 = n3;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < n3; ++i) {
                bufferedWriter.newLine();
                bufferedWriter.write("(:,:," + i + ")=");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        bufferedWriter.write(String.format(FF, dArray[j * n4 + k * n5 + i]) + "\t");
                    }
                    bufferedWriter.newLine();
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeFFTBenchmarkResultsToFile(String string, int n, int n2, boolean bl, boolean bl2, long[] lArray, double[] dArray, double[] dArray2) {
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.vendor", "java.version"};
        try {
            int n3;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, false));
            bufferedWriter.write(new Date().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("System properties:");
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.name = " + System.getProperty(stringArray[0]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.version = " + System.getProperty(stringArray[1]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tos.arch = " + System.getProperty(stringArray[2]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.vendor = " + System.getProperty(stringArray[3]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tjava.version = " + System.getProperty(stringArray[4]));
            bufferedWriter.newLine();
            bufferedWriter.write("\tavailable processors = " + Runtime.getRuntime().availableProcessors());
            bufferedWriter.newLine();
            bufferedWriter.write("Settings:");
            bufferedWriter.newLine();
            bufferedWriter.write("\tused processors = " + n);
            bufferedWriter.newLine();
            bufferedWriter.write("\tTHREADS_BEGIN_N_2D = " + ConcurrencyUtils.getThreadsBeginN_2D());
            bufferedWriter.newLine();
            bufferedWriter.write("\tTHREADS_BEGIN_N_3D = " + ConcurrencyUtils.getThreadsBeginN_3D());
            bufferedWriter.newLine();
            bufferedWriter.write("\tnumber of iterations = " + n2);
            bufferedWriter.newLine();
            bufferedWriter.write("\twarm-up performed = " + bl);
            bufferedWriter.newLine();
            bufferedWriter.write("\tscaling performed = " + bl2);
            bufferedWriter.newLine();
            bufferedWriter.write("--------------------------------------------------------------------------------------------------");
            bufferedWriter.newLine();
            bufferedWriter.write("sizes=[");
            for (n3 = 0; n3 < lArray.length; ++n3) {
                bufferedWriter.write(Long.toString(lArray[n3]));
                if (n3 < lArray.length - 1) {
                    bufferedWriter.write(", ");
                    continue;
                }
                bufferedWriter.write("]");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("times without constructor(in msec)=[");
            for (n3 = 0; n3 < dArray.length; ++n3) {
                bufferedWriter.write(String.format("%.2f", dArray[n3]));
                if (n3 < dArray.length - 1) {
                    bufferedWriter.write(", ");
                    continue;
                }
                bufferedWriter.write("]");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("times with constructor(in msec)=[");
            for (n3 = 0; n3 < dArray.length; ++n3) {
                bufferedWriter.write(String.format("%.2f", dArray2[n3]));
                if (n3 < dArray2.length - 1) {
                    bufferedWriter.write(", ");
                    continue;
                }
                bufferedWriter.write("]");
            }
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

