/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.renderer;

import icy.math.MathUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

public class NativeArrayTableCellRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final long serialVersionUID = 7536618123117211456L;
    final boolean signed;

    public NativeArrayTableCellRenderer(boolean signed) {
        this.signed = signed;
        this.setHorizontalAlignment(11);
    }

    public NativeArrayTableCellRenderer() {
        this(true);
    }

    protected void setValue(Object value) {
        if (value != null && ArrayUtil.getDim(value) == 1) {
            String s;
            int len = ArrayUtil.getLength(value);
            if (len == 0) {
                s = "";
            } else if (len == 1) {
                s = Double.toString(MathUtil.roundSignificant(Array1DUtil.getValue(value, 0, this.signed), 5));
            } else {
                s = "[" + Double.toString(MathUtil.roundSignificant(Array1DUtil.getValue(value, 0, this.signed), 5));
                for (int i = 1; i < len; ++i) {
                    s = s + " " + MathUtil.roundSignificant(Array1DUtil.getValue(value, i, this.signed), 5);
                }
                s = s + "]";
            }
            this.setText(s);
        } else {
            super.setValue(value);
        }
    }
}

