/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.gui.component.CheckTabbedPane;
import icy.gui.component.button.IcyButton;
import icy.gui.dialog.MessageDialog;
import icy.gui.lut.LUTChannelViewer;
import icy.gui.lut.abstract_.IcyLutViewer;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.IcyColorMapEvent;
import icy.image.colormap.IcyColorMapListener;
import icy.image.colormap.LinearColorMap;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LUTViewer
extends IcyLutViewer
implements IcyColorMapListener,
SequenceListener {
    private static final long serialVersionUID = 8385018166371243663L;
    private static final String PREF_ID_HISTO = "gui.histo";
    private static final String ID_AUTO_REFRESH = "autoRefresh";
    private static final String ID_AUTO_BOUNDS = "autoBounds";
    private static final String ID_LOG_VIEW = "logView";
    final CheckTabbedPane bottomPane;
    final JCheckBox autoRefreshHistoCheckBox;
    final JCheckBox autoBoundsCheckBox;
    final ButtonGroup scaleGroup;
    final JRadioButton logButton;
    final JRadioButton linearButton;
    final IcyButton exportXLSButton;
    final List<LUTChannelViewer> lutChannelViewers;
    final XMLPreferences pref = ApplicationPreferences.getPreferences().node("gui.histo");
    final Runnable boundsUpdater = new Runnable(){

        @Override
        public void run() {
            Sequence sequence = LUTViewer.this.getSequence();
            if (sequence != null) {
                double[][] typeBounds = sequence.getChannelsTypeBounds();
                double[][] bounds = sequence.getChannelsBounds();
                for (int i = 0; i < Math.min(LUTViewer.this.getLut().getNumChannel(), typeBounds.length); ++i) {
                    double[] tb = typeBounds[i];
                    double[] b = bounds[i];
                    Scaler scaler = LUTViewer.this.getLut().getLutChannel(i).getScaler();
                    scaler.setAbsLeftRightIn(tb[0], tb[1]);
                    scaler.setLeftRightIn(b[0], b[1]);
                }
            }
        }
    };
    final Runnable channelNameUpdater;
    final Runnable channelEnableUpdater = new Runnable(){

        @Override
        public void run() {
            for (int c = 0; c < Math.min(LUTViewer.this.getLut().getNumChannel(), LUTViewer.this.bottomPane.getTabCount()); ++c) {
                LUTViewer.this.bottomPane.setTabChecked(c, LUTViewer.this.getLut().getLutChannel(c).isEnabled());
            }
        }
    };
    final Runnable channelTabColorUpdater = new Runnable(){

        @Override
        public void run() {
            for (int c = 0; c < Math.min(LUTViewer.this.getLut().getNumChannel(), LUTViewer.this.bottomPane.getTabCount()); ++c) {
                IcyColorMap colormap = LUTViewer.this.getLut().getLutChannel(c).getColorMap();
                LUTViewer.this.bottomPane.setBackgroundAt(c, colormap.getDominantColor());
            }
        }
    };

    public LUTViewer(Viewer viewer, LUT lut) {
        super(viewer, lut);
        this.channelNameUpdater = new Runnable(){

            @Override
            public void run() {
                final Sequence sequence = LUTViewer.this.getSequence();
                if (sequence != null) {
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            for (int c = 0; c < Math.min(sequence.getSizeC(), LUTViewer.this.bottomPane.getTabCount()); ++c) {
                                String channelName = sequence.getChannelName(c);
                                LUTViewer.this.bottomPane.setTitleAt(c, StringUtil.limit(channelName, 10));
                                if (sequence.getDefaultChannelName(c).equals(channelName)) {
                                    LUTViewer.this.bottomPane.setToolTipTextAt(c, "Channel " + c);
                                    continue;
                                }
                                LUTViewer.this.bottomPane.setToolTipTextAt(c, channelName + " (channel " + c + ")");
                            }
                        }
                    });
                }
            }
        };
        this.lutChannelViewers = new ArrayList<LUTChannelViewer>();
        this.bottomPane = new CheckTabbedPane(3, true);
        this.bottomPane.setTabLayoutPolicy(1);
        for (int c = 0; c < lut.getNumChannel(); ++c) {
            LUT.LUTChannel lutChannel = lut.getLutChannel(c);
            LUTChannelViewer lbv = new LUTChannelViewer(viewer, lutChannel);
            lutChannel.getColorMap().addListener(this);
            this.lutChannelViewers.add(lbv);
            this.bottomPane.addTab("ch " + c, lbv);
        }
        this.bottomPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i;
                int size = LUTViewer.this.lutChannelViewers.size();
                boolean[] changedState = new boolean[size];
                boolean[] enabledState = new boolean[size];
                for (i = 0; i < size; ++i) {
                    try {
                        enabledState[i] = LUTViewer.this.bottomPane.isTabChecked(i);
                        changedState[i] = LUTViewer.this.lutChannelViewers.get(i).getLutChannel().isEnabled() != enabledState[i];
                        continue;
                    }
                    catch (Exception exc) {
                        enabledState[i] = true;
                        changedState[i] = false;
                    }
                }
                for (i = 0; i < size; ++i) {
                    if (!changedState[i]) continue;
                    LUTViewer.this.lutChannelViewers.get(i).getLutChannel().setEnabled(enabledState[i]);
                }
            }
        });
        this.autoRefreshHistoCheckBox = new JCheckBox("Refresh", this.pref.getBoolean(ID_AUTO_REFRESH, true));
        this.autoRefreshHistoCheckBox.setToolTipText("Automatically refresh histogram when data is modified");
        this.autoRefreshHistoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = LUTViewer.this.autoRefreshHistoCheckBox.isSelected();
                if (value) {
                    LUTViewer.this.refreshAllHistogram();
                }
                LUTViewer.this.pref.putBoolean(LUTViewer.ID_AUTO_REFRESH, value);
            }
        });
        if (this.autoRefreshHistoCheckBox.isSelected()) {
            this.refreshAllHistogram();
        }
        this.autoBoundsCheckBox = new JCheckBox("Auto bounds", this.getPreferredAutoBounds());
        this.autoBoundsCheckBox.setToolTipText("Automatically ajdust bounds when data is modified");
        this.autoBoundsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = LUTViewer.this.autoBoundsCheckBox.isSelected();
                if (value) {
                    ThreadUtil.runSingle(LUTViewer.this.boundsUpdater);
                    LUTViewer.this.refreshAllHistogram();
                    LUTViewer.this.autoRefreshHistoCheckBox.setSelected(true);
                    LUTViewer.this.autoRefreshHistoCheckBox.setEnabled(false);
                } else {
                    boolean refreshValue = LUTViewer.this.pref.getBoolean(LUTViewer.ID_AUTO_REFRESH, true);
                    if (refreshValue) {
                        LUTViewer.this.refreshAllHistogram();
                    }
                    LUTViewer.this.autoRefreshHistoCheckBox.setSelected(refreshValue);
                    LUTViewer.this.autoRefreshHistoCheckBox.setEnabled(true);
                }
                LUTViewer.this.pref.putBoolean(LUTViewer.ID_AUTO_BOUNDS, value);
            }
        });
        Sequence seq = this.getSequence();
        this.scaleGroup = new ButtonGroup();
        this.logButton = new JRadioButton("log");
        this.logButton.setToolTipText("Display histogram in a logarithm form");
        this.logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LUTViewer.this.scaleTypeChanged(true);
            }
        });
        this.linearButton = new JRadioButton("linear");
        this.linearButton.setToolTipText("Display histogram in a linear form");
        this.linearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LUTViewer.this.scaleTypeChanged(false);
            }
        });
        this.scaleGroup.add(this.logButton);
        this.scaleGroup.add(this.linearButton);
        if (this.pref.getBoolean(ID_LOG_VIEW, true)) {
            this.logButton.setSelected(true);
        } else {
            this.linearButton.setSelected(true);
        }
        this.scaleTypeChanged(this.logButton.isSelected());
        this.exportXLSButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_XLS_EXPORT, 18));
        this.exportXLSButton.setFlat(true);
        this.exportXLSButton.setToolTipText("Export histogram data into an excel file");
        this.exportXLSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LUTViewer.this.lutChannelViewers.get(LUTViewer.this.bottomPane.getSelectedIndex()).getScalerPanel().getScalerViewer().getHistogram().getHistogram().doXLSExport();
                }
                catch (Exception e1) {
                    MessageDialog.showDialog("Error", e1.getMessage(), 0);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)GuiUtil.createLineBoxPanel(this.autoRefreshHistoCheckBox, this.autoBoundsCheckBox, Box.createHorizontalGlue(), Box.createHorizontalStrut(4), this.logButton, this.linearButton, Box.createHorizontalStrut(4), this.exportXLSButton), "North");
        this.add((Component)this.bottomPane, "Center");
        this.validate();
        this.channelTabColorUpdater.run();
        this.channelNameUpdater.run();
        if (seq != null) {
            if (!seq.hasUserLUT() && this.autoBoundsCheckBox.isSelected()) {
                ThreadUtil.runSingle(this.boundsUpdater);
                this.refreshAllHistogram();
                this.autoRefreshHistoCheckBox.setSelected(true);
                this.autoRefreshHistoCheckBox.setEnabled(false);
            }
            seq.addListener(this);
        }
    }

    public int getActiveChannelIndex() {
        return this.bottomPane.getSelectedIndex();
    }

    private boolean getPreferredAutoBounds() {
        boolean result = this.pref.getBoolean(ID_AUTO_BOUNDS, true);
        if (!result) {
            return false;
        }
        Sequence sequence = this.getSequence();
        if (sequence != null && sequence.getDataType_() == DataType.UBYTE) {
            int numChannel = this.getLut().getNumChannel();
            for (int c = 0; c < numChannel; ++c) {
                if (this.getLut().getLutChannel(c).getColorMap().isLinear()) continue;
                return false;
            }
            if (numChannel == 3 || numChannel == 4) {
                boolean rgb;
                boolean bl = rgb = this.getLut().getLutChannel(0).getColorMap().equals(LinearColorMap.red_) && this.getLut().getLutChannel(1).getColorMap().equals(LinearColorMap.green_) && this.getLut().getLutChannel(2).getColorMap().equals(LinearColorMap.blue_);
                if (numChannel == 4) {
                    rgb &= this.getLut().getLutChannel(3).getColorMap().getType() == IcyColorMap.IcyColorMapType.ALPHA;
                }
                if (rgb) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Sequence getSequence() {
        return super.getSequence();
    }

    @Override
    public LUT getLut() {
        return super.getLut();
    }

    public boolean getAutoBounds() {
        return this.autoBoundsCheckBox.isSelected();
    }

    public void setAutoBound(boolean value) {
        this.autoBoundsCheckBox.setSelected(value);
    }

    public boolean getAutoRefreshHistogram() {
        return this.autoRefreshHistoCheckBox.isSelected();
    }

    public void setAutoRefreshHistogram(boolean value) {
        this.autoRefreshHistoCheckBox.setSelected(value);
    }

    public boolean getLogScale() {
        return this.logButton.isSelected();
    }

    public void setLogScale(boolean value) {
        if (value) {
            this.logButton.setSelected(true);
        } else {
            this.linearButton.setSelected(true);
        }
    }

    void refreshAllHistogram() {
        for (int i = 0; i < this.lutChannelViewers.size(); ++i) {
            this.lutChannelViewers.get(i).getScalerPanel().refreshHistogram();
        }
    }

    void scaleTypeChanged(boolean log) {
        this.pref.putBoolean(ID_LOG_VIEW, log);
        for (int i = 0; i < this.lutChannelViewers.size(); ++i) {
            this.lutChannelViewers.get(i).getScalerPanel().getScalerViewer().scaleTypeChanged(log);
        }
    }

    @Override
    public void colorMapChanged(IcyColorMapEvent e) {
        switch (e.getType()) {
            case ENABLED_CHANGED: {
                ThreadUtil.runSingle(this.channelEnableUpdater);
                break;
            }
            case MAP_CHANGED: {
                ThreadUtil.runSingle(this.channelTabColorUpdater);
                break;
            }
        }
    }

    public void dispose() {
        this.removeAll();
        Sequence seq = this.getSequence();
        if (seq != null) {
            seq.removeListener(this);
        }
    }

    @Override
    public void sequenceChanged(SequenceEvent sequenceEvent) {
        SequenceEvent e = sequenceEvent;
        switch (e.getSourceType()) {
            case SEQUENCE_META: {
                ThreadUtil.runSingle(this.channelNameUpdater);
                break;
            }
            case SEQUENCE_COMPONENTBOUNDS: {
                if (!this.autoBoundsCheckBox.isSelected()) break;
                ThreadUtil.runSingle(this.boundsUpdater);
            }
        }
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
    }
}

