/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.type.collection.array.DynamicArray;
import icy.type.point.Point4D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import java.awt.Rectangle;
import java.util.Map;
import java.util.TreeMap;

public class BooleanMask4D {
    public Rectangle4D.Integer bounds;
    public final TreeMap<Integer, BooleanMask3D> mask;

    private static BooleanMask3D doUnion3D(BooleanMask3D m1, BooleanMask3D m2) throws InterruptedException {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask3D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask3D)m1.clone();
        }
        return BooleanMask3D.getUnion(m1, m2);
    }

    private static BooleanMask3D doIntersection3D(BooleanMask3D m1, BooleanMask3D m2) throws InterruptedException {
        if (m1 == null || m2 == null) {
            return null;
        }
        return BooleanMask3D.getIntersection(m1, m2);
    }

    private static BooleanMask3D doExclusiveUnion3D(BooleanMask3D m1, BooleanMask3D m2) throws InterruptedException {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask3D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask3D)m1.clone();
        }
        return BooleanMask3D.getExclusiveUnion(m1, m2);
    }

    private static BooleanMask3D doSubtraction3D(BooleanMask3D m1, BooleanMask3D m2) throws InterruptedException {
        if (m1 == null) {
            return null;
        }
        if (m2 == null) {
            return (BooleanMask3D)m1.clone();
        }
        return BooleanMask3D.getSubtraction(m1, m2);
    }

    public static BooleanMask4D getUnion(BooleanMask4D mask1, BooleanMask4D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask4D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask4D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask4D)mask1.clone();
        }
        Rectangle4D.Integer bounds = (Rectangle4D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask3D[] mask;
            if (bounds.sizeT == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeT != Integer.MAX_VALUE || mask2.bounds.sizeT != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite T dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask3D[1];
                BooleanMask3D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask3D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask4D.doUnion3D(m2d1, m2d2);
            } else {
                mask = new BooleanMask3D[bounds.sizeT];
                for (int t = 0; t < bounds.sizeT; ++t) {
                    BooleanMask3D m2d1 = mask1.getMask3D(t + bounds.t);
                    BooleanMask3D m2d2 = mask2.getMask3D(t + bounds.t);
                    mask[t] = BooleanMask4D.doUnion3D(m2d1, m2d2);
                }
            }
            return new BooleanMask4D(bounds, mask);
        }
        return new BooleanMask4D();
    }

    public static BooleanMask4D getIntersection(BooleanMask4D mask1, BooleanMask4D mask2) throws InterruptedException {
        if (mask1 == null || mask2 == null) {
            return new BooleanMask4D();
        }
        Rectangle4D.Integer bounds = (Rectangle4D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask3D[] mask;
            if (bounds.sizeT == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeT != Integer.MAX_VALUE || mask2.bounds.sizeT != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite T dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask3D[1];
                BooleanMask3D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask3D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask4D.doIntersection3D(m2d1, m2d2);
            } else {
                mask = new BooleanMask3D[bounds.sizeT];
                for (int t = 0; t < bounds.sizeT; ++t) {
                    BooleanMask3D m2d1 = mask1.getMask3D(t + bounds.t);
                    BooleanMask3D m2d2 = mask2.getMask3D(t + bounds.t);
                    mask[t] = BooleanMask4D.doIntersection3D(m2d1, m2d2);
                }
            }
            return new BooleanMask4D(bounds, mask);
        }
        return new BooleanMask4D();
    }

    public static BooleanMask4D getExclusiveUnion(BooleanMask4D mask1, BooleanMask4D mask2) throws InterruptedException {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask4D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask4D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask4D)mask1.clone();
        }
        Rectangle4D.Integer bounds = (Rectangle4D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask3D[] mask;
            if (bounds.sizeT == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeT != Integer.MAX_VALUE || mask2.bounds.sizeT != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite T dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask3D[1];
                BooleanMask3D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask3D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask4D.doExclusiveUnion3D(m2d1, m2d2);
            } else {
                mask = new BooleanMask3D[bounds.sizeT];
                for (int t = 0; t < bounds.sizeT; ++t) {
                    BooleanMask3D m2d1 = mask1.getMask3D(t + bounds.t);
                    BooleanMask3D m2d2 = mask2.getMask3D(t + bounds.t);
                    mask[t] = BooleanMask4D.doExclusiveUnion3D(m2d1, m2d2);
                }
            }
            return new BooleanMask4D(bounds, mask);
        }
        return new BooleanMask4D();
    }

    public static BooleanMask4D getSubtraction(BooleanMask4D mask1, BooleanMask4D mask2) throws InterruptedException {
        if (mask1 == null) {
            return new BooleanMask4D();
        }
        if (mask2 == null) {
            return (BooleanMask4D)mask1.clone();
        }
        Rectangle4D.Integer bounds = (Rectangle4D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask3D[] mask;
            if (bounds.sizeT == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeT != Integer.MAX_VALUE || mask2.bounds.sizeT != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite T dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask3D[1];
                BooleanMask3D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask3D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask4D.doSubtraction3D(m2d1, m2d2);
            } else {
                mask = new BooleanMask3D[bounds.sizeT];
                for (int t = 0; t < bounds.sizeT; ++t) {
                    BooleanMask3D m2d1 = mask1.getMask3D(t + bounds.t);
                    BooleanMask3D m2d2 = mask2.getMask3D(t + bounds.t);
                    mask[t] = BooleanMask4D.doSubtraction3D(m2d1, m2d2);
                }
            }
            return new BooleanMask4D(bounds, mask);
        }
        return (BooleanMask4D)mask1.clone();
    }

    public BooleanMask4D(Rectangle4D.Integer bounds, BooleanMask3D[] mask) {
        this.bounds = bounds;
        this.mask = new TreeMap();
        if (bounds.sizeT == Integer.MAX_VALUE) {
            this.mask.put(Integer.MIN_VALUE, mask[0]);
        } else {
            for (int t = 0; t < bounds.sizeT; ++t) {
                if (mask[t] == null) continue;
                this.mask.put(bounds.t + t, mask[t]);
            }
        }
    }

    public BooleanMask4D(Point4D.Integer[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle4D.Integer();
        } else {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int minT = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxT = Integer.MIN_VALUE;
            for (Point4D.Integer pt : points) {
                int x = pt.x;
                int y = pt.y;
                int z = pt.z;
                int t = pt.t;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                if (t < minT) {
                    minT = t;
                }
                if (t <= maxT) continue;
                maxT = t;
            }
            this.bounds = new Rectangle4D.Integer(minX, minY, minZ, minT, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, maxT - minT + 1);
            for (Point4D.Integer pt : points) {
                BooleanMask2D m2d;
                BooleanMask3D m3d = this.mask.get(pt.t);
                if (m3d == null) {
                    m3d = new BooleanMask3D(new Rectangle3D.Integer(minX, minY, minZ, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ), new BooleanMask2D[this.bounds.sizeZ]);
                    this.mask.put(pt.t, m3d);
                }
                if ((m2d = m3d.getMask2D(pt.z)) == null) {
                    m2d = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    m3d.mask.put(pt.z, m2d);
                }
                m2d.mask[(pt.y - minY) * this.bounds.sizeX + (pt.x - minX)] = true;
            }
            for (BooleanMask3D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask4D(Point4D[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle4D.Integer();
        } else {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int minT = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxT = Integer.MIN_VALUE;
            for (Point4D pt : points) {
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                int z = (int)pt.getZ();
                int t = (int)pt.getT();
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                if (t < minT) {
                    minT = t;
                }
                if (t <= maxT) continue;
                maxT = t;
            }
            this.bounds = new Rectangle4D.Integer(minX, minY, minZ, minT, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, maxT - minT + 1);
            for (Point4D pt : points) {
                BooleanMask2D m2d;
                BooleanMask3D m3d = this.mask.get((int)pt.getT());
                if (m3d == null) {
                    m3d = new BooleanMask3D(new Rectangle3D.Integer(minX, minY, minZ, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ), new BooleanMask2D[this.bounds.sizeZ]);
                    this.mask.put((int)pt.getT(), m3d);
                }
                if ((m2d = m3d.getMask2D((int)pt.getZ())) == null) {
                    m2d = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    m3d.mask.put((int)pt.getZ(), m2d);
                }
                m2d.mask[((int)pt.getY() - minY) * this.bounds.sizeX + ((int)pt.getX() - minX)] = true;
            }
            for (BooleanMask3D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask4D() {
        this(new Rectangle4D.Integer(), new BooleanMask3D[0]);
    }

    public BooleanMask3D getMask3D(int t) {
        if (this.bounds.sizeT == Integer.MAX_VALUE) {
            return this.mask.firstEntry().getValue();
        }
        return this.mask.get(t);
    }

    public BooleanMask2D getMask2D(int z, int t) {
        BooleanMask3D m = this.getMask3D(t);
        if (m != null) {
            return m.getMask2D(z);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    public boolean contains(int x, int y, int z, int t) {
        BooleanMask3D m3d;
        if (this.bounds.contains(x, y, z, t) && (m3d = this.getMask3D(t)) != null) {
            return m3d.contains(x, y, z);
        }
        return false;
    }

    public boolean contains(BooleanMask2D booleanMask, int z, int t) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z, t);
        if (mask2d != null) {
            return mask2d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask3D booleanMask, int t) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask3D mask3d = this.getMask3D(t);
        if (mask3d != null) {
            return mask3d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask4D booleanMask) {
        int offT;
        if (this.isEmpty()) {
            return false;
        }
        int sizeT = booleanMask.bounds.sizeT;
        if (sizeT == Integer.MAX_VALUE) {
            if (this.bounds.sizeT != Integer.MAX_VALUE) {
                return false;
            }
            return booleanMask.mask.firstEntry().getValue().contains(this.mask.firstEntry().getValue());
        }
        for (int t = offT = booleanMask.bounds.t; t < offT + sizeT; ++t) {
            if (this.contains(booleanMask.getMask3D(t), t)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(BooleanMask2D booleanMask, int z, int t) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z, t);
        if (mask2d != null) {
            return mask2d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask3D booleanMask, int t) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask3D mask3d = this.getMask3D(t);
        if (mask3d != null) {
            return mask3d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask4D booleanMask) {
        int offT;
        if (this.isEmpty()) {
            return false;
        }
        int sizeT = booleanMask.bounds.sizeT;
        if (sizeT == Integer.MAX_VALUE) {
            BooleanMask3D mask3d = booleanMask.mask.firstEntry().getValue();
            for (BooleanMask3D m : this.mask.values()) {
                if (!m.intersects(mask3d)) continue;
                return true;
            }
            return false;
        }
        if (this.bounds.sizeT == Integer.MAX_VALUE) {
            BooleanMask3D mask3d = this.mask.firstEntry().getValue();
            for (BooleanMask3D m : booleanMask.mask.values()) {
                if (!m.intersects(mask3d)) continue;
                return true;
            }
            return false;
        }
        for (int t = offT = booleanMask.bounds.t; t < offT + sizeT; ++t) {
            if (!this.intersects(booleanMask.getMask3D(t), t)) continue;
            return true;
        }
        return false;
    }

    public Rectangle4D.Integer getOptimizedBounds(boolean compute3DBounds) {
        Rectangle4D.Integer result = new Rectangle4D.Integer();
        if (this.mask.isEmpty()) {
            return result;
        }
        Rectangle3D bounds3D = null;
        for (BooleanMask3D m3d : this.mask.values()) {
            Rectangle3D.Integer optB3d = compute3DBounds ? m3d.getOptimizedBounds() : new Rectangle3D.Integer(m3d.bounds);
            if (optB3d.isEmpty()) continue;
            if (bounds3D == null) {
                bounds3D = optB3d;
                continue;
            }
            bounds3D.add(optB3d);
        }
        if (bounds3D == null || bounds3D.isEmpty()) {
            return result;
        }
        int minT = this.mask.firstKey();
        int maxT = this.mask.lastKey();
        result.setX(((Rectangle3D.Integer)bounds3D).x);
        result.setY(((Rectangle3D.Integer)bounds3D).y);
        result.setZ(((Rectangle3D.Integer)bounds3D).z);
        result.setSizeX(((Rectangle3D.Integer)bounds3D).sizeX);
        result.setSizeY(((Rectangle3D.Integer)bounds3D).sizeY);
        result.setSizeZ(((Rectangle3D.Integer)bounds3D).sizeZ);
        if (minT == maxT && this.bounds.sizeT == Integer.MAX_VALUE) {
            result.setT(-2.147483648E9);
            result.setSizeT(2.147483647E9);
        } else {
            result.setT(minT);
            result.setSizeT(maxT - minT + 1);
        }
        return result;
    }

    public Rectangle4D.Integer getOptimizedBounds() {
        return this.getOptimizedBounds(true);
    }

    public void optimizeBounds() {
        for (BooleanMask3D m : this.mask.values()) {
            m.optimizeBounds();
        }
        this.moveBounds(this.getOptimizedBounds(false));
    }

    public void moveBounds(Rectangle4D.Integer value) {
        if (!this.bounds.equals(value)) {
            if (value.isEmpty()) {
                this.bounds = new Rectangle4D.Integer();
                this.mask.clear();
                return;
            }
            Rectangle3D.Integer bounds3D = new Rectangle3D.Integer(value.x, value.y, value.z, value.sizeX, value.sizeY, value.sizeZ);
            if (this.bounds.sizeT == Integer.MAX_VALUE) {
                BooleanMask3D m3d = this.mask.firstEntry().getValue();
                m3d.moveBounds(bounds3D);
                if (value.sizeT != Integer.MAX_VALUE) {
                    this.mask.clear();
                    for (int t = 0; t <= value.sizeT; ++t) {
                        this.mask.put(t + value.t, (BooleanMask3D)m3d.clone());
                    }
                }
            } else if (value.sizeT == Integer.MAX_VALUE) {
                BooleanMask3D mask3D = this.getMask3D(value.t);
                if (mask3D == null && !this.mask.isEmpty()) {
                    mask3D = this.mask.firstEntry().getValue();
                }
                this.mask.clear();
                if (mask3D != null) {
                    this.mask.put(Integer.MIN_VALUE, mask3D);
                }
            } else {
                int t;
                BooleanMask3D[] newMask = new BooleanMask3D[value.sizeT];
                for (t = 0; t < value.sizeT; ++t) {
                    BooleanMask3D mask3D = this.getMask3D(value.t + t);
                    if (mask3D != null) {
                        mask3D.moveBounds(bounds3D);
                    }
                    newMask[t] = mask3D;
                }
                this.mask.clear();
                for (t = 0; t < value.sizeT; ++t) {
                    this.mask.put(value.t + t, newMask[t]);
                }
            }
            this.bounds = value;
        }
    }

    public static int[] toInt4D(int[] source3D, int t) {
        int[] result = new int[source3D.length * 4 / 3];
        int pt = 0;
        for (int i = 0; i < source3D.length; i += 3) {
            result[pt++] = source3D[i + 0];
            result[pt++] = source3D[i + 1];
            result[pt++] = source3D[i + 2];
            result[pt++] = t;
        }
        return result;
    }

    public Point4D.Integer[] getContourPoints() throws InterruptedException {
        return Point4D.Integer.toPoint4D(this.getContourPointsAsIntArray());
    }

    public int[] getContourPointsAsIntArray() throws InterruptedException {
        DynamicArray.Int result = new DynamicArray.Int(8);
        if (this.mask.size() <= 2) {
            for (Map.Entry<Integer, BooleanMask3D> entry : this.mask.entrySet()) {
                result.add(BooleanMask4D.toInt4D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
            }
        } else {
            Map.Entry<Integer, BooleanMask3D> firstEntry = this.mask.firstEntry();
            Map.Entry<Integer, BooleanMask3D> lastEntry = this.mask.lastEntry();
            Integer firstKey = firstEntry.getKey();
            Integer lastKey = lastEntry.getKey();
            result.add(BooleanMask4D.toInt4D(firstEntry.getValue().getPointsAsIntArray(), firstKey));
            for (Map.Entry entry : this.mask.subMap(firstKey, false, lastKey, false).entrySet()) {
                result.add(BooleanMask4D.toInt4D(((BooleanMask3D)entry.getValue()).getContourPointsAsIntArray(), (Integer)entry.getKey()));
            }
            result.add(BooleanMask4D.toInt4D(lastEntry.getValue().getPointsAsIntArray(), lastKey));
        }
        return result.asArray();
    }

    public int getNumberOfPoints() throws InterruptedException {
        int result = 0;
        for (BooleanMask3D mask3d : this.mask.values()) {
            result += mask3d.getNumberOfPoints();
        }
        return result;
    }

    public Point4D.Integer[] getPoints() throws InterruptedException {
        return Point4D.Integer.toPoint4D(this.getPointsAsIntArray());
    }

    public int[] getPointsAsIntArray() throws InterruptedException {
        DynamicArray.Int result = new DynamicArray.Int(8);
        for (Map.Entry<Integer, BooleanMask3D> entry : this.mask.entrySet()) {
            result.add(BooleanMask4D.toInt4D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
        }
        return result.asArray();
    }

    public Object clone() {
        BooleanMask4D result = new BooleanMask4D();
        result.bounds = new Rectangle4D.Integer(this.bounds);
        for (Map.Entry<Integer, BooleanMask3D> entry : this.mask.entrySet()) {
            result.mask.put(entry.getKey(), (BooleanMask3D)entry.getValue().clone());
        }
        return result;
    }
}

