/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import java.awt.image.BufferedImage;

public class SequenceBuilder {
    private int _sizeX;
    private int _sizeY;
    private int _sizeZ;
    private int _sizeT;
    private int _sizeC;
    private DataType _dataType;
    private Sequence _result;
    private SequenceAllocator _allocator;

    public SequenceBuilder(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC, DataType dataType) {
        this(sizeX, sizeY, sizeZ, sizeT, sizeC, dataType, null);
    }

    public SequenceBuilder(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC, DataType dataType, Sequence target) {
        this._sizeX = sizeX;
        this._sizeY = sizeY;
        this._sizeZ = sizeZ;
        this._sizeT = sizeT;
        this._sizeC = sizeC;
        this._dataType = dataType;
        this._result = target == null ? new Sequence() : target;
        this._allocator = null;
    }

    public int getSizeX() {
        return this._sizeX;
    }

    public int getSizeY() {
        return this._sizeY;
    }

    public int getSizeZ() {
        return this._sizeZ;
    }

    public int getSizeT() {
        return this._sizeT;
    }

    public int getSizeC() {
        return this._sizeC;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public Sequence getResult() {
        return this._result;
    }

    public boolean isPreAllocated() {
        return this._result.getSizeX() == this._sizeX && this._result.getSizeY() == this._sizeY && this._result.getSizeZ() == this._sizeZ && this._result.getSizeT() == this._sizeT && this._result.getSizeC() == this._sizeC && (this._result.getDataType_() == this._dataType || this._sizeX == 0 || this._sizeY == 0 || this._sizeZ == 0 || this._sizeT == 0 || this._sizeC == 0);
    }

    public void beginUpdate() {
        if (this._allocator != null) {
            throw new IllegalStateException("The SequenceBuilder object is already in an update state.");
        }
        this._result.beginUpdate();
        if (this.isPreAllocated()) {
            this._allocator = new PreAllocatedAllocator(this._result);
        } else {
            this._result.removeAllImages();
            this._allocator = new OnFlyAllocator(this._sizeX, this._sizeY, this._sizeZ, this._sizeT, this._sizeC, this._dataType, this._result);
        }
    }

    public void endUpdate() {
        if (this._allocator == null) {
            return;
        }
        this._result.endUpdate();
        this._allocator = null;
    }

    public double[] getDataAsDouble(int t, int z, int c) {
        return (double[])this._allocator.getData(t, z, c);
    }

    public float[] getDataAsFloat(int t, int z, int c) {
        return (float[])this._allocator.getData(t, z, c);
    }

    public byte[] getDataAsByte(int t, int z, int c) {
        return (byte[])this._allocator.getData(t, z, c);
    }

    public short[] getDataAsShort(int t, int z, int c) {
        return (short[])this._allocator.getData(t, z, c);
    }

    public int[] getDataAsInt(int t, int z, int c) {
        return (int[])this._allocator.getData(t, z, c);
    }

    public Object getData(int t, int z, int c) {
        return this._allocator.getData(t, z, c);
    }

    public void validateData(int t, int z, int c) {
        this._allocator.validateData(t, z, c);
    }

    private static interface SequenceAllocator {
        public Object getData(int var1, int var2, int var3);

        public void validateData(int var1, int var2, int var3);
    }

    private static class PreAllocatedAllocator
    implements SequenceAllocator {
        private Sequence _target;

        public PreAllocatedAllocator(Sequence target) {
            this._target = target;
        }

        @Override
        public Object getData(int t, int z, int c) {
            return this._target.getDataXY(t, z, c);
        }

        @Override
        public void validateData(int t, int z, int c) {
        }
    }

    private static class OnFlyAllocator
    implements SequenceAllocator {
        private int _sizeZ;
        private ImageAllocator[] _image;

        public OnFlyAllocator(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC, DataType dataType, Sequence target) {
            int offset = 0;
            int sizeZT = sizeT * sizeZ;
            this._sizeZ = sizeZ;
            this._image = new ImageAllocator[sizeZT];
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    this._image[offset] = new ImageAllocator(sizeX, sizeY, sizeC, dataType, target, t, z);
                    ++offset;
                }
            }
        }

        @Override
        public Object getData(int t, int z, int c) {
            return this._image[z + this._sizeZ * t].getData(c);
        }

        @Override
        public void validateData(int t, int z, int c) {
            this._image[z + this._sizeZ * t].validateData(c);
        }
    }

    private static class ImageAllocator {
        private int _sizeX;
        private int _sizeY;
        private DataType _dataType;
        private Sequence _target;
        private int _t;
        private int _z;
        private boolean _done;
        private boolean[] _available;
        private Object[] _data;

        public ImageAllocator(int sizeX, int sizeY, int sizeC, DataType dataType, Sequence target, int t, int z) {
            this._sizeX = sizeX;
            this._sizeY = sizeY;
            this._dataType = dataType;
            this._target = target;
            this._t = t;
            this._z = z;
            this._done = false;
            this._data = Array2DUtil.createArray(this._dataType, sizeC);
            this._available = new boolean[sizeC];
            for (int c = 0; c < sizeC; ++c) {
                this._available[c] = false;
            }
        }

        public Object getData(int c) {
            if (this._data[c] == null) {
                this._data[c] = Array1DUtil.createArray(this._dataType, this._sizeX * this._sizeY);
            }
            return this._data[c];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateData(int c) {
            this._available[c] = true;
            for (boolean b : this._available) {
                if (b) continue;
                return;
            }
            ImageAllocator imageAllocator = this;
            synchronized (imageAllocator) {
                if (this._done) {
                    return;
                }
                IcyBufferedImage image = new IcyBufferedImage(this._sizeX, this._sizeY, this._data);
                Sequence sequence = this._target;
                synchronized (sequence) {
                    this._target.setImage(this._t, this._z, (BufferedImage)image);
                }
                this._done = true;
            }
        }
    }
}

