/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.watershed;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import plugins.kernel.roi.morphology.watershed.Point3D;

public class LabeledPixel
implements Comparable<LabeledPixel> {
    private static final int NO_LABEL = 0;
    private static final int TO_BE_LABELED = -1;
    private final Point3D position;
    private final AtomicDouble height;
    private final List<LabeledPixel> neighbors;
    private final AtomicInteger label;
    private final AtomicDouble distance;
    private final AtomicInteger level;

    public LabeledPixel(Point3D position, double height) {
        this.position = position;
        this.height = new AtomicDouble(height);
        this.neighbors = new ArrayList<LabeledPixel>(8);
        this.label = new AtomicInteger(0);
        this.distance = new AtomicDouble(Double.NaN);
        this.level = new AtomicInteger(0);
    }

    public Point3D getPosition() {
        return this.position;
    }

    public double getHeight() {
        return this.height.get();
    }

    public void setHeight(double newHeight) {
        this.height.set(newHeight);
    }

    public List<LabeledPixel> getNeighbors() {
        return this.neighbors;
    }

    public void addNeighbor(LabeledPixel neighbor) {
        this.neighbors.add(neighbor);
    }

    public int getLabel() {
        return this.label.get();
    }

    public void setLabel(int newLabel) {
        this.label.set(newLabel);
    }

    public double getDistance() {
        return this.distance.get();
    }

    public void setDistance(double newDistance) {
        this.distance.set(newDistance);
    }

    public boolean isLabeled() {
        return this.label.get() > 0;
    }

    public boolean isNoLabel() {
        return this.label.get() == 0;
    }

    public void setToBeLabeled() {
        this.setLabel(-1);
    }

    public boolean isToBeLabeled() {
        return this.getLabel() == -1;
    }

    public void setLevel(int newLevel) {
        this.level.set(newLevel);
    }

    public int getLevel() {
        return this.level.get();
    }

    @Override
    public int compareTo(LabeledPixel o) {
        return Double.compare(this.getHeight(), o.getHeight());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LabeledPixel)) {
            return false;
        }
        LabeledPixel other = (LabeledPixel)obj;
        return !(this.position == null ? other.position != null : !this.position.equals(other.position));
    }

    public String toString() {
        return "Pixel " + this.position + " [h=" + this.height + ", l=" + this.label + ", d=" + this.distance + "]";
    }
}

