/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashSet;
import java.util.Set;
import org.python.indexer.Indexer;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NUnionType
extends NType {
    private static final int MAX_RECURSION_DEPTH = 15;
    private Set<NType> types = new HashSet<NType>();

    public NUnionType() {
    }

    public NUnionType(NType ... initialTypes) {
        this();
        for (NType nt : initialTypes) {
            this.addType(nt);
        }
    }

    public void setTypes(Set<NType> types) {
        this.types = types;
    }

    public Set<NType> getTypes() {
        return this.types;
    }

    public void addType(NType t) {
        if (t == null) {
            throw new IllegalArgumentException("null type");
        }
        if (t.isUnionType()) {
            this.types.addAll(t.asUnionType().types);
        } else {
            this.types.add(t);
        }
    }

    public boolean contains(NType t) {
        return this.types.contains(t);
    }

    public static NType union(NType u, NType v) {
        NType wv;
        NType wu = NUnknownType.follow(u);
        if (wu == (wv = NUnknownType.follow(v))) {
            return u;
        }
        if (wu == Indexer.idx.builtins.None) {
            return v;
        }
        if (wv == Indexer.idx.builtins.None) {
            return u;
        }
        if (wu.isUnknownType() && !NUnionType.occurs(wu, wv, 0)) {
            NUnknownType.point(wu, wv);
            return u;
        }
        if (wv.isUnknownType() && !NUnionType.occurs(wv, wu, 0)) {
            NUnknownType.point(wv, wu);
            return v;
        }
        if (wu.isTupleType() && wv.isTupleType()) {
            NTupleType tu = (NTupleType)wu;
            NTupleType tv = (NTupleType)wv;
            if (tu.getElementTypes().size() == tv.getElementTypes().size()) {
                NTupleType ret = new NTupleType();
                for (int i = 0; i < tu.getElementTypes().size(); ++i) {
                    ret.add(NUnionType.union(tu.getElementTypes().get(i), tv.getElementTypes().get(i)));
                }
                return ret;
            }
            return NUnionType.newUnion(wu, wv);
        }
        if (wu.isListType() && wv.isListType()) {
            return new NListType(NUnionType.union(wu.asListType().getElementType(), wv.asListType().getElementType()));
        }
        if (wu.isDictType() && wv.isDictType()) {
            NDictType du = (NDictType)wu;
            NDictType dv = (NDictType)wv;
            return new NDictType(NUnionType.union(du.getKeyType(), dv.getKeyType()), NUnionType.union(du.getValueType(), dv.getValueType()));
        }
        if (wu.isFuncType() && wv.isFuncType()) {
            return new NFuncType(NUnionType.union(wu.asFuncType().getReturnType(), wv.asFuncType().getReturnType()));
        }
        if (wu.isFuncType() && wv.isClassType()) {
            NUnknownType.point(wu.asFuncType().getReturnType(), wv);
            NUnknownType.point(u, wv);
            return u;
        }
        if (wu.isClassType() && wv.isFuncType()) {
            NUnknownType.point(wv.asFuncType().getReturnType(), wu);
            NUnknownType.point(v, wu);
            return v;
        }
        return NUnionType.newUnion(wu, wv);
    }

    private static boolean occurs(NType u, NType v, int depth) {
        if (depth++ > 15) {
            return true;
        }
        if ((u = NUnknownType.follow(u)) == (v = NUnknownType.follow(v))) {
            return true;
        }
        if (v.isTupleType()) {
            for (NType vv : v.asTupleType().getElementTypes()) {
                if (!NUnionType.occurs(u, vv, depth)) continue;
                return true;
            }
            return false;
        }
        if (v.isListType()) {
            return NUnionType.occurs(u, v.asListType().getElementType(), depth);
        }
        if (v.isDictType()) {
            return NUnionType.occurs(u, v.asDictType().getKeyType(), depth) || NUnionType.occurs(u, v.asDictType().getValueType(), depth);
        }
        if (v.isFuncType()) {
            NType ret = v.asFuncType().getReturnType();
            if (NUnionType.occurs(v, ret, depth)) {
                return true;
            }
            return NUnionType.occurs(u, ret, depth);
        }
        if (v.isUnionType()) {
            for (NType vv : v.asUnionType().types) {
                if (!NUnionType.occurs(u, vv, depth)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static NUnionType newUnion(NType ... types) {
        NUnionType ret = new NUnionType();
        for (NType type : types) {
            ret.addType(type);
        }
        return ret;
    }

    public NType firstKnownAlternate() {
        for (NType type : this.types) {
            if (type.follow().isUnknownType()) continue;
            return type;
        }
        return null;
    }

    public NType firstKnownNonNullAlternate() {
        for (NType type : this.types) {
            NType tt = type.follow();
            if (tt.isUnknownType() || tt == Indexer.idx.builtins.None) continue;
            return type;
        }
        return null;
    }

    @Override
    public void printKids(NType.CyclicTypeRecorder ctr, StringBuilder sb) {
        sb.append("[");
        for (NType u : this.types) {
            u.print(ctr, sb);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
    }
}

