/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.bz2;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.bz2.PyBZ2File$PyExposer;

@ExposedType(name="bz2.BZ2File")
public class PyBZ2File
extends PyObject {
    public static final PyType TYPE;
    public PyObject newlines = null;
    private byte[] fileData = null;
    private int offset = 0;
    private String fileName = null;
    private String fileMode = "";
    private boolean inIterMode = false;
    private boolean inUniversalNewlineMode = false;
    private final ArrayList<String> validNewlines = new ArrayList();
    private BZip2CompressorOutputStream writeStream;

    public PyBZ2File() {
        super(TYPE);
        this.validNewlines.add("\n");
        this.validNewlines.add("\r");
        this.validNewlines.add("\r\n");
        this.writeStream = null;
    }

    public PyBZ2File(PyType subType) {
        super(subType);
        this.validNewlines.add("\n");
        this.validNewlines.add("\r");
        this.validNewlines.add("\r\n");
        this.writeStream = null;
    }

    protected void finalize() throws Throwable {
        this.BZ2File_close();
        super.finalize();
    }

    @ExposedNew
    final void BZ2File___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bz2file", args, kwds, new String[]{"filename", "mode", "buffering", "compresslevel"}, 1);
        PyObject filename = ap.getPyObject(0);
        if (!(filename instanceof PyString)) {
            throw Py.TypeError("coercing to Unicode: need string, '" + filename.getType().fastGetName() + "' type found");
        }
        String mode = ap.getString(1, "r");
        int buffering = ap.getInt(2, 0);
        int compresslevel = ap.getInt(3, 9);
        this.BZ2File___init__((PyString)filename, mode, buffering, compresslevel);
    }

    private void BZ2File___init__(PyString inFileName, String mode, int buffering, int compresslevel) {
        try {
            this.fileName = inFileName.asString();
            this.fileMode = mode;
            if (mode.contains("U")) {
                this.inUniversalNewlineMode = true;
            }
            if (mode.contains("w")) {
                File f = new File(this.fileName);
                if (!f.exists()) {
                    f.createNewFile();
                }
                this.writeStream = new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(this.fileName), compresslevel);
            } else {
                FileInputStream fin = new FileInputStream(this.fileName);
                BufferedInputStream bin = new BufferedInputStream(fin);
                BZip2CompressorInputStream bZin = new BZip2CompressorInputStream((InputStream)bin);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] buf = new byte[100];
                int n = 0;
                while (-1 != (n = bZin.read(buf))) {
                    buffer.write(buf, 0, n);
                }
                this.fileData = buffer.toByteArray();
                buffer.close();
                bZin.close();
                bin.close();
                fin.close();
            }
        }
        catch (IOException e) {
            throw Py.IOError("File " + this.fileName + " not found,");
        }
    }

    public void __del__() {
        this.BZ2File_close();
    }

    public void BZ2File_close() {
        this.fileData = null;
        if (this.writeStream != null) {
            this.BZ2File_flush();
            try {
                this.writeStream.close();
                this.writeStream = null;
            }
            catch (IOException e) {
                throw Py.IOError(e.getMessage());
            }
        }
    }

    private void BZ2File_flush() {
        if (this.writeStream != null) {
            try {
                this.writeStream.flush();
            }
            catch (IOException e) {
                throw Py.IOError(e.getMessage());
            }
        }
    }

    private byte[] peek() {
        byte[] buf = new byte[1];
        if (this.fileData.length > this.offset) {
            buf[0] = this.fileData[this.offset + 1];
        }
        return buf;
    }

    public PyObject BZ2File_read(PyObject[] args, String[] kwds) {
        this.checkInIterMode();
        ArgParser ap = new ArgParser("read", args, kwds, new String[]{"size"}, 0);
        int size = ap.getInt(0, -1);
        byte[] buf = this._BZ2File_read(size);
        return new PyString(new String(buf));
    }

    private byte[] _BZ2File_read(int size) {
        byte[] buf = null;
        if (size == 0) {
            return new byte[0];
        }
        buf = size > 0 ? new byte[size] : new byte[this.fileData.length - this.offset];
        int readbytes = 0;
        int i = this.offset;
        for (int j = 0; i < this.fileData.length && j < buf.length; ++i, ++j) {
            buf[j] = this.fileData[i];
            String possibleNewline = new String(new byte[]{buf[j]});
            if (possibleNewline.equals("\r")) {
                buf[j] = 10;
                if (this.fileData[i + 1] == 10) {
                    possibleNewline = possibleNewline + new String(new byte[]{this.fileData[i + 1]});
                    buf = Arrays.copyOf(buf, buf.length - 1);
                    ++i;
                }
            }
            if (this.validNewlines.contains(possibleNewline)) {
                this.addNewlineMarker(possibleNewline);
            }
            ++this.offset;
            ++readbytes;
        }
        if (readbytes == 0) {
            return new byte[0];
        }
        return buf;
    }

    public PyObject BZ2File_next(PyObject[] args, String[] kwds) {
        if (this.fileData == null) {
            throw Py.ValueError("Cannot call next() on closed file");
        }
        this.inIterMode = true;
        return null;
    }

    public PyString BZ2File_readline(PyObject[] args, String[] kwds) {
        this.checkInIterMode();
        ArgParser ap = new ArgParser("read", args, kwds, new String[]{"size"}, 0);
        int size = ap.getInt(0, -1);
        StringBuilder line = new StringBuilder();
        byte[] buf = null;
        int readSize = 0;
        while ((buf = this._BZ2File_read(1)).length > 0) {
            line.append(new String(buf));
            boolean mustBreak = false;
            if (this.inUniversalNewlineMode) {
                if ((char)buf[0] == '\r') {
                    if (this.peek()[0] == 10) {
                        buf = this._BZ2File_read(1);
                        mustBreak = true;
                    }
                    line.replace(line.length() - 1, line.length(), new String("\n"));
                    mustBreak = true;
                } else if ((char)buf[0] == '\n' || size > -1 && readSize >= size) {
                    mustBreak = true;
                }
            } else if ((char)buf[0] == '\n' || size > -1 && readSize >= size) {
                mustBreak = true;
            }
            if (!mustBreak) continue;
            break;
        }
        return new PyString(line.toString());
    }

    private void addNewlineMarker(String newline) {
        if (this.newlines == null) {
            this.newlines = new PyString(newline);
        } else if (this.newlines instanceof PyString) {
            if (!this.newlines.equals(new PyString(newline))) {
                this.newlines = new PyTuple(this.newlines, new PyString(newline));
            }
        } else if (!this.newlines.__contains__(new PyString(newline))) {
            this.newlines = this.newlines.__add__(new PyTuple(new PyString(newline)));
        }
    }

    public PyList BZ2File_readlines(PyObject[] args, String[] kwds) {
        this.checkInIterMode();
        if (this.fileData == null) {
            throw Py.ValueError("Cannot call readlines() on a closed file");
        }
        PyList lineList = new PyList();
        PyString line = null;
        while (!(line = this.BZ2File_readline(args, kwds)).equals(Py.EmptyString)) {
            lineList.add(line);
        }
        return lineList;
    }

    private void checkInIterMode() {
        if (this.fileMode.contains("r") && this.inIterMode) {
            throw Py.ValueError("Cannot mix iteration and reads");
        }
    }

    public PyList BZ2File_xreadlines() {
        return this.BZ2File_readlines(new PyObject[0], new String[0]);
    }

    public void BZ2File_seek(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("seek", args, kwds, new String[]{"offset", "whence"}, 1);
        int newOffset = ap.getInt(0);
        int whence = ap.getInt(1, 0);
        int finalOffset = 0;
        switch (whence) {
            case 0: {
                if (newOffset > this.fileData.length) {
                    finalOffset = this.fileData.length;
                    break;
                }
                finalOffset = newOffset;
                break;
            }
            case 1: {
                finalOffset = this.offset + newOffset;
                break;
            }
            case 2: {
                finalOffset = this.fileData.length + newOffset;
            }
        }
        if (finalOffset < 0) {
            finalOffset = 0;
        } else if (finalOffset > this.fileData.length) {
            finalOffset = this.fileData.length;
        }
        this.offset = finalOffset;
    }

    public PyLong BZ2File_tell() {
        return new PyLong(this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BZ2File_write(PyObject[] args, String[] kwds) {
        this.checkFileWritable();
        ArgParser ap = new ArgParser("write", args, kwds, new String[]{"data"}, 0);
        PyObject data = ap.getPyObject(0);
        if (data.getType() == PyNone.TYPE) {
            throw Py.TypeError("Expecting str argument");
        }
        byte[] buf = ap.getString(0).getBytes();
        try {
            PyBZ2File pyBZ2File = this;
            synchronized (pyBZ2File) {
                this.writeStream.write(buf);
            }
        }
        catch (IOException e) {
            throw Py.IOError(e.getMessage());
        }
    }

    public void BZ2File_writelines(PyObject[] args, String[] kwds) {
        this.checkFileWritable();
        ArgParser ap = new ArgParser("writelines", args, kwds, new String[]{"sequence_of_strings"}, 0);
        PySequence seq = (PySequence)ap.getPyObject(0);
        for (PyObject line : seq.asIterable()) {
            this.BZ2File_write(new PyObject[]{line}, new String[]{"data"});
        }
    }

    private void checkFileWritable() {
        if (this.fileMode.contains("r")) {
            throw Py.IOError("File in read-only mode");
        }
        if (this.writeStream == null) {
            throw Py.ValueError("Stream closed");
        }
    }

    @Override
    public PyObject __iter__() {
        return new BZ2FileIterator();
    }

    public PyObject BZ2File___enter__() {
        if (this.fileMode.contains("w") ? this.writeStream == null : this.fileMode.contains("r") && this.fileData == null) {
            throw Py.ValueError("Stream closed");
        }
        return this;
    }

    public boolean BZ2File___exit__(PyObject exc_type, PyObject exc_value, PyObject traceback) {
        this.BZ2File_close();
        return false;
    }

    static {
        PyType.addBuilder(PyBZ2File.class, new PyBZ2File$PyExposer());
        TYPE = PyType.fromClass(PyBZ2File.class);
    }

    private class BZ2FileIterator
    extends PyIterator {
        private BZ2FileIterator() {
        }

        @Override
        public PyObject __iternext__() {
            PyString s = PyBZ2File.this.BZ2File_readline(new PyObject[0], new String[0]);
            if (s.equals(Py.EmptyString)) {
                return null;
            }
            return s;
        }
    }
}

