/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.create;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.geom.BoxShape3D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi3d.ROI3DBox;
import plugins.stef.roi.bloc.RoiBlocks;

public class CreateRectangularROI
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarSequence inputSequence = new VarSequence("Size from Sequence", null);
    protected VarInteger sizeX = new VarInteger("Size X", 100);
    protected VarInteger sizeY = new VarInteger("Size Y", 100);
    protected VarInteger sizeZ = new VarInteger("Size Z", -1);
    protected VarROIArray output = new VarROIArray("roi");

    public void run() {
        int sz;
        int sy;
        int sx;
        if (this.inputSequence.getValue() == null) {
            sx = this.sizeX.getValue();
            sy = this.sizeY.getValue();
            sz = this.sizeZ.getValue();
            if (sx <= 0) {
                throw new VarException((Var)this.sizeX, "SizeX field should be > 0");
            }
            if (sy <= 0) {
                throw new VarException((Var)this.sizeY, "SizeY field should be > 0");
            }
            if (sz < -1 || sz == 0) {
                throw new VarException((Var)this.sizeZ, "SizeZ field should be > 0 or equals to -1 (infinite Z dimension)");
            }
        } else {
            Rectangle5D.Integer bnd = ((Sequence)this.inputSequence.getValue()).getBounds5D();
            sx = bnd.sizeX;
            sy = bnd.sizeY;
            sz = bnd.isInfiniteZ() || bnd.sizeZ == 1 ? -1 : bnd.sizeZ;
        }
        Object result = sz > 1 ? new ROI3DBox((BoxShape3D)new Rectangle3D.Integer(0, 0, 0, sx, sy, sz)) : new ROI2DRectangle((Rectangle2D)new Rectangle(0, 0, sx, sy));
        this.output.setValue((Object)new ROI[]{result});
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.inputSequence);
        inputMap.add("sizeX", (Var)this.sizeX);
        inputMap.add("sizeY", (Var)this.sizeY);
        inputMap.add("sizeZ", (Var)this.sizeZ);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

