/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.collection.CollectionUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.roi.descriptor.property.ROIColorDescriptor;
import plugins.stef.roi.bloc.RoiBlocks;

public class FilterROI
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    private static final StringUtil.AlphanumComparator comp = new StringUtil.AlphanumComparator();
    protected final VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected final VarSequence sequence = new VarSequence("Sequence", null);
    protected final VarString descriptors = new VarString("Filter on", "");
    protected final VarEnum<CompareOperator> operator = new VarEnum("Accept if", (Enum)CompareOperator.EQUAL);
    protected final VarString value = new VarString("Value", "0.0");
    protected final VarROIArray output = new VarROIArray("Filtered ROI(s)");

    public void run() {
        try {
            List<ROI> result = FilterROI.filterROIs((Collection<ROI>)CollectionUtil.asList((Object[])((ROI[])this.roiSet.getValue())), (Sequence)this.sequence.getValue(), (String)this.descriptors.getValue(), (CompareOperator)((Object)this.operator.getValue()), (String)this.value.getValue());
            this.output.setValue((Object)result.toArray(new ROI[result.size()]));
        }
        catch (IllegalArgumentException e) {
            throw new VarException((Var)this.descriptors, e.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        ArrayList roiDescriptors = new ArrayList(ROIDescriptor.getDescriptors().keySet());
        ArrayList<String> descriptorsId = new ArrayList<String>();
        String sizeDescriptorId = null;
        for (ROIDescriptor descriptor : roiDescriptors) {
            String id = descriptor.getId();
            if (StringUtil.equals((String)"Interior", (String)id)) {
                sizeDescriptorId = id;
            }
            descriptorsId.add(id);
        }
        Collections.sort(descriptorsId);
        this.descriptors.setDefaultEditorModel((VarEditorModel)new ValueSelectionModel((Object[])descriptorsId.toArray(new String[descriptorsId.size()]), (Object)sizeDescriptorId, false));
        inputMap.add("roi", (Var)this.roiSet);
        inputMap.add("sequence", (Var)this.sequence);
        inputMap.add("descriptors", (Var)this.descriptors);
        inputMap.add("operator", this.operator);
        inputMap.add("value", (Var)this.value);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }

    private static Object getTypedValue(String value) {
        try {
            return Double.parseDouble(value.replace(',', '.'));
        }
        catch (NumberFormatException e1) {
            try {
                return (double)Float.parseFloat(value.replace('.', ','));
            }
            catch (NumberFormatException e2) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return value;
                }
            }
        }
    }

    private static String colorToString(Color color) {
        return StringUtil.toHexaString((int)color.getAlpha(), (int)2) + StringUtil.toHexaString((int)color.getRed(), (int)2) + StringUtil.toHexaString((int)color.getGreen(), (int)2) + StringUtil.toHexaString((int)color.getBlue(), (int)2);
    }

    private static boolean compareNumber(CompareOperator op, double value1, double value2) {
        int compResult = Double.compare(value1, value2);
        switch (op) {
            default: {
                return compResult == 0;
            }
            case NOT_EQUAL: {
                return compResult != 0;
            }
            case LOWER: {
                return compResult < 0;
            }
            case LOWER_OR_EQUAL: {
                return compResult <= 0;
            }
            case GREATER: {
                return compResult > 0;
            }
            case GREATER_OR_EQUAL: 
        }
        return compResult >= 0;
    }

    private static boolean compareString(CompareOperator op, String value1, String value2, String value2Regex) {
        switch (op) {
            default: {
                return value1.matches(value2Regex);
            }
            case NOT_EQUAL: {
                return !value1.matches(value2Regex);
            }
            case LOWER: {
                return comp.compare(value1, value2) < 0;
            }
            case LOWER_OR_EQUAL: {
                return comp.compare(value1, value2) <= 0;
            }
            case GREATER: {
                return comp.compare(value1, value2) > 0;
            }
            case GREATER_OR_EQUAL: 
        }
        return comp.compare(value1, value2) >= 0;
    }

    public static List<ROI> filterROIs(Collection<ROI> rois, Sequence sequence, String descriptorId, CompareOperator op, String value) throws IllegalArgumentException {
        ArrayList<ROI> result;
        block13: {
            String regexValue;
            Object typedValue;
            ROIDescriptor roiDescriptor;
            block12: {
                result = new ArrayList<ROI>();
                roiDescriptor = ROIDescriptor.getDescriptor(ROIDescriptor.getDescriptors().keySet(), (String)descriptorId);
                if (roiDescriptor == null) {
                    throw new IllegalArgumentException("Cannot found '" + descriptorId + "' ROI descriptor !");
                }
                typedValue = FilterROI.getTypedValue(value);
                if (roiDescriptor instanceof ROIColorDescriptor) {
                    regexValue = StringUtil.wildcardToRegex((String)value.toLowerCase());
                    value = value.toLowerCase();
                } else {
                    regexValue = StringUtil.wildcardToRegex((String)value);
                }
                if (!(typedValue instanceof Number)) break block12;
                double doubleValue = ((Number)typedValue).doubleValue();
                for (ROI roi : rois) {
                    if (roi == null) continue;
                    try {
                        Object res = roiDescriptor.compute(roi, sequence);
                        boolean accepted = res instanceof Number ? FilterROI.compareNumber(op, ((Number)res).doubleValue(), doubleValue) : (res instanceof Color ? FilterROI.compareNumber(op, ((Color)res).getRGB(), doubleValue) : (res instanceof String ? FilterROI.compareString(op, (String)res, value, regexValue) : (res != null ? FilterROI.compareString(op, res.toString(), value, regexValue) : false)));
                        if (!accepted) continue;
                        result.add(roi);
                    }
                    catch (VarException e1) {
                        throw e1;
                    }
                    catch (Exception e2) {
                        IcyExceptionHandler.showErrorMessage((Throwable)e2, (boolean)false, (boolean)true);
                        result.add(roi);
                    }
                }
                break block13;
            }
            if (!(typedValue instanceof String)) break block13;
            for (ROI roi : rois) {
                if (roi == null) continue;
                try {
                    Object res = roiDescriptor.compute(roi, sequence);
                    if (res instanceof Number) {
                        throw new VarException(null, "Can't apply filtering criterion, you need to provide a valid number in 'Value' field.");
                    }
                    String stringRes = res instanceof String ? (String)res : (res instanceof Color ? FilterROI.colorToString((Color)res).toLowerCase() : (res != null ? res.toString() : ""));
                    if (!FilterROI.compareString(op, stringRes, value, regexValue)) continue;
                    result.add(roi);
                }
                catch (VarException e1) {
                    throw e1;
                }
                catch (Exception e2) {
                    IcyExceptionHandler.showErrorMessage((Throwable)e2, (boolean)false, (boolean)true);
                    result.add(roi);
                }
            }
        }
        return result;
    }

    public static List<ROI> filterROIs(Collection<ROI> rois, Sequence sequence, String descriptorId, CompareOperator op, double value) throws IllegalArgumentException {
        return FilterROI.filterROIs(rois, sequence, descriptorId, op, Double.toString(value));
    }

    public static enum CompareOperator {
        EQUAL{

            public String toString() {
                return "Equal to";
            }
        }
        ,
        NOT_EQUAL{

            public String toString() {
                return "Not equal to";
            }
        }
        ,
        LOWER{

            public String toString() {
                return "Lower than";
            }
        }
        ,
        LOWER_OR_EQUAL{

            public String toString() {
                return "Lower or equal than";
            }
        }
        ,
        GREATER{

            public String toString() {
                return "Greater than";
            }
        }
        ,
        GREATER_OR_EQUAL{

            public String toString() {
                return "Greater or equal than";
            }
        };

    }
}

