/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import mcib3d.geom.IntCoord3D;
import mcib3d.geom.Voxel3D;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.processing.FastFilters3D;
import mcib3d.image3d.processing.Flood3D;

public class MaximaFinder {
    protected ImageHandler img;
    protected ImageHandler imagePeaks = null;
    protected float noiseTolerance = 0.0f;
    protected ArrayList<Voxel3D> maxima;
    protected float radXY = 1.5f;
    protected float radZ = 1.5f;
    protected int nbCpus = 0;
    protected boolean verbose = true;

    public MaximaFinder(ImageHandler ima, float noiseTolerance) {
        this.img = ima.duplicate();
        this.noiseTolerance = noiseTolerance;
    }

    public MaximaFinder(ImageHandler img, float radXY, float radZ, float noiseTolerance) {
        this.img = img;
        this.noiseTolerance = noiseTolerance;
        this.radXY = radXY;
        this.radZ = radZ;
    }

    public MaximaFinder(ImageHandler ima) {
        this.img = ima.duplicate();
        this.noiseTolerance = 0.0f;
    }

    private void computePeaks() {
        this.imagePeaks = new ImageShort("peaks", this.img.sizeX, this.img.sizeY, this.img.sizeZ);
        if (this.verbose) {
            IJ.log((String)"Finding all peaks");
        }
        ArrayList<Voxel3DComparable> maximaTmp = FastFilters3D.getListMaxima(this.img, this.radXY, this.radXY, this.radZ, this.nbCpus, false);
        Collections.sort(maximaTmp);
        for (Voxel3DComparable V : maximaTmp) {
            this.imagePeaks.setPixel(V, (float)V.getValue());
        }
        if (this.verbose) {
            IJ.log((String)(maximaTmp.size() + " peaks found"));
        }
        if (this.verbose) {
            IJ.log((String)"Removing peaks below noise");
        }
        this.maxima = new ArrayList();
        int c = 1;
        int nb = maximaTmp.size();
        Date start = new Date();
        for (Voxel3DComparable voxel3DComparable : maximaTmp) {
            if (!(this.img.getPixel(voxel3DComparable) > 0.0f) || !(voxel3DComparable.getValue() > (double)this.noiseTolerance)) continue;
            this.maxima.add(voxel3DComparable);
            if (this.verbose) {
                Date temp = new Date();
                if (temp.getTime() - start.getTime() > 100L) {
                    IJ.showStatus((String)("Processing peak " + c + "/" + nb + " " + voxel3DComparable));
                    start = new Date();
                }
                ++c;
            }
            Flood3D.flood3DNoise26(this.img, new IntCoord3D(voxel3DComparable.getRoundX(), voxel3DComparable.getRoundY(), voxel3DComparable.getRoundZ()), (int)Math.max(1.0, voxel3DComparable.getValue() - (double)this.noiseTolerance), 0);
        }
        if (this.verbose) {
            IJ.log((String)(this.maxima.size() + " peaks found"));
        }
        if (this.verbose) {
            IJ.log((String)"Creating final peaks");
        }
        this.imagePeaks.fill(0.0);
        for (Voxel3D voxel3D : this.maxima) {
            this.imagePeaks.setPixel(voxel3D, (float)voxel3D.getValue());
        }
        if (this.verbose) {
            IJ.log((String)"MaximaFinder3D finished.");
        }
    }

    public ImageHandler getImagePeaks() {
        if (this.imagePeaks == null) {
            this.computePeaks();
        }
        return this.imagePeaks;
    }

    public ArrayList<Voxel3D> getListPeaks() {
        if (this.imagePeaks == null) {
            this.computePeaks();
        }
        return this.maxima;
    }

    public void setImage(ImageHandler img) {
        this.img = img;
        this.imagePeaks = null;
    }

    public void setNoiseTolerance(float noiseTolerance) {
        this.noiseTolerance = noiseTolerance;
        this.imagePeaks = null;
    }

    public void setRadii(float rxy, float rz) {
        this.radXY = rxy;
        this.radZ = rz;
        this.imagePeaks = null;
    }

    public void setNbCpus(int nbCpus) {
        this.nbCpus = nbCpus;
    }

    public void setVerbose(boolean show) {
        this.verbose = show;
    }

    @Deprecated
    public void setShow(boolean show) {
        this.verbose = show;
    }
}

