/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3DComparable;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;
import mcib3d.utils.Chrono;
import mcib3d.utils.Logger.AbstractLog;
import mcib3d.utils.Logger.NoLog;
import mcib3d.utils.ThreadUtil;

public class FastFilters3D {
    public static final int MEAN = 0;
    public static final int MEDIAN = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int MAXLOCAL = 4;
    public static final int TOPHAT = 5;
    public static final int OPENGRAY = 6;
    public static final int CLOSEGRAY = 7;
    public static final int VARIANCE = 8;
    public static final int SOBEL = 9;
    public static final int ADAPTIVE = 10;
    private static AbstractLog show = new NoLog();

    public static ArrayList<Voxel3DComparable> getListMaxima(ImageHandler stackorig, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        if (stackorig instanceof ImageByte || stackorig instanceof ImageShort) {
            return FastFilters3D.getListMaximaInt((ImageInt)stackorig, vx, vy, vz, nbcpus, showstatus);
        }
        if (stackorig instanceof ImageFloat) {
            return FastFilters3D.getListMaximaFloat((ImageFloat)stackorig, vx, vy, vz, nbcpus, showstatus);
        }
        return null;
    }

    public static ArrayList<Voxel3DComparable> getListMaximaInt(ImageInt stackorig, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        int nbToProcess = stackorig.sizeZ;
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final float voisx = vx;
        final float voisy = vy;
        final float voisz = vz;
        final ImageInt ima = stackorig;
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
        final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
        final ArrayList[] listes = new ArrayList[n_cpus];
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        listes[k] = ima.getListMaxima(voisx, voisy, voisz, dec * k, dec * (k + 1), time, show);
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threads);
        ArrayList<Voxel3DComparable> liste = new ArrayList<Voxel3DComparable>();
        for (ArrayList li : listes) {
            liste.addAll(li);
        }
        return liste;
    }

    public static ArrayList<Voxel3DComparable> getListMaximaFloat(ImageFloat stackorig, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        int nbToProcess = stackorig.sizeZ;
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final float voisx = vx;
        final float voisy = vy;
        final float voisz = vz;
        final ImageFloat ima = stackorig;
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
        final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
        final ArrayList[] listes = new ArrayList[n_cpus];
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        listes[k] = ima.getListMaxima(voisx, voisy, voisz, dec * k, dec * (k + 1), time, show);
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin(threads);
        ArrayList<Voxel3DComparable> liste = new ArrayList<Voxel3DComparable>();
        for (ArrayList li : listes) {
            liste.addAll(li);
        }
        return liste;
    }

    public static ImageInt filterIntImage(ImageInt stackorig, int filter, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        return FastFilters3D.filterIntImage(stackorig, filter, vx, vy, vz, nbcpus, showstatus, show);
    }

    public static ImageInt filterIntImage(ImageInt stackorig, int filter, float vx, float vy, float vz, int nbcpus, boolean showstatus, AbstractLog log) {
        int nbToProcess = stackorig.sizeZ;
        if (filter == 5 || filter == 7 || filter == 6) {
            nbToProcess *= 2;
        }
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final AbstractLog show = log;
        final float voisx = vx;
        final float voisy = vy;
        final float voisz = vz;
        final ImageInt ima = stackorig;
        ImageInt res = (ImageInt)ima.createSameDimensions();
        if (filter == 0 || filter == 1 || filter == 2 || filter == 3 || filter == 4 || filter == 5 || filter == 8 || filter == 7 || filter == 6) {
            int ithread;
            ImageInt res2;
            int f2;
            final ImageInt out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            int fi = filter;
            if (fi == 5 || fi == 6) {
                fi = 2;
            }
            if (fi == 7) {
                fi = 3;
            }
            final int f = fi;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            show.log("Starting");
            for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
                threads[ithread2] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.filterGeneric(out, voisx, voisy, voisz, dec * k, dec * (k + 1), f, time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            show.log("Finished");
            if (filter == 5 || filter == 6) {
                f2 = 3;
                res2 = (ImageInt)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, voisx, voisy, voisz, dec * k, dec * (k + 1), 3, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = filter == 5 ? ima.substractImage(res2) : res2;
            }
            if (filter == 7) {
                f2 = 2;
                res2 = (ImageInt)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, voisx, voisy, voisz, dec * k, dec * (k + 1), 2, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = res2;
            }
        } else if (filter == 9) {
            res = ima.sobelFilter();
        } else if (filter == 10) {
            final ImageInt out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            show.log("Starting");
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.adaptiveFilter(out, voisx, voisy, voisz, dec * k, dec * (k + 1), time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            show.log("Finished");
        }
        return res;
    }

    public static ImageHandler filterImage(ImageHandler stackorig, int filter, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        if (stackorig instanceof ImageByte || stackorig instanceof ImageShort) {
            return FastFilters3D.filterIntImage((ImageInt)stackorig, filter, vx, vy, vz, nbcpus, showstatus);
        }
        if (stackorig instanceof ImageFloat) {
            return FastFilters3D.filterFloatImage((ImageFloat)stackorig, filter, vx, vy, vz, nbcpus, showstatus);
        }
        return null;
    }

    public static ImageFloat filterFloatImage(ImageFloat stackorig, int filter, float vx, float vy, float vz, int nbcpus, boolean showstatus) {
        int nbToProcess = stackorig.sizeZ;
        if (filter == 5 || filter == 7 || filter == 6) {
            nbToProcess *= 2;
        }
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final float voisx = vx;
        final float voisy = vy;
        final float voisz = vz;
        final ImageFloat ima = stackorig;
        ImageFloat res = (ImageFloat)ima.createSameDimensions();
        if (filter == 0 || filter == 1 || filter == 2 || filter == 3 || filter == 4 || filter == 5 || filter == 8 || filter == 7 || filter == 6) {
            int ithread;
            ImageFloat res2;
            int f2;
            final ImageFloat out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            int fi = filter;
            if (fi == 5 || fi == 6) {
                fi = 2;
            }
            if (fi == 7) {
                fi = 3;
            }
            final int f = fi;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
                threads[ithread2] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.filterGeneric(out, voisx, voisy, voisz, dec * k, dec * (k + 1), f, time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            if (filter == 5 || filter == 6) {
                f2 = 3;
                res2 = (ImageFloat)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, voisx, voisy, voisz, dec * k, dec * (k + 1), 3, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = filter == 5 ? ima.subtractImage(res2) : res2;
            }
            if (filter == 7) {
                f2 = 2;
                res2 = (ImageFloat)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, voisx, voisy, voisz, dec * k, dec * (k + 1), 2, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = res2;
            }
        } else if (filter == 9) {
            res = ima.sobelFilter();
        } else if (filter == 10) {
            final ImageFloat out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            show.log("Starting");
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.adaptiveFilter(out, voisx, voisy, voisz, dec * k, dec * (k + 1), time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            show.log("Finished");
        }
        return res;
    }

    public static int[] createKernelEllipsoid(float radx, float rady, float radz) {
        int vx = (int)Math.ceil(radx);
        int vy = (int)Math.ceil(rady);
        int vz = (int)Math.ceil(radz);
        int[] ker = new int[(2 * vx + 1) * (2 * vy + 1) * (2 * vz + 1)];
        double rx2 = radx * radx;
        double ry2 = rady * rady;
        double rz2 = radz * radz;
        rx2 = rx2 != 0.0 ? 1.0 / rx2 : 0.0;
        ry2 = ry2 != 0.0 ? 1.0 / ry2 : 0.0;
        rz2 = rz2 != 0.0 ? 1.0 / rz2 : 0.0;
        int idx = 0;
        for (int k = -vz; k <= vz; ++k) {
            for (int j = -vy; j <= vy; ++j) {
                for (int i = -vx; i <= vx; ++i) {
                    double dist = (double)(i * i) * rx2 + (double)(j * j) * ry2 + (double)(k * k) * rz2;
                    ker[idx] = dist <= 1.0 ? 1 : 0;
                    ++idx;
                }
            }
        }
        return ker;
    }

    public static int[] createKernelFromObject(Object3D obj) {
        int[] bb = obj.getBoundingBox();
        ImageInt seg = obj.getLabelImage();
        int vx = bb[1] - bb[0] + 1;
        int vy = bb[3] - bb[2] + 1;
        int vz = bb[5] - bb[4] + 1;
        int[] ker = new int[vx * vy * vz];
        int idx = 0;
        for (int k = bb[4]; k <= bb[5]; ++k) {
            for (int j = bb[2]; j <= bb[3]; ++j) {
                for (int i = bb[0]; i <= bb[1]; ++i) {
                    ker[idx] = seg.getPixel(i, j, k) > 0.0f ? 1 : 0;
                    ++idx;
                }
            }
        }
        return ker;
    }

    public static int getNbFromKernel(int[] ker) {
        int nb = 0;
        for (int aKer : ker) {
            if (aKer <= 0) continue;
            ++nb;
        }
        return nb;
    }

    public static float[] getRadiiFromObject(Object3D obj) {
        int[] bb = obj.getBoundingBox();
        float vx = (float)Math.ceil(0.5 * (double)(bb[1] - bb[0]));
        float vy = (float)Math.ceil(0.5 * (double)(bb[3] - bb[2]));
        float vz = (float)Math.ceil(0.5 * (double)(bb[5] - bb[4]));
        return new float[]{vx, vy, vz};
    }

    public static ImageHandler filterImage(ImageHandler stackorig, int filter, Object3DVoxels obj, int nbcpus, boolean showstatus) {
        if (stackorig instanceof ImageByte || stackorig instanceof ImageShort) {
            return FastFilters3D.filterIntImage((ImageInt)stackorig, filter, obj, nbcpus, showstatus);
        }
        if (stackorig instanceof ImageFloat) {
            return FastFilters3D.filterFloatImage((ImageFloat)stackorig, filter, obj, nbcpus, showstatus);
        }
        return null;
    }

    public static ImageInt filterIntImage(ImageInt stackorig, int filter, Object3DVoxels obj, int nbcpus, boolean showstatus) {
        int nbToProcess = stackorig.sizeZ;
        if (filter == 5 || filter == 7 || filter == 6) {
            nbToProcess *= 2;
        }
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final Object3DVoxels object = obj;
        final ImageInt ima = stackorig;
        ImageInt res = (ImageInt)ima.createSameDimensions();
        if (filter == 0 || filter == 1 || filter == 2 || filter == 3 || filter == 4 || filter == 5 || filter == 8 || filter == 7 || filter == 6) {
            int ithread;
            ImageInt res2;
            int f2;
            final ImageInt out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            int fi = filter;
            if (fi == 5 || fi == 6) {
                fi = 2;
            }
            if (fi == 7) {
                fi = 3;
            }
            final int f = fi;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
                threads[ithread2] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.filterGeneric(out, object, dec * k, dec * (k + 1), f, time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            if (filter == 5 || filter == 6) {
                f2 = 3;
                res2 = (ImageInt)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, object, dec * k, dec * (k + 1), 3, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = filter == 5 ? ima.substractImage(res2) : res2;
            }
            if (filter == 7) {
                f2 = 2;
                res2 = (ImageInt)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, object, dec * k, dec * (k + 1), 2, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = res2;
            }
        } else if (filter == 9) {
            res = ima.sobelFilter();
        } else if (filter == 10) {
            // empty if block
        }
        return res;
    }

    public static ImageFloat filterFloatImage(ImageFloat stackorig, int filter, Object3DVoxels obj, int nbcpus, boolean showstatus) {
        int nbToProcess = stackorig.sizeZ;
        if (filter == 5 || filter == 7 || filter == 6) {
            nbToProcess *= 2;
        }
        final Chrono time = new Chrono(nbToProcess);
        time.start();
        final Object3DVoxels object = obj;
        final ImageFloat ima = stackorig;
        ImageFloat res = (ImageFloat)ima.createSameDimensions();
        if (filter == 0 || filter == 1 || filter == 2 || filter == 3 || filter == 4 || filter == 5 || filter == 8 || filter == 7 || filter == 6) {
            int ithread;
            ImageFloat res2;
            int f2;
            final ImageFloat out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = nbcpus == 0 ? ThreadUtil.getNbCpus() : nbcpus;
            int fi = filter;
            if (fi == 5 || fi == 6) {
                fi = 2;
            }
            if (fi == 7) {
                fi = 3;
            }
            final int f = fi;
            final int dec = (int)Math.ceil((double)ima.sizeZ / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            for (int ithread2 = 0; ithread2 < threads.length; ++ithread2) {
                threads[ithread2] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            ima.filterGeneric(out, object, dec * k, dec * (k + 1), f, time, show);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
            if (filter == 5 || filter == 6) {
                f2 = 3;
                res2 = (ImageFloat)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, object, dec * k, dec * (k + 1), 3, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = filter == 5 ? ima.subtractImage(res2) : res2;
            }
            if (filter == 7) {
                f2 = 2;
                res2 = (ImageFloat)ima.createSameDimensions();
                ai.set(0);
                for (ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(){

                        @Override
                        public void run() {
                            int k = ai.getAndIncrement();
                            while (k < n_cpus) {
                                out.filterGeneric(res2, object, dec * k, dec * (k + 1), 2, time, show);
                                k = ai.getAndIncrement();
                            }
                        }
                    };
                }
                ThreadUtil.startAndJoin(threads);
                res = res2;
            }
        } else if (filter == 9) {
            res = ima.sobelFilter();
        } else if (filter == 10) {
            // empty if block
        }
        return res;
    }

    public static AbstractLog geLog() {
        return show;
    }

    public static void setLog(AbstractLog log) {
        show = log;
    }
}

