/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import java.util.Iterator;
import java.util.SortedSet;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.expressions.Parser;
import plugins.ylemontag.mathoperations.functors.Functor1;
import plugins.ylemontag.mathoperations.functors.Functor2;
import plugins.ylemontag.mathoperations.functors.Functor3;
import plugins.ylemontag.mathoperations.functors.Functor4;

public abstract class Expression {
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Expression)) {
            return false;
        }
        return this.equals((Expression)obj);
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    public abstract boolean equals(Expression var1);

    public abstract String getRepresentation(boolean var1);

    public abstract SortedSet<String> getVariables();

    public String[] getVariablesAsArray() {
        SortedSet<String> variables = this.getVariables();
        String[] retVal = new String[variables.size()];
        int k = 0;
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            String v;
            retVal[k] = v = (String)iterator.next();
            ++k;
        }
        return retVal;
    }

    public abstract boolean isValidFunctor(String[] var1);

    public boolean isValidFunctor() {
        return this.isValidFunctor(null);
    }

    public boolean isValidFunctor1(String v1) {
        return this.isValidFunctor(new String[]{v1});
    }

    public boolean isValidFunctor2(String v1, String v2) {
        return this.isValidFunctor(new String[]{v1, v2});
    }

    public boolean isValidFunctor3(String v1, String v2, String v3) {
        return this.isValidFunctor(new String[]{v1, v2, v3});
    }

    public boolean isValidFunctor4(String v1, String v2, String v3, String v4) {
        return this.isValidFunctor(new String[]{v1, v2, v3, v4});
    }

    public abstract Functor getFunctor(String[] var1);

    public Functor getFunctor() {
        return this.getFunctor(this.getVariablesAsArray());
    }

    public Functor1 getFunctor1(String v1) {
        Functor fun = this.getFunctor(new String[]{v1});
        return new Functor1(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor1 getFunctor1() {
        Functor fun = this.getCanonicalFunctor(1);
        return new Functor1(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor2 getFunctor2(String v1, String v2) {
        Functor fun = this.getFunctor(new String[]{v1, v2});
        return new Functor2(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor2 getFunctor2() {
        Functor fun = this.getCanonicalFunctor(2);
        return new Functor2(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor3 getFunctor3(String v1, String v2, String v3) {
        Functor fun = this.getFunctor(new String[]{v1, v2, v3});
        return new Functor3(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor3 getFunctor3() {
        Functor fun = this.getCanonicalFunctor(3);
        return new Functor3(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor4 getFunctor4(String v1, String v2, String v3, String v4) {
        Functor fun = this.getFunctor(new String[]{v1, v2, v3, v4});
        return new Functor4(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    public Functor4 getFunctor4() {
        Functor fun = this.getCanonicalFunctor(4);
        return new Functor4(fun.getFormatPattern(), fun.getFunctionPointer());
    }

    private Functor getCanonicalFunctor(int expectedInputArgumentCount) {
        String[] canonicalVariables = this.getVariablesAsArray();
        if (canonicalVariables.length != expectedInputArgumentCount) {
            throw new BadFunctor(String.format("Wrong number of input variables (expected: %d, current: %d).", expectedInputArgumentCount, canonicalVariables.length));
        }
        return this.getFunctor(canonicalVariables);
    }

    public static Expression parse(String expr) {
        return Parser.parse(expr);
    }

    public static class BadFunctor
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public BadFunctor() {
        }

        public BadFunctor(String message) {
            super(message);
        }
    }

    public static class ParsingException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public ParsingException() {
        }

        public ParsingException(String message) {
            super(message);
        }
    }
}

