/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class XugglerUtil {
    public static IRational getVideoFrameRate(String filename) {
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("Could not open file.");
        }
        int numStreams = container.getNumStreams();
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder streamcoder = stream.getStreamCoder();
            if (streamcoder.getCodec().getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            IRational res = stream.getTimeBase();
            container.close();
            return res;
        }
        return null;
    }

    public static ArrayList<Long> getVideoKeyFrames(String filename) {
        ArrayList<Long> keyFrames = new ArrayList<Long>();
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("Could not open file.");
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder streamcoder = stream.getStreamCoder();
            if (streamcoder.getCodec().getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            break;
        }
        if (videoStreamId == -1) {
            System.out.println("No Video in file");
            return null;
        }
        IPacket packet = IPacket.make();
        keyFrames = new ArrayList();
        while (container.readNextPacket(packet) >= 0) {
            if (packet.getStreamIndex() != videoStreamId || !packet.isKey()) continue;
            keyFrames.add(packet.getTimeStamp());
        }
        container.close();
        return keyFrames;
    }

    public static long findBestKeyFrame(ArrayList<Long> keyFrames, long timeStampWanted) {
        if (timeStampWanted < 0L) {
            return -1L;
        }
        long bestKeyFrame = 0L;
        for (int i = 1; i < keyFrames.size(); ++i) {
            long currentKeyFrame = keyFrames.get(i);
            if (currentKeyFrame > timeStampWanted) continue;
            bestKeyFrame = currentKeyFrame;
        }
        return bestKeyFrame;
    }

    public static long getVideoDuration(String filename) {
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("Could not open file.");
        }
        int numStreams = container.getNumStreams();
        long duration = -1L;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder streamcoder = stream.getStreamCoder();
            if (streamcoder.getCodec().getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoCoder = streamcoder;
            duration = stream.getDuration();
            break;
        }
        if (videoCoder == null) {
            System.out.println("No Video in file");
            return -1L;
        }
        container.close();
        return duration;
    }

    public static BufferedImage getImage(String filename, long keyFrame, long wantedImageAfterKeyFrame) {
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("Could not open file.");
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder streamcoder = stream.getStreamCoder();
            if (streamcoder.getCodec().getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            videoCoder = streamcoder;
            break;
        }
        if (videoCoder == null) {
            System.out.println("null");
            return null;
        }
        if (videoCoder.open(null, null) < 0) {
            System.out.println("error open");
            return null;
        }
        IVideoResampler resampler = null;
        if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make((int)videoCoder.getWidth(), (int)videoCoder.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)videoCoder.getWidth(), (int)videoCoder.getHeight(), (IPixelFormat.Type)videoCoder.getPixelType())) == null) {
            throw new RuntimeException("could not create color space resampler for: " + filename);
        }
        IPacket packet = IPacket.make();
        int res = container.seekKeyFrame(videoStreamId, keyFrame, 0);
        if (res < 0) {
            System.out.println("no keyframe found");
            return null;
        }
        int nbImagesDones = 0;
        while (container.readNextPacket(packet) >= 0) {
            int bytesDecoded;
            if (packet.getStreamIndex() != videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)videoCoder.getPixelType(), (int)videoCoder.getWidth(), (int)videoCoder.getHeight());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding video");
            }
        }
        container.close();
        return null;
    }
}

