/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import plugins.nchenouard.linearprogrammingfullsimplex.CanonicalSimplexProgram;
import plugins.nchenouard.linearprogrammingfullsimplex.SimplexLEXICO;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Cluster;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.MHTracker.LinearProgramming.HierarchicalLP;
import plugins.nchenouard.particletracking.MHTracker.LinearProgramming.HierarchicalProcedureResult;
import plugins.nchenouard.particletracking.MHTracker.SolveMLAssociation;

public class ClusterSolveLPCustom
extends Cluster {
    double pFA;

    public ClusterSolveLPCustom(HMMMHTracker tracker, int firstT, int lastT, int K, double pFA) {
        super(tracker, firstT, lastT, K);
        this.pFA = pFA;
    }

    @Override
    public void buildAndApplyBestHypTree(int t2) {
        int t = t2;
        int firstTtemp = -1;
        boolean buildAndApplyBestHyp = false;
        for (Object i : this.concurrentFamilies.keySet()) {
            if (firstTtemp >= 0 && (Integer)i >= firstTtemp) continue;
            firstTtemp = (Integer)i;
        }
        buildAndApplyBestHyp = firstTtemp >= 0 && firstTtemp <= t - this.K;
        int firstT = firstTtemp;
        if (buildAndApplyBestHyp) {
            this.println("-----build best Hyp");
            this.println("different root time for families " + this.concurrentFamilies.size());
            this.println("firstT " + firstT + " first time " + firstT + "  time " + t);
            for (Map.Entry entry : this.concurrentFamilies.entrySet()) {
                this.println("time " + (Integer)entry.getKey() + "numFamily " + ((ArrayList)entry.getValue()).size());
            }
            int currentT = firstT;
            ArrayList arrayList = (ArrayList)this.concurrentFamilies.get(new Integer(currentT));
            ArrayList<Family> mandatoryFamilies = new ArrayList<Family>();
            ArrayList<Family> optionalFamilies = new ArrayList<Family>();
            for (Family f : arrayList) {
                if (f.rootTrack == null) {
                    optionalFamilies.add(f);
                    continue;
                }
                mandatoryFamilies.add(f);
                this.println("mandatory family : begin = " + f.rootTrack.associations.getFirst().t + " root time " + f.rootTime);
            }
            this.bestHypSafe.bestHyp = this.solvePbWithLPCustomHierarchical3(firstT, t);
            if (this.bestHypSafe.bestHyp == null) {
                SolveMLAssociation mlSolver = new SolveMLAssociation();
                mlSolver.solve(firstT, t, this.concurrentFamilies, mandatoryFamilies, optionalFamilies);
                this.bestHypSafe.bestHyp = mlSolver.getHypothesis(this, firstT, t, this.tracker);
            }
        }
        this.applyBestHyp(t);
        for (Collection collection : this.concurrentFamilies.values()) {
            for (Family f : collection) {
                f.hypotheses.clear();
            }
        }
    }

    public GlobalHypothesis solvePbWithLPCustomHierarchical3(int firstT, int t) {
        int n;
        GlobalHypothesis gh = null;
        ArrayList<Association> associations = new ArrayList<Association>();
        ArrayList<Object> mandatoryAssociations = new ArrayList<Object>();
        for (ArrayList flist : this.concurrentFamilies.values()) {
            for (Family f : flist) {
                if (f.rootTrack == null) continue;
                Association rootAssociation = f.rootNode.association;
                if (rootAssociation != null && !associations.contains(rootAssociation) && !mandatoryAssociations.contains(rootAssociation)) {
                    mandatoryAssociations.add(rootAssociation);
                    continue;
                }
                System.out.println("Error: rootrack without association!");
            }
            for (Family f : flist) {
                for (Association a : f.usedAssociations) {
                    if (associations.contains(a) || mandatoryAssociations.contains(a)) continue;
                    associations.add(a);
                }
            }
        }
        ArrayList<boolean[]> tuples = new ArrayList<boolean[]>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<Hypothesis> hypList = new ArrayList<Hypothesis>();
        ArrayList<Boolean> isPredList = new ArrayList<Boolean>();
        double logPFA = Math.log(this.pFA);
        for (ArrayList flist : this.concurrentFamilies.values()) {
            for (Family f : flist) {
                if (f.rootTrack == null && mandatoryAssociations.contains(f.rootNode.association)) continue;
                for (Hypothesis h : f.hypotheses) {
                    boolean[] detectionTab = new boolean[associations.size() + mandatoryAssociations.size()];
                    double s = h.leaf.score;
                    int cnt = 0;
                    for (Association association : associations) {
                        if (h.usedAssociations.contains(association)) {
                            detectionTab[cnt] = true;
                            if (!association.isPrediction) {
                                s -= logPFA;
                            }
                        }
                        ++cnt;
                    }
                    for (Association association : mandatoryAssociations) {
                        Association rootAssociation = f.rootNode.association;
                        if (rootAssociation != null && rootAssociation == association) {
                            detectionTab[cnt] = true;
                            if (!association.isPrediction) {
                                s -= logPFA;
                            }
                        } else {
                            detectionTab[cnt] = false;
                        }
                        ++cnt;
                    }
                    tuples.add(detectionTab);
                    scores.add(s);
                    hypList.add(h);
                    isPredList.add(new Boolean(false));
                }
            }
        }
        int numVariables = tuples.size();
        int numConstraintsDetections = ((boolean[])tuples.get(0)).length;
        ArrayList<double[]> Alist = new ArrayList<double[]>(numConstraintsDetections + numVariables);
        ArrayList<Boolean> isEqList = new ArrayList<Boolean>(numConstraintsDetections + numVariables);
        for (n = 0; n < numVariables; ++n) {
            double[] constraint = new double[numVariables];
            constraint[n] = 1.0;
            Alist.add(constraint);
            isEqList.add(false);
        }
        for (n = 0; n < numConstraintsDetections; ++n) {
            boolean isEquality = n >= associations.size();
            double[] constraint = new double[numVariables];
            int num1 = 0;
            for (int i = 0; i < numVariables; ++i) {
                if (!((boolean[])tuples.get(i))[n]) continue;
                constraint[i] = 1.0;
                ++num1;
            }
            if (num1 <= 0) continue;
            boolean alreadyExists = false;
            int idx = -1;
            for (int kk = 0; kk < Alist.size(); ++kk) {
                double[] dArray = (double[])Alist.get(kk);
                boolean e = true;
                for (int k = 0; k < numVariables; ++k) {
                    if (dArray[k] == constraint[k]) continue;
                    e = false;
                    break;
                }
                if (!e) continue;
                alreadyExists = true;
                idx = kk;
                break;
            }
            if (!alreadyExists) {
                Alist.add(constraint);
                isEqList.add(isEquality);
                continue;
            }
            if (!isEquality) continue;
            isEqList.set(idx, true);
        }
        int totalNumConstraints = Alist.size();
        double[] c = new double[numVariables];
        double[] b = new double[totalNumConstraints];
        double[][] A = new double[totalNumConstraints][numVariables];
        boolean[] equalityConstraints = new boolean[totalNumConstraints];
        for (int i = 0; i < totalNumConstraints; ++i) {
            A[i] = (double[])Alist.get(i);
            b[i] = 1.0;
            equalityConstraints[i] = (Boolean)isEqList.get(i);
        }
        for (int v = 0; v < numVariables; ++v) {
            c[v] = (Double)scores.get(v);
        }
        SimplexLEXICO program = new SimplexLEXICO(A, b, c, true, equalityConstraints);
        long tCustom1 = System.currentTimeMillis();
        HierarchicalProcedureResult res = HierarchicalLP.hierarchicalBinarySimplex((CanonicalSimplexProgram)program, true);
        long tCustom2 = System.currentTimeMillis();
        if (res != null) {
            double[] x = res.solution;
            gh = new GlobalHypothesis(firstT, t, this.tracker);
            for (int cnt = 0; cnt < numVariables; ++cnt) {
                if (!(x[cnt] > 0.5) || !(hypList.get(cnt) instanceof Hypothesis)) continue;
                gh.addHypothesis((Hypothesis)hypList.get(cnt));
            }
            gh.penalizeAllFD(this.pFA, this.realAssociations);
        } else {
            ArrayList<Family> mandatoryFamilies = new ArrayList<Family>();
            ArrayList<Family> optionalFamilies = new ArrayList<Family>();
            ArrayList fList = (ArrayList)this.concurrentFamilies.get(new Integer(firstT));
            for (Family f : fList) {
                if (f.rootTrack == null) {
                    optionalFamilies.add(f);
                    continue;
                }
                mandatoryFamilies.add(f);
                this.println("mandatory family : begin = " + f.rootTrack.associations.getFirst().t + " root time " + f.rootTime);
            }
            SolveMLAssociation mlSolver = new SolveMLAssociation();
            mlSolver.solve(firstT, t, this.concurrentFamilies, mandatoryFamilies, optionalFamilies);
            this.bestHypSafe.bestHyp = mlSolver.getHypothesis(this, firstT, t, this.tracker);
        }
        return gh;
    }
}

