/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers.js;

import icy.gui.main.MainInterface;
import icy.image.IcyBufferedImage;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.sequence.Sequence;
import icy.util.ClassUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.Gutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import plugins.tprovoost.scripteditor.completion.IcyCompletionProvider;
import plugins.tprovoost.scripteditor.completion.types.BasicJavaClassCompletion;
import plugins.tprovoost.scripteditor.completion.types.ScriptFunctionCompletion;
import plugins.tprovoost.scripteditor.scriptinghandlers.IcyFunctionBlock;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngineHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptVariable;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptingHandler;
import plugins.tprovoost.scripteditor.scriptinghandlers.VariableType;

public class JSScriptingHandlerRhino
extends ScriptingHandler {
    private String currentText;
    private static int LINE_NUMBER_START = 1;
    Reporter reporter = new Reporter();
    private LinkedList<IcyFunctionBlock> functionBlocksToResolve = new LinkedList();

    public JSScriptingHandlerRhino(DefaultCompletionProvider provider, JTextComponent textArea, Gutter gutter, boolean autocompilation) {
        super(provider, "javascript", textArea, gutter, autocompilation);
    }

    @Override
    public void evalEngine(ScriptEngine engine, String s) throws ScriptException {
        if (this.fileName == null || this.fileName.isEmpty() || this.fileName.contentEquals("Untitled")) {
            engine.eval(s);
        } else {
            engine.evalFile(this.fileName);
        }
    }

    @Override
    public void installDefaultLanguageCompletions(String language) {
        List list;
        FunctionCompletion c;
        ScriptEngine engine = this.getEngine();
        if (engine == null) {
            return;
        }
        ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
        HashMap<String, VariableType> engineFunctions = engineHandler.getEngineFunctions();
        HashMap<String, VariableType> engineVariables = engineHandler.getEngineVariables();
        try {
            this.importJavaScriptPackages(this.getEngine());
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        String mainInterface = MainInterface.class.getName();
        try {
            engine.eval("function getSequence() { return Packages.icy.main.Icy.getMainInterface().getFocusedSequence() }");
            if (this.provider != null) {
                c = new FunctionCompletion((CompletionProvider)this.provider, "getSequence", Sequence.class.getName());
                c.setDefinedIn(mainInterface);
                c.setReturnValueDescription("The focused sequence is returned.");
                c.setShortDescription("Returns the sequence under focus. Returns null if no sequence opened.");
                list = this.provider.getCompletionByInputText("gui");
                if (list == null || !IcyCompletionProvider.exists((Completion)c, list)) {
                    this.provider.addCompletion((Completion)c);
                }
            }
            engineFunctions.put("getSequence", new VariableType(Sequence.class));
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        try {
            engine.eval("function getImage() { return Packages.icy.main.Icy.getMainInterface().getFocusedImage(); }");
            if (this.provider != null) {
                c = new FunctionCompletion((CompletionProvider)this.provider, "getImage", IcyBufferedImage.class.getName());
                c.setDefinedIn(mainInterface);
                c.setShortDescription("Returns the current image viewed in the focused sequence.");
                c.setReturnValueDescription("Returns the focused Image, returns null if no sequence opened");
                list = this.provider.getCompletionByInputText("gui");
                if (list == null || !IcyCompletionProvider.exists((Completion)c, list)) {
                    this.provider.addCompletion((Completion)c);
                }
            }
            engineFunctions.put("getImage", new VariableType(IcyBufferedImage.class));
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        try {
            engine.eval("gui = Packages.icy.main.Icy.getMainInterface()");
            if (this.provider != null) {
                VariableCompletion vc = new VariableCompletion((CompletionProvider)this.provider, "gui", mainInterface);
                vc.setDefinedIn(mainInterface);
                vc.setShortDescription("Returns the sequence under focus. Returns null if no sequence opened.");
                list = this.provider.getCompletionByInputText("gui");
                if (list == null || !IcyCompletionProvider.exists((Completion)vc, list)) {
                    this.provider.addCompletion((Completion)vc);
                }
            }
            engineVariables.put("gui", new VariableType(MainInterface.class));
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        engineFunctions.put("importClass", new VariableType(Void.TYPE));
        engineFunctions.put("importPackage", new VariableType(Void.TYPE));
        engineFunctions.put("eval", new VariableType(Void.TYPE));
        try {
            this.importFunctions();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    private void importJavaScriptPackages(ScriptEngine engine) throws ScriptException {
    }

    @Override
    public void installMethods(ScriptEngine engine, ArrayList<Method> methods) {
        try {
            engine.eval("function getSequence() { return Packages.icy.main.Icy.getMainInterface().getFocusedSequence() }");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        try {
            engine.eval("function getImage() { return Packages.icy.main.Icy.getMainInterface().getFocusedImage(); }");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        try {
            engine.eval("gui = Packages.icy.main.Icy.getMainInterface()");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        for (Method method : methods) {
            ScriptFunctionCompletion.BindingFunction blockFunction = method.getAnnotation(ScriptFunctionCompletion.BindingFunction.class);
            if (blockFunction == null) continue;
            ArrayList<ParameterizedCompletion.Parameter> fParams = new ArrayList<ParameterizedCompletion.Parameter>();
            Class<?>[] paramTypes = method.getParameterTypes();
            String params = "";
            String functionName = blockFunction.value();
            int i = 0;
            while (i < paramTypes.length) {
                fParams.add(new ParameterizedCompletion.Parameter((Object)IcyCompletionProvider.getType(paramTypes[i], true), "arg" + i));
                params = String.valueOf(params) + ",arg" + i;
                ++i;
            }
            if (params.length() > 0) {
                params = params.substring(1);
            }
            ScriptFunctionCompletion sfc = Modifier.isStatic(method.getModifiers()) ? new ScriptFunctionCompletion(null, functionName, method) : new ScriptFunctionCompletion(null, method.getName(), method);
            try {
                if (method.getReturnType() == Void.TYPE) {
                    engine.eval("function " + functionName + " (" + params + ") {\n\t" + sfc.getMethodCall() + "\n}");
                    continue;
                }
                engine.eval("function " + functionName + " (" + params + ") {\n\treturn " + sfc.getMethodCall() + "\n}");
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registerImports() {
        int idxString;
        String s = this.textArea.getText();
        Pattern patternClasses = Pattern.compile("importClass\\(\\s*(Packages\\.|)((\\w|\\.|\\$)+)\\s*\\)");
        Matcher m = patternClasses.matcher(s);
        int offset = 0;
        while (m.find(offset)) {
            String foundString = m.group(0);
            String imported = m.group(2);
            this.scriptDeclaredImportClasses.add(imported);
            PluginDescriptor plugindesc = PluginRepositoryLoader.getPlugin((String)imported);
            if (plugindesc != null) {
                if (!plugindesc.isInstalled()) {
                    PluginInstaller.install((PluginDescriptor)plugindesc, (boolean)false);
                }
            } else {
                for (PluginDescriptor pd : PluginRepositoryLoader.getPlugins()) {
                    if (!pd.getClassName().startsWith(imported) || pd.isInstalled()) continue;
                    PluginInstaller.install((PluginDescriptor)pd, (boolean)false);
                }
            }
            try {
                if (this.provider != null && this.provider.getCompletionByInputText(imported) == null) {
                    this.provider.addCompletion((Completion)new BasicJavaClassCompletion((CompletionProvider)this.provider, ClassUtil.findClass((String)imported)));
                }
            }
            catch (ClassNotFoundException pd) {
                // empty catch block
            }
            if ((idxString = s.indexOf(foundString, offset)) == -1) break;
            offset = idxString + foundString.length();
        }
        Pattern patternPackages = Pattern.compile("importPackage\\((Packages\\.|)((\\w|\\.)+)\\)");
        m = patternPackages.matcher(s);
        offset = 0;
        while (m.find(offset)) {
            String foundString = m.group(0);
            String imported = m.group(2);
            this.scriptDeclaredImports.add(imported);
            for (PluginDescriptor pd : PluginRepositoryLoader.getPlugins()) {
                if (!pd.getClassName().startsWith(imported) || pd.isInstalled()) continue;
                PluginInstaller.install((PluginDescriptor)pd, (boolean)false);
            }
            idxString = s.indexOf(foundString, offset);
            if (idxString == -1) break;
            offset = idxString + foundString.length();
        }
    }

    @Override
    public void organizeImports(JTextComponent tc) {
        JSScriptingHandlerRhino.organizeImportsStatic(tc);
    }

    private static void organizeImportsStatic(JTextComponent tc) {
        Caret c;
        int idxStop;
        int idxStart;
        ArrayList<String> listImportsClass = new ArrayList<String>();
        ArrayList<String> listImportsPackages = new ArrayList<String>();
        boolean errorHappened = false;
        String originalText = tc.getText();
        String text = "";
        while ((text = tc.getText()).contains("importClass(") && !errorHappened) {
            idxStart = text.indexOf("importClass(");
            if (idxStart == -1) continue;
            idxStop = text.indexOf(41, idxStart);
            if (idxStop == -1) {
                errorHappened = true;
                break;
            }
            c = tc.getCaret();
            c.setDot(idxStart);
            c.moveDot(idxStop + 1);
            listImportsClass.add(tc.getSelectedText());
            tc.replaceSelection("");
        }
        while ((text = tc.getText()).contains("importPackage(") && !errorHappened) {
            idxStart = text.indexOf("importPackage(");
            if (idxStart == -1) continue;
            idxStop = text.indexOf(41, idxStart);
            if (idxStop == -1) {
                errorHappened = true;
                break;
            }
            c = tc.getCaret();
            c.setDot(idxStart);
            c.moveDot(idxStop + 1);
            listImportsPackages.add(tc.getSelectedText());
            tc.replaceSelection("");
        }
        if (errorHappened) {
            tc.setText(originalText);
        } else {
            char c2;
            String result = "";
            Collections.sort(listImportsClass);
            Collections.sort(listImportsPackages);
            int i = 0;
            while (i < listImportsClass.size()) {
                result = i == 0 ? String.valueOf(result) + (String)listImportsClass.get(i) : String.valueOf(result) + "\n" + (String)listImportsClass.get(i);
                ++i;
            }
            i = 0;
            while (i < listImportsPackages.size()) {
                result = i == 0 ? String.valueOf(result) + "\n\n" + (String)listImportsPackages.get(i) : String.valueOf(result) + "\n" + (String)listImportsPackages.get(i);
                ++i;
            }
            String leftText = tc.getText();
            while (leftText.length() > 0 && ((c2 = leftText.charAt(0)) == ' ' || c2 == '\n' || c2 == '\t')) {
                leftText = leftText.substring(1);
            }
            tc.setText(String.valueOf(result) + "\n\n" + leftText);
        }
    }

    @Override
    public void autoDownloadPlugins() {
        int idxString;
        String s = this.textArea.getText();
        Pattern patternClasses = Pattern.compile("importClass\\((Packages\\.|)((\\w|\\.)+)\\)");
        Matcher m = patternClasses.matcher(s);
        int offset = 0;
        while (m.find(offset)) {
            String foundString = m.group(0);
            String imported = m.group(2);
            PluginDescriptor plugindesc = PluginRepositoryLoader.getPlugin((String)imported);
            if (plugindesc != null) {
                if (!plugindesc.isInstalled()) {
                    PluginInstaller.install((PluginDescriptor)plugindesc, (boolean)false);
                }
            } else {
                for (PluginDescriptor pd : PluginRepositoryLoader.getPlugins()) {
                    if (!pd.getClassName().startsWith(imported) || pd.isInstalled()) continue;
                    PluginInstaller.install((PluginDescriptor)pd, (boolean)false);
                }
            }
            if ((idxString = s.indexOf(foundString, offset)) == -1) break;
            offset = idxString + foundString.length();
        }
        Pattern patternPackages = Pattern.compile("importPackage\\((Packages\\.|)((\\w|\\.)+)\\)");
        m = patternPackages.matcher(s);
        offset = 0;
        while (m.find(offset)) {
            String foundString = m.group(0);
            String imported = m.group(2);
            for (PluginDescriptor pd : PluginRepositoryLoader.getPlugins()) {
                if (!pd.getClassName().startsWith(imported) || pd.isInstalled()) continue;
                PluginInstaller.install((PluginDescriptor)pd, (boolean)false);
            }
            idxString = s.indexOf(foundString, offset);
            if (idxString == -1) break;
            offset = idxString + foundString.length();
        }
    }

    @Override
    protected void detectVariables(String s) throws ScriptException {
        Context.enter();
        try {
            this.currentText = s;
            CompilerEnvirons comp = CompilerEnvirons.ideEnvirons();
            comp.setErrorReporter((ErrorReporter)this.reporter);
            comp.setStrictMode(false);
            Parser parser = new Parser(comp);
            AstRoot root = null;
            try {
                root = parser.parse(s, this.fileName, LINE_NUMBER_START);
            }
            catch (RhinoException e) {
                throw new ScriptException(e.getMessage(), e.sourceName(), e.lineNumber(), e.columnNumber());
            }
            if (root == null || !root.hasChildren()) {
                return;
            }
            if (this.provider != null) {
                for (Completion c : this.variableCompletions) {
                    this.provider.removeCompletion(c);
                }
            }
            this.variableCompletions.clear();
            this.addExternalVariables();
            this.registerVariables((AstNode)root, root, s);
            if (this.provider != null) {
                this.provider.addCompletions((List)this.variableCompletions);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void registerVariables(AstNode n, AstRoot root, String text) throws ScriptException {
        if (n == null) {
            return;
        }
        for (Completion c : this.generateCompletion(n, root, text)) {
            ScriptVariable vc;
            if (c == null) continue;
            boolean alreadyExists = false;
            if (c instanceof VariableCompletion && (vc = (ScriptVariable)this.localVariables.get(((VariableCompletion)c).getName())) != null && !vc.isInScope(this.textArea.getCaretPosition())) {
                alreadyExists = true;
            }
            int i = 0;
            while (i < this.variableCompletions.size() && !alreadyExists) {
                if (((Completion)this.variableCompletions.get(i)).compareTo(c) == 0) {
                    if (this.textArea.getCaret().getDot() > n.getAbsolutePosition()) {
                        this.variableCompletions.remove(i);
                    } else {
                        alreadyExists = true;
                    }
                }
                ++i;
            }
            if (alreadyExists) continue;
            this.variableCompletions.add(c);
        }
        if (n.hasChildren()) {
            AstNode child = (AstNode)n.getFirstChild();
            while (child != null) {
                this.registerVariables(child, root, text);
                child = (AstNode)child.getNext();
            }
        }
    }

    private List<Completion> generateCompletion(AstNode n, AstRoot root, String text) throws ScriptException {
        ArrayList<Completion> toReturn = new ArrayList<Completion>();
        AstNode expression = null;
        switch (n.getType()) {
            case 122: {
                VariableDeclaration var = (VariableDeclaration)n;
                List listVars = var.getVariables();
                for (VariableInitializer v : listVars) {
                    AstNode target = v.getTarget();
                    AstNode init = v.getInitializer();
                    if (target.getType() != 39) continue;
                    VariableType type = null;
                    if (init != null) {
                        type = this.getRealType(init);
                    }
                    String typeString = "";
                    if (type != null) {
                        typeString = type.toString();
                    }
                    VariableCompletion c = new VariableCompletion((CompletionProvider)this.provider, target.getString(), typeString);
                    c.setSummary("variable");
                    c.setDefinedIn("script");
                    c.setRelevance(10);
                    int pos = n.getAbsolutePosition();
                    this.addVariableDeclaration(c.getName(), type, pos, pos + var.getParent().getLength());
                    toReturn.add((Completion)c);
                }
                break;
            }
            case 133: {
                if (n instanceof LabeledStatement) {
                    LabeledStatement labelSt = (LabeledStatement)n;
                    for (Label label : labelSt.getLabels()) {
                        toReturn.add((Completion)new BasicCompletion((CompletionProvider)this.provider, label.getName(), "Label"));
                    }
                    break;
                }
            }
            case 134: {
                expression = ((ExpressionStatement)n).getExpression();
            }
            case 90: {
                if (expression == null) {
                    expression = n;
                }
                if (expression instanceof Assignment) {
                    AstNode left = ((Assignment)expression).getLeft();
                    AstNode right = ((Assignment)expression).getRight();
                    VariableType type = this.getRealType(right);
                    if (type != null && type.getClazz() == Void.TYPE) {
                        throw new ScriptException("This method returns \"void\" and cannot be assigned", this.fileName, n.getLineno(), -1);
                    }
                    String typeString = "";
                    if (type != null) {
                        typeString = type.toString();
                    }
                    if (left.getType() != 39) break;
                    VariableCompletion c = new VariableCompletion((CompletionProvider)this.provider, left.getString(), typeString);
                    c.setSummary("variable");
                    c.setDefinedIn("script");
                    c.setRelevance(10);
                    this.addVariableDeclaration(c.getName(), type, n.getAbsolutePosition());
                    toReturn.add((Completion)c);
                    break;
                }
                if (expression instanceof FunctionCall) {
                    VariableType vt;
                    AstNode target = ((FunctionCall)expression).getTarget();
                    if (target.getType() == 39 && (target.getString().contentEquals("importClass") || target.getString().contentEquals("importPackage")) || (vt = this.resolveCallType(expression, text, false)) != null) break;
                    this.updateGutter();
                    break;
                }
                boolean cfr_ignored_0 = expression instanceof PropertyGet;
                break;
            }
            case 129: {
                if (n instanceof Block) {
                    Block scope = (Block)n;
                    AstNode child = (AstNode)scope.getFirstChild();
                    while (child != null) {
                        this.registerVariables(child, root, text);
                        child = (AstNode)child.getNext();
                    }
                } else {
                    if (!(n instanceof Scope)) break;
                    Scope scope = (Scope)n;
                    AstNode child = (AstNode)scope.getFirstChild();
                    while (child != null) {
                        this.registerVariables(child, root, text);
                        child = (AstNode)child.getNext();
                    }
                }
                break;
            }
            case 38: {
                this.resolveCallType(n, text, false);
                break;
            }
            case 109: {
                FunctionNode fn = (FunctionNode)n;
                FunctionCompletion fc = new FunctionCompletion((CompletionProvider)this.provider, fn.getName(), "");
                List paramsFn = fn.getParams();
                ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
                for (AstNode param : paramsFn) {
                    params.add(new ParameterizedCompletion.Parameter((Object)"", param.toSource()));
                }
                fc.setParams(params);
                fc.setDefinedIn("script");
                fc.setRelevance(10);
                this.localFunctions.put(fn.getName(), new VariableType(Void.class));
                toReturn.add((Completion)fc);
                this.registerVariables(fn.getBody(), root, text);
                break;
            }
            case 112: {
                IfStatement nIf = (IfStatement)n;
                this.registerVariables(nIf.getThenPart(), root, text);
                this.registerVariables(nIf.getElsePart(), root, text);
                break;
            }
            case 118: 
            case 119: {
                ForInLoop fl;
                if (n instanceof ForInLoop) {
                    fl = (ForInLoop)n;
                    this.registerVariables(fl.getIterator(), root, text);
                }
                if (n instanceof ForLoop) {
                    fl = (ForLoop)n;
                    this.registerVariables(fl.getInitializer(), root, text);
                }
            }
            case 117: {
                this.registerVariables(((Loop)n).getBody(), root, text);
                break;
            }
            case 114: {
                for (SwitchCase c : ((SwitchStatement)n).getCases()) {
                    for (AstNode statement : c.getStatements()) {
                        this.registerVariables(statement, root, text);
                    }
                }
                break;
            }
        }
        return toReturn;
    }

    /*
     * Unable to fully structure code
     */
    private VariableType resolveCallType(AstNode n, String text, boolean noerror) {
        toReturn = null;
        engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
        offset = n.getAbsolutePosition();
        s = this.buildFunction2(n);
        containsNew = s.contains("new ");
        if (containsNew) {
            s = s.substring("new ".length());
        }
        p = Pattern.compile("\\w(\\w|\\.|\\[|\\])*\\((\\w|\\.|\\[|,|\\]|\\(|\\)| )*\\)");
        match = p.matcher(s);
        idxP1 = 0;
        decal = 0;
        isField = false;
        if (match.find(0)) {
            firstCall = match.group(0);
            idxP1 = firstCall.indexOf(40);
            idxP2 = firstCall.indexOf(41);
            decal += idxP2 + 1;
            lastDot = firstCall.substring(0, idxP1).lastIndexOf(46);
            vt = null;
            classNameOrFunctionNameOrVariable = lastDot != -1 ? firstCall.substring(0, lastDot) : (idxP1 != -1 ? firstCall.substring(0, idxP1) : firstCall.substring(0));
            if (classNameOrFunctionNameOrVariable.contains(".")) {
                clazz = this.resolveClassDeclaration(classNameOrFunctionNameOrVariable);
                if (clazz != null) {
                    vt = new VariableType(clazz);
                } else {
                    res = classNameOrFunctionNameOrVariable.split("\\.");
                    classNameOrFunctionNameOrVariable = res[0];
                    isField = true;
                    i = 1;
                    while (i < res.length) {
                        lastDot = classNameOrFunctionNameOrVariable.length() + 1;
                        decal = classNameOrFunctionNameOrVariable.length() + 1;
                        ++i;
                    }
                }
            }
            if (vt == null) {
                vt = (VariableType)this.localFunctions.get(classNameOrFunctionNameOrVariable);
            }
            if (vt == null) {
                vt = ScriptEngineHandler.getEngineHandler(this.getEngine()).getEngineFunctions().get(classNameOrFunctionNameOrVariable);
                if (classNameOrFunctionNameOrVariable.contentEquals("println") || classNameOrFunctionNameOrVariable.contentEquals("print")) {
                    vt = new VariableType(Void.TYPE);
                }
            }
            if (vt == null) {
                vt = this.getVariableDeclaration(classNameOrFunctionNameOrVariable, offset);
            }
            if (vt == null) {
                vt = engineHandler.getEngineVariables().get(classNameOrFunctionNameOrVariable);
            }
            if (vt == null && (clazz = this.resolveClassDeclaration(classNameOrFunctionNameOrVariable)) != null) {
                vt = new VariableType(clazz);
            }
            if (vt == null) {
                this.errors.addWarning(new ScriptException("Unknown field or method: " + classNameOrFunctionNameOrVariable, null, n.getLineno()));
                return null;
            }
            returnType = vt.getClazz();
            if (returnType == null) {
                return null;
            }
            call = decal < idxP1 ? firstCall.substring(lastDot + 1) : firstCall.substring(lastDot + 1, idxP1);
            genericType = vt.getType();
            if (lastDot != -1) {
                if (!isField) {
                    try {
                        argsString = firstCall.substring(idxP1 + 1, idxP2);
                        args = argsString.split(",");
                        if (argsString.isEmpty()) {
                            clazzes = new Class[]{};
                        } else {
                            clazzes = new Class[args.length];
                            i = 0;
                            while (i < clazzes.length) {
                                clazzes[i] = this.resolveClassDeclaration(args[i]);
                                ++i;
                            }
                            clazzes = JSScriptingHandlerRhino.getGenericNumberTypes(text, n, vt.getClazz(), firstCall.substring(lastDot + 1, idxP1), clazzes);
                        }
                        m = JSScriptingHandlerRhino.resolveMethod(returnType, call, clazzes);
                        genericReturnType = m.getGenericReturnType().toString();
                        if (Pattern.matches("(\\[*)E", genericReturnType) && !genericType.isEmpty()) {
                            try {
                                returnType = ClassUtil.findClass((String)genericType);
                                genericType = "";
                            }
                            catch (ClassNotFoundException var27_36) {}
                        }
                        returnType = m.getReturnType();
                        if (returnType.getTypeParameters().length <= 0) ** GOTO lbl109
                        genericType = VariableType.getType(m.getGenericReturnType().toString());
                    }
                    catch (SecurityException clazzes) {
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            f = returnType.getField(call);
                            returnType = f.getType();
                        }
                        catch (SecurityException e) {
                            this.errors.addWarning(new ScriptException("Unknown field or method: " + call, null, n.getLineno()));
                            return null;
                        }
                        catch (NoSuchFieldException e) {
                            this.errors.addWarning(new ScriptException("Unknown field or method: " + call, null, n.getLineno()));
                            return null;
                        }
                    }
                } else {
                    try {
                        next = firstCall.substring(decal);
                        next = next.substring(0, next.indexOf(46));
                        decal += next.length();
                        f = returnType.getField(next);
                        returnType = f.getType();
                    }
                    catch (SecurityException e) {
                        this.errors.addWarning(new ScriptException("Unknown field or method: " + call, null, n.getLineno()));
                        return null;
                    }
                    catch (NoSuchFieldException e) {
                        this.errors.addWarning(new ScriptException("Unknown field or method: " + call, null, n.getLineno()));
                        return null;
                    }
                }
            }
lbl109:
            // 9 sources

            toReturn = new VariableType(returnType, genericType);
            fb = this.functionBlocksToResolve.pop();
            fb.setReturnType(toReturn);
            this.blockFunctions.put(fb.getStartOffset(), fb);
            while (match.find(decal) && !(firstCall = match.group()).isEmpty()) {
                if (returnType == Void.TYPE) {
                    System.out.println("Void return, impossible to call something else on it. at line:" + n.getLineno());
                }
                idxP1 = firstCall.indexOf(40);
                idxP2 = firstCall.indexOf(41);
                decal += idxP2 + 2;
                argsString = firstCall.substring(idxP1 + 1, idxP2);
                args = argsString.split(",");
                if (argsString.isEmpty()) {
                    clazzes = new Class[]{};
                } else {
                    clazzes = new Class[args.length];
                    i = 0;
                    while (i < clazzes.length) {
                        clazzes[i] = this.resolveClassDeclaration(args[i]);
                        ++i;
                    }
                    lastDot = firstCall.substring(0, idxP1).lastIndexOf(46);
                    if (lastDot < 0) {
                        lastDot = -1;
                    }
                    clazzes = JSScriptingHandlerRhino.getGenericNumberTypes(text, n, returnType, firstCall.substring(lastDot + 1, idxP1), clazzes);
                }
                call2 = firstCall.substring(0, idxP1);
                if (call2.contentEquals("newInstance")) {
                    try {
                        returnType.getConstructor(clazzes);
                    }
                    catch (SecurityException var27_38) {
                    }
                    catch (NoSuchMethodException var27_39) {}
                } else {
                    try {
                        m = JSScriptingHandlerRhino.resolveMethod(returnType, firstCall.substring(0, idxP1), clazzes);
                        genericReturnType = m.getGenericReturnType().toString();
                        if (Pattern.matches("(\\[*)E", genericReturnType) && !genericType.isEmpty()) {
                            try {
                                returnType = ClassUtil.findClass((String)genericType);
                                genericType = "";
                            }
                            catch (ClassNotFoundException var29_44) {}
                        } else {
                            returnType = m.getReturnType();
                            if (returnType.getTypeParameters().length > 0) {
                                genericType = VariableType.getType(m.getGenericReturnType().toString());
                            }
                        }
                    }
                    catch (SecurityException genericReturnType) {
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            f = returnType.getField(call);
                            returnType = f.getType();
                        }
                        catch (SecurityException f) {
                        }
                        catch (NoSuchFieldException e) {
                            return null;
                        }
                    }
                }
                if (this.functionBlocksToResolve.isEmpty()) {
                    return null;
                }
                fb = this.functionBlocksToResolve.pop();
                toReturn = new VariableType(returnType, genericType);
                fb.setReturnType(toReturn);
                this.blockFunctions.put(fb.getStartOffset(), fb);
            }
            return toReturn;
        }
        return null;
    }

    private VariableType resolveCallTypeOld(AstNode n, String text, boolean noerror) {
        VariableType toReturn = null;
        ScriptEngineHandler engineHandler = ScriptEngineHandler.getEngineHandler(this.getEngine());
        int offset = n.getAbsolutePosition();
        String s = this.buildFunction2(n);
        boolean containsNew = s.contains("new ");
        if (containsNew) {
            s = s.substring("new ".length());
        }
        Pattern p = Pattern.compile("\\w(\\w|\\.|\\[|\\])*\\((\\w|\\.|\\[|,|\\]|\\(|\\)| )*\\)");
        Matcher match = p.matcher(s);
        int idxP1 = 0;
        int decal = 0;
        if (match.find(0)) {
            Class[] clazzes;
            Class<?> clazz;
            String firstCall = match.group(0);
            idxP1 = firstCall.indexOf(40);
            int idxP2 = firstCall.indexOf(41);
            decal += idxP2 + 1;
            int lastDot = firstCall.substring(0, idxP1).lastIndexOf(46);
            VariableType vt = null;
            String classNameOrFunctionNameOrVariable = lastDot != -1 ? firstCall.substring(0, lastDot) : (idxP1 != -1 ? firstCall.substring(0, idxP1) : firstCall.substring(0));
            if (classNameOrFunctionNameOrVariable.contains(".")) {
                Class<?> clazz2 = this.resolveClassDeclaration(classNameOrFunctionNameOrVariable);
                if (clazz2 != null) {
                    vt = new VariableType(clazz2);
                } else {
                    String[] res = classNameOrFunctionNameOrVariable.split("\\.");
                    classNameOrFunctionNameOrVariable = res[0];
                    int i = 1;
                    while (i < res.length) {
                        lastDot = classNameOrFunctionNameOrVariable.length() + 1;
                        decal = classNameOrFunctionNameOrVariable.length() + 1;
                        ++i;
                    }
                }
            }
            String argsString = firstCall.substring(idxP1 + 1, idxP2);
            String[] args = argsString.split(",");
            vt = (VariableType)this.localFunctions.get(classNameOrFunctionNameOrVariable);
            if (vt == null) {
                vt = ScriptEngineHandler.getEngineHandler(this.getEngine()).getEngineFunctions().get(classNameOrFunctionNameOrVariable);
                if (classNameOrFunctionNameOrVariable.contentEquals("println") || classNameOrFunctionNameOrVariable.contentEquals("print")) {
                    vt = new VariableType(Void.TYPE);
                }
            }
            if (vt == null) {
                vt = this.getVariableDeclaration(classNameOrFunctionNameOrVariable, offset);
            }
            if (vt == null) {
                vt = engineHandler.getEngineVariables().get(classNameOrFunctionNameOrVariable);
            }
            if (vt == null && (clazz = this.resolveClassDeclaration(classNameOrFunctionNameOrVariable)) != null) {
                vt = new VariableType(clazz);
            }
            if (vt == null) {
                System.out.println("Unknown: " + classNameOrFunctionNameOrVariable + " at line: " + n.getLineno());
                return null;
            }
            if (argsString.isEmpty()) {
                clazzes = new Class[]{};
            } else {
                clazzes = new Class[args.length];
                int i = 0;
                while (i < clazzes.length) {
                    clazzes[i] = this.resolveClassDeclaration(args[i]);
                    ++i;
                }
                clazzes = JSScriptingHandlerRhino.getGenericNumberTypes(text, n, vt.getClazz(), firstCall.substring(lastDot + 1, idxP1), clazzes);
            }
            Class<?> returnType = vt.getClazz();
            String call = decal < idxP1 ? firstCall.substring(lastDot + 1) : firstCall.substring(lastDot + 1, idxP1);
            String genericType = vt.getType();
            if (lastDot != -1) {
                try {
                    Method m = JSScriptingHandlerRhino.resolveMethod(returnType, call, clazzes);
                    String genericReturnType = m.getGenericReturnType().toString();
                    if (Pattern.matches("(\\[*)E", genericReturnType) && !genericType.isEmpty()) {
                        try {
                            returnType = ClassUtil.findClass((String)genericType);
                            genericType = "";
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    } else {
                        returnType = m.getReturnType();
                        if (returnType.getTypeParameters().length > 0) {
                            genericType = VariableType.getType(m.getGenericReturnType().toString());
                        }
                    }
                }
                catch (SecurityException m) {
                }
                catch (NoSuchMethodException e1) {
                    try {
                        Field f = returnType.getField(call);
                        returnType = f.getType();
                    }
                    catch (SecurityException f) {
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
            }
            toReturn = new VariableType(returnType, genericType);
            IcyFunctionBlock fb = this.functionBlocksToResolve.pop();
            fb.setReturnType(toReturn);
            this.blockFunctions.put(fb.getStartOffset(), fb);
            while (match.find(decal) && !(firstCall = match.group()).isEmpty()) {
                if (returnType == Void.TYPE) {
                    System.out.println("Void return, impossible to call something else on it. at line:" + n.getLineno());
                }
                idxP1 = firstCall.indexOf(40);
                idxP2 = firstCall.indexOf(41);
                decal += idxP2 + 2;
                argsString = firstCall.substring(idxP1 + 1, idxP2);
                args = argsString.split(",");
                if (argsString.isEmpty()) {
                    clazzes = new Class[]{};
                } else {
                    clazzes = new Class[args.length];
                    int i = 0;
                    while (i < clazzes.length) {
                        clazzes[i] = this.resolveClassDeclaration(args[i]);
                        ++i;
                    }
                    lastDot = firstCall.substring(0, idxP1).lastIndexOf(46);
                    if (lastDot < 0) {
                        lastDot = -1;
                    }
                    clazzes = JSScriptingHandlerRhino.getGenericNumberTypes(text, n, returnType, firstCall.substring(lastDot + 1, idxP1), clazzes);
                }
                String call2 = firstCall.substring(0, idxP1);
                if (call2.contentEquals("newInstance")) {
                    try {
                        returnType.getConstructor(clazzes);
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                } else {
                    try {
                        Method m = JSScriptingHandlerRhino.resolveMethod(returnType, firstCall.substring(0, idxP1), clazzes);
                        String genericReturnType = m.getGenericReturnType().toString();
                        if (Pattern.matches("(\\[*)E", genericReturnType) && !genericType.isEmpty()) {
                            try {
                                returnType = ClassUtil.findClass((String)genericType);
                                genericType = "";
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        } else {
                            returnType = m.getReturnType();
                            if (returnType.getTypeParameters().length > 0) {
                                genericType = VariableType.getType(m.getGenericReturnType().toString());
                            }
                        }
                    }
                    catch (SecurityException genericReturnType) {
                    }
                    catch (NoSuchMethodException e1) {
                        try {
                            Field f = returnType.getField(call);
                            returnType = f.getType();
                        }
                        catch (SecurityException f) {
                        }
                        catch (NoSuchFieldException e) {
                            return null;
                        }
                    }
                }
                fb = this.functionBlocksToResolve.pop();
                toReturn = new VariableType(returnType, genericType);
                fb.setReturnType(toReturn);
                this.blockFunctions.put(fb.getStartOffset(), fb);
            }
            return toReturn;
        }
        return null;
    }

    private static Class<?>[] getGenericNumberTypes(String text, AstNode n, Class<?> clazz, String function, Class<?>[] argsClazzes) {
        Class[] toReturn = new Class[argsClazzes.length];
        int offset = n.getAbsolutePosition();
        String fullCommand = text.substring(offset, offset + n.getLength());
        int idxStart = fullCommand.indexOf(function);
        if (idxStart == -1) {
            return argsClazzes;
        }
        int idxP1 = fullCommand.indexOf(40, idxStart);
        int idxP2 = fullCommand.indexOf(41, idxStart);
        if (idxP1 == -1 || idxP2 == -1) {
            return argsClazzes;
        }
        String argumentsChained = fullCommand.substring(idxP1 + 1, idxP2);
        String[] args = argumentsChained.split(",");
        if (args.length != argsClazzes.length) {
            return argsClazzes;
        }
        boolean hasNumber = false;
        int i = 0;
        while (i < argsClazzes.length) {
            if (argsClazzes[i] == Number.class) {
                hasNumber = true;
            }
            toReturn[i] = argsClazzes[i];
            ++i;
        }
        if (hasNumber) {
            Method[] methodArray = clazz.getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Class<?>[] params;
                Method m = methodArray[n3];
                if (m.getName().contentEquals(function) && (params = m.getParameterTypes()).length == argsClazzes.length) {
                    int i2 = 0;
                    while (i2 < params.length) {
                        if (params[i2] == null || argsClazzes[i2] == null) break;
                        if (params[i2].isAssignableFrom(argsClazzes[i2])) {
                            toReturn[i2] = params[i2];
                        } else {
                            if (!params[i2].isPrimitive()) break;
                            if (params[i2] != Float.TYPE && params[i2] != Double.TYPE && !args[i2].contains(".")) {
                                toReturn[i2] = params[i2];
                            } else {
                                if (params[i2] != Float.TYPE && params[i2] != Double.TYPE) break;
                                toReturn[i2] = params[i2];
                            }
                        }
                        ++i2;
                    }
                }
                ++n3;
            }
            return toReturn;
        }
        return toReturn;
    }

    private Class<?> resolveArrayItemTypeComponent(AstNode node) {
        int type = node.getType();
        if (type == 39) {
            String varname = node.getString();
            VariableType clazz = this.getVariableDeclaration(varname, node.getAbsolutePosition());
            return clazz == null ? null : clazz.getClazz();
        }
        if (type == 36) {
            return this.resolveArrayItemTypeComponent(((ElementGet)node).getTarget());
        }
        return null;
    }

    private Class<?> createArrayItemType(Class<?> clazz, AstNode node) {
        int type = node.getType();
        if (type == 36) {
            return this.createArrayItemType(clazz.getComponentType(), ((ElementGet)node).getTarget());
        }
        if (type == 39) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    protected void addVariableDeclaration(String name, VariableType type, int offset) {
        ScriptVariable vc = (ScriptVariable)this.localVariables.get(name);
        if (vc == null) {
            vc = new ScriptVariable();
            this.localVariables.put(name, vc);
        }
        vc.addType(offset, type);
    }

    protected void addVariableDeclaration(String name, VariableType type, int offsetBegin, int offsetEnd) {
        ScriptVariable vc = (ScriptVariable)this.localVariables.get(name);
        if (vc == null) {
            vc = new ScriptVariable();
            this.localVariables.put(name, vc);
        }
        vc.addType(offsetBegin, offsetEnd, type);
    }

    @Override
    public Class<?> resolveClassDeclaration(String type) {
        Class<?> toReturn = null;
        int arraySize = 0;
        while (type.endsWith("[]")) {
            type = type.substring(0, type.length() - 2);
            ++arraySize;
        }
        if (type.contentEquals("Array")) {
            return NativeArray.class;
        }
        if (type.contentEquals("String")) {
            return String.class;
        }
        try {
            if (type.startsWith("Packages.")) {
                type = type.substring("Packages.".length());
            }
            toReturn = ClassUtil.findClass((String)type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (toReturn == null) {
            toReturn = super.resolveClassDeclaration(type);
        }
        if (toReturn == null) {
            toReturn = this.getNativeJSTypes(type);
        }
        while (toReturn != null && arraySize > 0) {
            toReturn = Array.newInstance(toReturn, 1).getClass();
            --arraySize;
        }
        return toReturn;
    }

    private Class<?> getNativeJSTypes(String type) {
        if (type.contentEquals("Math")) {
            return Math.class;
        }
        if (type.contentEquals("File")) {
            return File.class;
        }
        if (type.contentEquals("String")) {
            return String.class;
        }
        return null;
    }

    private String generateClassName(Node n, String toReturn) {
        if (n != null) {
            if (n.getType() == 33) {
                String left = this.generateClassName((Node)((PropertyGet)n).getLeft(), toReturn);
                String right = this.generateClassName((Node)((PropertyGet)n).getRight(), toReturn);
                toReturn = String.valueOf(toReturn) + left + (left.contentEquals("") ? "" : ".") + right;
            } else {
                if (n.getType() == 39) {
                    return n.getString();
                }
                if (n.getType() == 36) {
                    return this.generateClassName((Node)((ElementGet)n).getTarget(), toReturn);
                }
            }
        }
        return toReturn;
    }

    public int getTextAreaOffset(String text, int offset) throws BadLocationException {
        if (this.textArea instanceof JTextArea) {
            JTextArea txtTmp = new JTextArea(text);
            int line = txtTmp.getLineOfOffset(offset);
            int offsetFromLine = offset - txtTmp.getLineStartOffset(line);
            return ((JTextArea)this.textArea).getLineStartOffset(line) + offsetFromLine;
        }
        return offset;
    }

    private void dumpTree(Node n, AstRoot root, int commandIdx, String decal) {
        if (n == null) {
            return;
        }
        System.out.print(String.valueOf(commandIdx) + ": " + decal + this.typeToName(n.getType()));
        switch (n.getType()) {
            case 134: {
                int level;
                System.out.println();
                AstNode expression = ((ExpressionStatement)n).getExpression();
                if (expression instanceof Assignment) {
                    AstNode left = ((Assignment)expression).getLeft();
                    AstNode right = ((Assignment)expression).getRight();
                    System.out.println("");
                    level = commandIdx + 1;
                    this.dumpTree((Node)left, root, level, "-" + decal);
                    this.dumpTree((Node)right, root, level, "-" + decal);
                    break;
                }
                if (!(expression instanceof FunctionCall)) break;
                List args = ((FunctionCall)expression).getArguments();
                this.dumpTree((Node)((FunctionCall)expression).getTarget(), root, commandIdx, "-" + decal);
                for (AstNode arg : args) {
                    this.dumpTree((Node)arg, root, commandIdx, "-" + decal);
                }
                break;
            }
            case 33: {
                AstNode propLeft = ((PropertyGet)n).getLeft();
                AstNode propRight = ((PropertyGet)n).getRight();
                System.out.println(":");
                int level = commandIdx + 1;
                this.dumpTree((Node)propLeft, root, level, "-" + decal);
                this.dumpTree((Node)propRight, root, level, "-" + decal);
                break;
            }
            case 41: 
            case 49: {
                StringLiteral str = (StringLiteral)n;
                System.out.println(": " + str.getValue());
                break;
            }
            case 39: {
                System.out.println(": " + n.getString());
                break;
            }
            case 40: {
                System.out.println(": " + n.getDouble());
                break;
            }
            case 38: {
                System.out.println();
                int level = commandIdx + 1;
                FunctionCall fn = (FunctionCall)n;
                for (AstNode arg : fn.getArguments()) {
                    this.dumpTree((Node)arg, root, level, decal);
                }
                this.dumpTree((Node)fn.getTarget(), root, level, "-" + decal);
                break;
            }
            case 109: {
                FunctionNode fn2 = (FunctionNode)n;
                System.out.print(" " + fn2.getName());
                this.dumpTree((Node)fn2.getBody(), root, commandIdx + 1, "-" + decal);
                break;
            }
            case 112: {
                System.out.println();
                IfStatement nIf = (IfStatement)n;
                int level = commandIdx + 1;
                this.dumpTree((Node)nIf.getThenPart(), root, level, "-" + decal);
                this.dumpTree((Node)nIf.getElsePart(), root, level, "-" + decal);
                break;
            }
            case 129: {
                Node child;
                Block scope;
                int level;
                System.out.println();
                if (n instanceof Block) {
                    scope = (Block)n;
                    child = scope.getFirstChild();
                    level = commandIdx + 1;
                    while (child != null) {
                        this.dumpTree(child, root, level, "-" + decal);
                        child = child.getNext();
                    }
                } else {
                    if (!(n instanceof Scope)) break;
                    scope = (Scope)n;
                    child = scope.getFirstChild();
                    level = commandIdx + 1;
                    while (child != null) {
                        this.dumpTree(child, root, level, "-" + decal);
                        child = child.getNext();
                    }
                }
                break;
            }
            case 36: {
                System.out.println();
                int level = commandIdx + 1;
                ElementGet get = (ElementGet)n;
                this.dumpTree((Node)get.getElement(), root, level, "-" + decal);
                this.dumpTree((Node)get.getTarget(), root, level, "-" + decal);
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                int level = commandIdx + 1;
                this.dumpTree((Node)((Loop)n).getBody(), root, commandIdx + 1, "-" + decal);
                break;
            }
            case 114: {
                int level = commandIdx + 1;
                for (SwitchCase c : ((SwitchStatement)n).getCases()) {
                    for (AstNode statement : c.getStatements()) {
                        this.dumpTree((Node)statement, root, commandIdx + 1, decal);
                    }
                }
                break;
            }
            default: {
                System.out.println();
            }
        }
        if (n.hasChildren()) {
            Node child = n.getFirstChild();
            while (child != null) {
                this.dumpTree(child, root, commandIdx, "-" + decal);
                child = child.getNext();
                if (n != root) continue;
                ++commandIdx;
                System.out.println();
            }
        }
    }

    private String buildFunction2(AstNode n) {
        String callName = "";
        if (!(callName = this.buildFunctionRecursive(callName, n)).isEmpty()) {
            if (callName.startsWith(".")) {
                callName = callName.substring(1);
            }
            if (callName.startsWith("Packages.") || callName.startsWith("packages.")) {
                callName = callName.substring("Packages.".length());
            }
        }
        return callName;
    }

    private String buildFunctionRecursive(String elem, AstNode n) {
        if (n != null) {
            Class<?> clazz;
            int type = n.getType();
            if (type == 33) {
                AstNode propLeft = ((PropertyGet)n).getLeft();
                AstNode propRight = ((PropertyGet)n).getRight();
                String left = this.buildFunctionRecursive(elem, propLeft);
                String right = this.buildFunctionRecursive(elem, propRight);
                return String.valueOf(left) + right + elem;
            }
            if (type == 38) {
                String toReturn;
                FunctionCall fn = (FunctionCall)n;
                String args = "";
                args = String.valueOf(args) + "(";
                int i = 0;
                for (AstNode arg : fn.getArguments()) {
                    VariableType typeC;
                    if (i != 0) {
                        args = String.valueOf(args) + ",";
                    }
                    args = (typeC = this.getRealType(arg)) != null && typeC.getClazz() != null ? String.valueOf(args) + typeC.getClazz().getName() : String.valueOf(args) + "unknown";
                    ++i;
                }
                args = String.valueOf(args) + ")";
                String functionName = "";
                AstNode target = fn.getTarget();
                int targetType = target.getType();
                if (targetType == 39) {
                    functionName = target.getString();
                    toReturn = String.valueOf(functionName) + args;
                } else if (targetType == 33) {
                    functionName = ((PropertyGet)target).getRight().getString();
                    toReturn = String.valueOf(this.buildFunctionRecursive(elem, ((PropertyGet)target).getLeft())) + "." + functionName + args;
                } else if (targetType == 36) {
                    ElementGet get = (ElementGet)target;
                    elem = this.buildFunctionRecursive("", get.getElement());
                    functionName = elem.substring(0, elem.indexOf(40));
                    String targetName = this.buildFunctionRecursive("", get.getTarget());
                    toReturn = String.valueOf(targetName) + "." + elem;
                } else {
                    toReturn = elem;
                }
                int rp = fn.getRp();
                if (rp != -1) {
                    rp = n.getAbsolutePosition() + rp + 1;
                    IcyFunctionBlock fb = new IcyFunctionBlock(functionName, rp, null);
                    this.functionBlocksToResolve.add(fb);
                }
                return toReturn;
            }
            if (type == 39) {
                return "." + n.getString();
            }
            if (type == 40) {
                return Number.class.getName();
            }
            if (type == 41) {
                return ((StringLiteral)n).getValue();
            }
            if (type == 36 && (clazz = this.resolveArrayItemTypeComponent(n)) != null) {
                return clazz.getCanonicalName();
            }
        }
        return elem;
    }

    private VariableType getRealType(AstNode n) {
        if (n == null) {
            return null;
        }
        switch (n.getType()) {
            case 21: {
                InfixExpression expr = (InfixExpression)n;
                VariableType typeLeft = this.getRealType(expr.getLeft());
                VariableType typeRight = this.getRealType(expr.getRight());
                if (typeLeft != null && typeLeft.getClazz() == String.class || typeRight != null && typeRight.getClazz() == String.class) {
                    return new VariableType(String.class);
                }
            }
            case 22: 
            case 23: 
            case 24: 
            case 40: {
                return new VariableType(Number.class);
            }
            case 41: {
                return new VariableType(String.class);
            }
            case 44: 
            case 45: {
                return new VariableType(Boolean.TYPE);
            }
            case 39: {
                return this.getVariableDeclaration(n.getString(), n.getAbsolutePosition());
            }
            case 38: {
                VariableType vt = this.resolveCallType(n, this.currentText, false);
                if (vt == null) {
                    this.updateGutter();
                }
                return vt;
            }
            case 109: {
                return new VariableType(Void.class);
            }
            case 33: {
                AstNode target = ((PropertyGet)n).getTarget();
                if (target.getType() == 36) {
                    String rightStr = this.generateClassName((Node)n, "");
                    if (!rightStr.contentEquals("length")) break;
                    return new VariableType(Integer.TYPE);
                }
                String className = this.generateClassName((Node)n, "");
                Class<?> clazz = this.resolveClassDeclaration(className);
                if (clazz != null) {
                    return new VariableType(clazz);
                }
                int idx = className.lastIndexOf(46);
                if (idx == -1) break;
                clazz = this.resolveClassDeclaration(className.substring(0, idx));
                return clazz == null ? null : new VariableType(clazz);
            }
            case 65: {
                return new VariableType(Object[].class);
            }
            case 30: {
                NewExpression nexp = (NewExpression)n;
                AstNode target = nexp.getTarget();
                if (target != null) {
                    String className = this.generateClassName((Node)target, "");
                    Class<?> clazz = this.resolveClassDeclaration(className);
                    return clazz == null ? null : new VariableType(clazz);
                }
            }
            case 36: {
                ElementGet get = (ElementGet)n;
                AstNode target = get.getTarget();
                Class<?> clazz = this.resolveArrayItemTypeComponent(target);
                if (clazz != null) {
                    clazz = this.createArrayItemType(clazz, target);
                }
                return clazz == null ? null : new VariableType(clazz);
            }
        }
        return null;
    }

    private String typeToName(int token) {
        switch (token) {
            case 0: {
                return "EOF";
            }
            case 1: {
                return "EOL";
            }
            case 2: {
                return "ENTERWITH";
            }
            case 3: {
                return "LEAVEWITH";
            }
            case 4: {
                return "RETURN";
            }
            case 5: {
                return "GOTO";
            }
            case 6: {
                return "IFEQ";
            }
            case 7: {
                return "IFNE";
            }
            case 8: {
                return "SETNAME";
            }
            case 9: {
                return "BITOR";
            }
            case 10: {
                return "BITXOR";
            }
            case 11: {
                return "BITAND";
            }
            case 12: {
                return "EQ";
            }
            case 13: {
                return "NE";
            }
            case 14: {
                return "LT";
            }
            case 15: {
                return "LE";
            }
            case 16: {
                return "GT";
            }
            case 17: {
                return "GE";
            }
            case 18: {
                return "LSH";
            }
            case 19: {
                return "RSH";
            }
            case 20: {
                return "URSH";
            }
            case 21: {
                return "ADD";
            }
            case 22: {
                return "SUB";
            }
            case 23: {
                return "MUL";
            }
            case 24: {
                return "DIV";
            }
            case 25: {
                return "MOD";
            }
            case 26: {
                return "NOT";
            }
            case 27: {
                return "BITNOT";
            }
            case 28: {
                return "POS";
            }
            case 29: {
                return "NEG";
            }
            case 30: {
                return "NEW";
            }
            case 31: {
                return "DELPROP";
            }
            case 32: {
                return "TYPEOF";
            }
            case 33: {
                return "GETPROP";
            }
            case 35: {
                return "SETPROP";
            }
            case 36: {
                return "GETELEM";
            }
            case 37: {
                return "SETELEM";
            }
            case 38: {
                return "CALL";
            }
            case 39: {
                return "NAME";
            }
            case 40: {
                return "NUMBER";
            }
            case 41: {
                return "STRING";
            }
            case 42: {
                return "NULL";
            }
            case 43: {
                return "THIS";
            }
            case 44: {
                return "FALSE";
            }
            case 45: {
                return "TRUE";
            }
            case 46: {
                return "SHEQ";
            }
            case 47: {
                return "SHNE";
            }
            case 48: {
                return "REGEXP";
            }
            case 49: {
                return "BINDNAME";
            }
            case 50: {
                return "THROW";
            }
            case 51: {
                return "RETHROW";
            }
            case 52: {
                return "IN";
            }
            case 53: {
                return "INSTANCEOF";
            }
            case 54: {
                return "LOCAL_LOAD";
            }
            case 55: {
                return "GETVAR";
            }
            case 56: {
                return "SETVAR";
            }
            case 57: {
                return "CATCH_SCOPE";
            }
            case 58: {
                return "ENUM_INIT_KEYS";
            }
            case 59: {
                return "ENUM_INIT_VALUES";
            }
            case 61: {
                return "ENUM_NEXT";
            }
            case 62: {
                return "ENUM_ID";
            }
            case 63: {
                return "THISFN";
            }
            case 64: {
                return "RETURN_RESULT";
            }
            case 65: {
                return "ARRAYLIT";
            }
            case 66: {
                return "OBJECTLIT";
            }
            case 67: {
                return "GET_REF";
            }
            case 68: {
                return "SET_REF";
            }
            case 69: {
                return "DEL_REF";
            }
            case 70: {
                return "REF_CALL";
            }
            case 71: {
                return "REF_SPECIAL";
            }
            case 74: {
                return "DEFAULTNAMESPACE";
            }
            case 76: {
                return "ESCXMLTEXT";
            }
            case 75: {
                return "ESCXMLATTR";
            }
            case 77: {
                return "REF_MEMBER";
            }
            case 78: {
                return "REF_NS_MEMBER";
            }
            case 79: {
                return "REF_NAME";
            }
            case 80: {
                return "REF_NS_NAME";
            }
            case 81: {
                return "TRY";
            }
            case 82: {
                return "SEMI";
            }
            case 83: {
                return "LB";
            }
            case 84: {
                return "RB";
            }
            case 85: {
                return "LC";
            }
            case 86: {
                return "RC";
            }
            case 87: {
                return "LP";
            }
            case 88: {
                return "RP";
            }
            case 89: {
                return "COMMA";
            }
            case 90: {
                return "ASSIGN";
            }
            case 91: {
                return "ASSIGN_BITOR";
            }
            case 92: {
                return "ASSIGN_BITXOR";
            }
            case 93: {
                return "ASSIGN_BITAND";
            }
            case 94: {
                return "ASSIGN_LSH";
            }
            case 95: {
                return "ASSIGN_RSH";
            }
            case 96: {
                return "ASSIGN_URSH";
            }
            case 97: {
                return "ASSIGN_ADD";
            }
            case 98: {
                return "ASSIGN_SUB";
            }
            case 99: {
                return "ASSIGN_MUL";
            }
            case 100: {
                return "ASSIGN_DIV";
            }
            case 101: {
                return "ASSIGN_MOD";
            }
            case 102: {
                return "HOOK";
            }
            case 103: {
                return "COLON";
            }
            case 104: {
                return "OR";
            }
            case 105: {
                return "AND";
            }
            case 106: {
                return "INC";
            }
            case 107: {
                return "DEC";
            }
            case 108: {
                return "DOT";
            }
            case 109: {
                return "FUNCTION";
            }
            case 110: {
                return "EXPORT";
            }
            case 111: {
                return "IMPORT";
            }
            case 112: {
                return "IF";
            }
            case 113: {
                return "ELSE";
            }
            case 114: {
                return "SWITCH";
            }
            case 115: {
                return "CASE";
            }
            case 116: {
                return "DEFAULT";
            }
            case 117: {
                return "WHILE";
            }
            case 118: {
                return "DO";
            }
            case 119: {
                return "FOR";
            }
            case 120: {
                return "BREAK";
            }
            case 121: {
                return "CONTINUE";
            }
            case 122: {
                return "VAR";
            }
            case 123: {
                return "WITH";
            }
            case 124: {
                return "CATCH";
            }
            case 125: {
                return "FINALLY";
            }
            case 126: {
                return "VOID";
            }
            case 127: {
                return "RESERVED";
            }
            case 128: {
                return "EMPTY";
            }
            case 129: {
                return "BLOCK";
            }
            case 130: {
                return "LABEL";
            }
            case 131: {
                return "TARGET";
            }
            case 132: {
                return "LOOP";
            }
            case 133: {
                return "EXPR_VOID";
            }
            case 134: {
                return "EXPR_RESULT";
            }
            case 135: {
                return "JSR";
            }
            case 136: {
                return "SCRIPT";
            }
            case 137: {
                return "TYPEOFNAME";
            }
            case 138: {
                return "USE_STACK";
            }
            case 139: {
                return "SETPROP_OP";
            }
            case 140: {
                return "SETELEM_OP";
            }
            case 141: {
                return "LOCAL_BLOCK";
            }
            case 142: {
                return "SET_REF_OP";
            }
            case 143: {
                return "DOTDOT";
            }
            case 144: {
                return "COLONCOLON";
            }
            case 145: {
                return "XML";
            }
            case 146: {
                return "DOTQUERY";
            }
            case 147: {
                return "XMLATTR";
            }
            case 148: {
                return "XMLEND";
            }
            case 149: {
                return "TO_OBJECT";
            }
            case 150: {
                return "TO_DOUBLE";
            }
        }
        throw new IllegalStateException(String.valueOf(token));
    }

    public static String keywordToName(int token) {
        switch (token) {
            case 120: {
                return "break";
            }
            case 115: {
                return "case";
            }
            case 121: {
                return "continue";
            }
            case 116: {
                return "default";
            }
            case 31: {
                return "delete";
            }
            case 118: {
                return "do";
            }
            case 113: {
                return "else";
            }
            case 44: {
                return "false";
            }
            case 119: {
                return "for";
            }
            case 109: {
                return "function";
            }
            case 112: {
                return "if";
            }
            case 52: {
                return "in";
            }
            case 30: {
                return "new";
            }
            case 42: {
                return "null";
            }
            case 4: {
                return "return";
            }
            case 114: {
                return "switch";
            }
            case 43: {
                return "this";
            }
            case 45: {
                return "true";
            }
            case 32: {
                return "typeof";
            }
            case 122: {
                return "var";
            }
            case 126: {
                return "void";
            }
            case 117: {
                return "while";
            }
            case 123: {
                return "with";
            }
            case 124: {
                return "catch";
            }
            case 125: {
                return "finally";
            }
            case 53: {
                return "instanceof";
            }
            case 50: {
                return "throw";
            }
            case 81: {
                return "try";
            }
        }
        return null;
    }

    @Override
    public void format() {
        InputStream is = PluginLoader.getResourceAsStream((String)"plugins/tprovoost/scripteditor/resources/beautify/beautify.js");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Context context = Context.enter();
        context.setLanguageVersion(160);
        ScriptableObject scope = context.initStandardObjects();
        try {
            context.evaluateReader((Scriptable)scope, (Reader)reader, "Beautify", 1, null);
        }
        catch (IOException e) {
            return;
        }
        Function fct = (Function)scope.get("js_beautify", (Scriptable)scope);
        boolean preserveNewLines = true;
        boolean useTabs = true;
        boolean spaceBeforeConditional = true;
        boolean jslintHappy = false;
        boolean indentCase = false;
        boolean indentSize = true;
        String braceStyle = "collapse";
        NativeObject properties = new NativeObject();
        if (useTabs) {
            properties.defineProperty("indent_char", (Object)"\t", 1);
            properties.defineProperty("indent_size", (Object)1, 1);
        } else {
            int size = 4;
            size = !indentSize ? 2 : (indentSize ? 4 : 8);
            properties.defineProperty("indent_size", (Object)size, 1);
        }
        properties.defineProperty("preserve_newlines", (Object)preserveNewLines, 1);
        properties.defineProperty("max_preserve_newlines", (Object)false, 1);
        properties.defineProperty("jslint_happy", (Object)jslintHappy, 1);
        properties.defineProperty("space_before_conditional", (Object)spaceBeforeConditional, 1);
        properties.defineProperty("indent_case", (Object)indentCase, 1);
        properties.defineProperty("brace_style", (Object)braceStyle, 1);
        Object result = fct.call(context, (Scriptable)scope, (Scriptable)scope, new Object[]{this.textArea.getText(), properties});
        String finalText = result.toString();
        int caretPos = this.textArea.getCaretPosition();
        this.textArea.setText(finalText);
        if (caretPos > 0 && caretPos < finalText.length()) {
            this.textArea.setCaretPosition(caretPos);
        }
    }

    @Override
    public ScriptEngine getEngine() {
        return ScriptEngineHandler.getEngine("javascript");
    }

    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offs) {
        return null;
    }

    @Override
    public void autoImport() {
        try {
            this.detectVariables(this.currentText);
        }
        catch (ScriptException e) {
            this.errors.setRuntimeError(e);
        }
    }

    class Reporter
    implements ErrorReporter {
        Reporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            ScriptException se = new ScriptException(message, sourceName, line, lineOffset);
            JSScriptingHandlerRhino.this.errors.addWarning(se);
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            ScriptException se = new ScriptException(message, sourceName, line, lineOffset);
            JSScriptingHandlerRhino.this.errors.addError(se);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.out.println("runtimeError " + message + " " + sourceName + " " + line + " " + lineSource + " " + lineOffset);
            ScriptException se = new ScriptException(message, sourceName, line, lineOffset);
            JSScriptingHandlerRhino.this.errors.addError(se);
            return null;
        }
    }
}

