/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.uitools.filedialogs;

import icy.file.FileUtil;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileDialog {
    public static File open() {
        return FileDialog.open(null);
    }

    public static File open(String currentDirectory) {
        return FileDialog.open(currentDirectory, "", new String[0]);
    }

    public static File open(String currentDirectory, String filterDesc, String ... ext) {
        FileDialogAWT fcawt = new FileDialogAWT(false, currentDirectory, filterDesc, ext);
        while (!fcawt.isReady()) {
            ThreadUtil.sleep((int)100);
        }
        JFileChooser fc = fcawt.fc;
        int res = fcawt.result;
        if (res == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File openFolder() {
        return FileDialog.openFolder("");
    }

    public static File openFolder(String currentDirectory) {
        FileDialogAWT fcawt = new FileDialogAWT(false, currentDirectory, "", new String[0]);
        fcawt.setFolderOnly(true);
        while (!fcawt.isReady()) {
            ThreadUtil.sleep((int)100);
        }
        JFileChooser fc = fcawt.fc;
        int res = fcawt.result;
        if (res == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File[] openMulti() {
        return FileDialog.openMulti(null);
    }

    public static File[] openMulti(String currentDirectory) {
        return FileDialog.openMulti(currentDirectory, "", new String[0]);
    }

    public static File[] openMulti(String currentDirectory, String filterDesc, String ... ext) {
        FileDialogAWT fcawt = new FileDialogAWT(false, true, currentDirectory, filterDesc, ext);
        while (!fcawt.isReady()) {
            ThreadUtil.sleep((int)100);
        }
        JFileChooser fc = fcawt.fc;
        int res = fcawt.result;
        if (res == 0) {
            return fc.getSelectedFiles();
        }
        return null;
    }

    public static File save() {
        return FileDialog.save(null);
    }

    public static File save(String currentDirectory) {
        return FileDialog.save(currentDirectory, "", new String[0]);
    }

    public static File save(String currentDirectory, String filterDesc, String ... ext) {
        FileDialogAWT fcawt = new FileDialogAWT(true, currentDirectory, filterDesc, ext);
        while (!fcawt.isReady()) {
            ThreadUtil.sleep((int)100);
        }
        JFileChooser fc = fcawt.fc;
        int res = fcawt.result;
        if (res == 0) {
            String s = fc.getSelectedFile().getAbsolutePath();
            if (FileUtil.getFileExtension((String)s, (boolean)false).isEmpty() && ext != null && ext.length > 0) {
                new File(String.valueOf(s) + "." + ext[0]);
            } else {
                return fc.getSelectedFile();
            }
        }
        return null;
    }

    public static File saveFolder() {
        return FileDialog.saveFolder(null);
    }

    public static File saveFolder(String currentDirectory) {
        FileDialogAWT fcawt = new FileDialogAWT(true, currentDirectory, "", new String[0]);
        fcawt.setFolderOnly(true);
        while (!fcawt.isReady()) {
            ThreadUtil.sleep((int)100);
        }
        JFileChooser fc = fcawt.fc;
        int res = fcawt.result;
        if (res == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    private static class FileDialogAWT {
        private JFileChooser fc;
        private int result;
        private boolean ready;
        private boolean folderOnly = false;

        public FileDialogAWT(boolean save, String currentDirectory, String filterDesc, String ... ext) {
            this(save, false, currentDirectory, filterDesc, ext);
        }

        public void setFolderOnly(boolean folderOnly) {
            this.folderOnly = folderOnly;
        }

        public FileDialogAWT(final boolean save, final boolean multi, final String currentDirectory, final String filterDesc, final String[] ext) {
            this.setReady(false);
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    fc = new JFileChooser(currentDirectory);
                    if (folderOnly) {
                        fc.setFileSelectionMode(1);
                    } else {
                        if (ext != null && ext.length > 0) {
                            fc.setFileFilter(new FileNameExtensionFilter(filterDesc, ext));
                        }
                        fc.setMultiSelectionEnabled(multi);
                    }
                    if (save) {
                        result = fc.showSaveDialog((Component)Icy.getMainInterface().getMainFrame());
                    } else {
                        result = fc.showOpenDialog((Component)Icy.getMainInterface().getMainFrame());
                    }
                    this.setReady(true);
                }
            });
        }

        private boolean isReady() {
            return this.ready;
        }

        private void setReady(boolean ready) {
            this.ready = ready;
        }
    }
}

