/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.block;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.protocols.gui.block.WorkFlowPanel;
import plugins.adufour.protocols.gui.link.DragDropZone;
import plugins.adufour.protocols.gui.link.DragZone;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;

public class LoopPanel
extends WorkFlowPanel {
    private final Loop loop;
    private final JPanel innerLoopPanel;
    protected final JCheckBox menuStopOnFirstError = new JCheckBox("Stop on first error");

    public LoopPanel(WorkFlowContainer wfPane, BlockDescriptor blockInfo) {
        super(wfPane, blockInfo);
        this.loop = (Loop)this.blockDesc.getBlock();
        this.innerLoopPanel = new JPanel(new GridBagLayout()){

            @Override
            public void paintChildren(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                Point2D p1 = LoopPanel.this.gradient.getPoint1();
                p1.setLocation(p1.getX() + 1.0, p1.getY() - 30.0);
                g2.setPaint(new GradientPaint(p1, LoopPanel.this.gradient.getColor1(), LoopPanel.this.gradient.getPoint2(), LoopPanel.this.gradient.getColor2()));
                g2.fillRect(5, 0, this.getWidth() - 11, this.getHeight());
                g2.setPaint(null);
                g2.setColor(Color.gray);
                g2.drawLine(15, this.getHeight() - 1, this.getWidth() - 6, this.getHeight() - 1);
                g2.drawLine(this.getWidth() - 6, 0, this.getWidth() - 6, this.getHeight());
                super.paintChildren(g2);
            }
        };
        this.innerLoopPanel.setOpaque(false);
        this.innerLoopPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 2));
        this.menuStopOnFirstError.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuStopOnFirstError) {
            this.loop.stopOnFirstError.setValue((Object)this.menuStopOnFirstError.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void drawMenu() {
        super.drawMenu();
        this.menu.add(this.menuStopOnFirstError);
    }

    @Override
    protected void drawContent() {
        this.innerLoopPanel.removeAll();
        int nextRow = 0;
        if (this.blockDesc.getBlock() instanceof Batch) {
            nextRow = this.drawBatchVariables(nextRow);
        }
        for (Var<?> loopVariable : this.loop.getLoopVariables()) {
            Batch batch;
            if (this.blockDesc.getBlock() instanceof Batch && (loopVariable == (batch = (Batch)this.blockDesc.getBlock()).getBatchSource() || loopVariable == batch.getBatchElement())) continue;
            nextRow = this.drawLoopVariable(nextRow, loopVariable);
        }
        GridBagConstraints gbc_loop = new GridBagConstraints();
        gbc_loop.anchor = 18;
        this.jPanelContent.add((Component)this.innerLoopPanel, gbc_loop);
        nextRow = this.drawExposedLinks(nextRow);
        this.drawInnerWorkFlowContainer(nextRow + 1);
    }

    private int drawBatchVariables(int row) {
        Var<?> batchElement;
        Batch batch = (Batch)this.blockDesc.getBlock();
        Var<?> batchSource = batch.getBatchSource();
        if (!this.varDropZones.containsKey(batchSource)) {
            this.varDropZones.put(batchSource, this.createVarDropZone(batchSource, true, DragDropZone.LINK_RIGHT));
        }
        if (!this.varEditors.containsKey(batchSource)) {
            this.varEditors.put(batchSource, this.createVarEditor(batchSource));
        }
        if (!this.varDragZones.containsKey(batchElement = batch.getBatchElement())) {
            this.varDragZones.put(batchElement, this.createVarDragZone(batchElement, false));
        }
        GridBagConstraints gbc_dropZone = new GridBagConstraints();
        gbc_dropZone.anchor = 17;
        gbc_dropZone.fill = 0;
        gbc_dropZone.insets = new Insets(2, 0, 0, 0);
        gbc_dropZone.gridx = 0;
        gbc_dropZone.gridy = row;
        this.innerLoopPanel.add((Component)this.varDropZones.get(batchSource), gbc_dropZone);
        GridBagConstraints gbc_inputName = new GridBagConstraints();
        gbc_inputName.anchor = 10;
        gbc_inputName.fill = 2;
        gbc_inputName.insets = new Insets(2, 5, 0, 0);
        gbc_inputName.gridx = 1;
        gbc_inputName.gridy = row;
        gbc_inputName.weightx = 1.0;
        JLabel inputName = new JLabel(batchSource.getName());
        Dimension inputNameDim = inputName.getPreferredSize();
        inputNameDim.height = 20;
        inputName.setPreferredSize(inputNameDim);
        this.innerLoopPanel.add((Component)inputName, gbc_inputName);
        GridBagConstraints gbc_inputComponent = new GridBagConstraints();
        gbc_inputComponent.anchor = 10;
        gbc_inputComponent.fill = 2;
        gbc_inputComponent.insets = new Insets(2, 5, 0, 0);
        gbc_inputComponent.gridx = 2;
        gbc_inputComponent.gridy = row;
        gbc_inputComponent.weightx = 1.0;
        JComponent inputEditor = (JComponent)((VarEditor)this.varEditors.get(batchSource)).getEditorComponent();
        inputEditor.setOpaque(false);
        inputEditor.setFocusable(false);
        inputEditor.setPreferredSize(((VarEditor)this.varEditors.get(batchSource)).getPreferredSize());
        this.innerLoopPanel.add((Component)inputEditor, gbc_inputComponent);
        GridBagConstraints gbc_dragZone = new GridBagConstraints();
        gbc_dragZone.anchor = 13;
        gbc_dragZone.fill = 0;
        gbc_dragZone.insets = new Insets(2, 5, 0, 0);
        gbc_dragZone.gridx = 3;
        gbc_dragZone.gridy = row;
        this.innerLoopPanel.add((Component)this.varDragZones.get(batchElement), gbc_dragZone);
        return row + 1;
    }

    private int drawLoopVariable(int startRow, Var<?> loopVar) {
        boolean isLoopInput = this.loop.getBlockDescriptor().inputVars.contains(loopVar);
        if (!this.varDropZones.containsKey(loopVar) && isLoopInput) {
            this.varDropZones.put(loopVar, this.createVarDropZone(loopVar, true, DragDropZone.LINK_RIGHT));
        }
        if (!this.varEditors.containsKey(loopVar)) {
            this.varEditors.put(loopVar, this.createVarEditor(loopVar));
        }
        if (!this.varDragZones.containsKey(loopVar)) {
            this.varDragZones.put(loopVar, this.createVarDragZone(loopVar, true));
        }
        if (isLoopInput) {
            GridBagConstraints gbc_dropZone = new GridBagConstraints();
            gbc_dropZone.anchor = 17;
            gbc_dropZone.fill = 0;
            gbc_dropZone.insets = new Insets(2, 0, 0, 0);
            gbc_dropZone.gridx = 0;
            gbc_dropZone.gridy = startRow;
            this.innerLoopPanel.add(loopVar.isEnabled() ? (Component)this.varDropZones.get(loopVar) : new JLabel("   "), gbc_dropZone);
        }
        GridBagConstraints gbc_inputName = new GridBagConstraints();
        gbc_inputName.anchor = 10;
        gbc_inputName.fill = 2;
        gbc_inputName.insets = new Insets(2, 5, 0, 0);
        gbc_inputName.gridx = 1;
        gbc_inputName.gridy = startRow;
        gbc_inputName.weightx = 1.0;
        JLabel inputName = new JLabel(loopVar.getName());
        Dimension inputNameDim = inputName.getPreferredSize();
        inputNameDim.height = 20;
        inputName.setPreferredSize(inputNameDim);
        this.innerLoopPanel.add((Component)inputName, gbc_inputName);
        GridBagConstraints gbc_inputComponent = new GridBagConstraints();
        gbc_inputComponent.anchor = 10;
        gbc_inputComponent.fill = 2;
        gbc_inputComponent.insets = new Insets(2, 5, 0, 0);
        gbc_inputComponent.gridx = 2;
        gbc_inputComponent.gridy = startRow;
        gbc_inputComponent.weightx = 1.0;
        JComponent inputEditor = (JComponent)((VarEditor)this.varEditors.get(loopVar)).getEditorComponent();
        inputEditor.setOpaque(inputEditor instanceof JTextComponent);
        inputEditor.setFocusable(true);
        inputEditor.setEnabled(inputEditor instanceof JLabel || loopVar.getReference() == null);
        inputEditor.setPreferredSize(((VarEditor)this.varEditors.get(loopVar)).getPreferredSize());
        this.innerLoopPanel.add((Component)inputEditor, gbc_inputComponent);
        GridBagConstraints gbc_dragZone = new GridBagConstraints();
        gbc_dragZone.anchor = 13;
        gbc_dragZone.fill = 0;
        gbc_dragZone.insets = new Insets(2, 5, 0, 0);
        gbc_dragZone.gridx = 3;
        gbc_dragZone.gridy = startRow;
        this.innerLoopPanel.add((Component)this.varDragZones.get(loopVar), gbc_dragZone);
        return startRow + 1;
    }

    @Override
    public Point getDragZoneLocation(Var<?> output) {
        DragDropZone dz;
        if (this.blockDesc.isCollapsed()) {
            return super.getDragZoneLocation(output);
        }
        if (this.loop.isLoopVariable(output) && (dz = (DragDropZone)this.varDragZones.get(output)) != null) {
            int x = dz.getLocationOnScreen().x - this.innerFlowPane.getLocationOnScreen().x;
            int y = dz.getLocationOnScreen().y - this.innerFlowPane.getLocationOnScreen().y;
            return new Point(x + dz.getWidth(), y + dz.getHeight() / 2);
        }
        return super.getDragZoneLocation(output);
    }

    @Override
    public int getVarPanelWidth() {
        return this.innerLoopPanel.getWidth();
    }

    @Override
    public int getVarPanelHeight() {
        return this.getHeight();
    }

    @Override
    public void drawPanel() {
        super.drawPanel();
        if (this.blockDesc.isCollapsed()) {
            for (Component c : this.innerLoopPanel.getComponents()) {
                if (!(c instanceof DragZone)) continue;
                c.setPreferredSize(new Dimension());
            }
            this.innerLoopPanel.setSize(this.innerLoopPanel.getPreferredSize());
            this.varBox.add(this.innerLoopPanel);
            Dimension di = this.varBox.getPreferredSize();
            this.varBox.setPreferredSize(new Dimension(di.width, di.height + this.innerLoopPanel.getHeight()));
            this.setSize(this.getPreferredSize());
        } else {
            for (Component c : this.innerLoopPanel.getComponents()) {
                if (!(c instanceof DragZone)) continue;
                c.setPreferredSize(new Dimension(13, 13));
            }
        }
    }

    @Override
    void dispose() {
        this.menuStopOnFirstError.removeActionListener(this);
        super.dispose();
    }
}

