/*
 * Decompiled with CFR 0.152.
 */
package icy.common;

import icy.util.StringUtil;

public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int revision;
    private int build;
    private boolean beta;

    public Version() {
        this(0, 0, 0, 0, false);
    }

    public Version(int major) {
        this(major, 0, 0, 0, false);
    }

    public Version(int major, int minor) {
        this(major, minor, 0, 0, false);
    }

    public Version(int major, int minor, int revision) {
        this(major, minor, revision, 0, false);
    }

    public Version(int major, int minor, int revision, int build) {
        this(major, minor, revision, build, false);
    }

    public Version(int major, int minor, int revision, int build, boolean beta) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.build = build;
        this.beta = beta;
    }

    public Version(String version) {
        this(0, 0, 0, 0, version.toUpperCase().indexOf(66) != -1);
        String[] values = version.replaceAll("[a-zA-Z ]", "").split("\\.");
        if (values != null) {
            if (values.length > 0 && !StringUtil.isEmpty(values[0], true)) {
                this.major = Integer.parseInt(values[0]);
            }
            if (values.length > 1 && !StringUtil.isEmpty(values[1], true)) {
                this.minor = Integer.parseInt(values[1]);
            }
            if (values.length > 2 && !StringUtil.isEmpty(values[2], true)) {
                this.revision = Integer.parseInt(values[2]);
            }
            if (values.length > 3 && !StringUtil.isEmpty(values[3], true)) {
                this.build = Integer.parseInt(values[3]);
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public int getBuild() {
        return this.build;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public boolean isBeta() {
        return this.beta;
    }

    public void setBeta(boolean beta) {
        this.beta = beta;
    }

    public boolean isEmpty() {
        return this.major == 0 && this.minor == 0 && this.revision == 0 && this.build == 0 && !this.beta;
    }

    public String toShortString() {
        if (this.isEmpty()) {
            return "";
        }
        String result = Integer.toString(this.major) + ".";
        result = result + Integer.toString(this.minor) + ".";
        result = result + Integer.toString(this.revision) + ".";
        result = result + Integer.toString(this.build);
        if (this.beta) {
            result = result + "b";
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo((Version)obj) == 0;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = this.build << 22 | this.major << 15 | this.minor << 8 | this.revision << 1;
        if (this.beta) {
            return result + 1;
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        String result = Integer.toString(this.major) + ".";
        result = result + Integer.toString(this.minor) + ".";
        result = result + Integer.toString(this.revision) + ".";
        result = result + Integer.toString(this.build);
        if (this.beta) {
            result = result + " beta";
        }
        return result;
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return 1;
        }
        if (o.isEmpty() || this.isEmpty()) {
            return 0;
        }
        if (o.major < this.major) {
            return 1;
        }
        if (o.major > this.major) {
            return -1;
        }
        if (o.minor < this.minor) {
            return 1;
        }
        if (o.minor > this.minor) {
            return -1;
        }
        if (o.revision < this.revision) {
            return 1;
        }
        if (o.revision > this.revision) {
            return -1;
        }
        if (o.build < this.build) {
            return 1;
        }
        if (o.build > this.build) {
            return -1;
        }
        if (o.beta && !this.beta) {
            return 1;
        }
        if (!o.beta && this.beta) {
            return -1;
        }
        return 0;
    }

    public boolean isGreater(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterOrEqual(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLower(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerOrEqual(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isNewer(Version version) {
        return this.isGreater(version);
    }

    public boolean isNewerOrEqual(Version version) {
        return this.isGreaterOrEqual(version);
    }

    public boolean isOlder(Version version) {
        return this.isLower(version);
    }

    public boolean isOlderOrEqual(Version version) {
        return this.isLowerOrEqual(version);
    }
}

