/*
 * Decompiled with CFR 0.152.
 */
package icy.network;

import icy.common.Version;
import icy.common.listener.ProgressListener;
import icy.common.listener.weak.WeakListener;
import icy.file.FileUtil;
import icy.main.Icy;
import icy.network.AuthenticationInfo;
import icy.network.URLUtil;
import icy.preferences.NetworkPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.audit.Audit;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;

public class NetworkUtil {
    public static final String WEBSITE_HOST = "icy.bioimageanalysis.org";
    public static final String WEBSITE_URL = "https://icy.bioimageanalysis.org/";
    public static final String IMAGE_SC_URL = "https://forum.image.sc";
    public static final String IMAGE_SC_ICY_URL = "https://forum.image.sc/tag/icy";
    @Deprecated
    static final String REPORT_URL = "https://icy.bioimageanalysis.org/index.php";
    public static final String ID_KERNELVERSION = "kernelVersion";
    public static final String ID_BETAALLOWED = "betaAllowed";
    public static final String ID_JAVANAME = "javaName";
    public static final String ID_JAVAVERSION = "javaVersion";
    public static final String ID_JAVABITS = "javaBits";
    public static final String ID_OSNAME = "osName";
    public static final String ID_OSVERSION = "osVersion";
    public static final String ID_OSARCH = "osArch";
    public static final String ID_PLUGINCLASSNAME = "pluginClassName";
    public static final String ID_PLUGINVERSION = "pluginVersion";
    public static final String ID_DEVELOPERID = "developerId";
    public static final String ID_ERRORLOG = "errorLog";
    public static final int NO_PROXY = 0;
    public static final int SYSTEM_PROXY = 1;
    public static final int USER_PROXY = 2;
    private static final Set<InternetAccessListener> listeners = new HashSet<InternetAccessListener>();
    public static final InternetMonitorThread internetMonitor = new InternetMonitorThread();
    public static final boolean networkEnabled = Icy.isNetworkEnabled();
    private static boolean internetAccess;
    private static boolean httpsSupported;

    public static void init() {
        internetAccess = false;
        httpsSupported = false;
        if (networkEnabled) {
            Version javaVersion = SystemUtil.getJavaVersionAsVersion();
            int javaInt = javaVersion.getMajor();
            httpsSupported = javaInt == 7 ? javaVersion.isGreaterOrEqual(new Version("7.0.111")) : (javaInt == 8 ? javaVersion.isGreaterOrEqual(new Version("8.0.101")) : javaInt >= 9);
            NetworkUtil.updateNetworkSetting();
            NetworkUtil.installTruster();
        }
        if (networkEnabled || !Icy.getMainInterface().isHeadLess()) {
            internetMonitor.setPriority(1);
            internetMonitor.start();
        }
    }

    private static void installTruster() {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new FakeHostnameVerifier());
            TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            if (sc != null) {
                sc.init(null, trustAllCerts, new SecureRandom());
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            sc = SSLContext.getInstance("TLS");
            if (sc != null) {
                sc.init(null, trustAllCerts, new SecureRandom());
            }
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
        }
    }

    public static void updateNetworkSetting() {
        if (networkEnabled) {
            HttpURLConnection.setFollowRedirects(false);
            int proxySetting = NetworkPreferences.getProxySetting();
            if (proxySetting == 0) {
                NetworkUtil.disableProxySetting();
                NetworkUtil.disableHTTPProxySetting();
                NetworkUtil.disableHTTPSProxySetting();
                NetworkUtil.disableFTPProxySetting();
                NetworkUtil.disableSOCKSProxySetting();
                NetworkUtil.disableSystemProxy();
            } else if (proxySetting == 1) {
                NetworkUtil.disableProxySetting();
                NetworkUtil.disableHTTPProxySetting();
                NetworkUtil.disableHTTPSProxySetting();
                NetworkUtil.disableFTPProxySetting();
                NetworkUtil.disableSOCKSProxySetting();
                NetworkUtil.enableSystemProxy();
            } else {
                boolean auth;
                final String user = NetworkPreferences.getProxyUser();
                final String pass = NetworkPreferences.getProxyPassword();
                boolean bl = auth = NetworkPreferences.getProxyAuthentication() && !StringUtil.isEmpty(user) && !StringUtil.isEmpty(pass);
                if (auth) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, pass.toCharArray());
                        }
                    });
                }
                NetworkUtil.disableSystemProxy();
                String host = NetworkPreferences.getProxyHTTPHost();
                if (!StringUtil.isEmpty(host)) {
                    int port = NetworkPreferences.getProxyHTTPPort();
                    NetworkUtil.setProxyHost(host);
                    NetworkUtil.setProxyPort(port);
                    NetworkUtil.setHTTPProxyHost(host);
                    NetworkUtil.setHTTPProxyPort(port);
                    if (auth) {
                        NetworkUtil.setHTTPProxyUser(user);
                        NetworkUtil.setHTTPProxyPassword(pass);
                    }
                    NetworkUtil.enableProxySetting();
                    NetworkUtil.enableHTTPProxySetting();
                } else {
                    NetworkUtil.disableProxySetting();
                    NetworkUtil.disableHTTPProxySetting();
                }
                host = NetworkPreferences.getProxyHTTPSHost();
                if (!StringUtil.isEmpty(host)) {
                    NetworkUtil.setHTTPSProxyHost(host);
                    NetworkUtil.setHTTPSProxyPort(NetworkPreferences.getProxyHTTPSPort());
                    if (auth) {
                        NetworkUtil.setHTTPSProxyUser(user);
                        NetworkUtil.setHTTPSProxyPassword(pass);
                    }
                    NetworkUtil.enableHTTPSProxySetting();
                } else {
                    NetworkUtil.disableHTTPSProxySetting();
                }
                host = NetworkPreferences.getProxyFTPHost();
                if (!StringUtil.isEmpty(host)) {
                    NetworkUtil.setFTPProxyHost(host);
                    NetworkUtil.setFTPProxyPort(NetworkPreferences.getProxyFTPPort());
                    if (auth) {
                        NetworkUtil.setFTPProxyUser(user);
                        NetworkUtil.setFTPProxyPassword(pass);
                    }
                    NetworkUtil.enableFTPProxySetting();
                } else {
                    NetworkUtil.disableFTPProxySetting();
                }
                host = NetworkPreferences.getProxySOCKSHost();
                if (!StringUtil.isEmpty(host)) {
                    NetworkUtil.setSOCKSProxyHost(host);
                    NetworkUtil.setSOCKSProxyPort(NetworkPreferences.getProxySOCKSPort());
                    if (auth) {
                        NetworkUtil.setSOCKSProxyUser(user);
                        NetworkUtil.setSOCKSProxyPassword(pass);
                    }
                    NetworkUtil.enableSOCKSProxySetting();
                } else {
                    NetworkUtil.disableSOCKSProxySetting();
                }
            }
        }
    }

    static void setInternetAccess(boolean value) {
        if (networkEnabled && internetAccess != value) {
            internetAccess = value;
            NetworkUtil.fireInternetConnectionEvent(value);
            if (value) {
                Audit.onConnect();
            }
        }
    }

    private static void fireInternetConnectionEvent(boolean value) {
        if (value) {
            for (InternetAccessListener l : listeners) {
                l.internetUp();
            }
        } else {
            for (InternetAccessListener l : listeners) {
                l.internetDown();
            }
        }
    }

    public static void addInternetAccessListener(InternetAccessListener listener) {
        listeners.add(listener);
    }

    public static void removeInternetAccessListener(InternetAccessListener listener) {
        listeners.remove(listener);
    }

    public static boolean hasInternetAccess() {
        return internetAccess;
    }

    @Deprecated
    public static boolean hasInternetConnection() {
        return NetworkUtil.hasInternetAccess();
    }

    public static boolean isHTTPSSupported() {
        return httpsSupported;
    }

    public static boolean openBrowser(String url) {
        return NetworkUtil.openBrowser(URLUtil.getURL(url));
    }

    public static boolean openBrowser(URL url) {
        if (url == null) {
            return false;
        }
        try {
            return NetworkUtil.openBrowser(url.toURI());
        }
        catch (URISyntaxException e) {
            return NetworkUtil.systemOpenBrowser(url.toString());
        }
    }

    public static boolean openBrowser(URI uri) {
        if (uri == null) {
            return false;
        }
        Desktop desktop = SystemUtil.getDesktop();
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return NetworkUtil.systemOpenBrowser(uri.toString());
    }

    private static boolean systemOpenBrowser(String url) {
        if (StringUtil.isEmpty(url)) {
            return false;
        }
        try {
            if (SystemUtil.isMac()) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (SystemUtil.isWindows()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec("which " + browsers[count]).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error while opening system browser :\n" + e.toString());
            return false;
        }
    }

    @Deprecated
    public static void openURL(String url) {
        NetworkUtil.openBrowser(url);
    }

    @Deprecated
    public static void openURL(URL url) {
        NetworkUtil.openBrowser(url);
    }

    @Deprecated
    public static void openURL(URI uri) {
        NetworkUtil.openBrowser(uri);
    }

    public static byte[] download(String path, ProgressListener listener, boolean displayError) {
        return NetworkUtil.download(path, null, null, listener, displayError);
    }

    public static byte[] download(String path, String login, String pass, ProgressListener listener, boolean displayError) {
        File file = new File(FileUtil.getGenericPath(path));
        if (file.exists()) {
            return NetworkUtil.download(file, listener, displayError);
        }
        URL url = URLUtil.getURL(path);
        if (url == null) {
            if (displayError) {
                System.out.println("Can't download '" + path + "', incorrect path !");
            }
            return null;
        }
        return NetworkUtil.download(url, login, pass, listener, displayError);
    }

    public static byte[] download(URL url, ProgressListener listener, boolean displayError) {
        return NetworkUtil.download(url, null, null, listener, displayError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] download(URL url, String login, String pass, ProgressListener listener, boolean displayError) {
        if (url != null && URLUtil.isFileURL(url)) {
            try {
                return NetworkUtil.download(new File(url.toURI()), listener, displayError);
            }
            catch (URISyntaxException e) {
                if (displayError) {
                    System.out.println("Can't download from '" + url + "', incorrect path !");
                }
                return null;
            }
        }
        URLConnection uc = NetworkUtil.openConnection(url, login, pass, true, true, displayError);
        InputStream ip = NetworkUtil.getInputStream(uc, displayError);
        if (ip == null) {
            return null;
        }
        try {
            byte[] byArray = NetworkUtil.download(ip, uc.getContentLength(), listener);
            return byArray;
        }
        catch (Exception e) {
            if (displayError) {
                System.out.println("Error while downloading '" + uc.getURL() + "' :");
                IcyExceptionHandler.showErrorMessage(e, false, false);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                ip.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] download(File f, ProgressListener listener, boolean displayError) {
        if (!f.exists()) {
            System.err.println("File not found: " + f.getPath());
            return null;
        }
        try {
            return NetworkUtil.download(new FileInputStream(f), f.length(), listener);
        }
        catch (Exception e) {
            if (displayError) {
                System.out.println("NetworkUtil.download('" + f.getPath() + "',...) error :");
                IcyExceptionHandler.showErrorMessage(e, false, false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] download(InputStream in, long len, ProgressListener listener) throws IOException {
        int READ_BLOCKSIZE = 65536;
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)(len > 0L ? len : 65536L));
        byte[] data = new byte[65536];
        try {
            int off = 0;
            int count = 0;
            while (count >= 0) {
                count = bin.read(data);
                if (count <= 0) {
                    if (len != -1L && (long)off != len) {
                        throw new EOFException("Unexpected end of file at " + off + " (" + len + " expected)");
                    }
                } else {
                    off += count;
                }
                if (count > 0) {
                    bout.write(data, 0, count);
                }
                if (listener == null || listener.notifyProgress((double)off, (double)len)) continue;
                in.close();
                System.out.println("Interrupted by user.");
                byte[] byArray = null;
                return byArray;
            }
        }
        finally {
            bin.close();
        }
        return bout.toByteArray();
    }

    public static byte[] download(InputStream in) throws IOException {
        return NetworkUtil.download(in, -1L, null);
    }

    public static URLConnection openConnection(URL url, String login, String pass, boolean disableCache, boolean doConnect, boolean displayError) {
        if (url == null) {
            if (displayError) {
                System.out.println("NetworkUtil.openConnection(...) error: URL is null !");
            }
            return null;
        }
        URLConnection uc = null;
        try {
            boolean redirect;
            uc = url.openConnection();
            do {
                redirect = false;
                if (disableCache) {
                    NetworkUtil.disableCache(uc);
                }
                if (!StringUtil.isEmpty(login) && !StringUtil.isEmpty(pass)) {
                    NetworkUtil.setAuthentication(uc, login, pass);
                }
                if (!doConnect) continue;
                if (!NetworkUtil.connect(uc, displayError)) {
                    return null;
                }
                if (!(uc instanceof HttpURLConnection)) continue;
                int respCode = ((HttpURLConnection)uc).getResponseCode();
                boolean bl = redirect = respCode == 301 || respCode == 302 || respCode == 303;
                if (!redirect) continue;
                String location = ((HttpURLConnection)uc).getHeaderField("Location");
                ((HttpURLConnection)uc).disconnect();
                location = URLDecoder.decode(location, "UTF-8");
                uc = new URL(location).openConnection();
            } while (redirect);
            return uc;
        }
        catch (IOException e) {
            if (displayError) {
                if (!NetworkUtil.isHTTPSSupported() && uc != null && uc.getURL().toString().toLowerCase().startsWith("https://icy")) {
                    System.err.println("NetworkUtil.openConnection('" + uc.getURL() + "') error: HTTPS connection not supported (see detail below).");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                } else {
                    System.out.println("NetworkUtil.openConnection('" + url + "') error :");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                }
            }
            return null;
        }
    }

    public static URLConnection openConnection(URL url, String login, String pass, boolean disableCache, boolean displayError) {
        return NetworkUtil.openConnection(url, login, pass, disableCache, false, displayError);
    }

    public static URLConnection openConnection(URL url, AuthenticationInfo auth, boolean disableCache, boolean displayError) {
        if (auth != null && auth.isEnabled()) {
            return NetworkUtil.openConnection(url, auth.getLogin(), auth.getPassword(), disableCache, displayError);
        }
        return NetworkUtil.openConnection(url, null, null, disableCache, displayError);
    }

    public static URLConnection openConnection(URL url, boolean disableCache, boolean displayError) {
        return NetworkUtil.openConnection(url, null, null, disableCache, displayError);
    }

    public static URLConnection openConnection(String path, boolean disableCache, boolean displayError) {
        return NetworkUtil.openConnection(URLUtil.getURL(path), disableCache, displayError);
    }

    public static boolean connect(URLConnection uc, boolean displayError) {
        try {
            HttpURLConnection huc;
            uc.connect();
            if (uc instanceof HttpURLConnection && (huc = (HttpURLConnection)uc).getResponseCode() >= 1024) {
                if (displayError) {
                    System.out.println("NetworkUtil.connect('" + huc.getURL() + "' error:");
                    System.out.println(huc.getResponseMessage());
                }
                return false;
            }
        }
        catch (Exception e) {
            if (displayError) {
                if (uc.getURL().getProtocol().equalsIgnoreCase("file")) {
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                } else if (!NetworkUtil.hasInternetAccess()) {
                    System.out.println("Can't connect to '" + uc.getURL() + "' (no internet connection).");
                } else if (!NetworkUtil.isHTTPSSupported() && uc.getURL().toString().toLowerCase().startsWith("https://icy")) {
                    System.err.println("NetworkUtil.connect('" + uc.getURL() + "') error: HTTPS connection not supported (see detail below).");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                } else {
                    System.out.println("NetworkUtil.connect('" + uc.getURL() + "' error:");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                }
            }
            return false;
        }
        return true;
    }

    public static InputStream getInputStream(URLConnection uc, boolean displayError) {
        if (uc == null) {
            if (displayError) {
                System.out.print("NetworkUtil.getInputStream(URLConnection uc) error: URLConnection object is null !");
            }
            return null;
        }
        try {
            return uc.getInputStream();
        }
        catch (IOException e) {
            if (displayError) {
                if (!NetworkUtil.hasInternetAccess()) {
                    System.out.println("Can't connect to '" + uc.getURL() + "' (no internet connection).");
                } else if (!NetworkUtil.isHTTPSSupported() && uc != null && uc.getURL().toString().toLowerCase().startsWith("https://icy")) {
                    System.err.println("NetworkUtil.getInputStream('" + uc.getURL() + "') error: HTTPS connection not supported !");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                } else {
                    System.out.println("NetworkUtil.getInputStream('" + uc.getURL() + "') error:");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                }
            }
            return null;
        }
    }

    public static InputStream getInputStream(URL url, String login, String pass, boolean disableCache, boolean displayError) {
        URLConnection uc = NetworkUtil.openConnection(url, login, pass, disableCache, true, displayError);
        if (uc != null) {
            return NetworkUtil.getInputStream(uc, displayError);
        }
        return null;
    }

    public static InputStream getInputStream(URL url, AuthenticationInfo auth, boolean disableCache, boolean displayError) {
        if (auth != null && auth.isEnabled()) {
            return NetworkUtil.getInputStream(url, auth.getLogin(), auth.getPassword(), disableCache, displayError);
        }
        return NetworkUtil.getInputStream(url, null, null, disableCache, displayError);
    }

    public static void disableCache(URLConnection uc) {
        uc.setDefaultUseCaches(false);
        uc.setUseCaches(false);
        uc.setRequestProperty("Cache-Control", "no-cache");
        uc.setRequestProperty("Pragma", "no-cache");
    }

    public static void setAuthentication(URLConnection uc, String login, String pass) {
        String req = login + ":" + pass;
        String encoded = Base64.getEncoder().encodeToString(req.getBytes());
        uc.setRequestProperty("Authorization", "Basic " + encoded);
    }

    public static String getContentString(Map<String, String> values) {
        String result = "";
        for (Map.Entry<String, String> entry : values.entrySet()) {
            try {
                String key = entry.getKey();
                if (StringUtil.isEmpty(key)) continue;
                String value = entry.getValue();
                result = result + "&" + URLEncoder.encode(key, "UTF-8") + "=";
                if (StringUtil.isEmpty(value)) continue;
                result = result + URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                result = result + "&" + entry.getKey() + "=" + entry.getValue();
            }
        }
        return result.substring(1);
    }

    public static String postData(String target, Map<String, String> values, String login, String pass) throws IOException {
        return NetworkUtil.postData(target, NetworkUtil.getContentString(values), login, pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postData(String target, String content, String login, String pass) throws IOException {
        String response = "";
        URLConnection uc = NetworkUtil.openConnection(target, true, true);
        if (uc == null) {
            return null;
        }
        uc.setDoInput(true);
        uc.setDoOutput(true);
        if (login != null) {
            NetworkUtil.setAuthentication(uc, login, pass);
        }
        uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        try (DataOutputStream out = new DataOutputStream(uc.getOutputStream());){
            out.writeBytes(content);
            out.flush();
        }
        InputStream inStream = NetworkUtil.getInputStream(uc, false);
        if (inStream == null) {
            return null;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inStream));){
            String temp;
            while ((temp = in.readLine()) != null) {
                response = response + temp + "\n";
            }
        }
        return response;
    }

    public static String postData(String target, Map<String, String> values) throws IOException {
        return NetworkUtil.postData(target, values, null, null);
    }

    public static String postData(String target, String content) throws IOException {
        return NetworkUtil.postData(target, content, null, null);
    }

    @Deprecated
    public static void report(final Map<String, String> values) {
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                try {
                    if (NetworkUtil.postData(NetworkUtil.REPORT_URL, values) == null) {
                        System.out.println("Error while reporting data, verifying your internet connection.");
                    }
                }
                catch (IOException e) {
                    System.out.println("Error while reporting data :");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                }
            }
        });
    }

    @Deprecated
    public static String getContentString(HashMap<String, String> values) {
        return NetworkUtil.getContentString(values);
    }

    @Deprecated
    public static String postData(String target, HashMap<String, String> values, String login, String pass) throws IOException {
        return NetworkUtil.postData(target, values, login, pass);
    }

    @Deprecated
    public static String postData(String target, HashMap<String, String> values) throws IOException {
        return NetworkUtil.postData(target, values);
    }

    @Deprecated
    public static void report(HashMap<String, String> values) {
        NetworkUtil.report(values);
    }

    public static void enableSystemProxy() {
        SystemUtil.setProperty("java.net.useSystemProxies", "true");
    }

    public static void disableSystemProxy() {
        SystemUtil.setProperty("java.net.useSystemProxies", "false");
    }

    public static void enableProxySetting() {
        SystemUtil.setProperty("proxySet", "true");
    }

    public static void disableProxySetting() {
        SystemUtil.setProperty("proxySet", "false");
    }

    public static void enableHTTPProxySetting() {
        SystemUtil.setProperty("http.proxySet", "true");
    }

    public static void disableHTTPProxySetting() {
        SystemUtil.setProperty("http.proxySet", "false");
    }

    public static void enableHTTPSProxySetting() {
        SystemUtil.setProperty("https.proxySet", "true");
    }

    public static void disableHTTPSProxySetting() {
        SystemUtil.setProperty("https.proxySet", "false");
    }

    public static void enableFTPProxySetting() {
        SystemUtil.setProperty("ftp.proxySet", "true");
    }

    public static void disableFTPProxySetting() {
        SystemUtil.setProperty("ftp.proxySet", "false");
    }

    public static void enableSOCKSProxySetting() {
        SystemUtil.setProperty("socksProxySet", "true");
    }

    public static void disableSOCKSProxySetting() {
        SystemUtil.setProperty("socksProxySet", "false");
    }

    public static void setProxyHost(String host) {
        SystemUtil.setProperty("proxy.server", host);
    }

    public static void setProxyPort(int port) {
        SystemUtil.setProperty("proxy.port", Integer.toString(port));
    }

    public static void setHTTPProxyHost(String host) {
        SystemUtil.setProperty("http.proxyHost", host);
    }

    public static void setHTTPProxyPort(int port) {
        SystemUtil.setProperty("http.proxyPort", Integer.toString(port));
    }

    public static void setHTTPProxyUser(String user) {
        SystemUtil.setProperty("http.proxyUser", user);
    }

    public static void setHTTPProxyPassword(String password) {
        SystemUtil.setProperty("http.proxyPassword", password);
    }

    public static void setHTTPSProxyHost(String host) {
        SystemUtil.setProperty("https.proxyHost", host);
    }

    public static void setHTTPSProxyPort(int port) {
        SystemUtil.setProperty("https.proxyPort", Integer.toString(port));
    }

    public static void setHTTPSProxyUser(String user) {
        SystemUtil.setProperty("https.proxyUser", user);
    }

    public static void setHTTPSProxyPassword(String password) {
        SystemUtil.setProperty("https.proxyPassword", password);
    }

    public static void setFTPProxyHost(String host) {
        SystemUtil.setProperty("ftp.proxyHost", host);
    }

    public static void setFTPProxyPort(int port) {
        SystemUtil.setProperty("ftp.proxyPort", Integer.toString(port));
    }

    public static void setFTPProxyUser(String user) {
        SystemUtil.setProperty("ftp.proxyUser", user);
    }

    public static void setFTPProxyPassword(String password) {
        SystemUtil.setProperty("ftp.proxyPassword", password);
    }

    public static void setSOCKSProxyHost(String host) {
        SystemUtil.setProperty("socksProxyHost", host);
    }

    public static void setSOCKSProxyPort(int port) {
        SystemUtil.setProperty("socksProxyPort", Integer.toString(port));
    }

    public static void setSOCKSProxyUser(String user) {
        SystemUtil.setProperty("socksProxyUser", user);
    }

    public static void setSOCKSProxyPassword(String password) {
        SystemUtil.setProperty("socksProxyPassword", password);
    }

    public static String getProxyHost() {
        return SystemUtil.getProperty("proxy.server");
    }

    public static int getProxyPort() {
        try {
            return Integer.parseInt(SystemUtil.getProperty("proxy.port"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getHTTPProxyHost() {
        return SystemUtil.getProperty("http.proxyHost");
    }

    public static int getHTTPProxyPort() {
        try {
            return Integer.parseInt(SystemUtil.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getHTTPSProxyHost() {
        return SystemUtil.getProperty("https.proxyHost");
    }

    public static int getHTTPSProxyPort() {
        try {
            return Integer.parseInt(SystemUtil.getProperty("https.proxyPort"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getFTPProxyHost() {
        return SystemUtil.getProperty("ftp.proxyHost");
    }

    public static int getFTPProxyPort() {
        try {
            return Integer.parseInt(SystemUtil.getProperty("ftp.proxyPort"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getSOCKSProxyHost() {
        return SystemUtil.getProperty("socksProxyHost");
    }

    public static int getSOCKSProxyPort() {
        try {
            return Integer.parseInt(SystemUtil.getProperty("socksProxyPort"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static class InternetMonitorThread
    extends Thread {
        public InternetMonitorThread() {
            super("Internet monitor");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Socket socket = new Socket();
                    socket.setSoTimeout(3000);
                    socket.connect(new InetSocketAddress(NetworkUtil.WEBSITE_HOST, 80), 3000);
                    socket.close();
                    NetworkUtil.setInternetAccess(true);
                }
                catch (Throwable t1) {
                    try {
                        URLConnection urlConnection = NetworkUtil.openConnection("https://www.google.com", true, false);
                        if (urlConnection != null) {
                            urlConnection.setConnectTimeout(3000);
                            urlConnection.setReadTimeout(3000);
                            urlConnection.getInputStream();
                            NetworkUtil.setInternetAccess(true);
                        } else {
                            NetworkUtil.setInternetAccess(false);
                        }
                    }
                    catch (Throwable t2) {
                        NetworkUtil.setInternetAccess(false);
                    }
                }
                ThreadUtil.sleep(NetworkUtil.hasInternetAccess() ? 30000 : 5000);
            }
        }
    }

    private static class FakeHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static interface InternetAccessListener {
        public void internetUp();

        public void internetDown();
    }

    public static class WeakInternetAccessListener
    extends WeakListener<InternetAccessListener>
    implements InternetAccessListener {
        public WeakInternetAccessListener(InternetAccessListener listener) {
            super((Object)listener);
        }

        public void removeListener(Object source) {
            NetworkUtil.removeInternetAccessListener(this);
        }

        @Override
        public void internetUp() {
            InternetAccessListener listener = (InternetAccessListener)this.getListener();
            if (listener != null) {
                listener.internetUp();
            }
        }

        @Override
        public void internetDown() {
            InternetAccessListener listener = (InternetAccessListener)this.getListener();
            if (listener != null) {
                listener.internetDown();
            }
        }
    }
}

