/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.PlotVirtualStack;
import ij.measure.Calibration;
import ij.plugin.CompositeConverter;
import ij.plugin.RGBStackConverter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.MedianCut;

public class StackConverter {
    ImagePlus imp;
    int type;
    int nSlices;
    int width;
    int height;

    public StackConverter(ImagePlus imp) {
        this.imp = imp;
        this.type = imp.getType();
        this.nSlices = imp.getStackSize();
        if (this.nSlices < 2) {
            throw new IllegalArgumentException("Stack required");
        }
        this.width = imp.getWidth();
        this.height = imp.getHeight();
    }

    public void convertToGray8() {
        ImageStack stack1 = this.imp.getStack();
        int currentSlice = this.imp.getCurrentSlice();
        ImageProcessor ip = this.imp.getProcessor();
        boolean colorLut = ip.isColorLut();
        boolean pseudoColorLut = colorLut && ip.isPseudoColorLut();
        boolean composite = this.imp.isComposite();
        if (this.type == 0 && pseudoColorLut && !composite) {
            boolean invertedLut = ip.isInvertedLut();
            ip.setColorModel(LookUpTable.createGrayscaleColorModel(invertedLut));
            stack1.setColorModel(ip.getColorModel());
            this.imp.updateAndDraw();
            return;
        }
        if (!composite && (this.type == 4 || this.type == 3 || colorLut)) {
            this.convertRGBToGray8();
            this.imp.setSlice(currentSlice);
            return;
        }
        ImageStack stack2 = new ImageStack(this.width, this.height);
        double min = ip.getMin();
        double max = ip.getMax();
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        LUT[] luts = composite ? ((CompositeImage)this.imp).getLuts() : null;
        for (int i = 1; i <= this.nSlices; ++i) {
            String label = stack1.getSliceLabel(1);
            ip = stack1.getProcessor(1);
            stack1.deleteSlice(1);
            if (luts != null) {
                int index = (i - 1) % luts.length;
                min = luts[index].min;
                max = luts[index].max;
            }
            ip.setMinAndMax(min, max);
            boolean scale = ImageConverter.getDoScaling();
            stack2.addSlice(label, ip.convertToByte(scale));
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 8-bits: " + i + "/" + this.nSlices);
        }
        this.imp.setStack(null, stack2);
        this.imp.setCalibration(this.imp.getCalibration());
        if (this.imp.isComposite()) {
            ((CompositeImage)this.imp).resetDisplayRanges();
            ((CompositeImage)this.imp).updateAllChannelsAndDraw();
        }
        this.imp.setSlice(currentSlice);
        IJ.showProgress(1.0);
    }

    void convertRGBToGray8() {
        ImageStack stack1 = this.imp.getStack();
        if (stack1 instanceof PlotVirtualStack) {
            ((PlotVirtualStack)stack1).setBitDepth(8);
            this.imp.setStack(stack1);
            return;
        }
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        for (int i = 1; i <= this.nSlices; ++i) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip = stack1.getProcessor(1);
            stack1.deleteSlice(1);
            if (ip instanceof ByteProcessor) {
                ip = new ColorProcessor(ip.createImage());
            }
            boolean scale = ImageConverter.getDoScaling();
            stack2.addSlice(label, ip.convertToByte(scale));
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 8-bits: " + i + "/" + this.nSlices);
        }
        this.imp.setStack(null, stack2);
        IJ.showProgress(1.0);
    }

    public void convertToGray16() {
        if (this.type == 1) {
            return;
        }
        if (this.type != 0 && this.type != 2) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        boolean scale = this.type == 2 && ImageConverter.getDoScaling();
        for (int i = 1; i <= this.nSlices; ++i) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip1 = stack1.getProcessor(1);
            ImageProcessor ip2 = ip1.convertToShort(scale);
            stack1.deleteSlice(1);
            stack2.addSlice(label, ip2);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 16-bits: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
    }

    public void convertToGray32() {
        if (this.type == 2) {
            return;
        }
        if (this.type != 0 && this.type != 1 && this.type != 4) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        Calibration cal = this.imp.getCalibration();
        for (int i = 1; i <= this.nSlices; ++i) {
            String label = stack1.getSliceLabel(1);
            ImageProcessor ip1 = stack1.getProcessor(1);
            ip1.setCalibrationTable(cal.getCTable());
            ImageProcessor ip2 = ip1.convertToFloat();
            stack1.deleteSlice(1);
            stack2.addSlice(label, ip2);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to 32-bits: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        this.imp.setCalibration(this.imp.getCalibration());
        if (this.type == 4) {
            this.imp.resetDisplayRange();
            this.imp.updateAndDraw();
        }
    }

    public void convertToRGB() {
        int z = this.imp.getNSlices();
        int t = this.imp.getNFrames();
        if (this.imp.isComposite()) {
            RGBStackConverter.convertToRGB(this.imp);
            return;
        }
        ImageStack stack1 = this.imp.getStack();
        if (stack1 instanceof PlotVirtualStack) {
            ((PlotVirtualStack)stack1).setBitDepth(24);
            this.imp.setStack(stack1);
            return;
        }
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int inc = this.nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        Calibration cal = this.imp.getCalibration();
        for (int i = 1; i <= this.nSlices; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip1 = stack1.getProcessor(i);
            ImageProcessor ip2 = ip1.convertToRGB();
            stack2.addSlice(label, ip2);
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)this.nSlices);
            IJ.showStatus("Converting to RGB: " + i + "/" + this.nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        this.imp.setDimensions(1, z, t);
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGBHyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        new CompositeConverter().run("composite");
    }

    public void convertToHSBHyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int nSlices = stack1.getSize();
        Calibration cal = this.imp.getCalibration();
        int inc = nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        for (int i = 1; i <= nSlices; ++i) {
            String label = stack1.getSliceLabel(i);
            ColorProcessor cp = (ColorProcessor)stack1.getProcessor(i);
            ImageStack stackHSB = cp.getHSBStack();
            stack2.addSlice(label, stackHSB.getProcessor(1));
            stack2.addSlice(label, stackHSB.getProcessor(2));
            stack2.addSlice(label, stackHSB.getProcessor(3));
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)nSlices);
            IJ.showStatus("Converting to HSB: " + i + "/" + nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        this.imp.setProp("HSB_Stack", "true");
        this.imp.setCalibration(cal);
        this.imp.setDimensions(3, nSlices, 1);
        CompositeImage ci = new CompositeImage(this.imp, 3);
        ci.show();
        this.imp.hide();
    }

    public void convertToHSB32Hyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack stack1 = this.imp.getStack();
        ImageStack stack2 = new ImageStack(this.width, this.height);
        int nSlices = stack1.getSize();
        Calibration cal = this.imp.getCalibration();
        int inc = nSlices / 20;
        if (inc < 1) {
            inc = 1;
        }
        for (int i = 1; i <= nSlices; ++i) {
            String label = stack1.getSliceLabel(i);
            ColorProcessor cp = (ColorProcessor)stack1.getProcessor(i);
            ImageStack stackHSB = cp.getHSB32Stack();
            stack2.addSlice(label, stackHSB.getProcessor(1));
            stack2.addSlice(label, stackHSB.getProcessor(2));
            stack2.addSlice(label, stackHSB.getProcessor(3));
            if (i % inc != 0) continue;
            IJ.showProgress((double)i / (double)nSlices);
            IJ.showStatus("Converting to HSB: " + i + "/" + nSlices);
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, stack2);
        this.imp.setCalibration(cal);
        this.imp.setDimensions(3, nSlices, 1);
        CompositeImage ci = new CompositeImage(this.imp, 3);
        ci.show();
        this.imp.hide();
    }

    public void convertToLabHyperstack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        if (this.imp != null) {
            throw new IllegalArgumentException("Stacks currently not supported");
        }
    }

    public void convertToIndexedColor(int nColors) {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack stack = this.imp.getStack();
        int size = stack.size();
        ImageProcessor montage = new ColorProcessor(this.width * size, this.height);
        for (int i = 0; i < size; ++i) {
            montage.insert(stack.getProcessor(i + 1), i * this.width, 0);
        }
        MedianCut mc = new MedianCut((ColorProcessor)montage);
        montage = mc.convertToByte(nColors);
        ImageStack stack2 = new ImageStack(this.width, this.height);
        for (int i = 0; i < size; ++i) {
            montage.setRoi(i * this.width, 0, this.width, this.height);
            stack2.addSlice(null, montage.crop());
        }
        this.imp.setStack(null, stack2);
        this.imp.setTypeToColor256();
    }
}

