/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.ByteArray;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatByte3D;
import mitiv.array.impl.StriddenByte3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte3D
extends Array3D
implements ByteArray {
    protected Byte3D(int dim1, int dim2, int dim3) {
        super(dim1, dim2, dim3);
    }

    protected Byte3D(int[] dims) {
        super(dims);
    }

    protected Byte3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, byte var4);

    @Override
    public void fill(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, value);
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, value);
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) + value));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) + value));
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) - value));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) - value));
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) * value));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (byte)(this.get(i1, i2, i3) * value));
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, function.apply(this.get(i1, i2, i3)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, generator.nextByte());
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, generator.nextByte());
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                            continue;
                        }
                        scanner.initialize(this.get(i1, i2, i3));
                        initialized = true;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (initialized) {
                            scanner.update(this.get(i1, i2, i3));
                            continue;
                        }
                        scanner.initialize(this.get(i1, i2, i3));
                        initialized = true;
                    }
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value >= minValue) continue;
                        minValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value >= minValue) continue;
                        minValue = value;
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value <= maxValue) continue;
                        maxValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value <= maxValue) continue;
                        maxValue = value;
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value <= maxValue) continue;
                        maxValue = value;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        if (skip) {
                            skip = false;
                            continue;
                        }
                        int value = this.get(i1, i2, i3) & 0xFF;
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value <= maxValue) continue;
                        maxValue = value;
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        totalValue += this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        totalValue += this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        return this;
    }

    @Override
    public Short3D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)(inp[i] & 0xFF);
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = (short)(this.get(i1, i2, i3) & 0xFF);
                    }
                }
            }
        }
        return Short3D.wrap(out, this.getShape());
    }

    @Override
    public Int3D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        }
        return Int3D.wrap(out, this.getShape());
    }

    @Override
    public Long3D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        }
        return Long3D.wrap(out, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        }
        return Float3D.wrap(out, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        out[++i] = this.get(i1, i2, i3) & 0xFF;
                    }
                }
            }
        }
        return Double3D.wrap(out, this.getShape());
    }

    @Override
    public Byte3D copy() {
        return new FlatByte3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte3D src = arr.getType() == 0 ? (Byte3D)arr : (Byte3D)arr.toByte();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                    }
                }
            }
        } else {
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, src.get(i1, i2, i3));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (byte)src.get(++i));
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i3 = 0; i3 < this.dim3; ++i3) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i1 = 0; i1 < this.dim1; ++i1) {
                        this.set(i1, i2, i3, (byte)src.get(++i));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte3D create() {
        return new FlatByte3D(this.getShape());
    }

    public static Byte3D create(int dim1, int dim2, int dim3) {
        return new FlatByte3D(dim1, dim2, dim3);
    }

    public static Byte3D create(int[] dims) {
        return new FlatByte3D(dims);
    }

    public static Byte3D create(Shape shape) {
        return new FlatByte3D(shape);
    }

    public static Byte3D wrap(byte[] data, int dim1, int dim2, int dim3) {
        return new FlatByte3D(data, dim1, dim2, dim3);
    }

    public static Byte3D wrap(byte[] data, int[] dims) {
        return new FlatByte3D(data, dims);
    }

    public static Byte3D wrap(byte[] data, Shape shape) {
        return new FlatByte3D(data, shape);
    }

    public static Byte3D wrap(byte[] data, int offset, int stride1, int stride2, int stride3, int dim1, int dim2, int dim3) {
        return new StriddenByte3D(data, offset, stride1, stride2, stride3, dim1, dim2, dim3);
    }

    @Override
    public abstract Byte2D slice(int var1);

    @Override
    public abstract Byte2D slice(int var1, int var2);

    @Override
    public abstract Byte3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Byte3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Byte1D as1D();
}

