/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.ByteScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte1D;
import mitiv.array.impl.StriddenByte1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ByteGenerator;

public class FlatByte1D
extends Byte1D {
    static final int order = 1;
    final byte[] data;

    public FlatByte1D(int dim1) {
        super(dim1);
        this.data = new byte[this.number];
    }

    public FlatByte1D(int[] dims) {
        super(dims);
        this.data = new byte[this.number];
    }

    public FlatByte1D(Shape shape) {
        super(shape);
        this.data = new byte[this.number];
    }

    public FlatByte1D(byte[] arr, int dim1) {
        super(dim1);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatByte1D(byte[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatByte1D(byte[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(byte[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1) {
        return i1;
    }

    @Override
    public final byte get(int i1) {
        return this.data[i1];
    }

    @Override
    public final void set(int i1, byte value) {
        this.data[i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(byte value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextByte();
        }
    }

    @Override
    public void increment(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] - value);
        }
    }

    @Override
    public void scale(byte value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (byte)(this.data[n] * value);
        }
    }

    @Override
    public void map(ByteFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        if (forceCopy) {
            byte[] result = new byte[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ByteScalar slice(int idx) {
        idx = Helper.fixIndex(idx, this.dim1);
        return new ByteScalar(this.data, idx);
    }

    @Override
    public ByteScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new ByteScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Byte1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenByte1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Byte1D view(int[] sel1) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        return new SelectedByte1D(this.data, idx1);
    }

    @Override
    public Byte1D as1D() {
        return this;
    }
}

