/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.util.ListIterator;
import java.util.Map;
import jnr.constants.Constant;
import jnr.constants.platform.linux.Errno;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.util.Platform;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.imp;
import org.python.core.io.FileDescriptors;
import org.python.core.io.FileIO;
import org.python.core.io.IOBase;
import org.python.core.io.RawIOBase;
import org.python.core.util.StringUtil;
import org.python.modules.posix.Hide;
import org.python.modules.posix.Hider;
import org.python.modules.posix.OS;
import org.python.modules.posix.PosixImpl;
import org.python.modules.posix.PyStatResult;
import org.python.modules.posix.PythonPOSIXHandler;

public class PosixModule
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("This module provides access to operating system functionality that is\nstandardized by the C Standard and the POSIX standard (a thinly\ndisguised Unix interface).  Refer to the library manual and\ncorresponding Unix manual entries for more information on calls.");
    private static OS os = OS.getOS();
    private static POSIX posix = POSIXFactory.getPOSIX(new PythonPOSIXHandler(), true);
    private static int O_RDONLY = 0;
    private static int O_WRONLY = 1;
    private static int O_RDWR = 2;
    private static int O_APPEND = 8;
    private static int O_SYNC = 128;
    private static int O_CREAT = 512;
    private static int O_TRUNC = 1024;
    private static int O_EXCL = 2048;
    private static int F_OK = 0;
    private static int X_OK = 1;
    private static int W_OK = 2;
    private static int R_OK = 4;
    private static PyObject realpath;
    public static PyString __doc___exit;
    public static PyString __doc__access;
    public static PyString __doc__chdir;
    public static PyString __doc__chmod;
    public static PyString __doc__chown;
    public static PyString __doc__close;
    public static PyString __doc__fdopen;
    public static PyString __doc__fdatasync;
    public static PyString __doc__fsync;
    public static PyString __doc__ftruncate;
    public static PyString __doc__getcwd;
    public static PyString __doc__getcwdu;
    public static PyString __doc__getegid;
    public static PyString __doc__geteuid;
    public static PyString __doc__getgid;
    public static PyString __doc__getlogin;
    public static PyString __doc__getppid;
    public static PyString __doc__getuid;
    public static PyString __doc__getpid;
    public static PyString __doc__getpgrp;
    public static PyString __doc__isatty;
    public static PyString __doc__kill;
    public static PyString __doc__lchmod;
    public static PyString __doc__lchown;
    public static PyString __doc__link;
    public static PyString __doc__listdir;
    public static PyString __doc__lseek;
    public static PyString __doc__mkdir;
    public static PyString __doc__open;
    public static PyString __doc__popen;
    public static PyString __doc__putenv;
    public static PyString __doc__read;
    public static PyString __doc__readlink;
    public static PyString __doc__remove;
    public static PyString __doc__rename;
    public static PyString __doc__rmdir;
    public static PyString __doc__setpgrp;
    public static PyString __doc__setsid;
    public static PyString __doc__strerror;
    public static PyString __doc__symlink;
    public static PyString __doc__system;
    public static PyString __doc__umask;
    public static PyString __doc__unlink;
    public static PyString __doc__utime;
    public static PyString __doc__wait;
    public static PyString __doc__waitpid;
    public static PyString __doc__write;
    public static PyString __doc__unsetenv;
    public static PyString __doc__urandom;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("O_RDONLY", (PyObject)Py.newInteger(O_RDONLY));
        dict.__setitem__("O_WRONLY", (PyObject)Py.newInteger(O_WRONLY));
        dict.__setitem__("O_RDWR", (PyObject)Py.newInteger(O_RDWR));
        dict.__setitem__("O_APPEND", (PyObject)Py.newInteger(O_APPEND));
        dict.__setitem__("O_SYNC", (PyObject)Py.newInteger(O_SYNC));
        dict.__setitem__("O_CREAT", (PyObject)Py.newInteger(O_CREAT));
        dict.__setitem__("O_TRUNC", (PyObject)Py.newInteger(O_TRUNC));
        dict.__setitem__("O_EXCL", (PyObject)Py.newInteger(O_EXCL));
        dict.__setitem__("F_OK", (PyObject)Py.newInteger(F_OK));
        dict.__setitem__("X_OK", (PyObject)Py.newInteger(X_OK));
        dict.__setitem__("W_OK", (PyObject)Py.newInteger(W_OK));
        dict.__setitem__("R_OK", (PyObject)Py.newInteger(R_OK));
        dict.__setitem__("EX_OK", (PyObject)Py.Zero);
        boolean nativePosix = posix.isNative();
        dict.__setitem__("_native_posix", (PyObject)Py.newBoolean(nativePosix));
        dict.__setitem__("_posix_impl", Py.java2py(posix));
        dict.__setitem__("environ", PosixModule.getEnviron());
        dict.__setitem__("error", Py.OSError);
        dict.__setitem__("stat_result", (PyObject)PyStatResult.TYPE);
        dict.__setitem__("lstat", (PyObject)new LstatFunction());
        dict.__setitem__("stat", (PyObject)new StatFunction());
        Hider.hideFunctions(PosixModule.class, dict, os, nativePosix);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("__init__", null);
        dict.__setitem__("getPOSIX", null);
        dict.__setitem__("getOSName", null);
        dict.__setitem__("badFD", null);
        PyList keys = (PyList)dict.invoke("keys");
        ListIterator it = keys.listIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith("__doc__")) continue;
            it.remove();
            dict.__setitem__(key, null);
        }
        dict.__setitem__("__all__", (PyObject)keys);
        dict.__setitem__("__name__", (PyObject)new PyString(os.getModuleName()));
        dict.__setitem__("__doc__", (PyObject)__doc__);
    }

    public static void _exit() {
        PosixModule._exit(0);
    }

    public static void _exit(int status) {
        System.exit(status);
    }

    public static boolean access(PyObject path, int mode) {
        String absolutePath = PosixModule.absolutePath(path);
        File file = new File(absolutePath);
        boolean result = true;
        if (!file.exists()) {
            result = false;
        }
        if ((mode & R_OK) != 0 && !file.canRead()) {
            result = false;
        }
        if ((mode & W_OK) != 0 && !file.canWrite()) {
            result = false;
        }
        if ((mode & X_OK) != 0) {
            try {
                result = posix.stat(absolutePath).isExecutable();
            }
            catch (PyException pye) {
                if (!pye.match(Py.OSError)) {
                    throw pye;
                }
                result = false;
            }
        }
        return result;
    }

    public static void chdir(PyObject path) {
        if (!posix.stat(PosixModule.absolutePath(path)).isDirectory()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
        }
        if (realpath == null) {
            realpath = imp.load("os.path").__getattr__("realpath");
        }
        Py.getSystemState().setCurrentWorkingDir(realpath.__call__(path).asString());
    }

    public static void chmod(PyObject path, int mode) {
        if (posix.chmod(PosixModule.absolutePath(path), mode) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    @Hide(value={OS.NT})
    public static void chown(PyObject path, int uid, int gid) {
        if (posix.chown(PosixModule.absolutePath(path), uid, gid) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    public static void close(PyObject fd) {
        try {
            FileDescriptors.get(fd).close();
        }
        catch (PyException pye) {
            throw PosixModule.badFD();
        }
    }

    public static PyObject fdopen(PyObject fd) {
        return PosixModule.fdopen(fd, "r");
    }

    public static PyObject fdopen(PyObject fd, String mode) {
        return PosixModule.fdopen(fd, mode, -1);
    }

    public static PyObject fdopen(PyObject fd, String mode, int bufsize) {
        if (mode.length() == 0 || !"rwa".contains("" + mode.charAt(0))) {
            throw Py.ValueError(String.format("invalid file mode '%s'", mode));
        }
        RawIOBase rawIO = FileDescriptors.get(fd);
        if (rawIO.closed()) {
            throw PosixModule.badFD();
        }
        try {
            return new PyFile(rawIO, "<fdopen>", mode, bufsize);
        }
        catch (PyException pye) {
            if (!pye.match(Py.IOError)) {
                throw pye;
            }
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL);
        }
    }

    @Hide(value={OS.NT})
    public static void fdatasync(PyObject fd) {
        PosixModule.fsync(fd, false);
    }

    public static void fsync(PyObject fd) {
        PosixModule.fsync(fd, true);
    }

    private static void fsync(PyObject fd, boolean metadata) {
        RawIOBase rawIO = FileDescriptors.get(fd);
        rawIO.checkClosed();
        Channel channel = rawIO.getChannel();
        if (!(channel instanceof FileChannel)) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL);
        }
        try {
            ((FileChannel)channel).force(metadata);
        }
        catch (ClosedChannelException cce) {
            throw Py.ValueError("I/O operation on closed file");
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
    }

    public static void ftruncate(PyObject fd, long length) {
        try {
            FileDescriptors.get(fd).truncate(length);
        }
        catch (PyException pye) {
            throw Py.IOError(jnr.constants.platform.Errno.EBADF);
        }
    }

    public static PyObject getcwd() {
        return Py.newString(Py.getSystemState().getCurrentWorkingDir());
    }

    public static PyObject getcwdu() {
        return Py.newUnicode(Py.getSystemState().getCurrentWorkingDir());
    }

    @Hide(value={OS.NT})
    public static int getegid() {
        return posix.getegid();
    }

    @Hide(value={OS.NT})
    public static int geteuid() {
        return posix.geteuid();
    }

    @Hide(value={OS.NT})
    public static int getgid() {
        return posix.getgid();
    }

    @Hide(value={OS.NT})
    public static PyObject getlogin() {
        return new PyString(posix.getlogin());
    }

    @Hide(value={OS.NT})
    public static int getppid() {
        return posix.getppid();
    }

    @Hide(value={OS.NT})
    public static int getuid() {
        return posix.getuid();
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int getpid() {
        return posix.getpid();
    }

    @Hide(value={OS.NT})
    public static int getpgrp() {
        return posix.getpgrp();
    }

    public static boolean isatty(PyObject fdObj) {
        if (fdObj instanceof PyInteger) {
            FileDescriptor fd;
            switch (fdObj.asInt()) {
                case 0: {
                    fd = FileDescriptor.in;
                    break;
                }
                case 1: {
                    fd = FileDescriptor.out;
                    break;
                }
                case 2: {
                    fd = FileDescriptor.err;
                    break;
                }
                default: {
                    throw Py.NotImplementedError("Integer file descriptor compatibility only available for stdin, stdout and stderr (0-2)");
                }
            }
            return posix.isatty(fd);
        }
        Object tojava = fdObj.__tojava__(FileDescriptor.class);
        if (tojava != Py.NoConversion) {
            return posix.isatty((FileDescriptor)tojava);
        }
        tojava = fdObj.__tojava__(IOBase.class);
        if (tojava == Py.NoConversion) {
            throw Py.TypeError("a file descriptor is required");
        }
        return ((IOBase)tojava).isatty();
    }

    @Hide(value={OS.NT})
    public static void kill(int pid, int sig) {
        if (posix.kill(pid, sig) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT})
    public static void lchmod(PyObject path, int mode) {
        if (posix.lchmod(PosixModule.absolutePath(path), mode) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    @Hide(value={OS.NT})
    public static void lchown(PyObject path, int uid, int gid) {
        if (posix.lchown(PosixModule.absolutePath(path), uid, gid) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    @Hide(value={OS.NT})
    public static void link(PyObject src, PyObject dst) {
        if (posix.link(PosixModule.absolutePath(src), PosixModule.absolutePath(dst)) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    public static PyList listdir(PyObject path) {
        String absolutePath = PosixModule.absolutePath(path);
        File file = new File(absolutePath);
        String[] names = file.list();
        if (names == null) {
            FileStat stat = posix.stat(absolutePath);
            if (!stat.isDirectory()) {
                throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
            }
            if (!file.canRead()) {
                throw Py.OSError(jnr.constants.platform.Errno.EACCES, path);
            }
            throw Py.OSError("listdir(): an unknown error occurred: " + path);
        }
        PyList list = new PyList();
        PyString string = (PyString)path;
        for (String name : names) {
            list.append(string.createInstance(name));
        }
        return list;
    }

    public static long lseek(PyObject fd, long pos, int how) {
        try {
            return FileDescriptors.get(fd).seek(pos, how);
        }
        catch (PyException pye) {
            throw PosixModule.badFD();
        }
    }

    public static void mkdir(PyObject path) {
        PosixModule.mkdir(path, 511);
    }

    public static void mkdir(PyObject path, int mode) {
        if (posix.mkdir(PosixModule.absolutePath(path), mode) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    public static FileIO open(PyObject path, int flag) {
        return PosixModule.open(path, flag, 511);
    }

    public static FileIO open(PyObject path, int flag, int mode) {
        boolean sync;
        String absolutePath = PosixModule.absolutePath(path);
        File file = new File(absolutePath);
        boolean reading = (flag & O_RDONLY) != 0;
        boolean writing = (flag & O_WRONLY) != 0;
        boolean updating = (flag & O_RDWR) != 0;
        boolean creating = (flag & O_CREAT) != 0;
        boolean appending = (flag & O_APPEND) != 0;
        boolean truncating = (flag & O_TRUNC) != 0;
        boolean exclusive = (flag & O_EXCL) != 0;
        boolean bl = sync = (flag & O_SYNC) != 0;
        if (updating && writing) {
            throw Py.OSError(jnr.constants.platform.Errno.EINVAL, path);
        }
        if (!creating && !file.exists()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        if (!writing) {
            if (updating) {
                writing = true;
            } else {
                reading = true;
            }
        }
        if (truncating && !writing) {
            new FileIO((PyString)path, "w").close();
        }
        if (exclusive && creating) {
            try {
                if (!file.createNewFile()) {
                    throw Py.OSError(jnr.constants.platform.Errno.EEXIST, path);
                }
            }
            catch (IOException ioe) {
                throw Py.OSError(ioe);
            }
        }
        String fileIOMode = (reading ? "r" : "") + (!appending && writing ? "w" : "") + (appending && (writing || updating) ? "a" : "") + (updating ? "+" : "");
        if (sync && (writing || updating)) {
            try {
                return new FileIO(new RandomAccessFile(file, "rws").getChannel(), fileIOMode);
            }
            catch (FileNotFoundException fnfe) {
                throw Py.OSError(file.isDirectory() ? jnr.constants.platform.Errno.EISDIR : jnr.constants.platform.Errno.ENOENT, path);
            }
        }
        return new FileIO((PyString)path, fileIOMode);
    }

    public static PyObject popen(PyObject[] args, String[] kwds) {
        return imp.load("os").__getattr__("popen").__call__(args, kwds);
    }

    public static void putenv(String key, String value) {
        PyObject environ = imp.load("os").__getattr__("environ");
        environ.__setitem__(key, (PyObject)new PyString(value));
    }

    public static PyObject read(PyObject fd, int buffersize) {
        try {
            return new PyString(StringUtil.fromBytes(FileDescriptors.get(fd).read(buffersize)));
        }
        catch (PyException pye) {
            throw PosixModule.badFD();
        }
    }

    @Hide(value={OS.NT})
    public static String readlink(PyObject path) {
        try {
            return posix.readlink(PosixModule.absolutePath(path));
        }
        catch (IOException ioe) {
            throw Py.OSError(ioe);
        }
    }

    public static void remove(PyObject path) {
        PosixModule.unlink(path);
    }

    public static void rename(PyObject oldpath, PyObject newpath) {
        if (!new File(PosixModule.absolutePath(oldpath)).renameTo(new File(PosixModule.absolutePath(newpath)))) {
            PyTuple args = new PyTuple(Py.Zero, new PyString("Couldn't rename file"));
            throw new PyException(Py.OSError, args);
        }
    }

    public static void rmdir(PyObject path) {
        File file = new File(PosixModule.absolutePath(path));
        if (!file.exists()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOENT, path);
        }
        if (!file.isDirectory()) {
            throw Py.OSError(jnr.constants.platform.Errno.ENOTDIR, path);
        }
        if (!file.delete()) {
            PyTuple args = new PyTuple(Py.Zero, new PyString("Couldn't delete directory"), path);
            throw new PyException(Py.OSError, args);
        }
    }

    @Hide(value={OS.NT})
    public static void setpgrp() {
        if (posix.setpgrp(0, 0) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    @Hide(value={OS.NT})
    public static void setsid() {
        if (posix.setsid() < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    public static PyObject strerror(int code) {
        Constant errno2 = jnr.constants.platform.Errno.valueOf(code);
        if (errno2 == jnr.constants.platform.Errno.__UNKNOWN_CONSTANT__) {
            return new PyString("Unknown error: " + code);
        }
        if (errno2.name() == ((Object)errno2).toString()) {
            errno2 = Enum.valueOf(Errno.class, errno2.name());
        }
        return new PyString(((Object)errno2).toString());
    }

    @Hide(value={OS.NT})
    public static void symlink(PyObject src, PyObject dst) {
        if (posix.symlink(PosixModule.asPath(src), PosixModule.absolutePath(dst)) < 0) {
            throw PosixModule.errorFromErrno();
        }
    }

    public static PyObject system(PyObject command) {
        return imp.load("subprocess").invoke("call", command, new PyObject[]{Py.True}, new String[]{"shell"});
    }

    @Hide(posixImpl=PosixImpl.JAVA)
    public static int umask(int mask) {
        return posix.umask(mask);
    }

    public static void unlink(PyObject path) {
        String absolutePath = PosixModule.absolutePath(path);
        File file = new File(absolutePath);
        if (!file.delete()) {
            posix.stat(absolutePath);
            if (file.isDirectory()) {
                throw Py.OSError(jnr.constants.platform.Errno.EISDIR, path);
            }
            if (!file.canWrite()) {
                throw Py.OSError(jnr.constants.platform.Errno.EPERM, path);
            }
            throw Py.OSError("unlink(): an unknown error occurred" + absolutePath);
        }
    }

    public static void utime(PyObject path, PyObject times) {
        long[] mtimeval;
        long[] atimeval;
        if (times == Py.None) {
            atimeval = null;
            mtimeval = null;
        } else if (times instanceof PyTuple && times.__len__() == 2) {
            mtimeval = PosixModule.extractTimeval(times.__getitem__(0));
            atimeval = PosixModule.extractTimeval(times.__getitem__(1));
        } else {
            throw Py.TypeError("utime() arg 2 must be a tuple (atime, mtime)");
        }
        if (posix.utimes(PosixModule.absolutePath(path), mtimeval, atimeval) < 0) {
            throw PosixModule.errorFromErrno(path);
        }
    }

    private static long[] extractTimeval(PyObject seconds) {
        long[] timeval = new long[]{Platform.IS_32_BIT ? (long)seconds.asInt() : seconds.asLong(), 0L};
        if (seconds instanceof PyFloat) {
            long usec = (long)(seconds.asDouble() % 1.0 * 1000000.0);
            if (usec < 0L) {
                usec = 0L;
            }
            timeval[1] = usec;
        }
        return timeval;
    }

    @Hide(value={OS.NT})
    public static PyObject wait$() {
        int[] status = new int[1];
        int pid = posix.wait(status);
        if (pid < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(pid), Py.newInteger(status[0]));
    }

    public static PyObject waitpid(int pid, int options) {
        int[] status = new int[1];
        if ((pid = posix.waitpid(pid, status, options)) < 0) {
            throw PosixModule.errorFromErrno();
        }
        return new PyTuple(Py.newInteger(pid), Py.newInteger(status[0]));
    }

    public static int write(PyObject fd, String string) {
        try {
            return FileDescriptors.get(fd).write(ByteBuffer.wrap(StringUtil.toBytes(string)));
        }
        catch (PyException pye) {
            throw PosixModule.badFD();
        }
    }

    public static void unsetenv(String key) {
        block2: {
            PyObject environ = imp.load("os").__getattr__("environ");
            try {
                environ.__delitem__(key);
            }
            catch (PyException pye) {
                if (pye.match(Py.KeyError)) break block2;
                throw pye;
            }
        }
    }

    public static PyObject urandom(int n) {
        byte[] buf = new byte[n];
        UrandomSource.INSTANCE.nextBytes(buf);
        return new PyString(StringUtil.fromBytes(buf));
    }

    public static PyObject _get_shell_commands() {
        String[][] commands = os.getShellCommands();
        PyObject[] commandsTup = new PyObject[commands.length];
        int i = 0;
        for (String[] command : commands) {
            PyList args = new PyList();
            for (String arg : command) {
                args.append(new PyString(arg));
            }
            commandsTup[i++] = args;
        }
        return new PyTuple(commandsTup);
    }

    private static PyObject getEnviron() {
        Map<String, String> env;
        PyDictionary environ = new PyDictionary();
        try {
            env = System.getenv();
        }
        catch (SecurityException se) {
            return environ;
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            ((PyObject)environ).__setitem__(Py.newString(entry.getKey()), (PyObject)Py.newString(entry.getValue()));
        }
        return environ;
    }

    private static String asPath(PyObject path) {
        if (path instanceof PyString) {
            return path.toString();
        }
        throw Py.TypeError(String.format("coercing to Unicode: need string, %s type found", path.getType().fastGetName()));
    }

    private static String absolutePath(PyObject path) {
        return PySystemState.getPathLazy(PosixModule.asPath(path));
    }

    private static PyException badFD() {
        return Py.OSError(jnr.constants.platform.Errno.EBADF);
    }

    private static PyException errorFromErrno() {
        return Py.OSError(jnr.constants.platform.Errno.valueOf(posix.errno()));
    }

    private static PyException errorFromErrno(PyObject path) {
        return Py.OSError(jnr.constants.platform.Errno.valueOf(posix.errno()), path);
    }

    public static POSIX getPOSIX() {
        return posix;
    }

    public static String getOSName() {
        return os.getModuleName();
    }

    static {
        __doc___exit = new PyString("_exit(status)\n\nExit to the system with specified status, without normal exit processing.");
        __doc__access = new PyString("access(path, mode) -> True if granted, False otherwise\n\nUse the real uid/gid to test for access to a path.  Note that most\noperations will use the effective uid/gid, therefore this routine can\nbe used in a suid/sgid environment to test if the invoking user has the\nspecified access to the path.  The mode argument can be F_OK to test\nexistence, or the inclusive-OR of R_OK, W_OK, and X_OK.");
        __doc__chdir = new PyString("chdir(path)\n\nChange the current working directory to the specified path.");
        __doc__chmod = new PyString("chmod(path, mode)\n\nChange the access permissions of a file.");
        __doc__chown = new PyString("chown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.");
        __doc__close = new PyString("close(fd)\n\nClose a file descriptor (for low level IO).");
        __doc__fdopen = new PyString("fdopen(fd [, mode='r' [, bufsize]]) -> file_object\n\nReturn an open file object connected to a file descriptor.");
        __doc__fdatasync = new PyString("fdatasync(fildes)\n\nforce write of file with filedescriptor to disk.\ndoes not force update of metadata.");
        __doc__fsync = new PyString("fsync(fildes)\n\nforce write of file with filedescriptor to disk.");
        __doc__ftruncate = new PyString("ftruncate(fd, length)\n\nTruncate a file to a specified length.");
        __doc__getcwd = new PyString("getcwd() -> path\n\nReturn a string representing the current working directory.");
        __doc__getcwdu = new PyString("getcwd() -> path\n\nReturn a unicode string representing the current working directory.");
        __doc__getegid = new PyString("getegid() -> egid\n\nReturn the current process's effective group id.");
        __doc__geteuid = new PyString("geteuid() -> euid\n\nReturn the current process's effective user id.");
        __doc__getgid = new PyString("getgid() -> gid\n\nReturn the current process's group id.");
        __doc__getlogin = new PyString("getlogin() -> string\n\nReturn the actual login name.");
        __doc__getppid = new PyString("getppid() -> ppid\n\nReturn the parent's process id.");
        __doc__getuid = new PyString("getuid() -> uid\n\nReturn the current process's user id.");
        __doc__getpid = new PyString("getpid() -> pid\n\nReturn the current process id");
        __doc__getpgrp = new PyString("getpgrp() -> pgrp\n\nReturn the current process group id.");
        __doc__isatty = new PyString("isatty(fd) -> bool\n\nReturn True if the file descriptor 'fd' is an open file descriptor\nconnected to the slave end of a terminal.");
        __doc__kill = new PyString("kill(pid, sig)\n\nKill a process with a signal.");
        __doc__lchmod = new PyString("lchmod(path, mode)\n\nChange the access permissions of a file. If path is a symlink, this\naffects the link itself rather than the target.");
        __doc__lchown = new PyString("lchown(path, uid, gid)\n\nChange the owner and group id of path to the numeric uid and gid.\nThis function will not follow symbolic links.");
        __doc__link = new PyString("link(src, dst)\n\nCreate a hard link to a file.");
        __doc__listdir = new PyString("listdir(path) -> list_of_strings\n\nReturn a list containing the names of the entries in the directory.\n\npath: path of directory to list\n\nThe list is in arbitrary order.  It does not include the special\nentries '.' and '..' even if they are present in the directory.");
        __doc__lseek = new PyString("lseek(fd, pos, how) -> newpos\n\nSet the current position of a file descriptor.");
        __doc__mkdir = new PyString("mkdir(path [, mode=0777])\n\nCreate a directory.");
        __doc__open = new PyString("open(filename, flag [, mode=0777]) -> fd\n\nOpen a file (for low level IO).\n\nNote that the mode argument is not currently supported on Jython.");
        __doc__popen = new PyString("popen(command [, mode='r' [, bufsize]]) -> pipe\n\nOpen a pipe to/from a command returning a file object.");
        __doc__putenv = new PyString("putenv(key, value)\n\nChange or add an environment variable.");
        __doc__read = new PyString("read(fd, buffersize) -> string\n\nRead a file descriptor.");
        __doc__readlink = new PyString("readlink(path) -> path\n\nReturn a string representing the path to which the symbolic link points.");
        __doc__remove = new PyString("remove(path)\n\nRemove a file (same as unlink(path)).");
        __doc__rename = new PyString("rename(old, new)\n\nRename a file or directory.");
        __doc__rmdir = new PyString("rmdir(path)\n\nRemove a directory.");
        __doc__setpgrp = new PyString("setpgrp()\n\nMake this process a session leader.");
        __doc__setsid = new PyString("setsid()\n\nCall the system call setsid().");
        __doc__strerror = new PyString("strerror(code) -> string\n\nTranslate an error code to a message string.");
        __doc__symlink = new PyString("symlink(src, dst)\n\nCreate a symbolic link pointing to src named dst.");
        __doc__system = new PyString("system(command) -> exit_status\n\nExecute the command (a string) in a subshell.");
        __doc__umask = new PyString("umask(new_mask) -> old_mask\n\nSet the current numeric umask and return the previous umask.");
        __doc__unlink = new PyString("unlink(path)\n\nRemove a file (same as remove(path)).");
        __doc__utime = new PyString("utime(path, (atime, mtime))\nutime(path, None)\n\nSet the access and modified time of the file to the given values.  If the\nsecond form is used, set the access and modified times to the current time.");
        __doc__wait = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
        __doc__waitpid = new PyString("wait() -> (pid, status)\n\nWait for completion of a child process.");
        __doc__write = new PyString("write(fd, string) -> byteswritten\n\nWrite a string to a file descriptor.");
        __doc__unsetenv = new PyString("unsetenv(key)\n\nDelete an environment variable.");
        __doc__urandom = new PyString("urandom(n) -> str\n\nReturn a string of n random bytes suitable for cryptographic use.");
    }

    static class StatFunction
    extends PyBuiltinFunctionNarrow {
        StatFunction() {
            super("stat", 1, 1, "stat(path) -> stat result\n\nPerform a stat system call on the given path.\n\nNote that some platforms may return only a small subset of the\nstandard fields");
        }

        @Override
        public PyObject __call__(PyObject path) {
            return PyStatResult.fromFileStat(posix.stat(PosixModule.absolutePath(path)));
        }
    }

    static class LstatFunction
    extends PyBuiltinFunctionNarrow {
        LstatFunction() {
            super("lstat", 1, 1, "lstat(path) -> stat result\n\nLike stat(path), but do not follow symbolic links.");
        }

        @Override
        public PyObject __call__(PyObject path) {
            return PyStatResult.fromFileStat(posix.lstat(PosixModule.absolutePath(path)));
        }
    }

    private static class UrandomSource {
        static final SecureRandom INSTANCE = new SecureRandom();

        private UrandomSource() {
        }
    }
}

