/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import jline.ConsoleReader;
import jline.Terminal;
import jline.WindowsTerminal;
import jnr.constants.platform.Errno;
import org.python.core.PlainConsole;
import org.python.core.PyObject;
import org.python.util.ConsoleInputStream;
import org.python.util.ConsoleOutputStream;

public class JLineConsole
extends PlainConsole {
    public ConsoleReader reader;
    protected PyObject startup_hook;
    protected PyObject pre_input_hook;
    private boolean windows;
    protected static final String CTRL_Z = "\u001a";
    public static final int MAX_PROMPT = 512;
    private ConsoleOutputStream outWrapper;
    private static final List<String> SUSPENDED_STRERRORS = Arrays.asList(Errno.EINTR.description(), Errno.EIO.description());

    public JLineConsole(String encoding) {
        super(encoding);
        System.setProperty("jline.WindowsTerminal.input.encoding", this.encoding);
        System.setProperty("input.encoding", this.encoding);
    }

    @Override
    public void install() {
        Terminal.setupTerminal();
        String userHomeSpec = System.getProperty("user.home", ".");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, this.encoding));
            this.outWrapper = new ConsoleOutputStream(System.out, 512);
            System.setOut(new PrintStream((OutputStream)this.outWrapper, true, this.encoding));
            InputStream bindings = JLineConsole.getBindings(userHomeSpec, this.getClass().getClassLoader());
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            this.reader = new ConsoleReader(in, out, bindings);
            this.reader.setBellEnabled(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            File historyFile = new File(userHomeSpec, ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(historyFile);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.windows = this.reader.getTerminal() instanceof WindowsTerminal;
        Stream wrapper = new Stream();
        System.setIn(wrapper);
    }

    private String readerReadLine(String prompt) throws IOException, EOFException {
        while (true) {
            try {
                if (this.startup_hook != null) {
                    this.startup_hook.__call__();
                }
                String line = this.reader.readLine(prompt);
                return line;
            }
            catch (IOException ioe) {
                if (!this.fromSuspend(ioe)) {
                    throw ioe;
                }
                try {
                    this.reader.getTerminal().initializeTerminal();
                    prompt = "";
                }
                catch (Exception e) {
                    throw new IOException("Failed to re-initialize JLine: " + e.getMessage());
                }
            }
        }
    }

    protected static InputStream getBindings(String userHomeSpec, ClassLoader loader) {
        String bindingsFileSpec = System.getProperty("jline.keybindings");
        File bindingsFile = bindingsFileSpec != null ? new File(bindingsFileSpec) : new File(userHomeSpec, ".jlinebindings.properties");
        try {
            if (bindingsFile.isFile()) {
                try {
                    return new FileInputStream(bindingsFile);
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return loader.getResourceAsStream("org/python/util/jline-keybindings.properties");
    }

    private boolean fromSuspend(IOException ioe) {
        return !this.windows && SUSPENDED_STRERRORS.contains(ioe.getMessage());
    }

    private boolean isEOF(String line) {
        return line == null || this.windows && CTRL_Z.equals(line);
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public PyObject getStartupHook() {
        return this.startup_hook;
    }

    public void setStartupHook(PyObject hook) {
        this.startup_hook = hook;
    }

    private class Stream
    extends ConsoleInputStream {
        Stream() {
            super(System.in, JLineConsole.this.encodingCharset, ConsoleInputStream.EOLPolicy.ADD, LINE_SEPARATOR);
        }

        @Override
        protected CharSequence getLine() throws IOException, EOFException {
            String prompt = ((Object)JLineConsole.this.outWrapper.getPrompt(JLineConsole.this.encodingCharset)).toString();
            String line = JLineConsole.this.readerReadLine(prompt);
            if (!JLineConsole.this.isEOF(line)) {
                return line;
            }
            throw new EOFException();
        }
    }
}

