/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PNM_Writer
implements PlugIn {
    @Override
    public void run(String path) {
        ImagePlus img = IJ.getImage();
        boolean isGray = false;
        String extension = null;
        ImageProcessor ip = img.getProcessor();
        if (img.getBitDepth() == 24) {
            extension = ".pnm";
        } else {
            if (img.getBitDepth() == 8 && ip.isInvertedLut()) {
                ip = ip.duplicate();
                ip.invert();
            }
            if (img.getBitDepth() != 16) {
                ip = ip.convertToByte(true);
            }
            isGray = true;
            extension = ".pgm";
        }
        String title = img.getTitle();
        int length = title.length();
        for (int i = 2; i < 5; ++i) {
            if (length <= i + 1 || title.charAt(length - i) != '.') continue;
            title = title.substring(0, length - i);
            break;
        }
        if (path == null || path.equals("")) {
            SaveDialog od = new SaveDialog("PNM Writer", title, extension);
            String dir = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return;
            }
            path = dir + name;
        }
        IJ.showStatus("Writing PNM " + path + "...");
        if (img.getBitDepth() == 16) {
            this.save16BitImage(ip, path);
            return;
        }
        try {
            FileOutputStream fileOutput = new FileOutputStream(path);
            DataOutputStream output = new DataOutputStream(fileOutput);
            int w = img.getWidth();
            int h = img.getHeight();
            output.writeBytes((isGray ? "P5" : "P6") + "\n# Written by ImageJ PNM Writer\n" + w + " " + h + "\n255\n");
            if (isGray) {
                output.write((byte[])ip.getPixels(), 0, w * h);
            } else {
                byte[] pixels = new byte[w * h * 3];
                ColorProcessor proc = (ColorProcessor)ip;
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < w; ++i) {
                        int c = proc.getPixel(i, j);
                        pixels[3 * (i + w * j) + 0] = (byte)((c & 0xFF0000) >> 16);
                        pixels[3 * (i + w * j) + 1] = (byte)((c & 0xFF00) >> 8);
                        pixels[3 * (i + w * j) + 2] = (byte)(c & 0xFF);
                    }
                }
                output.write(pixels, 0, pixels.length);
            }
            output.close();
        }
        catch (IOException e) {
            IJ.handleException(e);
        }
        IJ.showStatus("");
    }

    private void save16BitImage(ImageProcessor ip, String path) {
        ip.resetMinAndMax();
        int max = (int)ip.getMax();
        if (max < 256) {
            max = 256;
        }
        try {
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            output.writeBytes("P5\n# Written by ImageJ PNM Writer\n" + ip.getWidth() + " " + ip.getHeight() + "\n" + max + "\n");
            for (int i = 0; i < ip.getPixelCount(); ++i) {
                output.writeShort(ip.get(i));
            }
            output.close();
        }
        catch (IOException e) {
            IJ.handleException(e);
        }
    }
}

