/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.particletracking.DetectionSpotTrack;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Cluster;
import plugins.nchenouard.particletracking.MHTracker.ClusterSolveLP;
import plugins.nchenouard.particletracking.MHTracker.ClusterSolveLPCustom;
import plugins.nchenouard.particletracking.MHTracker.ConstructionCluster;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.FixedThreadPool;
import plugins.nchenouard.particletracking.MHTracker.MHTrack2s;
import plugins.nchenouard.particletracking.MHTracker.ValidatedTrack;
import plugins.nchenouard.particletracking.SpotTrackingPlugin;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.legacytracker.StoppableTracker;
import plugins.nchenouard.spot.Detection;
import plugins.nchenouard.spot.Spot;

public class HMMMHTracker
implements StoppableTracker {
    final int K;
    final double gateFactor;
    final double volume;
    final double Pd;
    final double totalGateLikelihood;
    final double pDpG;
    final double pFA;
    final double pNT;
    final double pNT0;
    double p10;
    double p11;
    double pc;
    double pt;
    public final List<Predictor> initPredictors;
    boolean parallelComputing = true;
    boolean useLPSolve = true;
    private LinkedList<ValidatedTrack> validatedTracks;
    private ArrayList<Family> families;
    private LinkedList<Cluster> trackClusters;
    private ArrayList<Association> currentAssociations;
    public static volatile long totalElapseTime = 0L;
    public static volatile long compatibleElapseTime = 0L;
    public static volatile long tracksFormationTime = 0L;
    public static volatile long createClustersTime = 0L;
    public static volatile long hypothesesFormationTime = 0L;
    public static volatile long MLFormationTime = 0L;
    public static volatile long compatibleHypTime = 0L;
    public static volatile long buildGHTime = 0L;
    public static volatile long applyHypTime = 0L;
    boolean verbose = false;
    private double p1_0;

    public HMMMHTracker(List<Predictor> predictors, double volume, double gateFactor, double probaDetect, double densityFalseDetection, double densityInitialTrack, double densityNewTrack, int treeDepth, int dim, boolean useMultithreading, boolean uselPSolve) {
        this.volume = volume;
        this.initPredictors = predictors;
        this.gateFactor = Math.max(gateFactor, 0.0);
        this.Pd = probaDetect;
        this.K = Math.max(treeDepth, 0);
        this.totalGateLikelihood = predictors.get(0).getTotalGateLikelihood(true, gateFactor);
        this.pDpG = this.Pd * this.totalGateLikelihood;
        this.pFA = densityFalseDetection;
        this.pNT = densityNewTrack;
        this.pNT0 = densityInitialTrack;
        this.validatedTracks = new LinkedList();
        this.families = new ArrayList();
        this.trackClusters = new LinkedList();
        this.currentAssociations = new ArrayList();
        this.useLPSolve = uselPSolve;
        this.parallelComputing = useMultithreading;
    }

    public void changeExistenceSettings(double p10, double confirmationThreshold, double terminationThreshold) {
        this.p10 = p10;
        this.p11 = 1.0 - p10;
        this.pc = confirmationThreshold;
        this.pt = terminationThreshold;
        MHTrack2s.INIT_P10 = p10;
        MHTrack2s.INIT_P11 = 1.0 - p10;
        MHTrack2s.INIT_Pc = this.pc;
        MHTrack2s.INIT_Pt = this.pt;
    }

    protected void hypothesisFormation() {
        if (this.parallelComputing) {
            int processors = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(processors);
            final CountDownLatch latch = new CountDownLatch(this.families.size());
            for (final Family f : this.families) {
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            f.buildHypothesesAndResetBestScores();
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            service.shutdown();
            try {
                latch.await();
            }
            catch (InterruptedException E) {
                E.printStackTrace();
            }
        } else {
            for (Family f1 : this.families) {
                f1.buildHypothesesAndResetBestScores();
            }
        }
    }

    protected void createClusters(int t) {
        this.trackClusters.clear();
        LinkedList<Object> clusters = new LinkedList<Object>();
        for (Family f : this.families) {
            boolean confirmed = false;
            for (MHTrack2s mHTrack2s : f.leafs) {
                if (!mHTrack2s.confirmed) continue;
                confirmed = true;
                break;
            }
            if (!confirmed) continue;
            ConstructionCluster cl = new ConstructionCluster();
            cl.families.add(f);
            for (Association association : f.usedAssociations) {
                if (association.isPrediction) continue;
                cl.associations.add(association);
            }
            clusters.add(cl);
        }
        LinkedList<ConstructionCluster> finishedClusters = new LinkedList<ConstructionCluster>();
        while (!clusters.isEmpty()) {
            ConstructionCluster cl = (ConstructionCluster)clusters.poll();
            boolean fused = false;
            for (ConstructionCluster constructionCluster : clusters) {
                if (cl != constructionCluster) {
                    for (Association a : constructionCluster.associations) {
                        if (!cl.associations.contains(a)) continue;
                        constructionCluster.associations.addAll(cl.associations);
                        constructionCluster.families.addAll(cl.families);
                        fused = true;
                        break;
                    }
                }
                if (!fused) continue;
                break;
            }
            if (fused) continue;
            finishedClusters.add(cl);
        }
        for (ConstructionCluster cl : finishedClusters) {
            Cluster cluster = this.useLPSolve && SpotTrackingPlugin.optimizationLibraryLoaded ? new ClusterSolveLP(this, t - this.K, t, this.K, this.pFA) : new ClusterSolveLPCustom(this, t - this.K, t, this.K, this.pFA);
            for (Family family : cl.families) {
                ArrayList<Family> cFamily = cluster.concurrentFamilies.get(family.rootTime);
                if (cFamily == null) {
                    cFamily = new ArrayList();
                    cluster.concurrentFamilies.put(family.rootTime, cFamily);
                }
                cFamily.add(family);
                for (Association a : family.usedAssociations) {
                    if (a.isPrediction) continue;
                    cluster.realAssociations.add(a);
                }
            }
            cluster.initRealSpotsNum();
            this.trackClusters.add(cluster);
        }
    }

    protected void createClusters2(int t) {
        Cluster cl;
        int numCluster = 0;
        HashSet<Association> associations = new HashSet<Association>();
        ArrayList<FamilyAndAssociation> faTable = new ArrayList<FamilyAndAssociation>();
        for (Family f : this.families) {
            for (Association a : f.usedAssociations) {
                faTable.add(new FamilyAndAssociation(a, f));
                associations.add(a);
            }
        }
        this.println("create clusters #spots " + associations.size());
        HashMap<Family, Integer> familyTable = new HashMap<Family, Integer>();
        HashMap<Association, Integer> associationTable = new HashMap<Association, Integer>();
        for (Association as : associations) {
            Integer idCl = associationTable.containsKey(as) ? (Integer)associationTable.get(as) : Integer.valueOf(numCluster++);
            ArrayList<FamilyAndAssociation> associationsList = new ArrayList<FamilyAndAssociation>();
            for (FamilyAndAssociation fa : faTable) {
                if (fa.a != as) continue;
                associationsList.add(fa);
            }
            for (FamilyAndAssociation a : associationsList) {
                Integer prevCluster;
                if (familyTable.containsKey(a.f) && (prevCluster = (Integer)familyTable.get(a.f)) != idCl) {
                    for (Map.Entry e : familyTable.entrySet()) {
                        if (e.getValue() != prevCluster) continue;
                        familyTable.put((Family)e.getKey(), idCl);
                    }
                    for (Map.Entry e : associationTable.entrySet()) {
                        if (e.getValue() != prevCluster) continue;
                        associationTable.put((Association)e.getKey(), idCl);
                    }
                }
                familyTable.put(a.f, idCl);
                if (associationTable.containsKey(a) && (prevCluster = (Integer)associationTable.get(a)) != idCl) {
                    for (Map.Entry e : familyTable.entrySet()) {
                        if (e.getValue() != prevCluster) continue;
                        familyTable.put((Family)e.getKey(), idCl);
                    }
                    for (Map.Entry e : associationTable.entrySet()) {
                        if (e.getValue() != prevCluster) continue;
                        associationTable.put((Association)e.getKey(), idCl);
                    }
                }
                associationTable.put(a.a, idCl);
            }
        }
        this.trackClusters.clear();
        HashMap<Integer, Cluster> clustersTable = new HashMap<Integer, Cluster>();
        for (Map.Entry e : associationTable.entrySet()) {
            if (clustersTable.containsKey(e.getValue())) {
                cl = (Cluster)clustersTable.get(e.getValue());
            } else {
                cl = this.useLPSolve && SpotTrackingPlugin.optimizationLibraryLoaded ? new ClusterSolveLP(this, t - this.K, t, this.K, this.pFA) : new ClusterSolveLPCustom(this, t - this.K, t, this.K, this.pFA);
                clustersTable.put((Integer)e.getValue(), cl);
            }
            Association a = (Association)e.getKey();
            if (a.isPrediction) continue;
            cl.realAssociations.add(a);
        }
        for (Map.Entry e : familyTable.entrySet()) {
            if (clustersTable.containsKey(e.getValue())) {
                cl = (Cluster)clustersTable.get(e.getValue());
            } else {
                cl = this.useLPSolve ? new ClusterSolveLP(this, t - this.K, t, this.K, this.pFA) : new ClusterSolveLPCustom(this, t - this.K, t, this.K, this.pFA);
                clustersTable.put((Integer)e.getValue(), cl);
            }
            ArrayList<Family> cFamily = cl.concurrentFamilies.get(((Family)e.getKey()).rootTime);
            if (cFamily == null) {
                cFamily = new ArrayList();
                cl.concurrentFamilies.put(new Integer(((Family)e.getKey()).rootTime), cFamily);
            }
            cFamily.add((Family)e.getKey());
        }
        this.trackClusters.addAll(clustersTable.values());
        for (Cluster cl2 : this.trackClusters) {
            cl2.initRealSpotsNum();
        }
    }

    public ArrayList<TrackSegment> getTracks() {
        ArrayList<DetectionSpotTrack> detections;
        ArrayList<TrackSegment> tsList = new ArrayList<TrackSegment>();
        LinkedList<ValidatedTrack> validated = new LinkedList<ValidatedTrack>(this.validatedTracks);
        for (ValidatedTrack track : validated) {
            detections = new ArrayList<DetectionSpotTrack>();
            for (Association a : track.associations) {
                DetectionSpotTrack detect = new DetectionSpotTrack(a.spot, a.t);
                if (a.isPrediction) {
                    detect.setDetectionType(2);
                } else {
                    detect.setDetectionType(1);
                }
                detections.add(detect);
                TrackSegment motherTS = new TrackSegment(detections);
                tsList.add(motherTS);
                if (track.family.rootNode == null) continue;
                for (MHTrack2s ts : track.family.rootNode.followingSegments) {
                    TrackSegment ts2 = this.recursBuildTrackSegments(ts, tsList);
                    motherTS.addNext(ts2);
                }
            }
        }
        for (Family f : this.families) {
            if (f.rootNode == null || f.rootTrack != null) continue;
            detections = new ArrayList();
            Association a = f.rootNode.association;
            DetectionSpotTrack detect = new DetectionSpotTrack(a.spot, a.t);
            if (a.isPrediction) {
                detect.setDetectionType(2);
            } else {
                detect.setDetectionType(1);
            }
            detections.add(detect);
            TrackSegment ts = new TrackSegment(detections);
            tsList.add(ts);
            for (MHTrack2s next : f.rootNode.followingSegments) {
                TrackSegment ts2 = this.recursBuildTrackSegments(next, tsList);
                ts.addNext(ts2);
            }
        }
        return tsList;
    }

    public ArrayList<TrackSegment> getCompleteTracks() {
        ArrayList<TrackSegment> tsList = new ArrayList<TrackSegment>();
        LinkedList<ValidatedTrack> validated = new LinkedList<ValidatedTrack>(this.validatedTracks);
        for (ValidatedTrack track : validated) {
            ArrayList<Detection> detections = new ArrayList<Detection>();
            for (Association a : track.associations) {
                DetectionSpotTrack detect = new DetectionSpotTrack(a.spot, a.t);
                if (a.isPrediction) {
                    detect.setDetectionType(2);
                } else {
                    detect.setDetectionType(1);
                }
                detections.add(detect);
            }
            if (track.family != null) {
                Family f = track.family;
                if (f.lastSelectedLeaf != null) {
                    MHTrack2s mht = f.lastSelectedLeaf;
                    if (!track.associations.contains(mht.association)) {
                        MHTrack2s node = mht;
                        LinkedList<DetectionSpotTrack> detList = new LinkedList<DetectionSpotTrack>();
                        boolean stop = false;
                        while (node != null && !stop) {
                            stop = node == f.rootNode;
                            if (stop) continue;
                            Association a = node.association;
                            DetectionSpotTrack detectionSpotTrack = new DetectionSpotTrack(a.spot, a.t);
                            if (a.isPrediction) {
                                detectionSpotTrack.setDetectionType(2);
                            } else {
                                detectionSpotTrack.setDetectionType(1);
                            }
                            detList.addFirst(detectionSpotTrack);
                            node = node.precedingSegment;
                        }
                        for (Detection detection : detList) {
                            detections.add(detection);
                        }
                    }
                }
            }
            boolean stop = false;
            while (!stop && !detections.isEmpty()) {
                Detection d = (Detection)detections.get(detections.size() - 1);
                if (d.getDetectionType() == 2) {
                    detections.remove(detections.size() - 1);
                    continue;
                }
                stop = true;
            }
            TrackSegment motherTS = new TrackSegment(detections);
            tsList.add(motherTS);
        }
        return tsList;
    }

    protected void println(String text) {
        if (this.verbose) {
            System.out.println(text);
        }
    }

    protected void buildAndApplyGlobalHyp(final int t) {
        ArrayList<Family> fCopy = new ArrayList<Family>(this.families);
        this.families.clear();
        LinkedList<Family> fCluster = new LinkedList<Family>();
        for (Cluster cl : this.trackClusters) {
            for (ArrayList<Family> arrayList : cl.concurrentFamilies.values()) {
                fCluster.addAll(arrayList);
            }
        }
        for (Family f : fCopy) {
            if (fCluster.contains(f) || f.rootTime <= t - this.K + 1) continue;
            this.families.add(f);
        }
        this.println("num families before hyp selection : " + this.families.size());
        if (this.parallelComputing) {
            int processors = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(processors);
            final CountDownLatch latch = new CountDownLatch(this.trackClusters.size());
            for (final Cluster c : this.trackClusters) {
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            c.buildAndApplyBestHypTree(t);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            service.shutdown();
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (Cluster cl1 : this.trackClusters) {
                cl1.buildAndApplyBestHypTree(t);
            }
        }
        this.println("num families after hypothesis selection : " + this.families.size());
    }

    protected TrackSegment recursBuildTrackSegments(MHTrack2s trk, ArrayList<TrackSegment> tsList) {
        Association a = trk.association;
        DetectionSpotTrack detect = new DetectionSpotTrack(a.spot, a.t);
        if (a.isPrediction) {
            detect.setDetectionType(2);
        } else {
            detect.setDetectionType(1);
        }
        ArrayList<DetectionSpotTrack> detections = new ArrayList<DetectionSpotTrack>();
        detections.add(detect);
        TrackSegment ts = new TrackSegment(detections);
        tsList.add(ts);
        for (MHTrack2s next : trk.followingSegments) {
            TrackSegment ts2 = this.recursBuildTrackSegments(next, tsList);
            ts2.addNext(ts);
        }
        return ts;
    }

    protected ArrayList<Association> createAssociations(Vector<Spot> spotsVector, int t) {
        ArrayList<Association> associations = new ArrayList<Association>(spotsVector.size());
        Predictor predictor = this.initPredictors.get(0);
        double lpFA = Math.log(this.pFA);
        for (Spot s : spotsVector) {
            associations.add(new Association(predictor.buildMeasurementMatrix(s), s, false, t, lpFA));
        }
        return associations;
    }

    public double computeFalseDetectionsPenalization(int numFD) {
        return Math.pow(this.pFA, numFD);
    }

    public double computeNewTrackPenalization(int numNT, int t) {
        return 1.0;
    }

    public void track(int t, Vector<Spot> spotsVector) {
        long begin = System.currentTimeMillis();
        this.p1_0 = t == 0 ? this.pNT0 / (this.pFA + this.pNT0) : this.pNT / (this.pFA + this.pNT);
        if (this.verbose) {
            this.println("****************************** T " + t + " ******************************");
            this.println("p1_0 " + this.p1_0);
            this.println("-- time " + t + " num spots " + spotsVector.size());
        }
        long t1 = System.currentTimeMillis();
        this.currentAssociations = this.createAssociations(spotsVector, t);
        this.println("begin TracksFormation");
        this.tracksFormation(this.currentAssociations, t);
        this.println("-- time " + t + " num families " + this.families.size());
        long t2 = System.currentTimeMillis();
        tracksFormationTime += t2 - t1;
        this.println("begin HypothesisFormation");
        t1 = System.currentTimeMillis();
        this.hypothesisFormation();
        t2 = System.currentTimeMillis();
        hypothesesFormationTime += t2 - t1;
        if (this.verbose) {
            int cnt = 0;
            for (Family f : this.families) {
                cnt += f.hypotheses.size();
            }
            this.println("t " + t + "  - h " + cnt);
        }
        this.println("begin ClustersFormation");
        t1 = System.currentTimeMillis();
        this.createClusters(t);
        t2 = System.currentTimeMillis();
        createClustersTime += t2 - t1;
        this.println("-- time " + t + " num clusters " + this.trackClusters.size());
        if (this.verbose) {
            for (Cluster c : this.trackClusters) {
                int tmp = 0;
                for (ArrayList<Family> a : c.concurrentFamilies.values()) {
                    tmp += a.size();
                }
                this.println("*num families " + tmp);
            }
        }
        this.println("begin BHFormation");
        t1 = System.currentTimeMillis();
        this.buildAndApplyGlobalHyp(t);
        t2 = System.currentTimeMillis();
        buildGHTime += t2 - t1;
        this.tracksGlobalPruning();
        this.tracksMerging();
        this.tracksUpdatingAndPruning();
        long end = System.currentTimeMillis();
        totalElapseTime += end - begin;
    }

    protected void tracksGlobalPruning() {
    }

    protected void tracksFormation(final ArrayList<Association> associations, final int t) {
        if (this.parallelComputing) {
            int processors = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(processors);
            final CountDownLatch latch = new CountDownLatch(this.families.size());
            for (final Family f : this.families) {
                service.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            LinkedList<MHTrack2s> copyOfLeafs = new LinkedList<MHTrack2s>(f.leafs);
                            f.leafs.clear();
                            for (MHTrack2s trk : copyOfLeafs) {
                                if (!trk.terminated) {
                                    for (Association a : associations) {
                                        HMMMHTracker.this.tryToContinueTrack(trk, a, t, f);
                                    }
                                    MHTrack2s newTrack = trk.createPotentialTrackWithPrediction(t);
                                    f.leafs.add(newTrack);
                                    continue;
                                }
                                f.leafs.add(trk);
                            }
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            service.shutdown();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ExecutorService service2 = Executors.newFixedThreadPool(processors);
            final CountDownLatch latch2 = new CountDownLatch(associations.size() * this.initPredictors.size());
            for (final Association a : associations) {
                for (Predictor predictor : this.initPredictors) {
                    final Predictor predictor2 = predictor.copy();
                    service2.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MHTrack2s track;
                                Family f = new Family();
                                f.rootNode = track = new MHTrack2s(HMMMHTracker.this.p1_0, HMMMHTracker.this, predictor2, a, f);
                                f.leafs.add(track);
                                f.rootTime = a.t;
                                f.usedAssociations.add(track.association);
                                HMMMHTracker.this.addFamily(f);
                            }
                            finally {
                                latch2.countDown();
                            }
                        }
                    });
                }
            }
            service2.shutdown();
            try {
                latch2.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (Family f : this.families) {
                LinkedList<MHTrack2s> copyOfLeafs = new LinkedList<MHTrack2s>(f.leafs);
                f.leafs.clear();
                for (MHTrack2s trk : copyOfLeafs) {
                    if (!trk.terminated) {
                        for (Association a : associations) {
                            this.tryToContinueTrack(trk, a, t, f);
                        }
                        MHTrack2s newTrack = trk.createPotentialTrackWithPrediction(t);
                        f.leafs.add(newTrack);
                        continue;
                    }
                    f.leafs.add(trk);
                }
            }
            Iterator<Object> iterator = associations.iterator();
            while (iterator.hasNext()) {
                Association a;
                Association a2 = a = (Association)iterator.next();
                for (Predictor predictor : this.initPredictors) {
                    MHTrack2s track;
                    Family f = new Family();
                    f.rootNode = track = new MHTrack2s(this.p1_0, this, predictor.copy(), a2, f);
                    f.leafs.add(track);
                    f.rootTime = a2.t;
                    f.usedAssociations.add(track.association);
                    this.families.add(f);
                }
            }
        }
    }

    protected void tracksMerging() {
    }

    protected void tracksUpdatingAndPruning() {
        for (Family f : this.families) {
            if (f == null) continue;
            for (MHTrack2s track : f.leafs) {
                track.applyLastAssociation();
            }
        }
    }

    protected void tryToContinueTrack(MHTrack2s trk, Association a, int t, Family family) {
        if (trk.inGate(a)) {
            MHTrack2s newTrack = trk.createPotentialTrack(a, t);
            family.leafs.add(newTrack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFamily(Family f) {
        ArrayList<Family> arrayList = this.families;
        synchronized (arrayList) {
            this.families.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFamilies(Collection<Family> fList) {
        ArrayList<Family> arrayList = this.families;
        synchronized (arrayList) {
            this.families.addAll(fList);
        }
    }

    protected void finalize() throws Throwable {
        this.validatedTracks = null;
        this.families = null;
        this.trackClusters = null;
        super.finalize();
    }

    public static void resetMonitoring() {
        totalElapseTime = 0L;
        compatibleElapseTime = 0L;
        tracksFormationTime = 0L;
        createClustersTime = 0L;
        hypothesesFormationTime = 0L;
        MLFormationTime = 0L;
        compatibleHypTime = 0L;
        buildGHTime = 0L;
        applyHypTime = 0L;
    }

    public static void printMonitoring() {
        System.out.println("======= MHT monitoring =======");
        System.out.println("total time " + totalElapseTime + " | 100");
        System.out.println("tracks formation " + tracksFormationTime + " | " + (double)tracksFormationTime / (double)totalElapseTime);
        System.out.println("create Clusters " + createClustersTime + " | " + (double)createClustersTime / (double)totalElapseTime);
        System.out.println("hypotheses formation " + hypothesesFormationTime + " | " + (double)hypothesesFormationTime / (double)totalElapseTime);
        System.out.println("build Global hypotheses " + buildGHTime + " | " + (double)buildGHTime / (double)totalElapseTime);
        System.out.println("ml formation time " + MLFormationTime + " | " + (double)MLFormationTime / (double)totalElapseTime);
        System.out.println("compatible hypotheses time " + compatibleHypTime + " | " + (double)compatibleHypTime / (double)totalElapseTime);
        System.out.println("compatibility " + compatibleElapseTime + " | " + (double)compatibleElapseTime / (double)totalElapseTime);
        System.out.println("apply hyp " + applyHypTime + " | " + (double)applyHypTime / (double)totalElapseTime);
    }

    @Override
    public void stopComputing() {
    }

    @Override
    public void stopCurrentIteration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidatedTrack(ValidatedTrack vtrack) {
        LinkedList<ValidatedTrack> linkedList = this.validatedTracks;
        synchronized (linkedList) {
            this.validatedTracks.add(vtrack);
        }
    }

    class FamilyAndAssociation {
        Association a;
        Family f;

        public FamilyAndAssociation(Association a, Family f) {
            this.a = a;
            this.f = f;
        }
    }

    class BuildHypTask
    implements FixedThreadPool.Task {
        Cluster clusterTask;
        int tTask;

        public BuildHypTask(Cluster cluster, int tt) {
            this.clusterTask = cluster;
            this.tTask = tt;
        }

        @Override
        public void run() {
            this.clusterTask.buildAndApplyBestHypTree(this.tTask);
        }
    }
}

