/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.PositiveInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OBFReader
extends FormatReader {
    private static final boolean LITTLE_ENDIAN = true;
    private static final String FILE_MAGIC_STRING = "OMAS_BF\n";
    private static final String STACK_MAGIC_STRING = "OMAS_BF_STACK\n";
    private static final short MAGIC_NUMBER = -1;
    private static final int MAXIMAL_NUMBER_OF_DIMENSIONS = 15;
    private int file_version = -1;
    private transient OMEXMLMetadata ome_meta_data;
    private State state;
    private byte[] skipBuffer;
    private List<Stack> stacks = new ArrayList<Stack>();

    public OBFReader() {
        super("OBF", new String[]{"obf", "msr"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.datasetDescription = "OBF file";
    }

    private int getFileVersion(RandomAccessInputStream stream) throws IOException {
        stream.seek(0L);
        stream.order(true);
        try {
            String magicString = stream.readString(FILE_MAGIC_STRING.length());
            short magicNumber = stream.readShort();
            int version = stream.readInt();
            if (magicString.equals(FILE_MAGIC_STRING) && magicNumber == -1) {
                return version;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.getFileVersion(stream) >= 0;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.file_version = this.getFileVersion(this.in);
        this.addGlobalMeta("Version", this.file_version);
        long stackPosition = this.in.readLong();
        int lengthOfDescription = this.in.readInt();
        String description = this.in.readString(lengthOfDescription);
        this.metadata.put("Description", description);
        if (this.file_version >= 2) {
            long meta_data_position = this.in.readLong();
            long current_position = this.in.getFilePointer();
            this.in.seek(meta_data_position);
            String key = this.readString();
            while (key.length() > 0) {
                if (key.equals("ome_xml")) {
                    String ome_xml = this.readString();
                    LOGGER.trace("OME-xml = {}", (Object)ome_xml);
                    try {
                        ServiceFactory factory = new ServiceFactory();
                        OMEXMLService service = factory.getInstance(OMEXMLService.class);
                        if (!service.validateOMEXML(ome_xml)) break;
                        this.ome_meta_data = service.createOMEXMLMetadata(ome_xml);
                        for (int image = 0; image != this.ome_meta_data.getImageCount(); ++image) {
                            if (this.ome_meta_data.getPixelsBigEndian(image) == null) {
                                this.ome_meta_data.setPixelsBigEndian(Boolean.FALSE, image);
                            }
                            int channels = this.ome_meta_data.getChannelCount(image);
                            for (int channel = 0; channel != channels; ++channel) {
                                if (this.ome_meta_data.getChannelSamplesPerPixel(image, channel) != null) continue;
                                this.ome_meta_data.setChannelSamplesPerPixel(new PositiveInteger(1), image, channel);
                            }
                        }
                        service.convertMetadata(this.ome_meta_data, this.metadataStore);
                        OMEXMLMetadata reference = service.getOMEMetadata(service.asRetrieve(this.metadataStore));
                        for (int image = 0; image != reference.getImageCount(); ++image) {
                            service.addMetadataOnly(reference, image);
                        }
                        break;
                    }
                    catch (DependencyException exception) {
                        throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, exception);
                    }
                    catch (ServiceException exception) {
                        throw new FormatException(exception);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not parse OME-XML metadata", e);
                        break;
                    }
                }
                this.addGlobalMeta(key, this.readString());
                key = this.readString();
            }
            this.in.seek(current_position);
        }
        if (stackPosition != 0L) {
            this.core.clear();
            while ((stackPosition = this.initStack(stackPosition)) != 0L) {
            }
        }
        if (this.ome_meta_data == null) {
            MetadataTools.populatePixels(this.metadataStore, this);
            for (int image = 0; image != this.core.size(); ++image) {
                Length physicalSizeZ;
                CoreMetadata meta_data = (CoreMetadata)this.core.get(image);
                String name = meta_data.seriesMetadata.get("Name").toString();
                this.metadataStore.setImageName(name.trim(), image);
                List lengths = (List)meta_data.seriesMetadata.get("Lengths");
                if (lengths.size() > 0) {
                    Length physicalSizeX;
                    double lengthX = Math.abs((Double)lengths.get(0));
                    if (lengthX < 0.01) {
                        lengthX *= 1000000.0;
                    }
                    if (lengthX > 0.0 && (physicalSizeX = FormatTools.getPhysicalSizeX((Double)(lengthX / (double)meta_data.sizeX), UNITS.MICROMETER)) != null) {
                        this.metadataStore.setPixelsPhysicalSizeX(physicalSizeX, image);
                    }
                }
                if (lengths.size() > 1) {
                    Length physicalSizeY;
                    double lengthY = Math.abs((Double)lengths.get(1));
                    if (lengthY < 0.01) {
                        lengthY *= 1000000.0;
                    }
                    if (lengthY > 0.0 && (physicalSizeY = FormatTools.getPhysicalSizeY((Double)(lengthY / (double)meta_data.sizeY), UNITS.MICROMETER)) != null) {
                        this.metadataStore.setPixelsPhysicalSizeY(physicalSizeY, image);
                    }
                }
                if (lengths.size() <= 2) continue;
                double lengthZ = Math.abs((Double)lengths.get(2));
                if (lengthZ < 0.01) {
                    lengthZ *= 1000000.0;
                }
                if (!(lengthZ > 0.0) || (physicalSizeZ = FormatTools.getPhysicalSizeZ((Double)(lengthZ / (double)meta_data.sizeZ), UNITS.MICROMETER)) == null) continue;
                this.metadataStore.setPixelsPhysicalSizeZ(physicalSizeZ, image);
            }
        }
    }

    private long initStack(long current) throws FormatException, IOException {
        this.in.seek(current);
        String magicString = this.in.readString(STACK_MAGIC_STRING.length());
        short magicNumber = this.in.readShort();
        int stackVersion = this.in.readInt();
        this.addGlobalMeta("Stack version", stackVersion);
        if (magicString.equals(STACK_MAGIC_STRING) && magicNumber == -1) {
            int image = this.core.size();
            CoreMetadata meta_data = new CoreMetadata();
            this.core.add(meta_data);
            meta_data.littleEndian = true;
            meta_data.thumbnail = false;
            int numberOfDimensions = this.in.readInt();
            if (numberOfDimensions > 5) {
                throw new FormatException("Unsupported number of " + numberOfDimensions + " dimensions");
            }
            Stack stack = new Stack();
            stack.samplesWritten = 1L;
            int[] sizes = new int[15];
            for (int dimension = 0; dimension != 15; ++dimension) {
                int size = this.in.readInt();
                if (dimension < numberOfDimensions) {
                    stack.samplesWritten *= (long)size;
                }
                sizes[dimension] = dimension < numberOfDimensions ? size : 1;
            }
            if (this.ome_meta_data != null) {
                meta_data.sizeX = (Integer)this.ome_meta_data.getPixelsSizeX(image).getValue();
                meta_data.sizeY = (Integer)this.ome_meta_data.getPixelsSizeY(image).getValue();
                meta_data.sizeZ = (Integer)this.ome_meta_data.getPixelsSizeZ(image).getValue();
                meta_data.sizeC = (Integer)this.ome_meta_data.getPixelsSizeC(image).getValue();
                meta_data.sizeT = (Integer)this.ome_meta_data.getPixelsSizeT(image).getValue();
            } else {
                meta_data.sizeX = sizes[0];
                meta_data.sizeY = sizes[1];
                meta_data.sizeZ = sizes[2];
                meta_data.sizeC = sizes[3];
                meta_data.sizeT = sizes[4];
            }
            meta_data.imageCount = meta_data.sizeZ * meta_data.sizeC * meta_data.sizeT;
            if (this.ome_meta_data != null) {
                meta_data.dimensionOrder = this.ome_meta_data.getPixelsDimensionOrder(image).toString();
                meta_data.orderCertain = true;
            } else {
                meta_data.dimensionOrder = "XYZCT";
                meta_data.orderCertain = false;
            }
            ArrayList<Double> lengths = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double length = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                lengths.add(new Double(length));
            }
            meta_data.seriesMetadata.put("Lengths", lengths);
            ArrayList<Double> offsets = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double offset = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                offsets.add(new Double(offset));
            }
            meta_data.seriesMetadata.put("Offsets", offsets);
            int type = this.in.readInt();
            meta_data.pixelType = this.getPixelType(type);
            meta_data.bitsPerPixel = this.getBitsPerPixel(type);
            stack.bytesPerSample = meta_data.bitsPerPixel / 8;
            meta_data.indexed = false;
            meta_data.rgb = false;
            meta_data.interleaved = false;
            int compression = this.in.readInt();
            stack.compression = this.getCompression(compression);
            this.in.skipBytes(4);
            int lengthOfName = this.in.readInt();
            int lengthOfDescription = this.in.readInt();
            this.in.skipBytes(8);
            long lengthOfData = this.in.readLong();
            stack.length = this.getLength(lengthOfData);
            long next = this.in.readLong();
            String name = this.in.readString(lengthOfName);
            meta_data.seriesMetadata.put("Name", name);
            String description = this.in.readString(lengthOfDescription);
            if (description != null && lengthOfDescription > 0) {
                description = XMLTools.sanitizeXML(description);
                description = description.replaceAll("<Time Lapse ", "<TimeLapse ");
                description = description.replaceAll("</Time Lapse", "</TimeLapse");
                boolean xml = false;
                try {
                    Element root = XMLTools.parseDOM(description).getDocumentElement();
                    root = this.getChildNodes(root).get(0);
                    ArrayList<Element> children = this.getChildNodes(root);
                    for (Element child : children) {
                        String nodeName = child.getNodeName();
                        ArrayList<Element> grandchildren = this.getChildNodes(child);
                        for (Element grandchild : grandchildren) {
                            String key = grandchild.getNodeName();
                            String value = grandchild.getTextContent().trim();
                            if (!key.equals("doc") && !key.equals("hwr")) {
                                this.addSeriesMeta(nodeName + " " + key, value);
                                continue;
                            }
                            ArrayList<Element> docs = this.getChildNodes(grandchild);
                            for (Element doc : docs) {
                                key = doc.getNodeName();
                                value = doc.getTextContent().trim();
                                this.addSeriesMeta(nodeName + " " + key, value);
                            }
                        }
                    }
                    xml = true;
                }
                catch (ParserConfigurationException e) {
                    LOGGER.warn("Could not parse description as XML", e);
                }
                catch (SAXException e) {
                    LOGGER.warn("Could not parse description as XML", e);
                }
                if (!xml) {
                    meta_data.seriesMetadata.put("Description", description);
                }
            }
            stack.position = this.in.getFilePointer();
            if (stackVersion >= 1) {
                this.in.skip(lengthOfData);
                long footer = this.in.getFilePointer();
                int offset = this.in.readInt();
                ArrayList<Boolean> stepsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepsPresent.add(new Boolean(present != 0));
                }
                ArrayList<Boolean> stepLabelsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepLabelsPresent.add(new Boolean(present != 0));
                }
                int obsoleteMetadataLength = 0;
                long numFlushPoints = 0L;
                if (stackVersion >= 3) {
                    int SI_UNIT_SIZE = 80;
                    obsoleteMetadataLength = this.in.readInt();
                    this.in.skipBytes(1280);
                    numFlushPoints = this.in.readLong();
                    stack.flushBlockSize = this.in.readLong();
                }
                long tagDictionaryLength = 0L;
                long stackEndDisk = 0L;
                int minFormatVersion = 0;
                if (stackVersion >= 4) {
                    tagDictionaryLength = this.in.readLong();
                    stackEndDisk = this.in.readLong();
                    minFormatVersion = this.in.readInt();
                }
                long stackEndUsedDisk = 0L;
                long numChunkPositions = 0L;
                if (stackVersion >= 6) {
                    stackEndUsedDisk = this.in.readLong();
                    stack.samplesWritten = this.in.readLong();
                    numChunkPositions = this.in.readLong();
                }
                this.in.seek(footer + (long)offset);
                ArrayList<String> labels = new ArrayList<String>();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    int length = this.in.readInt();
                    String label = this.in.readString(length);
                    labels.add(label);
                    if (label.endsWith("X") && meta_data.sizeX == 0 || dimension == 1 && this.isFLIMLabel((String)labels.get(0))) {
                        meta_data.sizeX = sizes[dimension];
                        continue;
                    }
                    if (label.endsWith("Y") && meta_data.sizeY == 0 || dimension == 2 && this.isFLIMLabel((String)labels.get(0))) {
                        meta_data.sizeY = sizes[dimension];
                        continue;
                    }
                    if (!this.isFLIMLabel(label)) continue;
                    meta_data.sizeZ = sizes[dimension];
                    meta_data.moduloZ.type = "Lifetime";
                    meta_data.moduloZ.typeDescription = label;
                    meta_data.moduloZ.start = 0.0;
                    meta_data.moduloZ.step = 1.0;
                    meta_data.moduloZ.end = meta_data.sizeZ - 1;
                    meta_data.imageCount = meta_data.sizeZ * meta_data.sizeC * meta_data.sizeT;
                }
                meta_data.seriesMetadata.put("Labels", labels);
                ArrayList steps = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    if (((Boolean)stepsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            double step = this.in.readDouble();
                            list.add(new Double(step));
                        }
                    }
                    steps.add(list);
                }
                meta_data.seriesMetadata.put("Steps", steps);
                ArrayList stepLabels = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (((Boolean)stepLabelsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            int length = this.in.readInt();
                            String label = this.in.readString(length);
                            list.add(label);
                        }
                    }
                    stepLabels.add(list);
                }
                meta_data.seriesMetadata.put("StepLabels", stepLabels);
                this.in.skipBytes(obsoleteMetadataLength);
                if (numFlushPoints > 0L) {
                    if (numFlushPoints > Integer.MAX_VALUE) {
                        throw new FormatException("The implementation can not currently handle more than Integer.MAX_VALUE flush points");
                    }
                    ArrayList<Long> flushPoints = new ArrayList<Long>((int)numFlushPoints);
                    int i = 0;
                    while ((long)i < numFlushPoints) {
                        flushPoints.add(this.in.readLong());
                        ++i;
                    }
                    stack.flushPoints = flushPoints;
                }
                this.in.skipBytes(tagDictionaryLength);
                if (numChunkPositions > 0L) {
                    if (numChunkPositions > Integer.MAX_VALUE) {
                        throw new FormatException("The implementation can not currently handle more than Integer.MAX_VALUE chunk positions");
                    }
                    ArrayList<Long> logicalPositions = new ArrayList<Long>((int)numChunkPositions + 1);
                    ArrayList<Long> filePositions = new ArrayList<Long>((int)numChunkPositions + 1);
                    logicalPositions.add(0L);
                    filePositions.add(0L);
                    int i = 0;
                    while ((long)i < numChunkPositions) {
                        logicalPositions.add(this.in.readLong());
                        filePositions.add(this.in.readLong());
                        ++i;
                    }
                    stack.chunkLogicalPositions = logicalPositions;
                    stack.chunkFilePositions = filePositions;
                }
            }
            this.stacks.add(stack);
            return next;
        }
        throw new FormatException("Unsupported stack format");
    }

    private boolean isFLIMLabel(String label) {
        return label.startsWith("SPCM");
    }

    private int getPixelType(int type) throws FormatException {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private int getBitsPerPixel(int type) throws FormatException {
        switch (type) {
            case 1: 
            case 2: {
                return 8;
            }
            case 4: 
            case 8: {
                return 16;
            }
            case 16: 
            case 32: {
                return 32;
            }
            case 64: {
                return 32;
            }
            case 128: {
                return 64;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private long getLength(long length) throws FormatException {
        if (length >= 0L) {
            return length;
        }
        throw new FormatException("Negative stack length on disk");
    }

    private boolean getCompression(int compression) throws FormatException {
        switch (compression) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new FormatException("Unsupported compression " + compression);
    }

    private String readString() throws IOException {
        int length = this.in.readInt();
        if (length > 0) {
            return this.in.readString(length);
        }
        return "";
    }

    private long remainingBytesInChunk(Stack stack) throws IOException, FormatException {
        long result = this.state.chunkFileStart + this.state.chunkSize - this.in.getFilePointer();
        if (result < 0L) {
            throw new FormatException("Negative remaining bytes in chunk; malformed file?");
        }
        return result;
    }

    private void readFromStackRaw(Stack stack, byte[] buffer, int bufferOffset, int bytes) throws IOException, FormatException {
        long remainingBytesInChunk = this.remainingBytesInChunk(stack);
        while (bytes > 0) {
            while (remainingBytesInChunk == 0L) {
                this.switchChunk(stack, this.state.currentChunk + 1);
                this.in.seek(this.state.chunkFileStart);
                remainingBytesInChunk = this.remainingBytesInChunk(stack);
            }
            int bytesToRead = (int)Math.min((long)bytes, remainingBytesInChunk);
            if (buffer != null) {
                this.in.read(buffer, bufferOffset, bytesToRead);
            } else {
                this.in.skipBytes(bytesToRead);
            }
            bufferOffset += bytesToRead;
            remainingBytesInChunk -= (long)bytesToRead;
            bytes -= bytesToRead;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readFromStack(Stack stack, byte[] buffer, int bufferOffset, int bytes) throws IOException, FormatException {
        int remainingBytes = bytes;
        long stackByteCount = stack.samplesWritten * (long)stack.bytesPerSample;
        if (!stack.compression) {
            this.readFromStackRaw(stack, buffer, bufferOffset, bytes);
        } else if (stack.compression) {
            Inflater inflater = this.state.inflater;
            byte[] input = this.state.inflateInputBuffer;
            while (remainingBytes > 0) {
                if (inflater.needsInput()) {
                    long logicalOffset = this.state.chunkLogicalStart + (this.in.getFilePointer() - this.state.chunkFileStart);
                    long remainder = stackByteCount - logicalOffset;
                    if (remainder <= 0L) throw new FormatException("Corrupted zlib compression");
                    int length = remainder > (long)input.length ? input.length : (int)remainder;
                    this.readFromStackRaw(stack, input, 0, length);
                    inflater.setInput(input, 0, length);
                } else if (inflater.needsDictionary()) {
                    throw new FormatException("Unsupported zlib compression");
                }
                long bytesWrittenBefore = inflater.getBytesWritten();
                try {
                    int decompressedBytes = inflater.inflate(buffer, bufferOffset, remainingBytes);
                    bufferOffset += decompressedBytes;
                    remainingBytes -= decompressedBytes;
                }
                catch (DataFormatException exception) {
                    long bytesWrittenAfter = inflater.getBytesWritten();
                    long decompressedBytes = bytesWrittenAfter - bytesWrittenBefore;
                    bufferOffset = (int)((long)bufferOffset + decompressedBytes);
                    remainingBytes = (int)((long)remainingBytes - decompressedBytes);
                    if (remainingBytes != 0) {
                        throw new FormatException("Error while deflating stream, upgrading to Java 11 or later may help", exception);
                    }
                    LOGGER.warn("Error past the end of deflated stream", exception);
                }
            }
        }
        this.state.nextReadPosition += (long)bytes;
    }

    private void switchChunk(Stack stack, int chunkIndex) throws FormatException {
        if (chunkIndex >= stack.chunkLogicalPositions.size()) {
            throw new FormatException("Missing OBF data chunks");
        }
        this.state.currentChunk = chunkIndex;
        this.state.chunkLogicalStart = stack.chunkLogicalPositions.get(chunkIndex);
        this.state.chunkFileStart = stack.chunkFilePositions.get(chunkIndex) + stack.position;
        this.state.chunkSize = chunkIndex + 1 == stack.chunkLogicalPositions.size() ? stack.samplesWritten * (long)stack.bytesPerSample - this.state.chunkLogicalStart : stack.chunkLogicalPositions.get(chunkIndex + 1) - this.state.chunkLogicalStart;
    }

    private void seekToFrameStart(Stack stack, long sampleOffset) throws IOException, FormatException {
        int flushBlockIndex;
        boolean hasChunks = stack.chunkLogicalPositions != null;
        long stackByteOffset = sampleOffset * (long)stack.bytesPerSample;
        if (this.state.nextReadPosition == stackByteOffset) {
            return;
        }
        this.state.nextReadPosition = stackByteOffset;
        if (!hasChunks) {
            this.state.chunkLogicalStart = 0L;
            this.state.chunkFileStart = stack.position;
            this.state.chunkSize = stack.samplesWritten * (long)stack.bytesPerSample;
            if (!stack.compression) {
                this.in.seek(stack.position + stackByteOffset);
                return;
            }
        }
        long seekDestination = 0L;
        long extraSkipBytes = stackByteOffset;
        if (stack.flushPoints != null && stack.flushBlockSize != 0L && (flushBlockIndex = (int)(stackByteOffset / stack.flushBlockSize)) > 0) {
            seekDestination = stack.flushPoints.get(flushBlockIndex - 1);
            extraSkipBytes -= (long)flushBlockIndex * stack.flushBlockSize;
        }
        if (stack.compression) {
            this.state.inflater = new Inflater(seekDestination != 0L);
            if (this.state.inflateInputBuffer == null) {
                this.state.inflateInputBuffer = new byte[8192];
            }
        }
        if (!hasChunks) {
            this.in.seek(stack.position + seekDestination);
            this.skipBytes(stack, extraSkipBytes);
            return;
        }
        this.switchChunk(stack, Collections.binarySearch(stack.chunkLogicalPositions, seekDestination));
        this.in.seek(this.state.chunkFileStart + seekDestination - this.state.chunkLogicalStart);
        this.skipBytes(stack, extraSkipBytes);
    }

    private void skipBytes(Stack stack, long byteCount) throws IOException, FormatException {
        boolean hasChunks;
        boolean bl = hasChunks = stack.chunkLogicalPositions != null;
        if (!stack.compression && !hasChunks) {
            this.in.skipBytes(byteCount);
            this.state.nextReadPosition += byteCount;
        } else if (stack.compression) {
            if (this.skipBuffer == null) {
                this.skipBuffer = new byte[8192];
            }
            while (byteCount > 0L) {
                int readSize = (int)Math.min((long)this.skipBuffer.length, byteCount);
                this.readFromStack(stack, this.skipBuffer, 0, readSize);
                byteCount -= (long)readSize;
            }
        } else {
            while (byteCount > 0L) {
                int skipSize = (int)Math.min(byteCount, Integer.MAX_VALUE);
                this.readFromStackRaw(stack, null, 0, skipSize);
                byteCount -= (long)skipSize;
            }
        }
    }

    private void readStackFrame(Stack stack, long sampleOffset, byte[] buffer, int bufferOffset, int w, int h2) throws IOException, FormatException {
        long rows;
        long columns = this.getSizeX();
        long frameSamplesTotal = columns * (rows = (long)this.getSizeY());
        long frameBytesWritten = Math.max(Math.min(stack.samplesWritten - sampleOffset, frameSamplesTotal) * (long)stack.bytesPerSample, 0L);
        if (frameBytesWritten > 0L) {
            this.seekToFrameStart(stack, sampleOffset);
        }
        long rowSkipBytes = (columns - (long)w) * (long)stack.bytesPerSample;
        int currentBufferOffset = bufferOffset;
        for (int y = 0; y < h2; ++y) {
            if (y != 0 && rowSkipBytes > 0L) {
                long writtenSkipBytes = Math.min(rowSkipBytes, frameBytesWritten);
                this.skipBytes(stack, writtenSkipBytes);
                frameBytesWritten -= writtenSkipBytes;
            }
            int totalRowBytes = w * stack.bytesPerSample;
            int writtenRowBytes = (int)Math.min((long)totalRowBytes, frameBytesWritten);
            int unwrittenRowBytes = Math.max(w - writtenRowBytes, 0);
            if (writtenRowBytes > 0) {
                this.readFromStack(stack, buffer, currentBufferOffset, writtenRowBytes);
                currentBufferOffset += writtenRowBytes;
                frameBytesWritten -= (long)writtenRowBytes;
            }
            if (unwrittenRowBytes <= 0) continue;
            Arrays.fill(buffer, currentBufferOffset, currentBufferOffset + unwrittenRowBytes, (byte)0);
        }
    }

    private void readFlimFrame(Stack stack, int no, byte[] buffer, int x, int y, int w, int h2) throws IOException, FormatException {
        if (this.state.wholeStackBuffer == null) {
            int wholeStackSize = this.getSizeX() * this.getSizeY() * this.getSizeZ() * stack.bytesPerSample;
            this.state.wholeStackBuffer = new byte[wholeStackSize];
            this.seekToFrameStart(stack, 0L);
            this.readFromStack(stack, this.state.wholeStackBuffer, 0, (int)stack.samplesWritten * stack.bytesPerSample);
        }
        byte[] wholeStackBuffer = this.state.wholeStackBuffer;
        int bytesPerSample = stack.bytesPerSample;
        int width = this.getSizeX();
        int lifetimeCount = this.getSizeZ();
        for (int yy = y; yy < y + h2; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                int sourcePosition = lifetimeCount * bytesPerSample * (yy * width + xx) + no * bytesPerSample;
                int destinationPosition = (yy - y) * w * bytesPerSample + (xx - x) * bytesPerSample;
                System.arraycopy(wholeStackBuffer, sourcePosition, buffer, destinationPosition, bytesPerSample);
            }
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buffer, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buffer.length, x, y, w, h2);
        int series = this.getSeries();
        if (this.state == null || this.state.series != series) {
            this.state = new State(series);
        }
        long rows = this.getSizeY();
        long columns = this.getSizeX();
        boolean isFLIM = "Lifetime".equals(this.getModuloZ().type);
        Stack stack = this.stacks.get(series);
        if (isFLIM) {
            this.readFlimFrame(stack, no, buffer, x, y, w, h2);
        } else {
            long frameStartSampleOffset = (long)no * rows * columns + (long)y * columns + (long)x;
            this.readStackFrame(stack, frameStartSampleOffset, buffer, 0, w, h2);
        }
        return buffer;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (!fileOnly) {
            this.state = null;
            this.skipBuffer = null;
            this.file_version = -1;
            this.ome_meta_data = null;
            this.stacks.clear();
        }
        super.close(fileOnly);
    }

    private ArrayList<Element> getChildNodes(Element root) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            list.add((Element)child);
        }
        return list;
    }

    private class State {
        Inflater inflater;
        byte[] inflateInputBuffer;
        byte[] wholeStackBuffer;
        int series = -1;
        long nextReadPosition = -1L;
        int currentChunk = -1;
        long chunkLogicalStart = 0L;
        long chunkFileStart = 0L;
        long chunkSize = 0L;

        State(int series) {
            this.series = series;
        }
    }

    private class Stack {
        long position;
        long length;
        boolean compression;
        long samplesWritten = -1L;
        int bytesPerSample = 0;
        List<Long> flushPoints;
        long flushBlockSize = 0L;
        List<Long> chunkLogicalPositions;
        List<Long> chunkFilePositions;

        private Stack() {
        }
    }
}

