/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.SequenceFileGroupImporter;
import icy.file.SequenceFileImporter;
import icy.file.SequenceFileSticher;
import icy.gui.component.PopupPanel;
import icy.gui.component.RangeComponent;
import icy.gui.component.Region2DComponent;
import icy.gui.component.SpecialValueSpinner;
import icy.gui.component.ThumbnailComponent;
import icy.gui.component.model.SpecialValueSpinnerModel;
import icy.image.IcyBufferedImage;
import icy.resource.ResourceUtil;
import icy.sequence.MetaDataUtil;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.type.collection.CollectionUtil;
import icy.util.OMEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ome.xml.meta.OMEXMLMetadata;
import plugins.kernel.importer.LociImporterPlugin;

public class LoaderOptionPanel
extends JPanel {
    private static final long serialVersionUID = 4180367632912879286L;
    protected ThumbnailComponent preview;
    protected JPanel optionsPanel;
    protected PopupPanel popupPanel;
    protected JComboBox loadingTypeCombo;
    protected JLabel loadInSeparatedLabel;
    protected JSlider resolutionSlider;
    protected JLabel resolutionLevelLabel;
    protected JLabel zRangeLabel;
    protected JLabel tRangeLabel;
    protected JLabel channelLabel;
    protected RangeComponent zRangeComp;
    protected RangeComponent tRangeComp;
    protected SpecialValueSpinner channelSpinner;
    protected JLabel resolutionFixLabel;
    protected JToggleButton xyRegionLoadingToggle;
    protected JLabel seriesLabel;
    protected SpecialValueSpinner seriesSpinner;
    protected Region2DComponent xyRegionComp;
    protected boolean metadataFieldsOk = false;
    protected PreviewUpdater previewUpdater;
    protected OMEXMLMetadata metadata = null;
    protected int series = -1;
    protected int pZMin = -1;
    protected int pZMax = -1;
    protected int pTMin = -1;
    protected int pTMax = -1;
    protected int pCh = -1;
    protected boolean updatingPanel = false;

    public LoaderOptionPanel(LoaderLoadingType loadType) {
        this.initialize(loadType);
        this.previewUpdater = new PreviewUpdater();
        this.previewUpdater.start();
        this.updatePanel();
    }

    private void initialize(LoaderLoadingType loadType) {
        this.setBorder(BorderFactory.createTitledBorder((Border)null));
        this.setLayout(new BorderLayout());
        this.preview = new ThumbnailComponent(false);
        this.preview.setMinimumSize(new Dimension(200, 160));
        this.preview.setPreferredSize(new Dimension(240, 200));
        this.preview.setShortDisplay(true);
        this.add((Component)this.preview, "Center");
        this.optionsPanel = new JPanel();
        this.popupPanel = new PopupPanel("Advanced options", this.optionsPanel);
        this.popupPanel.setExpanded(true);
        this.add((Component)this.popupPanel, "South");
        GridBagLayout gbl_optionsPanel = new GridBagLayout();
        gbl_optionsPanel.columnWidths = new int[]{0, 100, 0, 0, 0};
        gbl_optionsPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_optionsPanel.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gbl_optionsPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.optionsPanel.setLayout(gbl_optionsPanel);
        GridBagConstraints gbc_loadInSeparatedLabel = new GridBagConstraints();
        gbc_loadInSeparatedLabel.anchor = 17;
        gbc_loadInSeparatedLabel.insets = new Insets(0, 0, 5, 5);
        gbc_loadInSeparatedLabel.gridx = 0;
        gbc_loadInSeparatedLabel.gridy = 0;
        this.loadInSeparatedLabel = new JLabel("Load type");
        this.loadInSeparatedLabel.setToolTipText("Define if we try to group files / series or not (and eventually automatic set Z, T, C ordering from file name)");
        this.optionsPanel.add((Component)this.loadInSeparatedLabel, gbc_loadInSeparatedLabel);
        this.loadingTypeCombo = new JComboBox();
        this.loadingTypeCombo.setToolTipText("Define if we try to group files or not (and eventually automatic set Z, T, C ordering from file name)");
        this.loadingTypeCombo.setModel(new DefaultComboBoxModel<LoaderLoadingType>(LoaderLoadingType.values()));
        this.loadingTypeCombo.setSelectedIndex(loadType.ordinal());
        this.loadingTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderOptionPanel.this.loadingTypeChanged();
            }
        });
        GridBagConstraints gbc_loadingTypeCombo = new GridBagConstraints();
        gbc_loadingTypeCombo.fill = 2;
        gbc_loadingTypeCombo.gridwidth = 3;
        gbc_loadingTypeCombo.insets = new Insets(0, 0, 5, 0);
        gbc_loadingTypeCombo.gridx = 1;
        gbc_loadingTypeCombo.gridy = 0;
        this.optionsPanel.add((Component)this.loadingTypeCombo, gbc_loadingTypeCombo);
        this.seriesLabel = new JLabel("Series");
        this.seriesLabel.setToolTipText("Series to load (only for multi serie image)");
        GridBagConstraints gbc_seriesLabel = new GridBagConstraints();
        gbc_seriesLabel.anchor = 17;
        gbc_seriesLabel.insets = new Insets(0, 0, 5, 5);
        gbc_seriesLabel.gridx = 0;
        gbc_seriesLabel.gridy = 1;
        this.optionsPanel.add((Component)this.seriesLabel, gbc_seriesLabel);
        this.seriesSpinner = new SpecialValueSpinner(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
        this.seriesSpinner.setPreferredSize(new Dimension(50, 22));
        this.seriesSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoaderOptionPanel.this.seriesChanged();
            }
        });
        this.seriesSpinner.setToolTipText("Series to load (only for multi serie image)");
        GridBagConstraints gbc_seriesSpinner = new GridBagConstraints();
        gbc_seriesSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_seriesSpinner.anchor = 17;
        gbc_seriesSpinner.gridx = 1;
        gbc_seriesSpinner.gridy = 1;
        this.optionsPanel.add((Component)this.seriesSpinner, gbc_seriesSpinner);
        this.channelLabel = new JLabel("Channel");
        this.channelLabel.setToolTipText("Channel to load");
        GridBagConstraints gbc_channelLabel = new GridBagConstraints();
        gbc_channelLabel.anchor = 13;
        gbc_channelLabel.insets = new Insets(0, 0, 5, 5);
        gbc_channelLabel.gridx = 2;
        gbc_channelLabel.gridy = 1;
        this.optionsPanel.add((Component)this.channelLabel, gbc_channelLabel);
        this.channelSpinner = new SpecialValueSpinner(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
        this.channelSpinner.setPreferredSize(new Dimension(50, 22));
        this.channelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoaderOptionPanel.this.rangeChanged();
            }
        });
        this.channelSpinner.setToolTipText("Channel to load");
        GridBagConstraints gbc_channelSpinner = new GridBagConstraints();
        gbc_channelSpinner.anchor = 13;
        gbc_channelSpinner.insets = new Insets(0, 0, 5, 0);
        gbc_channelSpinner.gridx = 3;
        gbc_channelSpinner.gridy = 1;
        this.optionsPanel.add((Component)this.channelSpinner, gbc_channelSpinner);
        this.resolutionFixLabel = new JLabel("Resolution");
        this.resolutionFixLabel.setToolTipText("Select resolution level to open");
        GridBagConstraints gbc_resolutionFixLabel = new GridBagConstraints();
        gbc_resolutionFixLabel.anchor = 17;
        gbc_resolutionFixLabel.insets = new Insets(0, 0, 5, 5);
        gbc_resolutionFixLabel.gridx = 0;
        gbc_resolutionFixLabel.gridy = 2;
        this.optionsPanel.add((Component)this.resolutionFixLabel, gbc_resolutionFixLabel);
        this.resolutionSlider = new JSlider();
        this.resolutionSlider.setSnapToTicks(true);
        this.resolutionSlider.setMinimumSize(new Dimension(80, 22));
        this.resolutionSlider.setMaximumSize(new Dimension(100, 22));
        this.resolutionSlider.setPreferredSize(new Dimension(100, 22));
        this.resolutionSlider.setToolTipText("Select resolution level to open");
        this.resolutionSlider.setValue(0);
        this.resolutionSlider.setMaximum(10);
        this.resolutionSlider.setFocusable(false);
        this.resolutionSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoaderOptionPanel.this.updateFinaleResolution();
            }
        });
        this.resolutionLevelLabel = new JLabel("");
        GridBagConstraints gbc_resolutionLevelLabel = new GridBagConstraints();
        gbc_resolutionLevelLabel.anchor = 17;
        gbc_resolutionLevelLabel.insets = new Insets(0, 0, 5, 5);
        gbc_resolutionLevelLabel.gridx = 1;
        gbc_resolutionLevelLabel.gridy = 2;
        this.optionsPanel.add((Component)this.resolutionLevelLabel, gbc_resolutionLevelLabel);
        GridBagConstraints gbc_resolutionSlider = new GridBagConstraints();
        gbc_resolutionSlider.fill = 1;
        gbc_resolutionSlider.gridwidth = 2;
        gbc_resolutionSlider.insets = new Insets(0, 0, 5, 0);
        gbc_resolutionSlider.gridx = 2;
        gbc_resolutionSlider.gridy = 2;
        this.optionsPanel.add((Component)this.resolutionSlider, gbc_resolutionSlider);
        this.xyRegionLoadingToggle = new JToggleButton("XY region");
        this.xyRegionLoadingToggle.setFocusPainted(false);
        this.xyRegionLoadingToggle.setIconTextGap(0);
        this.xyRegionLoadingToggle.setMargin(new Insets(2, 4, 2, 4));
        this.xyRegionLoadingToggle.setToolTipText("Enable region loading (X,Y)-(W,H) in original resolution coordinates (pixel)");
        this.xyRegionLoadingToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderOptionPanel.this.regionLoadingToggleChanged();
            }
        });
        GridBagConstraints gbc_xyRegionLoadingCheck = new GridBagConstraints();
        gbc_xyRegionLoadingCheck.fill = 1;
        gbc_xyRegionLoadingCheck.insets = new Insets(0, 0, 5, 5);
        gbc_xyRegionLoadingCheck.gridx = 0;
        gbc_xyRegionLoadingCheck.gridy = 3;
        this.optionsPanel.add((Component)this.xyRegionLoadingToggle, gbc_xyRegionLoadingCheck);
        this.xyRegionComp = new Region2DComponent();
        this.xyRegionComp.setMaximumSize(new Dimension(160, 24));
        this.xyRegionComp.setInteger(true);
        this.xyRegionComp.setToolTipText("Rectangular region to load (X,Y,W,H) in original resolution coordinates");
        GridBagConstraints gbc_xyRegionComp = new GridBagConstraints();
        gbc_xyRegionComp.fill = 2;
        gbc_xyRegionComp.gridwidth = 3;
        gbc_xyRegionComp.insets = new Insets(0, 0, 5, 0);
        gbc_xyRegionComp.gridx = 1;
        gbc_xyRegionComp.gridy = 3;
        this.optionsPanel.add((Component)this.xyRegionComp, gbc_xyRegionComp);
        this.zRangeLabel = new JLabel("Z range  ");
        this.zRangeLabel.setToolTipText("Z interval to load");
        GridBagConstraints gbc_zRangeLabel = new GridBagConstraints();
        gbc_zRangeLabel.anchor = 17;
        gbc_zRangeLabel.insets = new Insets(0, 0, 5, 5);
        gbc_zRangeLabel.gridx = 0;
        gbc_zRangeLabel.gridy = 4;
        this.optionsPanel.add((Component)this.zRangeLabel, gbc_zRangeLabel);
        this.zRangeComp = new RangeComponent();
        this.zRangeComp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoaderOptionPanel.this.rangeChanged();
            }
        });
        this.zRangeComp.setToolTipText("Z interval to load");
        this.zRangeComp.setMinimumSize(new Dimension(130, 22));
        this.zRangeComp.setMaximumSize(new Dimension(180, 22));
        this.zRangeComp.getHighSpinner().setPreferredSize(new Dimension(50, 20));
        this.zRangeComp.getHighSpinner().setMaximumSize(new Dimension(50, 20));
        this.zRangeComp.getLowSpinner().setMaximumSize(new Dimension(50, 20));
        this.zRangeComp.getLowSpinner().setPreferredSize(new Dimension(50, 20));
        this.zRangeComp.setPreferredSize(new Dimension(180, 22));
        this.zRangeComp.getSlider().setPreferredSize(new Dimension(70, 22));
        this.zRangeComp.setSliderVisible(true);
        GridBagConstraints gbc_zRangeComp = new GridBagConstraints();
        gbc_zRangeComp.gridwidth = 3;
        gbc_zRangeComp.insets = new Insets(0, 0, 5, 0);
        gbc_zRangeComp.fill = 2;
        gbc_zRangeComp.gridx = 1;
        gbc_zRangeComp.gridy = 4;
        this.optionsPanel.add((Component)this.zRangeComp, gbc_zRangeComp);
        this.tRangeLabel = new JLabel("T range  ");
        this.tRangeLabel.setToolTipText("T interval to load");
        GridBagConstraints gbc_tRangeLabel = new GridBagConstraints();
        gbc_tRangeLabel.anchor = 17;
        gbc_tRangeLabel.insets = new Insets(0, 0, 0, 5);
        gbc_tRangeLabel.gridx = 0;
        gbc_tRangeLabel.gridy = 5;
        this.optionsPanel.add((Component)this.tRangeLabel, gbc_tRangeLabel);
        this.tRangeComp = new RangeComponent();
        this.tRangeComp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoaderOptionPanel.this.rangeChanged();
            }
        });
        this.tRangeComp.setToolTipText("T interval to load");
        this.tRangeComp.setMinimumSize(new Dimension(130, 22));
        this.tRangeComp.setMaximumSize(new Dimension(180, 22));
        this.tRangeComp.getLowSpinner().setPreferredSize(new Dimension(50, 20));
        this.tRangeComp.getHighSpinner().setPreferredSize(new Dimension(50, 20));
        this.tRangeComp.getHighSpinner().setMaximumSize(new Dimension(50, 20));
        this.tRangeComp.getLowSpinner().setMaximumSize(new Dimension(50, 20));
        this.tRangeComp.setPreferredSize(new Dimension(180, 22));
        this.tRangeComp.getSlider().setPreferredSize(new Dimension(70, 22));
        this.tRangeComp.setSliderVisible(true);
        GridBagConstraints gbc_tRangeComp = new GridBagConstraints();
        gbc_tRangeComp.gridwidth = 3;
        gbc_tRangeComp.fill = 2;
        gbc_tRangeComp.gridx = 1;
        gbc_tRangeComp.gridy = 5;
        this.optionsPanel.add((Component)this.tRangeComp, gbc_tRangeComp);
    }

    protected void updatePreviewOnChange() {
        if (this.updatingPanel) {
            return;
        }
        int z = -1;
        int t = -1;
        boolean changed = false;
        int v = this.getZMin();
        if (this.pZMin != v) {
            z = v;
            this.pZMin = v;
            changed = true;
        }
        if (this.pZMax != (v = this.getZMax())) {
            z = v;
            this.pZMax = v;
            changed = true;
        }
        if (this.pTMin != (v = this.getTMin())) {
            t = v;
            this.pTMin = v;
            changed = true;
        }
        if (this.pTMax != (v = this.getTMax())) {
            t = v;
            this.pTMax = v;
            changed = true;
        }
        if (this.pCh != (v = this.getChannel())) {
            this.pCh = v;
            changed = true;
        }
        if (changed) {
            this.updatePreview(z, t);
        }
    }

    protected void rangeChanged() {
        this.updatePreviewOnChange();
    }

    protected void seriesChanged() {
        this.previewUpdater.updatePreview((Integer)this.seriesSpinner.getValue());
    }

    void updateLoadingType() {
        List<String> files = this.getFiles();
        this.loadingTypeCombo.setEnabled(files != null && !files.isEmpty());
    }

    void updateXYRegion() {
        if (this.metadata != null) {
            Rectangle2D r = this.xyRegionComp.getRegion();
            int s = this.getSelectedSeries();
            int sizeX = MetaDataUtil.getSizeX(this.metadata, s);
            int sizeY = MetaDataUtil.getSizeY(this.metadata, s);
            this.xyRegionLoadingToggle.setEnabled(this.canUseAdvancedSetting());
            this.xyRegionComp.setEnabled(this.canUseAdvancedSetting() && this.xyRegionLoadingToggle.isSelected());
            if (r.getMaxX() > (double)sizeX || r.getMaxY() > (double)sizeY) {
                this.xyRegionComp.setRegion(0, 0, sizeX, sizeY);
            }
        } else {
            this.xyRegionComp.setEnabled(false);
            this.xyRegionLoadingToggle.setEnabled(false);
        }
    }

    void updateZRange() {
        if (this.metadata != null) {
            int s = this.getSelectedSeries();
            int sizeZ = Math.max(MetaDataUtil.getSizeZ(this.metadata, s), 1);
            this.zRangeComp.setMinMaxStep(0.0, (double)sizeZ - 1.0, 1.0);
            this.zRangeComp.setLowHigh(0.0, (double)sizeZ - 1.0);
            this.zRangeComp.setEnabled(this.canUseAdvancedSetting() && sizeZ > 1);
        } else {
            this.zRangeComp.setMinMaxStep(0.0, 0.0, 1.0);
            this.zRangeComp.setEnabled(false);
        }
    }

    void updateTRange() {
        if (this.metadata != null) {
            int s = this.getSelectedSeries();
            int sizeT = Math.max(MetaDataUtil.getSizeT(this.metadata, s), 1);
            this.tRangeComp.setMinMaxStep(0.0, (double)sizeT - 1.0, 1.0);
            this.tRangeComp.setLowHigh(0.0, (double)sizeT - 1.0);
            this.tRangeComp.setEnabled(this.canUseAdvancedSetting() && sizeT > 1);
        } else {
            this.tRangeComp.setMinMaxStep(0.0, 0.0, 1.0);
            this.tRangeComp.setEnabled(false);
        }
    }

    void updateChannelRange() {
        if (this.metadata != null) {
            int s = this.getSelectedSeries();
            int sizeC = Math.max(MetaDataUtil.getSizeC(this.metadata, s), 1);
            this.channelSpinner.setModel(new SpecialValueSpinnerModel(Math.min(this.getChannel(), sizeC - 1), -1, sizeC - 1, 1, -1, "ALL"));
            this.channelSpinner.setEnabled(this.canUseAdvancedSetting() && sizeC > 1);
        } else {
            this.channelSpinner.setModel(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
            this.channelSpinner.setEnabled(false);
        }
    }

    void updateSeriesRange() {
        if (this.metadata != null) {
            int numSeries = Math.max(MetaDataUtil.getNumSeries(this.metadata), 1);
            this.seriesSpinner.setModel(new SpecialValueSpinnerModel(Math.min(this.getSeries(), numSeries - 1), -1, numSeries - 1, 1, -1, "ALL"));
            this.seriesSpinner.setEnabled(this.canUseAdvancedSetting() && numSeries > 1);
        } else {
            this.seriesSpinner.setModel(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
            this.seriesSpinner.setEnabled(false);
        }
    }

    void updateResolutionSlider() {
        int minRes = 0;
        int maxRes = 0;
        if (this.metadata != null) {
            int s = this.getSelectedSeries();
            for (long sizeXY = (long)MetaDataUtil.getSizeX(this.metadata, s) * (long)MetaDataUtil.getSizeY(this.metadata, s); sizeXY > 16384L; sizeXY /= 4L) {
                ++maxRes;
            }
        }
        this.resolutionSlider.setMinimum(minRes);
        this.resolutionSlider.setMaximum(maxRes);
        this.resolutionSlider.setEnabled(this.canUseAdvancedSetting() && maxRes > 0);
        this.updateFinaleResolution();
    }

    void updateFinaleResolution() {
        if (this.metadata != null) {
            int res = this.resolutionSlider.getValue();
            int s = this.getSelectedSeries();
            int baseX = MetaDataUtil.getSizeX(this.metadata, s);
            int baseY = MetaDataUtil.getSizeY(this.metadata, s);
            double diviser = Math.pow(2.0, res);
            this.resolutionLevelLabel.setText(res + " (" + Integer.toString((int)((double)baseX / diviser)) + " x " + Integer.toString((int)((double)baseY / diviser)) + ")");
        } else {
            this.resolutionLevelLabel.setText("");
        }
    }

    void disablePanel() {
        this.channelSpinner.setEnabled(false);
        this.seriesSpinner.setEnabled(false);
        this.resolutionLevelLabel.setText("");
        this.resolutionSlider.setEnabled(false);
        this.xyRegionLoadingToggle.setEnabled(false);
        this.xyRegionComp.setEnabled(false);
        this.tRangeComp.setEnabled(false);
        this.zRangeComp.setEnabled(false);
    }

    void updatePanel() {
        this.updatingPanel = true;
        try {
            this.updateResolutionSlider();
            this.updateXYRegion();
            this.updateTRange();
            this.updateZRange();
            this.updateChannelRange();
            this.updateSeriesRange();
        }
        finally {
            this.updatingPanel = false;
        }
    }

    void loadingTypeChanged() {
        this.updatePreview(-1);
    }

    void regionLoadingToggleChanged() {
        this.xyRegionComp.setEnabled(this.xyRegionLoadingToggle.isEnabled() && this.xyRegionLoadingToggle.isSelected());
    }

    public List<String> getFiles() {
        if (this.previewUpdater != null) {
            return this.previewUpdater.newFiles;
        }
        return new ArrayList<String>();
    }

    public boolean getOptionsVisible() {
        return this.popupPanel.isExpanded();
    }

    public void setOptionsVisible(boolean value) {
        this.popupPanel.setExpanded(value);
    }

    public boolean isSeparateSequenceSelected() {
        return this.loadingTypeCombo.getSelectedItem() == LoaderLoadingType.NO_GROUP;
    }

    public boolean isGroupedSequenceSelected() {
        return this.loadingTypeCombo.getSelectedItem() == LoaderLoadingType.GROUP;
    }

    public boolean isMultiFile() {
        return this.previewUpdater.isMultiFile();
    }

    public boolean canUseAdvancedSetting() {
        return !this.isSeparateSequenceSelected() || !this.isMultiFile();
    }

    public LoaderLoadingType getLoadingType() {
        return (LoaderLoadingType)((Object)this.loadingTypeCombo.getSelectedItem());
    }

    void setLoadingType(LoaderLoadingType value) {
        this.loadingTypeCombo.setSelectedItem((Object)value);
    }

    public int getResolutionLevel() {
        if (this.resolutionSlider.isVisible() && this.resolutionSlider.isEnabled()) {
            return this.resolutionSlider.getValue();
        }
        return 0;
    }

    public Rectangle getXYRegion() {
        if (this.xyRegionComp.isVisible() && this.xyRegionComp.isEnabled()) {
            return (Rectangle)this.xyRegionComp.getRegion();
        }
        return null;
    }

    public void setXYRegion(Rectangle region) {
        this.xyRegionLoadingToggle.setSelected(true);
        this.xyRegionComp.setEnabled(true);
        this.xyRegionComp.setRegion(region);
        this.setOptionsVisible(true);
    }

    public int getZMin() {
        if (this.zRangeComp.isVisible()) {
            return (int)this.zRangeComp.getLow();
        }
        return 0;
    }

    public int getZMax() {
        if (this.zRangeComp.isVisible()) {
            return (int)this.zRangeComp.getHigh();
        }
        return 0;
    }

    public boolean getFullZRange() {
        return this.getZMin() == 0 && this.getZMax() == (int)this.zRangeComp.getMax();
    }

    public int getTMin() {
        if (this.tRangeComp.isVisible()) {
            return (int)this.tRangeComp.getLow();
        }
        return 0;
    }

    public int getTMax() {
        if (this.tRangeComp.isVisible()) {
            return (int)this.tRangeComp.getHigh();
        }
        return 0;
    }

    public boolean getFullTRange() {
        return this.getTMin() == 0 && this.getTMax() == (int)this.tRangeComp.getMax();
    }

    public int getChannel() {
        if (this.channelSpinner.isVisible()) {
            return (Integer)this.channelSpinner.getValue();
        }
        return -1;
    }

    public int getSeries() {
        if (this.seriesSpinner.isVisible()) {
            return this.series;
        }
        return -1;
    }

    public void setSeries(int series) {
        this.seriesSpinner.setValue(series);
        this.setOptionsVisible(true);
    }

    public int getSelectedSeries() {
        int result = this.getSeries();
        return result == -1 ? 0 : result;
    }

    public void cancelPreview() {
        this.previewUpdater.cancelPreview();
    }

    protected void updatePreview(int series) {
        this.previewUpdater.updatePreview(series);
    }

    protected void updatePreview(int z, int t) {
        this.previewUpdater.updatePreview(z, t);
    }

    public void updatePreview(String[] files, int s) {
        if (this.series != s || !CollectionUtil.equals(this.getFiles(), CollectionUtil.asList(files))) {
            this.previewUpdater.updatePreview(files, s);
        }
    }

    public void updatePreview(List<String> files, int s) {
        if (this.series != s || !CollectionUtil.equals(this.getFiles(), files)) {
            this.previewUpdater.updatePreview(files, s);
        }
    }

    public void updatePreview(String[] files) {
        if (!CollectionUtil.equals(this.getFiles(), CollectionUtil.asList(files))) {
            this.previewUpdater.updatePreview(files, -1);
        }
    }

    public void closingFromEDT() {
        this.previewUpdater.closeFromEDT();
    }

    public static enum LoaderLoadingType {
        GROUP{

            public String toString() {
                return "Group files";
            }
        }
        ,
        GROUP_NO_ORDERING{

            public String toString() {
                return "Group files (no ordering)";
            }
        }
        ,
        NO_GROUP{

            public String toString() {
                return "Separate files";
            }
        };

    }

    private class PreviewUpdater
    extends Thread {
        SequenceFileImporter newImporter;
        List<String> newFiles;
        int newZ;
        int newT;
        boolean newImageRefreshOnly;
        boolean needUpdate;
        PreviewSingleUpdate singleUpdater;

        PreviewUpdater() {
            super("Preview updater");
            this.singleUpdater = null;
            this.needUpdate = false;
        }

        public boolean getNeedUpdate() {
            return this.needUpdate;
        }

        public boolean isUpdating() {
            return this.getNeedUpdate() || this.singleUpdater != null && this.singleUpdater.isAlive();
        }

        public boolean isMultiFile() {
            if (this.singleUpdater == null) {
                return false;
            }
            return this.singleUpdater.isMultiFile();
        }

        public boolean isPreviewCanceled() {
            if (this.singleUpdater == null) {
                return true;
            }
            return !this.singleUpdater.isAlive() || this.singleUpdater.isInterrupted();
        }

        public void cancelPreview() {
            if (this.singleUpdater != null) {
                this.singleUpdater.interrupt();
            }
        }

        protected synchronized void updatePreview(int z, int t) {
            if (this.singleUpdater == null) {
                return;
            }
            this.cancelPreview();
            this.newImporter = this.singleUpdater.importer;
            this.newFiles = this.singleUpdater.files;
            this.newZ = z == -1 ? this.singleUpdater.z : z;
            this.newT = t == -1 ? this.singleUpdater.t : t;
            this.newImageRefreshOnly = true;
            LoaderOptionPanel.this.updateLoadingType();
            this.needUpdate = true;
        }

        public synchronized void updatePreview() {
            this.updatePreview(this.singleUpdater.files, LoaderOptionPanel.this.series);
        }

        public synchronized void updatePreview(int s) {
            this.updatePreview(this.singleUpdater.files, s);
        }

        public synchronized void updatePreview(String[] files, int s) {
            this.cancelPreview();
            LoaderOptionPanel.this.metadata = null;
            LoaderOptionPanel.this.metadataFieldsOk = false;
            LoaderOptionPanel.this.series = s;
            this.newImporter = null;
            this.newFiles = CollectionUtil.asList(files);
            this.newZ = -1;
            this.newT = -1;
            this.newImageRefreshOnly = false;
            LoaderOptionPanel.this.updateLoadingType();
            this.needUpdate = true;
        }

        public synchronized void updatePreview(List<String> files, int s) {
            this.cancelPreview();
            LoaderOptionPanel.this.metadata = null;
            LoaderOptionPanel.this.metadataFieldsOk = false;
            LoaderOptionPanel.this.series = s;
            this.newImporter = null;
            this.newFiles = files;
            this.newZ = -1;
            this.newT = -1;
            this.newImageRefreshOnly = false;
            LoaderOptionPanel.this.updateLoadingType();
            this.needUpdate = true;
        }

        public synchronized void closeFromEDT() {
            this.cancelPreview();
            LoaderOptionPanel.this.updatePanel();
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(10L);
                    PreviewUpdater previewUpdater = this;
                    synchronized (previewUpdater) {
                        if (this.isPreviewCanceled() && this.needUpdate) {
                            this.singleUpdater = new PreviewSingleUpdate(this.newImporter, this.newFiles, this.newZ, this.newT, this.newImageRefreshOnly);
                            this.singleUpdater.start();
                            this.needUpdate = false;
                        }
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable t) {
                IcyExceptionHandler.showErrorMessage(t, false);
            }
        }
    }

    private class PreviewSingleUpdate
    extends Thread {
        SequenceFileImporter importer;
        List<SequenceFileImporter> importers;
        List<String> files;
        int z;
        int t;
        boolean imageRefreshOnly;

        PreviewSingleUpdate(SequenceFileImporter importer, List<String> files, int z, int t, boolean imageRefreshOnly) {
            super("Preview single update");
            this.importer = importer;
            this.importers = null;
            this.files = Loader.cleanNonImageFile(files);
            this.z = z;
            this.t = t;
            this.imageRefreshOnly = imageRefreshOnly;
        }

        public List<SequenceFileImporter> getSingleFileImporters() {
            List<SequenceFileImporter> result = Loader.getSequenceFileImporters(this.files.get(0));
            for (SequenceFileImporter imp : result) {
                if (!(imp instanceof LociImporterPlugin) || !LoaderOptionPanel.this.isSeparateSequenceSelected()) continue;
                ((LociImporterPlugin)imp).setGroupFiles(false);
            }
            return result;
        }

        void getImporters() {
            if (this.importer != null) {
                return;
            }
            this.importers = this.getSingleFileImporters();
            if (!this.importers.isEmpty()) {
                this.importer = this.importers.get(0);
            }
        }

        void close() {
            try {
                if (this.importer != null) {
                    this.importer.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.importer = null;
        }

        boolean internalOpen(SequenceFileImporter imp) throws ClosedByInterruptException, InterruptedException {
            SequenceFileImporter usedImp;
            block9: {
                usedImp = imp;
                try {
                    if (this.isMultiFile()) {
                        SequenceFileGroupImporter grpImp = new SequenceFileGroupImporter();
                        SequenceFileSticher.SequenceFileGroup group = SequenceFileSticher.groupFiles(imp, this.files, LoaderOptionPanel.this.isGroupedSequenceSelected(), null);
                        usedImp = grpImp;
                        if (group != null) {
                            grpImp.open(group, 1);
                        }
                    } else {
                        usedImp.open(this.files.get(0), 1);
                    }
                }
                catch (Exception e) {
                    try {
                        usedImp.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (e instanceof InterruptedException) {
                        throw (InterruptedException)e;
                    }
                    if (!(e instanceof ClosedByInterruptException)) break block9;
                    throw (ClosedByInterruptException)e;
                }
            }
            if (usedImp.getOpened() != null) {
                this.importer = usedImp;
                return true;
            }
            return false;
        }

        boolean open() throws ClosedByInterruptException, InterruptedException {
            this.getImporters();
            if (this.importer.getOpened() != null) {
                return true;
            }
            if (this.importers == null) {
                return this.internalOpen(this.importer);
            }
            for (SequenceFileImporter imp : this.importers) {
                if (!this.internalOpen(imp)) continue;
                return true;
            }
            return false;
        }

        OMEXMLMetadata getMetaData() throws InterruptedException, UnsupportedFormatException, IOException {
            if (!this.open()) {
                throw new IOException("Can't open importer !");
            }
            return this.importer.getOMEXMLMetaData();
        }

        IcyBufferedImage getThumbnail(int s) throws InterruptedException, UnsupportedFormatException, IOException {
            if (!this.open()) {
                throw new IOException("Can't open importer !");
            }
            return this.importer.getThumbnail(s);
        }

        IcyBufferedImage getImage(int s, int res) throws InterruptedException, UnsupportedFormatException, IOException {
            if (!this.open()) {
                throw new IOException("Can't open importer !");
            }
            if (LoaderOptionPanel.this.pCh == -1) {
                return this.importer.getImage(s, res, this.z, this.t);
            }
            return this.importer.getImage(s, res, this.z, this.t, LoaderOptionPanel.this.pCh);
        }

        public boolean isMultiFile() {
            try {
                SequenceFileSticher.SequenceFileGroup group;
                if (this.files.size() > 1) {
                    return true;
                }
                if (this.importer instanceof SequenceFileGroupImporter && (group = ((SequenceFileGroupImporter)this.importer).getOpenedGroup()) != null) {
                    return group.positions.size() > 1;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block36: {
                if (this.isInterrupted()) {
                    return;
                }
                int s = LoaderOptionPanel.this.getSelectedSeries();
                if (this.imageRefreshOnly) {
                    block35: {
                        if (this.importer == null && this.files.size() == 0) {
                            return;
                        }
                        try {
                            int res = Math.max(0, LoaderOptionPanel.this.resolutionSlider.getMaximum() - 1);
                            try {
                                if (!this.open()) {
                                    throw new IOException("Can't open '" + this.files.get(0) + "' image file..");
                                }
                                if (this.isInterrupted()) {
                                    return;
                                }
                                if (this.z == -1) {
                                    this.z = 0;
                                }
                                if (this.t == -1) {
                                    this.t = 0;
                                }
                                if (this.z == 0 && this.t == 0 && LoaderOptionPanel.this.pCh == -1) {
                                    LoaderOptionPanel.this.preview.setImage(this.getThumbnail(s));
                                } else {
                                    LoaderOptionPanel.this.preview.setImage(this.getImage(s, res));
                                }
                            }
                            finally {
                                if (this.importer instanceof SequenceFileGroupImporter) {
                                    ((SequenceFileGroupImporter)this.importer).closeInternalsImporters();
                                }
                            }
                        }
                        catch (ClosedByInterruptException e) {
                            this.close();
                        }
                        catch (InterruptedException e2) {
                            this.close();
                        }
                        catch (Throwable e) {
                            if (e.getCause() instanceof ClosedByInterruptException) {
                                this.close();
                            }
                            if (LoaderOptionPanel.this.previewUpdater.getNeedUpdate()) break block35;
                            LoaderOptionPanel.this.preview.setImage(ResourceUtil.ICON_DELETE);
                        }
                    }
                    return;
                }
                try {
                    LoaderOptionPanel.this.metadata = null;
                    if (this.files.size() == 0) {
                        LoaderOptionPanel.this.preview.setImage(null);
                        LoaderOptionPanel.this.preview.setInfos("");
                        LoaderOptionPanel.this.metadata = OMEUtil.createOMEXMLMetadata();
                        ThreadUtil.invokeNow(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                LoaderOptionPanel.this.disablePanel();
                                return Boolean.TRUE;
                            }
                        });
                        return;
                    }
                    LoaderOptionPanel.this.preview.setImage(ResourceUtil.ICON_WAIT);
                    LoaderOptionPanel.this.preview.setInfos("loading...");
                    ThreadUtil.invokeNow(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            LoaderOptionPanel.this.disablePanel();
                            return Boolean.TRUE;
                        }
                    });
                    this.close();
                    if (!this.open()) {
                        throw new IOException("Can't open '" + this.files.get(0) + "' image file..");
                    }
                    try {
                        if (this.isInterrupted()) {
                            return;
                        }
                        LoaderOptionPanel.this.metadata = this.getMetaData();
                        ThreadUtil.invokeNow(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                LoaderOptionPanel.this.updatePanel();
                                return Boolean.TRUE;
                            }
                        });
                        LoaderOptionPanel.this.metadataFieldsOk = true;
                        LoaderOptionPanel.this.pZMin = LoaderOptionPanel.this.getZMin();
                        LoaderOptionPanel.this.pZMax = LoaderOptionPanel.this.getZMax();
                        LoaderOptionPanel.this.pTMin = LoaderOptionPanel.this.getTMin();
                        LoaderOptionPanel.this.pTMax = LoaderOptionPanel.this.getTMax();
                        LoaderOptionPanel.this.pCh = LoaderOptionPanel.this.getChannel();
                        int sizeC = MetaDataUtil.getSizeC(LoaderOptionPanel.this.metadata, s);
                        LoaderOptionPanel.this.preview.setInfos(MetaDataUtil.getSizeX(LoaderOptionPanel.this.metadata, s) + " x " + MetaDataUtil.getSizeY(LoaderOptionPanel.this.metadata, s) + " - " + MetaDataUtil.getSizeZ(LoaderOptionPanel.this.metadata, s) + "Z x " + MetaDataUtil.getSizeT(LoaderOptionPanel.this.metadata, s) + "T - " + sizeC + " ch (" + (Object)((Object)MetaDataUtil.getDataType(LoaderOptionPanel.this.metadata, s)) + ")");
                        if (this.isInterrupted()) {
                            return;
                        }
                        LoaderOptionPanel.this.preview.setImage(this.getThumbnail(s));
                    }
                    finally {
                        if (this.importer instanceof SequenceFileGroupImporter) {
                            ((SequenceFileGroupImporter)this.importer).closeInternalsImporters();
                        }
                    }
                }
                catch (ClosedByInterruptException e) {
                    this.close();
                }
                catch (InterruptedException t) {
                    this.close();
                }
                catch (Throwable t1) {
                    if (LoaderOptionPanel.this.previewUpdater.getNeedUpdate()) break block36;
                    LoaderOptionPanel.this.preview.setImage(ResourceUtil.ICON_DELETE);
                    if (LoaderOptionPanel.this.metadataFieldsOk) break block36;
                    LoaderOptionPanel.this.preview.setInfos("Cannot read file");
                    try {
                        ThreadUtil.invokeNow(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                LoaderOptionPanel.this.updatePanel();
                                return Boolean.TRUE;
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

