/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.gui.util.LookAndFeelUtil;
import icy.main.Icy;
import icy.preferences.CanvasPreferences;
import icy.preferences.GeneralPreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GUICanvasPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 7070251589085892036L;
    public static final String NODE_NAME = "GUI & Canvas";
    private JCheckBox filteringCheckBox;
    private JCheckBox invertWheelAxisCheckBox;
    private JSpinner wheelAxisSensitivity;
    private JCheckBox alwaysOnTopCheckBox;
    private JSpinner uiFontSizeSpinner;

    GUICanvasPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.initialize();
        this.load();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 80, 4, 0};
        gridBagLayout.rowHeights = new int[]{23, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.mainPanel.setLayout(gridBagLayout);
        this.alwaysOnTopCheckBox = new JCheckBox("Application window always on top");
        GridBagConstraints gbc_alwaysOnTopCheckBox = new GridBagConstraints();
        gbc_alwaysOnTopCheckBox.anchor = 18;
        gbc_alwaysOnTopCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_alwaysOnTopCheckBox.gridx = 0;
        gbc_alwaysOnTopCheckBox.gridy = 0;
        this.mainPanel.add((Component)this.alwaysOnTopCheckBox, gbc_alwaysOnTopCheckBox);
        this.filteringCheckBox = new JCheckBox("Enable image filtering");
        this.filteringCheckBox.setToolTipText("Enable image filtering to improve rendering quality");
        GridBagConstraints gbc_filteringCheckBox = new GridBagConstraints();
        gbc_filteringCheckBox.anchor = 18;
        gbc_filteringCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_filteringCheckBox.gridx = 0;
        gbc_filteringCheckBox.gridy = 1;
        this.mainPanel.add((Component)this.filteringCheckBox, gbc_filteringCheckBox);
        this.invertWheelAxisCheckBox = new JCheckBox("Invert mouse wheel axis");
        this.invertWheelAxisCheckBox.setToolTipText("Invert the mouse wheel axis for canvas operation");
        GridBagConstraints gbc_invertWheelAxisCheckBox = new GridBagConstraints();
        gbc_invertWheelAxisCheckBox.anchor = 18;
        gbc_invertWheelAxisCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_invertWheelAxisCheckBox.gridx = 0;
        gbc_invertWheelAxisCheckBox.gridy = 2;
        this.mainPanel.add((Component)this.invertWheelAxisCheckBox, gbc_invertWheelAxisCheckBox);
        JLabel label = new JLabel(" GUI font size   ");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 17;
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 0;
        gbc_label.gridy = 3;
        this.mainPanel.add((Component)label, gbc_label);
        this.uiFontSizeSpinner = new JSpinner(new SpinnerNumberModel(7, 7, 24, 1));
        this.uiFontSizeSpinner.setToolTipText("");
        GridBagConstraints gbc_uiFontSizeSpinner = new GridBagConstraints();
        gbc_uiFontSizeSpinner.fill = 2;
        gbc_uiFontSizeSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_uiFontSizeSpinner.gridx = 1;
        gbc_uiFontSizeSpinner.gridy = 3;
        this.mainPanel.add((Component)this.uiFontSizeSpinner, gbc_uiFontSizeSpinner);
        GridBagConstraints gbc_lblMouseWheelSensivity = new GridBagConstraints();
        gbc_lblMouseWheelSensivity.anchor = 17;
        gbc_lblMouseWheelSensivity.insets = new Insets(0, 0, 5, 5);
        gbc_lblMouseWheelSensivity.gridx = 0;
        gbc_lblMouseWheelSensivity.gridy = 4;
        JLabel lblMouseWheelSensivity = new JLabel(" Mouse wheel sensivity");
        this.mainPanel.add((Component)lblMouseWheelSensivity, gbc_lblMouseWheelSensivity);
        this.wheelAxisSensitivity = new JSpinner(new SpinnerNumberModel(5.0, 1.0, 10.0, 0.5));
        this.wheelAxisSensitivity.setToolTipText("Set mouse wheel sensivity for canvas operation (1-10)");
        GridBagConstraints gbc_wheelAxisSensitivity = new GridBagConstraints();
        gbc_wheelAxisSensitivity.fill = 2;
        gbc_wheelAxisSensitivity.insets = new Insets(0, 0, 5, 5);
        gbc_wheelAxisSensitivity.gridx = 1;
        gbc_wheelAxisSensitivity.gridy = 4;
        this.mainPanel.add((Component)this.wheelAxisSensitivity, gbc_wheelAxisSensitivity);
        this.mainPanel.validate();
    }

    @Override
    protected void load() {
        this.wheelAxisSensitivity.setValue(CanvasPreferences.getMouseWheelSensitivity());
        this.invertWheelAxisCheckBox.setSelected(CanvasPreferences.getInvertMouseWheelAxis());
        this.filteringCheckBox.setSelected(CanvasPreferences.getFiltering());
        this.alwaysOnTopCheckBox.setSelected(GeneralPreferences.getAlwaysOnTop());
        this.uiFontSizeSpinner.setValue(GeneralPreferences.getGuiFontSize());
    }

    @Override
    protected void save() {
        CanvasPreferences.setMouseWheelSensitivity((Double)this.wheelAxisSensitivity.getValue());
        CanvasPreferences.setInvertMouseWheelAxis(this.invertWheelAxisCheckBox.isSelected());
        CanvasPreferences.setFiltering(this.filteringCheckBox.isSelected());
        boolean booleanValue = this.alwaysOnTopCheckBox.isSelected();
        Icy.getMainInterface().setAlwaysOnTop(booleanValue);
        GeneralPreferences.setAlwaysOnTop(booleanValue);
        int intValue = (Integer)this.uiFontSizeSpinner.getValue();
        LookAndFeelUtil.setFontSize(intValue);
        GeneralPreferences.setGuiFontSize(intValue);
    }
}

