/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTable;
import icy.gui.component.IcyTextField;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.gui.util.ComponentUtil;
import icy.preferences.RepositoryPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class WorkspaceListPreferencePanel
extends PreferencePanel
implements IcyTextField.TextChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = -264986966623111155L;
    private static final String BOTTOM_MESS = "*Workspace modification need application restart to take effect";
    static final String[] columnNames = new String[]{"Name", "Description", "", "Enabled"};
    List<Workspace> workspaces = new ArrayList<Workspace>();
    final AbstractTableModel tableModel;
    final JTable table;
    final JComboBox repository;
    final JPanel repositoryPanel;
    final IcyTextField filter;
    final JButton refreshButton;
    final JButton action1Button;
    private final Runnable buttonsStateUpdater = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    WorkspaceListPreferencePanel.this.updateButtonsStateInternal();
                }
            });
        }
    };
    private final Runnable tableDataRefresher = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    WorkspaceListPreferencePanel.this.refreshTableDataInternal();
                }
            });
        }
    };
    private final Runnable workspaceListRefresher = new Runnable(){

        @Override
        public void run() {
            WorkspaceListPreferencePanel.this.refreshWorkspacesInternal();
        }
    };
    private final Runnable repositoriesUpdater = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    WorkspaceListPreferencePanel.this.updateRepositoriesInternal();
                }
            });
        }
    };
    final ActionListener repositoryActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkspaceListPreferencePanel.this.repositoryChanged();
        }
    };

    WorkspaceListPreferencePanel(PreferenceFrame parent, String nodeName) {
        super(parent, nodeName, "Workspace");
        this.repository = new JComboBox();
        this.repository.setToolTipText("Select a repository");
        this.repository.addActionListener(this.repositoryActionListener);
        this.repositoryPanel = new JPanel();
        this.repositoryPanel.setLayout(new BoxLayout(this.repositoryPanel, 3));
        this.repositoryPanel.setVisible(false);
        JPanel internalRepPanel = new JPanel();
        internalRepPanel.setLayout(new BoxLayout(internalRepPanel, 2));
        internalRepPanel.add(new JLabel("Repository :"));
        internalRepPanel.add(Box.createHorizontalStrut(8));
        internalRepPanel.add(this.repository);
        internalRepPanel.add(Box.createHorizontalGlue());
        this.repositoryPanel.add(internalRepPanel);
        this.repositoryPanel.add(Box.createVerticalStrut(8));
        this.filter = new IcyTextField();
        this.filter.addTextChangeListener(this);
        this.load();
        Dimension buttonsDim = new Dimension(100, 24);
        this.refreshButton = new JButton("Reload list");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceListPreferencePanel.this.reloadWorkspaces();
            }
        });
        ComponentUtil.setFixedSize(this.refreshButton, buttonsDim);
        this.action1Button = new JButton("null");
        this.action1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceListPreferencePanel.this.doAction1(WorkspaceListPreferencePanel.this.getSelectedWorkspace());
            }
        });
        this.action1Button.setVisible(false);
        ComponentUtil.setFixedSize(this.action1Button, buttonsDim);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 3));
        buttonsPanel.add(this.refreshButton);
        buttonsPanel.add(Box.createVerticalStrut(64));
        buttonsPanel.add(this.action1Button);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(Box.createVerticalGlue());
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return WorkspaceListPreferencePanel.this.getColumnCount();
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return WorkspaceListPreferencePanel.this.workspaces.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                Workspace workspace = WorkspaceListPreferencePanel.this.workspaces.get(row);
                switch (column) {
                    case 0: {
                        return workspace.getName();
                    }
                    case 1: {
                        return workspace.getDescription();
                    }
                    case 2: {
                        return WorkspaceListPreferencePanel.this.getStateValue(workspace);
                    }
                    case 3: {
                        return WorkspaceListPreferencePanel.this.isWorkspaceEnable(workspace);
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 3;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 3) {
                    return Boolean.class;
                }
                return String.class;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                Workspace workspace = WorkspaceListPreferencePanel.this.workspaces.get(rowIndex);
                if (columnIndex == 3 && aValue instanceof Boolean) {
                    WorkspaceListPreferencePanel.this.setWorkspaceEnable(workspace, (Boolean)aValue);
                }
                WorkspaceListPreferencePanel.this.getPreferenceFrame().setNeedRestart();
            }
        };
        this.table = new IcyTable(this.tableModel);
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setMinWidth(80);
        col.setPreferredWidth(100);
        col.setMaxWidth(120);
        col = colModel.getColumn(1);
        col.setMinWidth(160);
        col.setPreferredWidth(240);
        col.setMaxWidth(500);
        col = colModel.getColumn(2);
        col.setMinWidth(60);
        col.setPreferredWidth(70);
        col.setMaxWidth(80);
        if (colModel.getColumnCount() > 3) {
            col = colModel.getColumn(3);
            col.setMinWidth(60);
            col.setPreferredWidth(60);
            col.setMaxWidth(60);
        }
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(24);
        this.table.setShowVerticalLines(false);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoResizeMode(4);
        JPanel tableTopPanel = new JPanel();
        tableTopPanel.setLayout(new BoxLayout(tableTopPanel, 3));
        tableTopPanel.add(Box.createVerticalStrut(2));
        tableTopPanel.add(this.repositoryPanel);
        tableTopPanel.add(this.filter);
        tableTopPanel.add(Box.createVerticalStrut(8));
        tableTopPanel.add(this.table.getTableHeader());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)tableTopPanel, "North");
        tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)tablePanel, "Center");
        this.mainPanel.add((Component)buttonsPanel, "East");
        this.mainPanel.add((Component)new JLabel(BOTTOM_MESS), "South");
        this.mainPanel.validate();
    }

    @Override
    protected void closed() {
        super.closed();
        this.workspaces.clear();
    }

    private List<Workspace> filterList(List<Workspace> list, String filter) {
        ArrayList<Workspace> result = new ArrayList<Workspace>();
        boolean empty = StringUtil.isEmpty(filter, true);
        String filterUp = !empty ? filter.toUpperCase() : "";
        for (Workspace workspace : list) {
            String name = workspace.getName().toUpperCase();
            String desc = workspace.getDescription().toUpperCase();
            if (!empty && name.indexOf(filterUp) == -1 && desc.indexOf(filterUp) == -1) continue;
            result.add(workspace);
        }
        return result;
    }

    protected abstract void doAction1(Workspace var1);

    protected abstract void repositoryChanged();

    protected abstract void reloadWorkspaces();

    protected abstract String getStateValue(Workspace var1);

    protected abstract int getColumnCount();

    protected abstract List<Workspace> getWorkspaces();

    protected abstract void updateButtonsStateInternal();

    protected final void updateButtonsState() {
        ThreadUtil.runSingle(this.buttonsStateUpdater);
    }

    protected void updateRepositoriesInternal() {
        ArrayList<RepositoryPreferences.RepositoryInfo> repositeries = RepositoryPreferences.getRepositeries();
        RepositoryPreferences.RepositoryInfo savedRepository = (RepositoryPreferences.RepositoryInfo)this.repository.getSelectedItem();
        this.repository.removeActionListener(this.repositoryActionListener);
        this.repository.removeAllItems();
        for (RepositoryPreferences.RepositoryInfo repos : repositeries) {
            if (!repos.isEnabled()) continue;
            this.repository.addItem(repos);
        }
        this.repository.setEnabled(true);
        this.repository.addActionListener(this.repositoryActionListener);
        boolean selected = false;
        if (savedRepository != null) {
            String repositoryName = savedRepository.getName();
            for (int ind = 0; ind < this.repository.getItemCount(); ++ind) {
                RepositoryPreferences.RepositoryInfo repo = (RepositoryPreferences.RepositoryInfo)this.repository.getItemAt(ind);
                if (repo == null || !repo.getName().equals(repositoryName)) continue;
                this.repository.setSelectedIndex(ind);
                selected = true;
                break;
            }
        }
        if (!selected) {
            this.repository.setSelectedIndex(this.repository.getItemCount() > 0 ? 0 : -1);
        }
        this.repository.setMinimumSize(new Dimension(48, 18));
    }

    protected final void updateRepositories() {
        ThreadUtil.runSingle(this.repositoriesUpdater);
    }

    protected Boolean isWorkspaceEnable(Workspace workspace) {
        return Boolean.FALSE;
    }

    protected void setWorkspaceEnable(Workspace workspace, Boolean value) {
    }

    protected void refreshWorkspacesInternal() {
        this.workspaces = this.filterList(this.getWorkspaces(), this.filter.getText());
        this.refreshTableData();
    }

    protected final void refreshWorkspaces() {
        ThreadUtil.runSingle(this.workspaceListRefresher);
    }

    protected int getWorkspaceIndex(Workspace workspace) {
        return this.workspaces.indexOf(workspace);
    }

    protected int getWorkspaceModelIndex(Workspace workspace) {
        return this.getWorkspaceIndex(workspace);
    }

    protected int getWorkspaceTableIndex(Workspace workspace) {
        int ind = this.getWorkspaceModelIndex(workspace);
        if (ind == -1) {
            return ind;
        }
        try {
            return this.table.convertRowIndexToView(ind);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    Workspace getSelectedWorkspace() {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            return null;
        }
        try {
            index = this.table.convertRowIndexToModel(index);
        }
        catch (IndexOutOfBoundsException e) {
            index = -1;
        }
        if (index < 0 || index >= this.workspaces.size()) {
            return null;
        }
        return this.workspaces.get(index);
    }

    void setSelectedWorkspace(Workspace workspace) {
        int index = this.getWorkspaceTableIndex(workspace);
        if (index > -1) {
            this.table.clearSelection();
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    @Override
    protected void load() {
    }

    @Override
    protected void save() {
        this.updateRepositories();
    }

    protected void refreshTableDataInternal() {
        Workspace workspace = this.getSelectedWorkspace();
        this.tableModel.fireTableDataChanged();
        this.setSelectedWorkspace(workspace);
        this.updateButtonsState();
    }

    protected final void refreshTableData() {
        ThreadUtil.runSingle(this.tableDataRefresher);
    }

    protected void workspacesChanged() {
        this.refreshWorkspaces();
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        this.workspacesChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateButtonsState();
    }
}

