/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.math.UnitUtil;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;

public class ROISurfaceAreaDescriptor
extends ROIDescriptor {
    public static final String ID = "Surface area";

    public ROISurfaceAreaDescriptor() {
        super(ID, "Surface Area", Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getUnit(Sequence sequence) {
        if (sequence != null) {
            return sequence.getBestPixelSizeUnit(3, 2).toString() + "m2";
        }
        return UnitUtil.UnitPrefix.MICRO.toString() + "m2";
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        SequenceEvent.SequenceEventSourceType sourceType = change.getSourceType();
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            return true;
        }
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_META) {
            String metaName = (String)change.getSource();
            return StringUtil.isEmpty(metaName) || StringUtil.equals(metaName, "pixelSizeX") || StringUtil.equals(metaName, "pixelSizeY") || StringUtil.equals(metaName, "pixelSizeZ");
        }
        return false;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROISurfaceAreaDescriptor.computeSurfaceArea(roi, sequence);
    }

    public static double computeSurfaceArea(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        if (!(roi instanceof ROI3D)) {
            throw new UnsupportedOperationException("Can't process Surface area calculation for on " + roi.getDimension() + "D ROI: '" + roi.getName() + "'");
        }
        if (sequence == null) {
            throw new UnsupportedOperationException("Can't process Surface area calculation with null Sequence parameter !");
        }
        UnitUtil.UnitPrefix bestUnit = sequence.getBestPixelSizeUnit(3, 2);
        double surfaceArea = ((ROI3D)roi).getSurfaceArea(sequence);
        return UnitUtil.getValueInUnit(surfaceArea, UnitUtil.UnitPrefix.MICRO, bestUnit, 2);
    }
}

